/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.actionbar;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.actionbar.Actionbar;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;

public abstract class ActionbarManager
implements ChatPluginManager,
Runnable {
    public static final Pattern ACTIONBAR_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    protected static ActionbarManager instance;
    protected boolean enabled;
    protected boolean randomOrder;
    protected boolean hasPrefix;
    protected String prefix;
    protected long sendingTimeout;
    protected long timerTaskID = -1L;
    protected Set<PlaceholderType> placeholderTypes = Collections.emptySet();
    protected List<Actionbar> actionbars = new CopyOnWriteArrayList<Actionbar>();
    protected int timerIndex = -1;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    public boolean hasPrefix() {
        return this.hasPrefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public long getSendingTimeout() {
        return this.sendingTimeout;
    }

    public Set<PlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public List<Actionbar> getActionbars() {
        return this.actionbars;
    }

    public Actionbar getActionbar(String id) {
        return this.actionbars.stream().filter(actionbar -> actionbar.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public int getTimerIndex() {
        return this.timerIndex;
    }

    public boolean isValidActionbarID(String actionbarID) {
        return ACTIONBAR_ID_PATTERN.matcher(actionbarID).matches();
    }

    public static ActionbarManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract void sendActionbar(Actionbar var1, ChatPluginServerPlayer var2);
}

