/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.actionbar;

import java.util.Map;
import java.util.NoSuchElementException;
import me.remigio07.chatplugin.api.server.actionbar.ActionbarManager;
import me.remigio07.chatplugin.api.server.language.Language;

public class Actionbar {
    private String id;
    private Map<Language, String> texts;
    private boolean hidden;

    public Actionbar(String id, Map<Language, String> texts, boolean hidden) {
        if (!ActionbarManager.getInstance().isValidActionbarID(id)) {
            throw new IllegalArgumentException("Actionbar ID \"" + id + "\" does not respect the following pattern: \"" + ActionbarManager.ACTIONBAR_ID_PATTERN.pattern() + "\"");
        }
        if (texts.get(Language.getMainLanguage()) == null) {
            throw new NoSuchElementException("Specified map does not contain a translation for the main language");
        }
        this.id = id;
        this.texts = texts;
        this.hidden = hidden;
    }

    public String toString() {
        return "Actionbar{id=\"" + this.id + "\"}";
    }

    public String getID() {
        return this.id;
    }

    public Map<Language, String> getTexts() {
        return this.texts;
    }

    public String getText(Language language, boolean avoidNull) {
        return this.texts.get(language) == null ? (avoidNull ? this.texts.get(Language.getMainLanguage()) : null) : this.texts.get(language);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Actionbar setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }
}

