/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.proxy.util.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.common.util.packet.PacketSerializer;
import me.remigio07.chatplugin.api.common.util.packet.Packets;
import me.remigio07.chatplugin.api.proxy.event.socket.ClientConnectionEvent;
import me.remigio07.chatplugin.api.proxy.event.socket.ClientDisconnectionEvent;
import me.remigio07.chatplugin.api.proxy.event.socket.ServerReceivePacketEvent;
import me.remigio07.chatplugin.api.proxy.util.socket.Server;

public class ClientHandler
extends Thread {
    public static final Pattern CLIENT_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    private Server server;
    private Socket socket;
    private String id;
    private String disconnectionReason;
    private DataInputStream input;
    private DataOutputStream output;

    ClientHandler(Server server, Socket socket) throws IOException {
        this.server = server;
        this.socket = socket;
        this.input = new DataInputStream(socket.getInputStream());
        this.output = new DataOutputStream(socket.getOutputStream());
        new Thread(() -> {
            try {
                for (int i = 0; i < 49; ++i) {
                    if (this.id != null) {
                        if (!ClientHandler.isValidClientID(this.id)) {
                            this.output.writeUTF("INVALID_ID");
                            LogManager.log("[SOCKETS] Client {0} has just tried to connect using ID \"{1}\" but it does not respect the required pattern: \"{2}\".", 4, socket.getInetAddress().getHostAddress() + ":" + socket.getPort(), this.id, CLIENT_ID_PATTERN.pattern());
                            socket.close();
                            return;
                        }
                        for (ClientHandler clientHandler : server.getClientHandlers()) {
                            if (!clientHandler.getID().equals(this.id)) continue;
                            this.output.writeUTF("ID_ALREADY_IN_USE");
                            LogManager.log("[SOCKETS] Client {0} has just tried to connect using ID \"{1}\" but it was already in use by {2}.", 4, socket.getInetAddress().getHostAddress() + ":" + socket.getPort(), this.id, clientHandler.getSocket().getInetAddress().getHostAddress() + ":" + clientHandler.getSocket().getPort());
                            socket.close();
                            return;
                        }
                        this.output.writeUTF("SUCCESS");
                        server.getClientHandlers().add(this);
                        new ClientConnectionEvent(this).call();
                        LogManager.log("[SOCKETS] Client {0} has just connected using ID \"{1}\".", 4, socket.getInetAddress().getHostAddress() + ":" + socket.getPort(), this.id);
                        this.start();
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        LogManager.log("[SOCKETS] The identification task for client {0} has been suddenly interrupted: {1}", 2, socket.getInetAddress().getHostAddress() + ":" + socket.getPort(), ie.getLocalizedMessage());
                        break;
                    }
                }
                LogManager.log("[SOCKETS] Client {0} did not send its ID within 5000ms so it was disconnected.", 4, socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                socket.close();
            }
            catch (IOException ioe) {
                LogManager.log("[SOCKETS] IOException occurred while closing socket for client \"{0}\": {1}", 2, this.id, ioe.getLocalizedMessage());
            }
        }).start();
        new Thread(() -> {
            try {
                this.id = this.input.readUTF();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void run() {
        try {
            DataInputStream dataInputStream = this.input;
            synchronized (dataInputStream) {
                short bytesRead;
                while ((bytesRead = this.input.readShort()) != -1) {
                    byte[] data = new byte[bytesRead];
                    this.input.readFully(data);
                    new ServerReceivePacketEvent(this, data).call();
                }
            }
        }
        catch (EOFException | SocketException iOException) {
        }
        catch (IOException ioe) {
            LogManager.log("[SOCKETS] IOException occurred while reading a packet received from client \"{0}\": {1}", 2, this.id, ioe.getLocalizedMessage());
        }
        try {
            this.socket.close();
        }
        catch (IOException ioe) {
            LogManager.log("[SOCKETS] IOException occurred while closing socket for client \"{0}\"): {1}", 2, this.id, ioe.getLocalizedMessage());
        }
        new ClientDisconnectionEvent(this).call();
        this.server.getClientHandlers().remove(this);
        LogManager.log("[SOCKETS] Client \"{0}\" has just disconnected from the server{1}", 4, this.id, this.disconnectionReason == null ? "." : ": " + this.disconnectionReason);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", "ClientHandler{", "}").add("server=" + this.server).add("id=" + (this.id == null ? this.id : "\"" + this.id + "\"")).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(PacketSerializer packet) {
        byte[] data = packet.toArray();
        try {
            DataOutputStream dataOutputStream = this.output;
            synchronized (dataOutputStream) {
                this.output.writeShort(data.length);
                this.output.write(data);
            }
        }
        catch (IOException ioe) {
            LogManager.log("[SOCKETS] IOException occurred while writing a packet to send to client \"{0}\": {1}", 2, this.id, ioe.getLocalizedMessage());
        }
    }

    public void disconnect(String reason) throws IOException {
        if (reason.length() > 255) {
            throw new IllegalArgumentException("Specified reason is longer than 255 characters");
        }
        this.disconnectionReason = reason;
        this.sendPacket(Packets.Misc.clientDisconnection(this.disconnectionReason));
        this.socket.close();
    }

    public Server getServer() {
        return this.server;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getID() {
        return this.id;
    }

    public DataInputStream getInput() {
        return this.input;
    }

    public DataOutputStream getOutput() {
        return this.output;
    }

    public static boolean isValidClientID(String clientID) {
        return CLIENT_ID_PATTERN.matcher(clientID).matches();
    }
}

