/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.text;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.minecraft.class_5251;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

public class ChatColor {
    private static final Map<Character, ChatColor> BY_CHAR = new HashMap<Character, ChatColor>();
    private static final Map<String, ChatColor> BY_NAME = new HashMap<String, ChatColor>();
    public static final ChatColor BLACK = new ChatColor("BLACK", '0', 0);
    public static final ChatColor DARK_BLUE = new ChatColor("DARK_BLUE", '1', 170);
    public static final ChatColor DARK_GREEN = new ChatColor("DARK_GREEN", '2', 43520);
    public static final ChatColor DARK_AQUA = new ChatColor("DARK_AQUA", '3', 43690);
    public static final ChatColor DARK_RED = new ChatColor("DARK_RED", '4', 0xAA0000);
    public static final ChatColor DARK_PURPLE = new ChatColor("DARK_PURPLE", '5', 0xAA00AA);
    public static final ChatColor GOLD = new ChatColor("GOLD", '6', 0xFFAA00);
    public static final ChatColor GRAY = new ChatColor("GRAY", '7', 0xAAAAAA);
    public static final ChatColor DARK_GRAY = new ChatColor("DARK_GRAY", '8', 0x555555);
    public static final ChatColor BLUE = new ChatColor("BLUE", '9', 0x5555FF);
    public static final ChatColor GREEN = new ChatColor("GREEN", 'a', 0x55FF55);
    public static final ChatColor AQUA = new ChatColor("AQUA", 'b', 0x55FFFF);
    public static final ChatColor RED = new ChatColor("RED", 'c', 0xFF5555);
    public static final ChatColor LIGHT_PURPLE = new ChatColor("LIGHT_PURPLE", 'd', 0xFF55FF);
    public static final ChatColor YELLOW = new ChatColor("YELLOW", 'e', 0xFFFF55);
    public static final ChatColor WHITE = new ChatColor("WHITE", 'f', 0xFFFFFF);
    public static final ChatColor OBFUSCATED = new ChatColor("OBFUSCATED", 'k');
    public static final ChatColor BOLD = new ChatColor("BOLD", 'l');
    public static final ChatColor STRIKETHROUGH = new ChatColor("STRIKETHROUGH", 'm');
    public static final ChatColor UNDERLINE = new ChatColor("UNDERLINE", 'n');
    public static final ChatColor ITALIC = new ChatColor("ITALIC", 'o');
    public static final ChatColor RESET = new ChatColor("RESET", 'r');
    public static final String COLOR_CODES = "0123456789AaBbCcDdEeFfRr";
    public static final String FORMAT_CODES = "KkLlMmNnOo";
    public static final String CODES = "0123456789AaBbCcDdEeFfRrKkLlMmNnOo";
    public static final Pattern STRIP_COLOR = Pattern.compile("(?i)\u00a7[0-9A-FK-ORX]");
    public static final Pattern[] HEX_COLORS = new Pattern[]{Pattern.compile("&#([A-Fa-f0-9]){6}"), Pattern.compile("#([A-Fa-f0-9]){6}")};
    private static final Pattern TRANSLATED_HEX_COLORS = Pattern.compile("(?i)\u00a7X(\u00a7[A-F0-9]){6}");
    private static final ChatColor[] VALUES = new ChatColor[]{BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE, OBFUSCATED, BOLD, STRIKETHROUGH, UNDERLINE, ITALIC, RESET};
    private String name;
    private String toString;
    private Character code;
    private Color color;

    private ChatColor(String name, char code) {
        this(name, code, -1);
    }

    private ChatColor(String name, char code, int rgb) {
        this.name = name;
        this.code = Character.valueOf(code);
        this.toString = '\u00a7' + String.valueOf(code);
        this.color = rgb == -1 ? null : new Color(rgb);
        BY_CHAR.put(Character.valueOf(code), this);
        BY_NAME.put(name, this);
    }

    private ChatColor(String name, String toString, int rgb) {
        this.name = name;
        this.toString = toString;
        this.color = new Color(rgb);
    }

    public int hashCode() {
        return this.toString.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChatColor && ((ChatColor)obj).toString().equals(this.toString());
    }

    public String toString() {
        return this.toString;
    }

    public org.bukkit.ChatColor bukkitValue() {
        if (Environment.isBukkit()) {
            return org.bukkit.ChatColor.valueOf((String)(this.isDefaultColor() ? (this.name.equals(ChatColor.OBFUSCATED.name) ? "MAGIC" : this.name) : ChatColor.RESET.name));
        }
        throw new UnsupportedOperationException("Unable to adapt chat color to a Bukkit's ChatColor on a " + Environment.getCurrent().getName() + " environment");
    }

    public TextElement spongeValue() {
        if (Environment.isSponge()) {
            return SpongeChatColor.adapt(this);
        }
        throw new UnsupportedOperationException("Unable to adapt chat color to a Sponge's TextElement on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_5251 fabricValue() {
        if (Environment.isFabric()) {
            return this.isDefaultColor() ? (class_5251)class_5251.method_27719((String)this.name.toLowerCase()).getOrThrow() : class_5251.method_27717((int)this.color.getRGB());
        }
        throw new UnsupportedOperationException("Unable to adapt chat color to a Fabric's TextColor on a " + Environment.getCurrent().getName() + " environment");
    }

    public net.md_5.bungee.api.ChatColor bungeeCordValue() {
        if (Environment.isBungeeCord() || VersionUtils.isSpigot()) {
            return this.isDefaultColor() ? net.md_5.bungee.api.ChatColor.valueOf((String)this.name) : net.md_5.bungee.api.ChatColor.of((Color)this.color);
        }
        throw new UnsupportedOperationException("Unable to adapt chat color to a BungeeCord's ChatColor on a " + Environment.getCurrent().getName() + " environment");
    }

    public TextFormat velocityValue() {
        if (Environment.isVelocity()) {
            return AdventureChatColor.adapt(this);
        }
        throw new UnsupportedOperationException("Unable to adapt chat color to a Velocity's TextFormat on a " + Environment.getCurrent().getName() + " environment");
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (this != VALUES[i]) continue;
            return i;
        }
        return -1;
    }

    public Character getCode() {
        return this.code;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isDefaultColor() {
        return this.ordinal() != -1;
    }

    public boolean isFormatCode() {
        return this.isDefaultColor() && FORMAT_CODES.contains(String.valueOf(this.code));
    }

    public ChatColor getClosestDefaultColor() {
        if (this.isDefaultColor() || this.isFormatCode()) {
            return this;
        }
        ChatColor closest = null;
        int smallestDiff = 0;
        int r = this.color.getRGB() >> 16 & 0xFF;
        int g = this.color.getRGB() >> 8 & 0xFF;
        int b = this.color.getRGB() & 0xFF;
        for (ChatColor defaultColor : VALUES) {
            if (defaultColor.getColor() == null) continue;
            int rgb = defaultColor.getColor().getRGB();
            if (rgb == this.color.getRGB()) {
                return defaultColor;
            }
            int rAverage = ((rgb >> 16 & 0xFF) + r) / 2;
            int rDiff = (rgb >> 16 & 0xFF) - r;
            int gDiff = (rgb >> 8 & 0xFF) - g;
            int bDiff = (rgb & 0xFF) - b;
            int diff = (2 + (rAverage >> 8)) * rDiff * rDiff + 4 * gDiff * gDiff + (2 + (255 - rAverage >> 8)) * bDiff * bDiff;
            if (closest != null && diff >= smallestDiff) continue;
            closest = defaultColor;
            smallestDiff = diff;
        }
        return closest;
    }

    public static ChatColor of(Color color) {
        return ChatColor.of("#" + String.format("%08x", color.getRGB()).substring(2));
    }

    public static ChatColor of(String hex) {
        String string = hex = hex.startsWith("#") ? hex : "#" + hex;
        if (hex.length() != 7) {
            throw new NumberFormatException("Specified string's format is invalid");
        }
        Color.decode(hex);
        int rgb = Integer.parseInt(hex.substring(1), 16) | 0xFF000000;
        for (ChatColor defaultColor : VALUES) {
            if (defaultColor.getColor() == null || defaultColor.getColor().getRGB() != rgb) continue;
            return defaultColor;
        }
        StringBuilder sb = new StringBuilder("\u00a7x");
        for (char x : hex.substring(1).toCharArray()) {
            sb.append('\u00a7').append(x);
        }
        return new ChatColor(hex.toUpperCase(), sb.toString().toLowerCase(), rgb);
    }

    public static String translate(String string) {
        return ChatColor.translate(string, true);
    }

    public static String translate(String string, boolean retainNewLines) {
        String message = string;
        if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_16)) {
            for (Pattern pattern : HEX_COLORS) {
                Matcher matcher = pattern.matcher(message);
                while (matcher.find()) {
                    message = message.substring(0, matcher.start()) + ChatColor.of(matcher.group().substring(1, matcher.group().length())) + message.substring(matcher.end());
                    matcher = pattern.matcher(message);
                }
            }
        }
        char[] array = message.toCharArray();
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] != '&' || CODES.indexOf(array[i + 1]) == -1) continue;
            array[i] = 167;
            array[i + 1] = Character.toLowerCase(array[i + 1]);
        }
        return retainNewLines ? new String(array) : new String(array).replace("\r\n", " ").replace("\n", " ").replace("\r", " ");
    }

    public static List<String> translate(List<String> list) {
        return ChatColor.translate(list, true);
    }

    public static List<String> translate(List<String> list, boolean retainNewLines) {
        return list.stream().map(string -> ChatColor.translate(string, retainNewLines)).collect(Collectors.toList());
    }

    public static String stripColor(String string) {
        return STRIP_COLOR.matcher(string).replaceAll("");
    }

    public static String getLastColors(String string) {
        String colors = "";
        if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_16)) {
            Matcher matcher = TRANSLATED_HEX_COLORS.matcher(string);
            int index = 0;
            while (matcher.find()) {
                colors = matcher.group();
                index = matcher.end();
            }
            if (index != 0) {
                string = string.substring(index);
            }
        }
        char[] array = string.toCharArray();
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] != '\u00a7' || CODES.indexOf(array[i + 1]) == -1) continue;
            colors = COLOR_CODES.indexOf(array[i + 1]) != -1 ? "\u00a7" + array[i + 1] : colors + "\u00a7" + array[i + 1];
        }
        return colors;
    }

    public static boolean isColorCode(char character) {
        return COLOR_CODES.contains(String.valueOf(character));
    }

    public static boolean isFormatCode(char character) {
        return FORMAT_CODES.contains(String.valueOf(character));
    }

    public static boolean isColorString(String string) {
        if ((string = string.trim()).length() % 2 != 0) {
            return false;
        }
        boolean colorCodeExpected = true;
        for (int index = string.length() - 1; index > 0; --index) {
            if (colorCodeExpected ? !ChatColor.isColorCode(string.charAt(index)) && !ChatColor.isFormatCode(string.charAt(index)) : string.charAt(index) != '\u00a7') {
                return false;
            }
            colorCodeExpected = !colorCodeExpected;
        }
        return true;
    }

    public static ChatColor getRandomColor() {
        return VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_16) ? ChatColor.of(String.format("%06x", ThreadLocalRandom.current().nextInt(0x1000000))) : VALUES[ThreadLocalRandom.current().nextInt(16)];
    }

    public static ChatColor getByChar(char code) {
        return BY_CHAR.get(Character.valueOf(Character.toLowerCase(code)));
    }

    public static ChatColor valueOf(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        ChatColor value = BY_NAME.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No pseudo-enum constant ChatColor." + name);
        }
        return value;
    }

    public static ChatColor[] values() {
        return VALUES;
    }

    private static class SpongeChatColor {
        private SpongeChatColor() {
        }

        public static TextElement adapt(ChatColor chatColor) {
            try {
                return (org.spongepowered.api.text.format.TextColor)TextColors.class.getField(chatColor.isDefaultColor() ? chatColor.name : RESET.name).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
                try {
                    return (TextStyle)TextStyles.class.getField(chatColor.name).get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e2) {
                    e.printStackTrace();
                    return TextColors.RESET;
                }
            }
        }
    }

    private static class AdventureChatColor {
        private AdventureChatColor() {
        }

        public static TextFormat adapt(ChatColor chatColor) {
            return chatColor.isFormatCode() ? (TextFormat)TextDecoration.NAMES.value((Object)(chatColor == UNDERLINE ? "UNDERLINED" : chatColor.name)) : TextColor.color((int)chatColor.color.getRed(), (int)chatColor.color.getGreen(), (int)chatColor.color.getBlue());
        }
    }
}

