/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.packet;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import me.remigio07.chatplugin.api.server.util.manager.ProxyManager;

public class PacketSerializer {
    private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private DataOutputStream output = new DataOutputStream(this.bytes);

    public PacketSerializer(String subchannel) {
        try {
            this.output.writeUTF(subchannel);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public PacketSerializer writeBoolean(boolean arg) {
        try {
            this.output.writeBoolean(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeByte(byte arg) {
        try {
            this.output.writeByte(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeChar(char arg) {
        try {
            this.output.writeChar(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeShort(short arg) {
        try {
            this.output.writeShort(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeInt(int arg) {
        try {
            this.output.writeInt(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeLong(long arg) {
        try {
            this.output.writeLong(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeFloat(float arg) {
        try {
            this.output.writeFloat(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeDouble(double arg) {
        try {
            this.output.writeDouble(arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeUTF(String arg) {
        try {
            this.output.writeUTF(arg == null ? "${null_string}" : arg);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public PacketSerializer writeUTFArray(String ... args) {
        this.writeInt(args.length);
        for (String utf : args) {
            this.writeUTF(utf);
        }
        return this;
    }

    public PacketSerializer writeUUID(UUID arg) {
        this.writeUTF(arg == null ? null : arg.toString());
        return this;
    }

    public PacketSerializer writeServerID() {
        try {
            this.output.writeUTF(ProxyManager.getInstance().getServerID());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this;
    }

    public byte[] toArray() {
        byte[] array = this.bytes.toByteArray();
        if (array.length > Short.MAX_VALUE) {
            throw new IllegalStateException("Packet exceeds maximum length of 32767");
        }
        return array;
    }
}

