/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.packet;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.UUID;

public class PacketDeserializer {
    private DataInputStream input;

    public PacketDeserializer(byte[] bytes) {
        if (bytes.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Packet exceeds maximum length of 32767");
        }
        this.input = new DataInputStream(new ByteArrayInputStream(bytes));
    }

    public DataInputStream getInput() {
        return this.input;
    }

    public boolean readBoolean() {
        try {
            return this.input.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte readByte() {
        try {
            return this.input.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public char readChar() {
        try {
            return this.input.readChar();
        }
        catch (IOException e) {
            e.printStackTrace();
            return '\u0000';
        }
    }

    public short readShort() {
        try {
            return this.input.readShort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int readInt() {
        try {
            return this.input.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public long readLong() {
        try {
            return this.input.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public float readFloat() {
        try {
            return this.input.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public double readDouble() {
        try {
            return this.input.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public String readUTF() {
        try {
            String utf = this.input.readUTF();
            return utf.equals("${null_string}") ? null : utf;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] readUTFArray() {
        String[] array = new String[this.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readUTF();
        }
        return array;
    }

    public UUID readUUID() {
        String uuid = this.readUTF();
        return uuid == null ? null : UUID.fromString(uuid);
    }
}

