/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.manager;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.storage.StorageManager;
import me.remigio07.chatplugin.api.common.storage.StorageMethod;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.storage.database.DatabaseManager;
import me.remigio07.chatplugin.api.common.storage.flat_file.FlatFileManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;

public abstract class ChatPluginManagers {
    protected static ChatPluginManagers instance;
    protected Map<Class<? extends ChatPluginManager>, ChatPluginManager> managers = new LinkedHashMap<Class<? extends ChatPluginManager>, ChatPluginManager>();
    protected DatabaseManager databaseManager;
    protected FlatFileManager flatFileManager;

    public Map<Class<? extends ChatPluginManager>, ChatPluginManager> getManagers() {
        return this.managers;
    }

    public List<ChatPluginManager> getEnabledManagers() {
        return this.managers.values().stream().filter(ChatPluginManager::isEnabled).collect(Collectors.toList());
    }

    public void unloadManagers() throws ChatPluginManagerException {
        for (ChatPluginManager manager : Lists.reverse(this.managers.values().stream().filter(ChatPluginManager::isEnabled).collect(Collectors.toList()))) {
            manager.unload();
        }
    }

    public <T extends ChatPluginManager> T getManager(Class<T> clazz) {
        return (T)this.managers.get(clazz);
    }

    @Deprecated
    public ChatPluginManager getManager(String name) {
        for (Class<? extends ChatPluginManager> clazz : this.managers.keySet()) {
            String className = clazz.getSimpleName();
            if (!className.contains("Manager") || !className.substring(0, className.indexOf("Manager")).equalsIgnoreCase(name)) continue;
            return this.managers.get(clazz);
        }
        return null;
    }

    public void addManager(Class<? extends ChatPluginManager> clazz, ChatPluginManager manager) throws ChatPluginManagerException {
        this.managers.put(clazz, manager);
        manager.load();
    }

    public void reloadManagers() throws ChatPluginManagerException {
        List managers = this.managers.values().stream().filter(ChatPluginManager::isReloadable).collect(Collectors.toList());
        for (ChatPluginManager manager : Lists.reverse(managers.stream().filter(ChatPluginManager::isEnabled).collect(Collectors.toList()))) {
            manager.unload();
        }
        for (ChatPluginManager manager : managers) {
            if (manager instanceof StorageManager) {
                StorageManager storageManager = this.getStorageMethod().isDatabase() ? this.getDatabaseManager() : this.getFlatFileManager();
                this.managers.put(StorageManager.class, storageManager);
                storageManager.load();
                continue;
            }
            manager.load();
        }
        PlayerManager.getInstance().loadOnlinePlayers();
    }

    protected StorageMethod getStorageMethod() throws ChatPluginManagerException {
        String method = ConfigurationType.CONFIG.get().getString("storage.method");
        try {
            return StorageMethod.valueOf(method.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ChatPluginManagerException("managers utils", "Invalid storage method (\"{0}\") set at \"storage.method\" in config.yml: only H2, SQLITE, MYSQL, YAML and JSON are allowed.", method);
        }
    }

    public static ChatPluginManagers getInstance() {
        return instance;
    }

    public abstract void loadManagers() throws ChatPluginManagerException;

    protected abstract DatabaseManager getDatabaseManager();

    protected abstract FlatFileManager getFlatFileManager();
}

