/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util.manager;

import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.server.util.GameFeature;
import me.remigio07.chatplugin.bootstrap.Environment;

public interface ChatPluginManager {
    public void load() throws ChatPluginManagerException;

    default public void unload() throws ChatPluginManagerException {
    }

    default public void reload() throws ChatPluginManagerException {
        this.unload();
        this.load();
    }

    public boolean isEnabled();

    default public boolean isReloadable() {
        return true;
    }

    default public boolean checkAvailability(boolean warnIfUnavailable) {
        GameFeature gameFeature;
        Class<?> clazz = this.getClass();
        while ((gameFeature = clazz.getAnnotation(GameFeature.class)) == null && (clazz = clazz.getSuperclass()) != null) {
        }
        if (gameFeature == null) {
            gameFeature = ChatPluginManager.checkInterfaces(this.getClass());
        }
        if (Environment.isProxy() || gameFeature == null) {
            return true;
        }
        String str = null;
        if (Environment.isBukkit()) {
            VersionUtils.Version minimumBukkitVersion = gameFeature.minimumBukkitVersion();
            if (minimumBukkitVersion == VersionUtils.Version.UNSUPPORTED) {
                str = "Bukkit cannot";
            } else if (gameFeature.spigotRequired() && !VersionUtils.isSpigot()) {
                str = "Spigot is required to";
            } else if (gameFeature.paperRequired() && !VersionUtils.isPaper()) {
                str = "Paper is required to";
            } else if (VersionUtils.getVersion().isOlderThan(minimumBukkitVersion)) {
                str = "At least Minecraft " + gameFeature.minimumBukkitVersion().toString() + " is required to";
            }
        } else if (Environment.isSponge()) {
            VersionUtils.Version minimumSpongeVersion = gameFeature.minimumSpongeVersion();
            if (minimumSpongeVersion == VersionUtils.Version.UNSUPPORTED) {
                str = "Sponge cannot";
            } else if (VersionUtils.getVersion().isOlderThan(minimumSpongeVersion)) {
                str = "At least Minecraft " + gameFeature.minimumSpongeVersion().toString() + " is required to";
            }
        } else {
            VersionUtils.Version minimumFabricVersion = gameFeature.minimumFabricVersion();
            if (minimumFabricVersion == VersionUtils.Version.UNSUPPORTED) {
                str = "Fabric cannot";
            } else if (VersionUtils.getVersion().isOlderThan(minimumFabricVersion)) {
                str = "At least Minecraft " + gameFeature.minimumFabricVersion().toString() + " is required to";
            }
        }
        if (str != null && warnIfUnavailable) {
            LogManager.log(str + " run the " + gameFeature.name() + " module; disabling feature...", 1, new Object[0]);
        }
        return str == null;
    }

    public static GameFeature checkInterfaces(Class<?> clazz) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            GameFeature feature = clazz2.getAnnotation(GameFeature.class);
            if (feature != null) {
                return feature;
            }
            if (!clazz2.isInterface() || (feature = ChatPluginManager.checkInterfaces(clazz2)) == null) continue;
            return feature;
        }
        return null;
    }
}

