/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagers;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.FabricBootstrapper;
import me.remigio07.chatplugin.bootstrap.VelocityBootstrapper;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ProxyServer;
import org.bukkit.Bukkit;
import org.spongepowered.api.Sponge;

public class Utils {
    public static final String STRING_NOT_FOUND = "string_not_found";
    public static final String NOT_APPLICABLE = "N/A";
    public static final String USER_AGENT = "Mozilla/5.0 +https://remigio07.me/chatplugin ChatPlugin/1.10.5";
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final Path ROOT_FOLDER = Paths.get("", new String[0]);
    public static final Pattern IPV4_PATTERN = Pattern.compile("^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}$");
    public static final int SECONDS_IN_A_YEAR = 31536000;
    public static final int SECONDS_IN_A_MONTH = 2592000;
    public static final int SECONDS_IN_A_WEEK = 604800;
    public static final int SECONDS_IN_A_DAY = 86400;
    public static final int SECONDS_IN_AN_HOUR = 3600;
    public static final int SECONDS_IN_A_MINUTE = 60;

    public static boolean isNumber(String number) {
        try {
            Double.parseDouble(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isFloat(String number) {
        try {
            Float.parseFloat(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String number) {
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String number) {
        try {
            Long.parseLong(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isPositiveInteger(String number) {
        try {
            int amount = Integer.parseInt(number);
            if (amount <= 0) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isPositiveLong(String number) {
        try {
            long amount = Long.parseLong(number);
            if (amount <= 0L) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double truncate(double number, int decimalPlaces) {
        double scale = Math.pow(10.0, decimalPlaces);
        return (double)Math.round(number * scale) / scale;
    }

    public static long kilometersToMiles(long kilometers) {
        return (long)((double)kilometers / 1.609344);
    }

    public static long kilometersToNauticalMiles(long kilometers) {
        return (long)((double)kilometers * 0.53995680345572);
    }

    public static int getMaxPlayers() {
        switch (Environment.getCurrent()) {
            case BUKKIT: {
                return Bukkit.getMaxPlayers();
            }
            case SPONGE: {
                return Sponge.getServer().getMaxPlayers();
            }
            case FABRIC: {
                return FabricBootstrapper.getInstance().getServer().method_3802();
            }
            case BUNGEECORD: {
                return ProxyServer.getInstance().getConfigurationAdapter().getInt("player_limit", -1);
            }
            case VELOCITY: {
                return VelocityBootstrapper.getInstance().getProxy().getConfiguration().getShowMaxPlayers();
            }
        }
        return -1;
    }

    public static boolean isValidIPv4(String ipv4) {
        return IPV4_PATTERN.matcher(ipv4).matches();
    }

    public static InetAddress getInetAddress(String ipv4) {
        if (Utils.isValidIPv4(ipv4)) {
            String[] bytes = ipv4.split("\\.");
            try {
                return InetAddress.getByAddress(new byte[]{Integer.valueOf(bytes[0]).byteValue(), Integer.valueOf(bytes[1]).byteValue(), Integer.valueOf(bytes[2]).byteValue(), Integer.valueOf(bytes[3]).byteValue()});
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Specified IPv4 does not respect the following pattern: \"" + IPV4_PATTERN.pattern() + "\"");
    }

    public static Class<? extends ChatPluginManager> getOriginalClass(ChatPluginManager manager) {
        for (Map.Entry<Class<? extends ChatPluginManager>, ChatPluginManager> entry : ChatPluginManagers.getInstance().getManagers().entrySet()) {
            if (!entry.getValue().equals(manager)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T> List<T> addAndGet(Collection<T> input, Collection<T> args) {
        CopyOnWriteArrayList<T> list2 = new CopyOnWriteArrayList<T>(input);
        for (T e : args) {
            if (list2.contains(e)) continue;
            list2.add(e);
        }
        return list2;
    }

    public static <T> List<T> removeAndGet(Collection<T> input, Collection<T> args) {
        CopyOnWriteArrayList<T> list2 = new CopyOnWriteArrayList<T>(input);
        for (T e : args) {
            if (!list2.contains(e)) continue;
            list2.remove(e);
        }
        return list2;
    }

    public static String getStringFromList(List<?> list, boolean translateColorCodes, boolean retainNewLines) {
        if (list.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Object s : list) {
            if (translateColorCodes) {
                sb.append(ChatColor.translate(s + "&r, ", retainNewLines));
                continue;
            }
            sb.append(s + ", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(translateColorCodes ? "\u00a7r]" : Character.valueOf(']'));
        return sb.toString();
    }

    public static List<String> getListFromString(String string) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || !string.startsWith("[") || !string.endsWith("]") || string.length() == 2) {
            return list;
        }
        string = string.substring(1, string.length() - 1);
        for (String str : string.split(", ")) {
            list.add(str);
        }
        return list;
    }

    public static void reverse(char[] array) {
        int i = 0;
        for (int j = Math.min(array.length, array.length - 1); j > i; --j, ++i) {
            char temp;
            array[i] = temp = array[j];
        }
    }

    public static int arrayIndexOf(String[] array, String string, boolean ignoreCase) {
        for (int i = 0; i < array.length; ++i) {
            if (!(ignoreCase ? array[i].equalsIgnoreCase(string) : array[i].equals(string))) continue;
            return i;
        }
        return -1;
    }

    public static boolean arrayContains(String[] array, String string, boolean ignoreCase) {
        return Utils.arrayIndexOf(array, string, ignoreCase) != -1;
    }

    public static String[] removeFromArray(String[] array, String string, boolean ignoreCase) {
        int index = Utils.arrayIndexOf(array, string, ignoreCase);
        if (array.length == 0 || index == -1) {
            return array;
        }
        String[] newArray = new String[array.length - 1];
        int destinationIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) continue;
            newArray[destinationIndex++] = array[i];
        }
        return newArray;
    }

    public static String capitalizeEveryWord(String input) {
        return Stream.of(input.toLowerCase().split("\\s")).filter(word -> !word.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }

    public static long getTime(String input, boolean addCurrent, boolean allow0s) {
        String[] array = input.split(",");
        int seconds = 0;
        int minutes = 0;
        int hours = 0;
        int days = 0;
        int weeks = 0;
        int months = 0;
        int years = 0;
        try {
            block11: for (int i = 0; i < array.length; ++i) {
                char[] chars = array[i].toCharArray();
                Utils.reverse(chars);
                switch (chars[0]) {
                    case 'Y': 
                    case 'y': {
                        years = Integer.valueOf(array[i].substring(0, array[i].toLowerCase().indexOf(121)));
                        continue block11;
                    }
                    case 'M': {
                        months = Integer.valueOf(array[i].substring(0, array[i].indexOf(77)));
                        continue block11;
                    }
                    case 'W': 
                    case 'w': {
                        weeks = Integer.valueOf(array[i].substring(0, array[i].toLowerCase().indexOf(119)));
                        continue block11;
                    }
                    case 'D': 
                    case 'd': {
                        days = Integer.valueOf(array[i].substring(0, array[i].toLowerCase().indexOf(100)));
                        continue block11;
                    }
                    case 'H': 
                    case 'h': {
                        hours = Integer.valueOf(array[i].substring(0, array[i].toLowerCase().indexOf(104)));
                        continue block11;
                    }
                    case 'm': {
                        minutes = Integer.valueOf(array[i].substring(0, array[i].indexOf(109)));
                        continue block11;
                    }
                    case 'S': 
                    case 's': {
                        seconds = Integer.valueOf(array[i].substring(0, array[i].toLowerCase().indexOf(115)));
                    }
                }
            }
            long time = Utils.getTime(years, months, weeks, days, hours, minutes, seconds, addCurrent);
            return time < 0L || time == 0L && (!allow0s || !input.equals("0s")) ? -1L : time;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return -1L;
        }
    }

    public static long getTime(int years, int months, int weeks, int days, int hours, int minutes, int seconds, boolean addCurrent) {
        return (addCurrent ? System.currentTimeMillis() : 0L) + (long)(((long)years < 0L ? 0 : years * 31536000) + ((long)months < 0L ? 0 : months * 2592000) + ((long)weeks < 0L ? 0 : weeks * 604800) + ((long)days < 0L ? 0 : days * 86400) + ((long)hours < 0L ? 0 : hours * 3600) + ((long)minutes < 0L ? 0 : minutes * 60) + ((long)seconds < 0L ? 0 : seconds)) * 1000L;
    }

    public static String replaceNumericPlaceholders(String string, Object ... args) {
        return Utils.replaceCustomPlaceholders(string, (String[])IntStream.range(0, args.length).mapToObj(String::valueOf).toArray(String[]::new), args);
    }

    public static String replaceCustomPlaceholders(String string, String[] placeholders, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            string = string.replace("{" + placeholders[i] + "}", String.valueOf(args[i]));
        }
        return string;
    }

    public static String toLegacyText(Component adventureComponent) {
        return AdventureComponent.toLegacyText(adventureComponent);
    }

    public static Component toAdventureComponent(String legacyText) {
        return AdventureComponent.toAdventureComponent(legacyText);
    }

    public static long getTotalStorage() {
        try {
            return Files.getFileStore(ROOT_FOLDER).getTotalSpace();
        }
        catch (IOException ioe) {
            LogManager.log("IOException occurred while getting the total storage: {0}", 2, ioe.getLocalizedMessage());
            return -1L;
        }
    }

    public static long getFreeStorage() {
        try {
            return Files.getFileStore(ROOT_FOLDER).getUsableSpace();
        }
        catch (IOException ioe) {
            LogManager.log("IOException occurred while getting the free storage: {0}", 2, ioe.getLocalizedMessage());
            return -1L;
        }
    }

    public static long getUnallocatedStorage() {
        try {
            return Files.getFileStore(ROOT_FOLDER).getUnallocatedSpace();
        }
        catch (IOException ioe) {
            LogManager.log("IOException occurred while getting the unallocated storage: {0}", 2, ioe.getLocalizedMessage());
            return -1L;
        }
    }

    private static class AdventureComponent {
        private AdventureComponent() {
        }

        public static Component toAdventureComponent(String legacyText) {
            return LegacyComponentSerializer.legacySection().deserialize(legacyText);
        }

        public static String toLegacyText(Component adventureComponent) {
            return LegacyComponentSerializer.legacySection().serialize(adventureComponent);
        }
    }
}

