/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.telegram;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookup;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.punishment.Punishment;
import me.remigio07.chatplugin.api.common.punishment.ban.BanManager;
import me.remigio07.chatplugin.api.common.punishment.mute.MuteManager;
import me.remigio07.chatplugin.api.common.punishment.warning.WarningManager;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.telegram.TelegramBot;
import me.remigio07.chatplugin.api.common.telegram.TelegramIntegrationManager;
import me.remigio07.chatplugin.api.common.telegram.TelegramMessage;
import me.remigio07.chatplugin.api.common.util.MemoryUtils;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.adapter.user.PlayerAdapter;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagers;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;

public class TelegramMessages {
    private static String getString(String path) {
        return ConfigurationType.TELEGRAM_INTEGRATION.get().getString(path);
    }

    private static String getString(TelegramMessage message) {
        return TelegramMessages.getString(message.getPath() + (ConfigurationType.TELEGRAM_INTEGRATION.get().contains(message.getPath() + ".enabled") ? ".value" : ""));
    }

    private static String formatTime(long totalMilliseconds, boolean everInsteadOfNever, boolean useZeroSecondsInstead) {
        StringBuilder sb = new StringBuilder();
        long totalSeconds = (totalMilliseconds + 999L) / 1000L;
        if (totalMilliseconds == -1L) {
            return TelegramMessages.getString(everInsteadOfNever ? "timestamps.ever" : "timestamps.never");
        }
        if (totalSeconds < 1L && !useZeroSecondsInstead) {
            return TelegramMessages.getString("timestamps.now");
        }
        int years = (int)(totalSeconds / 31536000L);
        int months = (int)((totalSeconds -= (long)(years * 31536000)) / 2592000L);
        int days = (int)((totalSeconds -= (long)(months * 2592000)) / 86400L);
        totalSeconds -= (long)(days * 86400);
        int weeks = 0;
        if (ConfigurationType.CONFIG.get().getBoolean("settings.use-week-timestamp")) {
            weeks = (int)(totalSeconds / 604800L);
            totalSeconds -= (long)(weeks * 604800);
        }
        int hours = (int)(totalSeconds / 3600L);
        int minutes = (int)((totalSeconds -= (long)(hours * 3600)) / 60L);
        totalSeconds -= (long)(minutes * 60);
        if (years != 0) {
            sb.append(years + (years == 1 ? "{year}, " : "{years}, "));
        }
        if (months != 0) {
            sb.append(months + (months == 1 ? "{month}, " : "{months}, "));
        }
        if (weeks != 0) {
            sb.append(weeks + (weeks == 1 ? "{week}, " : "{weeks}, "));
        }
        if (days != 0) {
            sb.append(days + (days == 1 ? "{day}, " : "{days}, "));
        }
        if (hours != 0) {
            sb.append(hours + (hours == 1 ? "{hour}, " : "{hours}, "));
        }
        if (minutes != 0) {
            sb.append(minutes + (minutes == 1 ? "{minute}, " : "{minutes}, "));
        }
        if (totalSeconds != 0L || useZeroSecondsInstead && minutes == 0 && hours == 0 && days == 0 && weeks == 0 && months == 0 && years == 0) {
            sb.append(totalSeconds + (totalSeconds == 1L ? "{second}" : "{seconds}"));
        } else {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString().replace("{second}", TelegramMessages.getString("timestamps.second")).replace("{seconds}", TelegramMessages.getString("timestamps.seconds")).replace("{minute}", TelegramMessages.getString("timestamps.minute")).replace("{minutes}", TelegramMessages.getString("timestamps.minutes")).replace("{hour}", TelegramMessages.getString("timestamps.hour")).replace("{hours}", TelegramMessages.getString("timestamps.hours")).replace("{day}", TelegramMessages.getString("timestamps.day")).replace("{days}", TelegramMessages.getString("timestamps.days")).replace("{week}", TelegramMessages.getString("timestamps.week")).replace("{weeks}", TelegramMessages.getString("timestamps.weeks")).replace("{month}", TelegramMessages.getString("timestamps.month")).replace("{months}", TelegramMessages.getString("timestamps.months")).replace("{year}", TelegramMessages.getString("timestamps.year")).replace("{years}", TelegramMessages.getString("timestamps.years"));
    }

    private static String formatDate(long ms) {
        long now = System.currentTimeMillis();
        return ms == -1L ? TelegramMessages.getString("timestamps.never") : new SimpleDateFormat(TelegramMessages.getString("simple-date-format")).format(new Date(ms + (long)PlayerManager.getInstance().getDisplayedTimeZone().getOffset(now) - (long)TimeZone.getDefault().getOffset(now)));
    }

    @Target(value={ElementType.FIELD})
    public static @interface MessageArguments {
        public Class<?>[] types();

        public String[] descriptions();
    }

    public static enum Mute implements TelegramMessage
    {
        INFO,
        LIST,
        EMPTY_LIST,
        MUTED,
        UPDATED,
        UNMUTED,
        EXPIRED;


        @Override
        public String getPath() {
            return "messages.mute." + this.name().toLowerCase().replace('_', '-');
        }

        @Override
        public String getValue(Object ... args) {
            return this.name().endsWith("LIST") ? (this == LIST ? TelegramMessages.getString(this).replace("{mutes}", Utils.getStringFromList(MuteManager.getInstance().getActiveMutes().stream().map(Punishment::getID).collect(Collectors.toList()), false, true)) : TelegramMessages.getString(this)) : this.formatValue((me.remigio07.chatplugin.api.common.punishment.mute.Mute)args[0]);
        }

        private String formatValue(me.remigio07.chatplugin.api.common.punishment.mute.Mute mute) {
            return TelegramMessages.getString(this).replace("{id}", String.valueOf(mute.getID())).replace("{player}", mute.getPlayer().getName()).replace("{player_uuid}", mute.getPlayer().getUUID().toString()).replace("{staff_member}", mute.getStaffMember()).replace("{who_unmuted}", mute.getWhoUnmuted() == null ? TelegramMessages.getString("placeholders.nobody") : mute.getWhoUnmuted()).replace("{reason}", mute.getReason() == null ? TelegramMessages.getString("messages.mute.unspecified-reason") : ChatColor.stripColor(mute.getReason())).replace("{server}", mute.getServer()).replace("{date}", TelegramMessages.formatDate(mute.getDate())).replace("{unmute_date}", TelegramMessages.formatDate(mute.getUnmuteDate())).replace("{expiration_date}", mute.getDuration() == -1L ? TelegramMessages.getString("timestamps.never") : TelegramMessages.formatDate(mute.getDate() + mute.getDuration())).replace("{duration}", TelegramMessages.formatTime(mute.getDuration(), true, true)).replace("{remaining_time}", TelegramMessages.formatTime(mute.getRemainingTime(), true, true)).replace("{active}", Mute.getFormat("active." + (mute.isActive() ? "yes" : "no"))).replace("{global}", Mute.getFormat("global." + (mute.isGlobal() ? "yes" : "no"))).replace("{silent}", Mute.getFormat("silent." + (mute.isSilent() ? "yes" : "no")));
        }

        private static String getFormat(String type) {
            return TelegramMessages.getString("messages.mute.formats." + type);
        }
    }

    public static enum Kick implements TelegramMessage
    {
        INFO,
        KICKED;


        @Override
        public String getPath() {
            return "messages.kick." + this.name().toLowerCase().replace('_', '-');
        }

        @Override
        public String getValue(Object ... args) {
            return this.formatValue((me.remigio07.chatplugin.api.common.punishment.kick.Kick)args[0]);
        }

        private String formatValue(me.remigio07.chatplugin.api.common.punishment.kick.Kick kick) {
            return TelegramMessages.getString(this).replace("{id}", String.valueOf(kick.getID())).replace("{player}", kick.getPlayer().getName()).replace("{player_uuid}", kick.getPlayer().getUUID().toString()).replace("{ip_address}", kick.getIPAddress() == null ? TelegramMessages.getString("placeholders.not-present") : kick.getIPAddress().getHostAddress()).replace("{staff_member}", kick.getStaffMember()).replace("{reason}", kick.getReason() == null ? TelegramMessages.getString("messages.kick.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(kick.getReason()))).replace("{server}", kick.getServer()).replace("{type}", Kick.getFormat("types." + kick.getType().name().toLowerCase())).replace("{date}", TelegramMessages.formatDate(kick.getDate())).replace("{silent}", Kick.getFormat("silent." + (kick.isSilent() ? "yes" : "no")));
        }

        private static String getFormat(String type) {
            return TelegramMessages.getString("messages.kick.formats." + type);
        }
    }

    public static enum Warning implements TelegramMessage
    {
        INFO,
        LIST,
        EMPTY_LIST,
        WARNED,
        REMOVED,
        CLEARED,
        EXPIRED;


        @Override
        public String getPath() {
            return "messages.warning." + this.name().toLowerCase().replace('_', '-');
        }

        @Override
        public String getValue(Object ... args) {
            switch (this.ordinal()) {
                case 1: {
                    return TelegramMessages.getString(this).replace("{warnings}", Utils.getStringFromList(WarningManager.getInstance().getActiveWarnings().stream().map(Punishment::getID).collect(Collectors.toList()), false, true));
                }
                case 2: {
                    return TelegramMessages.getString(this);
                }
                case 5: {
                    return this.getClearWarningsValues((me.remigio07.chatplugin.api.common.player.OfflinePlayer)args[0], (String)args[1]);
                }
            }
            return this.formatValue((me.remigio07.chatplugin.api.common.punishment.warning.Warning)args[0]);
        }

        private String formatValue(me.remigio07.chatplugin.api.common.punishment.warning.Warning warning) {
            return TelegramMessages.getString(this).replace("{id}", String.valueOf(warning.getID())).replace("{player}", warning.getPlayer().getName()).replace("{player_uuid}", warning.getPlayer().getUUID().toString()).replace("{staff_member}", warning.getStaffMember()).replace("{who_unwarned}", warning.getWhoUnwarned() == null ? TelegramMessages.getString("placeholders.nobody") : warning.getWhoUnwarned()).replace("{reason}", warning.getReason() == null ? TelegramMessages.getString("messages.warning.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(warning.getReason()))).replace("{server}", warning.getServer()).replace("{date}", TelegramMessages.formatDate(warning.getDate())).replace("{unwarn_date}", TelegramMessages.formatDate(warning.getUnwarnDate())).replace("{expiration_date}", TelegramMessages.formatDate(warning.getDate() + warning.getDuration())).replace("{duration}", TelegramMessages.formatTime(warning.getDuration(), true, true)).replace("{remaining_time}", TelegramMessages.formatTime(warning.getRemainingTime(), true, true)).replace("{amount}", String.valueOf(WarningManager.getInstance().getActiveWarnings(warning.getPlayer(), warning.getServer()).stream().filter(other -> other.getDate() <= warning.getDate()).count())).replace("{max_amount}", String.valueOf(ConfigurationType.CONFIG.get().getInt("warning.max-warnings-placeholder." + warning.getServer()))).replace("{active}", Warning.getFormat("active." + (warning.isActive() ? "yes" : "no"))).replace("{global}", Warning.getFormat("global." + (warning.isGlobal() ? "yes" : "no"))).replace("{silent}", Warning.getFormat("silent." + (warning.isSilent() ? "yes" : "no")));
        }

        private String getClearWarningsValues(me.remigio07.chatplugin.api.common.player.OfflinePlayer player, String whoUnwarned) {
            return TelegramMessages.getString(this).replace("{player}", player.getName()).replace("{player_uuid}", player.getUUID().toString()).replace("{who_unwarned}", whoUnwarned == null ? TelegramMessages.getString("placeholders.nobody") : whoUnwarned);
        }

        private static String getFormat(String type) {
            return TelegramMessages.getString("messages.warning.formats." + type);
        }
    }

    public static enum Ban implements TelegramMessage
    {
        INFO,
        LIST,
        EMPTY_LIST,
        BANNED,
        UPDATED,
        UNBANNED,
        EXPIRED;


        @Override
        public String getPath() {
            return "messages.ban." + this.name().toLowerCase().replace('_', '-');
        }

        @Override
        public String getValue(Object ... args) {
            return this.name().endsWith("LIST") ? (this == LIST ? TelegramMessages.getString(this).replace("{bans}", Utils.getStringFromList(BanManager.getInstance().getActiveBans().stream().map(Punishment::getID).collect(Collectors.toList()), false, true)) : TelegramMessages.getString(this)) : this.formatValue((me.remigio07.chatplugin.api.common.punishment.ban.Ban)args[0]);
        }

        private String formatValue(me.remigio07.chatplugin.api.common.punishment.ban.Ban ban) {
            return TelegramMessages.getString(this).replace("{id}", String.valueOf(ban.getID())).replace("{player}", ban.getPlayer() == null ? TelegramMessages.getString("placeholders.not-present") : ban.getPlayer().getName()).replace("{player_uuid}", ban.getPlayer() == null ? TelegramMessages.getString("placeholders.not-present") : ban.getPlayer().getUUID().toString()).replace("{ip_address}", ban.getIPAddress() == null ? TelegramMessages.getString("placeholders.not-present") : ban.getIPAddress().getHostAddress()).replace("{staff_member}", ban.getStaffMember()).replace("{who_unbanned}", ban.getWhoUnbanned() == null ? TelegramMessages.getString("placeholders.nobody") : ban.getWhoUnbanned()).replace("{reason}", ban.getReason() == null ? TelegramMessages.getString("messages.ban.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(ban.getReason()))).replace("{server}", ban.getServer()).replace("{type}", Ban.getFormat("types." + ban.getType().name().toLowerCase())).replace("{date}", TelegramMessages.formatDate(ban.getDate())).replace("{unban_date}", TelegramMessages.formatDate(ban.getUnbanDate())).replace("{expiration_date}", ban.getDuration() == -1L ? TelegramMessages.getString("timestamps.never") : TelegramMessages.formatDate(ban.getDate() + ban.getDuration())).replace("{duration}", TelegramMessages.formatTime(ban.getDuration(), true, true)).replace("{remaining_time}", TelegramMessages.formatTime(ban.getRemainingTime(), true, true)).replace("{active}", Ban.getFormat("active." + (ban.isActive() ? "yes" : "no"))).replace("{global}", Ban.getFormat("global." + (ban.isGlobal() ? "yes" : "no"))).replace("{silent}", Ban.getFormat("silent." + (ban.isSilent() ? "yes" : "no")));
        }

        private static String getFormat(String type) {
            return TelegramMessages.getString("messages.ban.formats." + type);
        }
    }

    public static enum Misc implements TelegramMessage
    {
        INEXISTENT_ID,
        NO_PERMISSION,
        INVALID_NUMBER,
        GROUP_ONLY_ACTION,
        WRONG_SYNTAX,
        DISABLED_FEATURE,
        INVALID_IP_ADDRESS,
        AT_LEAST_ONE_ONLINE,
        IP_LOOKUP;


        @Override
        public String getPath() {
            return "messages." + this.name().toLowerCase().replace('_', '-');
        }

        @Override
        public String getValue(Object ... args) {
            String value = TelegramMessages.getString(this);
            return this == WRONG_SYNTAX ? value.replace("{usage}", (String)args[0]) : (this == IP_LOOKUP ? ((IPLookup)args[0]).formatPlaceholders(value) : value);
        }
    }

    public static enum OfflinePlayer implements TelegramMessage
    {
        PLAYER_PUNISHMENTS;


        @Override
        public String getPath() {
            throw new UnsupportedOperationException("Not available yet");
        }

        @Override
        public String getValue(Object ... args) {
            throw new UnsupportedOperationException("Not available yet");
        }
    }

    public static enum OnlinePlayer implements TelegramMessage
    {
        PLAYER_INFO;


        @Override
        public String getPath() {
            throw new UnsupportedOperationException("Not available yet");
        }

        @Override
        public String getValue(Object ... args) {
            throw new UnsupportedOperationException("Not available yet");
        }
    }

    public static enum Main implements TelegramMessage
    {
        HELP,
        INFO,
        STATUS,
        VERSION;


        @Override
        public String getPath() {
            return "messages.main." + this.name().toLowerCase().replace('_', '-');
        }

        @Override
        public String getValue(Object ... args) {
            return this.translateStatus(TelegramMessages.getString(this));
        }

        private String translateVersion(String input) {
            return input == null ? null : input.replace("{chatplugin_version}", "1.10.5").replace("{java_telegram_bot_api_version}", TelegramIntegrationManager.getInstance().getJavaTelegramBotAPIVersion());
        }

        public String translateStatus(String input) {
            return input == null ? null : this.translateVersion(input.replace("{online_minecraft}", String.valueOf(PlayerAdapter.getOnlinePlayers().size())).replace("{telegram_users}", String.valueOf(TelegramBot.getInstance().getUsers())).replace("{enabled_players}", String.valueOf(PlayerManager.getInstance().getPlayers().size())).replace("{enabled_managers}", String.valueOf(ChatPluginManagers.getInstance().getEnabledManagers().size())).replace("{max_players}", String.valueOf(Utils.getMaxPlayers())).replace("{date}", TelegramMessages.formatDate(System.currentTimeMillis())).replace("{startup_time}", String.valueOf(ChatPlugin.getInstance().getStartupTime())).replace("{last_reload_time}", String.valueOf(ChatPlugin.getInstance().getLastReloadTime())).replace("{java_version}", System.getProperty("java.version")).replace("{environment}", VersionUtils.getImplementationName()).replace("{environment_version}", VersionUtils.getImplementationVersion()).replace("{uptime}", TelegramMessages.formatTime(ManagementFactory.getRuntimeMXBean().getUptime(), false, false)).replace("{max_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().maxMemory(), MemoryUtils.MEGABYTE)).replace("{total_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().totalMemory(), MemoryUtils.MEGABYTE)).replace("{used_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory(), MemoryUtils.MEGABYTE)).replace("{free_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().freeMemory(), MemoryUtils.MEGABYTE)).replace("{total_storage}", MemoryUtils.formatMemory(Utils.getTotalStorage(), MemoryUtils.GIGABYTE)).replace("{used_storage}", MemoryUtils.formatMemory(Utils.getTotalStorage() - Utils.getFreeStorage(), MemoryUtils.GIGABYTE)).replace("{free_storage}", MemoryUtils.formatMemory(Utils.getFreeStorage(), MemoryUtils.GIGABYTE)).replace("{os_name}", System.getProperty("os.name")).replace("{os_arch}", System.getProperty("os.arch")).replace("{os_version}", System.getProperty("os.version")).replace("{active_threads}", String.valueOf(Thread.activeCount())));
        }
    }
}

