/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage.flat_file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.common.storage.DataContainer;
import me.remigio07.chatplugin.api.common.storage.StorageConnector;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;

public abstract class FlatFileConnector
extends StorageConnector {
    @Override
    public Set<DataContainer> getMissingDataContainers() {
        return Stream.of(DataContainer.values()).filter(container -> Files.exists(container.getFlatFile(), new LinkOption[0])).collect(Collectors.toCollection(() -> EnumSet.noneOf(DataContainer.class)));
    }

    @Override
    public void createDataContainer(DataContainer container) throws IOException {
        LogManager.log("Creating default data container \"{0}\"...", 0, container.getFlatFile().getFileName().toString());
        Files.createFile(container.getFlatFile(), new FileAttribute[0]);
    }
}

