/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage.configuration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationMappings;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;

public abstract class Configuration {
    protected ConfigurationType type;
    protected ConfigurationMappings mappings;
    protected Path path;

    public ConfigurationType getType() {
        return this.type;
    }

    public ConfigurationMappings getMappings() {
        return this.mappings;
    }

    public Path getPath() {
        return this.path;
    }

    public void createFile(FileAttribute<?> ... attributes) throws IOException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            if (this.path.getParent() != null) {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            }
            Files.createFile(this.path, attributes);
        }
    }

    public ConfigurationMappings getSection(String path) {
        return this.mappings.getSection(path);
    }

    public List<String> getKeys() {
        return this.mappings.getKeys();
    }

    public List<String> getKeys(String path) {
        return this.mappings.getKeys(path);
    }

    public boolean contains(String path) {
        return this.mappings.contains(path);
    }

    public void addDefault(String path, Object value) {
        this.mappings.addDefault(path, value);
    }

    public void set(String path, Object value) {
        this.mappings.set(path, value);
    }

    public boolean getBoolean(String path) {
        return this.mappings.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.mappings.getBoolean(path, def);
    }

    public byte getByte(String path) {
        return this.mappings.getByte(path, (byte)0);
    }

    public byte getByte(String path, byte def) {
        return this.mappings.getByte(path, def);
    }

    public short getShort(String path) {
        return this.mappings.getShort(path, (short)0);
    }

    public short getShort(String path, short def) {
        return this.mappings.getShort(path, def);
    }

    public int getInt(String path) {
        return this.mappings.getInt(path, 0);
    }

    public int getInt(String path, int def) {
        return this.mappings.getInt(path, def);
    }

    public long getLong(String path) {
        return this.mappings.getLong(path, 0L);
    }

    public long getLong(String path, long def) {
        return this.mappings.getLong(path, def);
    }

    public float getFloat(String path) {
        return this.mappings.getFloat(path, 0.0f);
    }

    public float getFloat(String path, float def) {
        return this.mappings.getFloat(path, def);
    }

    public double getDouble(String path) {
        return this.mappings.getDouble(path, 0.0);
    }

    public double getDouble(String path, double def) {
        return this.mappings.getDouble(path, def);
    }

    public String getString(String path) {
        return this.mappings.getString(path, "");
    }

    public String getString(String path, String def) {
        return this.mappings.getString(path, def);
    }

    public List<?> getList(String path) {
        return this.mappings.getList(path, new ArrayList());
    }

    public <T> List<T> getList(String path, List<T> def) {
        return this.mappings.getList(path, def);
    }

    public List<Boolean> getBooleanList(String path) {
        return this.mappings.getBooleanList(path);
    }

    public List<Byte> getByteList(String path) {
        return this.mappings.getByteList(path);
    }

    public List<Short> getShortList(String path) {
        return this.mappings.getShortList(path);
    }

    public List<Integer> getIntegerList(String path) {
        return this.mappings.getIntegerList(path);
    }

    public List<Long> getLongList(String path) {
        return this.mappings.getLongList(path);
    }

    public List<Float> getFloatList(String path) {
        return this.mappings.getFloatList(path);
    }

    public List<Double> getDoubleList(String path) {
        return this.mappings.getDoubleList(path);
    }

    public List<String> getStringList(String path) {
        return this.mappings.getStringList(path);
    }

    public String translateString(String path) {
        return this.mappings.translateString(path);
    }

    public String translateString(String path, String def) {
        return this.mappings.translateString(path, def);
    }

    public String translateString(String path, String def, boolean retainNewLines) {
        return this.mappings.translateString(path, def, retainNewLines);
    }

    public List<String> translateStringList(String path) {
        return this.mappings.translateStringList(path);
    }

    public List<String> translateStringList(String path, List<String> def) {
        return this.mappings.translateStringList(path, def);
    }

    public List<String> translateStringList(String path, List<String> def, boolean retainNewLines) {
        return this.mappings.translateStringList(path, def, retainNewLines);
    }

    protected ConfigurationMappings createMappings(Map<String, Object> map) {
        return new ConfigurationMappings(map);
    }

    public abstract void load() throws IOException;

    public abstract void save() throws IOException;
}

