/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.punishment.ban;

import java.net.InetAddress;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.punishment.Punishment;
import me.remigio07.chatplugin.api.common.punishment.ban.BanType;

public abstract class Ban
extends Punishment {
    public static final String[] PLACEHOLDERS = new String[]{"id", "player", "player_uuid", "ip_address", "staff_member", "who_unbanned", "reason", "server", "type", "date", "unban_date", "expiration_date", "duration", "remaining_time", "active", "global", "silent"};
    protected InetAddress ipAddress;
    protected String whoUnbanned;
    protected BanType type;
    protected long unbanDate;
    protected long duration;
    protected long taskID = -1L;
    protected boolean global;

    protected Ban(int id, OfflinePlayer player, InetAddress ipAddress, String staffMember, String whoUnbanned, String reason, String server, BanType type, long date, long unbanDate, long duration, boolean global, boolean silent) {
        super(id, player, staffMember, reason, server, date, silent);
        this.ipAddress = ipAddress;
        this.whoUnbanned = whoUnbanned;
        this.type = type;
        this.unbanDate = unbanDate;
        this.duration = duration;
        this.global = global;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public InetAddress getIPAddress() {
        return this.ipAddress;
    }

    public String getWhoUnbanned() {
        return this.whoUnbanned;
    }

    public void setWhoUnbanned(String whoUnbanned) {
        this.whoUnbanned = whoUnbanned;
    }

    public BanType getType() {
        return this.type;
    }

    public long getUnbanDate() {
        return this.unbanDate;
    }

    public void setUnbanDate(long unbanDate) {
        this.unbanDate = unbanDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getRemainingTime() {
        return this.getWhoUnbanned() == null ? (this.duration == -1L ? -1L : (System.currentTimeMillis() > this.date + this.duration ? 0L : this.date + this.duration - System.currentTimeMillis())) : 0L;
    }

    public long getTaskID() {
        return this.taskID;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isActive() {
        return this.getRemainingTime() != 0L;
    }
}

