/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.player;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.integration.IntegrationType;
import me.remigio07.chatplugin.api.common.integration.permission.PermissionIntegration;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.storage.DataContainer;
import me.remigio07.chatplugin.api.common.storage.PlayersDataType;
import me.remigio07.chatplugin.api.common.storage.StorageConnector;
import me.remigio07.chatplugin.api.common.util.UUIDFetcher;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.adapter.user.PlayerAdapter;
import me.remigio07.chatplugin.api.common.util.manager.TaskManager;
import me.remigio07.chatplugin.api.proxy.player.ChatPluginProxyPlayer;
import me.remigio07.chatplugin.api.proxy.player.ProxyPlayerManager;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.player.ServerPlayerManager;
import me.remigio07.chatplugin.api.server.util.adapter.user.CommandSenderAdapter;
import me.remigio07.chatplugin.bootstrap.Environment;

public class OfflinePlayer {
    protected UUID uuid;
    protected String name;

    public OfflinePlayer(PlayerAdapter player) {
        this(player.getUUID(), player.getName());
    }

    public OfflinePlayer(CommandSenderAdapter sender) {
        this(sender.getUUID(), sender.getName());
    }

    public OfflinePlayer(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public int hashCode() {
        return ChatPlugin.getInstance().isOnlineMode() ? this.uuid.hashCode() : (this.name == null ? -1 : this.name.hashCode());
    }

    public boolean equals(Object obj) {
        return obj instanceof OfflinePlayer ? (ChatPlugin.getInstance().isOnlineMode() ? ((OfflinePlayer)obj).getUUID().equals(this.uuid) : (((OfflinePlayer)obj).getName() == null ? false : ((OfflinePlayer)obj).getName().equalsIgnoreCase(this.name))) : false;
    }

    public String toString() {
        return new StringJoiner(", ", "OfflinePlayer{", "}").add("uuid=" + this.uuid.toString()).add("name=\"" + this.name + "\"").toString();
    }

    public boolean isPaidAccount() {
        return this.uuid.version() == 4 || this.uuid.version() == 0;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getIPAddress() {
        PlayerAdapter player = PlayerAdapter.getPlayer(this.uuid);
        if (player == null) {
            try {
                return Utils.getInetAddress(StorageConnector.getInstance().getPlayerData(PlayersDataType.PLAYER_IP, this).toString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return player.getIPAddress();
    }

    public boolean isOnline() {
        return PlayerAdapter.getPlayer(this.uuid) != null;
    }

    public boolean isLoaded() {
        return this.isOnline() && PlayerManager.getInstance().getPlayer(this.uuid) != null;
    }

    public boolean hasPlayedBefore() {
        try {
            return StorageConnector.getInstance().isPlayerStored(this);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean hasPermission(String permission) {
        return this.isOnline() ? this.toAdapter().hasPermission(permission) : (IntegrationType.VAULT.isEnabled() && IntegrationType.VAULT.get().getAPI() != null ? ((PermissionIntegration)((Object)IntegrationType.VAULT.get())).hasPermission(this, permission) : (IntegrationType.LUCKPERMS.isEnabled() ? IntegrationType.LUCKPERMS.get().hasPermission(this, permission) : false));
    }

    public PlayerAdapter toAdapter() {
        return PlayerAdapter.getPlayer(this.uuid);
    }

    public ChatPluginServerPlayer toServerPlayer() {
        if (Environment.isProxy()) {
            throw new UnsupportedOperationException("Unable to get a ChatPluginServerPlayer on a " + Environment.getCurrent().getName() + " environment");
        }
        return ServerPlayerManager.getInstance().getPlayer(this.uuid);
    }

    public ChatPluginProxyPlayer toProxyPlayer() {
        if (Environment.isProxy()) {
            return ProxyPlayerManager.getInstance().getPlayer(this.uuid);
        }
        throw new UnsupportedOperationException("Unable to get a ChatPluginProxyPlayer on a " + Environment.getCurrent().getName() + " environment");
    }

    public static CompletableFuture<OfflinePlayer> get(String name) {
        PlayerAdapter player = PlayerAdapter.getPlayer(name, true);
        if (player == null) {
            if (!PlayerManager.getInstance().getFloodgateUsernamePrefix().isEmpty() && name.startsWith(PlayerManager.getInstance().getFloodgateUsernamePrefix()) || ChatPlugin.getInstance().isOnlineMode()) {
                CompletableFuture<OfflinePlayer> future = new CompletableFuture<OfflinePlayer>();
                TaskManager.runAsync(() -> {
                    try {
                        String finalName;
                        UUID uuid;
                        String storageUUID = StorageConnector.getInstance().select(DataContainer.PLAYERS, "player_uuid", String.class, new StorageConnector.WhereCondition("player_name", StorageConnector.WhereCondition.WhereOperator.EQUAL, name));
                        if (storageUUID == null) {
                            uuid = UUIDFetcher.getInstance().getOnlineUUID(name).get();
                            finalName = UUIDFetcher.getInstance().getName(uuid).get();
                        } else {
                            uuid = UUID.fromString(storageUUID);
                            finalName = StorageConnector.getInstance().select(DataContainer.PLAYERS, "player_name", String.class, new StorageConnector.WhereCondition("player_uuid", StorageConnector.WhereCondition.WhereOperator.EQUAL, uuid));
                        }
                        future.complete(new OfflinePlayer(uuid, finalName));
                    }
                    catch (InterruptedException | SQLException e) {
                        future.completeExceptionally(e);
                    }
                    catch (ExecutionException ee) {
                        future.completeExceptionally(ee.getCause());
                    }
                }, 0L);
                return future;
            }
            return CompletableFuture.completedFuture(new OfflinePlayer(UUIDFetcher.getInstance().getOfflineUUID(name), name));
        }
        return CompletableFuture.completedFuture(new OfflinePlayer(player));
    }

    public static CompletableFuture<OfflinePlayer> get(UUID uuid) {
        switch (uuid.version()) {
            case 0: 
            case 3: 
            case 4: {
                CompletableFuture<OfflinePlayer> future = new CompletableFuture<OfflinePlayer>();
                TaskManager.runAsync(() -> {
                    try {
                        String name = StorageConnector.getInstance().select(DataContainer.PLAYERS, "player_name", String.class, new StorageConnector.WhereCondition("player_uuid", StorageConnector.WhereCondition.WhereOperator.EQUAL, uuid.toString()));
                        future.complete(new OfflinePlayer(uuid, name == null ? UUIDFetcher.getInstance().getName(uuid).get() : name));
                    }
                    catch (IllegalArgumentException iae) {
                        future.completeExceptionally(new UnsupportedOperationException("Unable to obtain a player name from an offline UUIDv3"));
                    }
                    catch (InterruptedException | SQLException e) {
                        future.completeExceptionally(e);
                    }
                    catch (ExecutionException ee) {
                        future.completeExceptionally(ee.getCause());
                    }
                }, 0L);
                return future;
            }
        }
        throw new IllegalArgumentException("Specified UUIDv" + uuid.version() + " is not a valid Bedrock (v0), Java offline (v3) or Java online (v4) UUID");
    }
}

