/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.ip_lookup;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookupMethod;
import me.remigio07.chatplugin.api.server.language.Language;

public abstract class IPLookup {
    public static final String[] PLACEHOLDERS = new String[]{"ip_address", "isp", "continent", "country", "subdivisions", "city", "country_code", "inside_eu", "time_zone", "postal_code", "latitude", "longitude", "accuracy_radius_km", "accuracy_radius_mi", "accuracy_radius_nm", "relative_date_full", "relative_date_day", "relative_date_hour"};
    protected IPLookupMethod method = IPLookupMethod.REMOTE;
    protected InetAddress ipAddress;
    protected String json = "{}";
    protected String isp = "unknown ISP";
    protected String continent = "unknown continent";
    protected String country = "unknown country";
    protected String city = "unknown city";
    protected String countryCode = "unknown country code";
    protected String timeZone = "unknown time zone";
    protected String postalCode = "unknown postal code";
    protected List<String> subdivisions = Collections.emptyList();
    protected boolean insideEU;
    protected boolean valid = true;
    protected double latitude = -1.0;
    protected double longitude = -1.0;
    protected long accuracyRadius = -1L;

    public IPLookupMethod getMethod() {
        return this.method;
    }

    public void setMethod(IPLookupMethod method) {
        this.method = method;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        if (!valid) {
            this.isp = "unknown ISP";
            this.continent = "unknown continent";
            this.country = "unknown country";
            this.city = "unknown city";
            this.countryCode = "unknown country code";
            this.timeZone = "unknown time zone";
            this.postalCode = "unknown postal code";
            this.subdivisions = Collections.emptyList();
            this.insideEU = false;
            this.accuracyRadius = -1L;
            this.latitude = this.longitude = (double)-1L;
        }
    }

    public InetAddress getIPAddress() {
        return this.ipAddress;
    }

    public String getISP() {
        return this.isp;
    }

    public void setISP(String isp) {
        this.isp = isp;
    }

    public String getContinent() {
        return this.continent;
    }

    public void setContinent(String continent) {
        this.continent = continent;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public List<String> getSubdivisions() {
        return this.subdivisions;
    }

    public void setSubdivisions(List<String> subdivisions) {
        this.subdivisions = subdivisions;
    }

    public boolean isInsideEU() {
        return this.insideEU;
    }

    public void setInsideEU(boolean insideEU) {
        this.insideEU = insideEU;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public long getAccuracyRadius() {
        return this.accuracyRadius;
    }

    public void setAccuracyRadius(long accuracyRadius) {
        this.accuracyRadius = accuracyRadius;
    }

    public String toJSON() {
        return this.json;
    }

    public abstract IPLookup setJSON(String var1) throws Exception;

    public abstract String formatSubdivisions();

    public abstract String formatPlaceholders(String var1);

    public abstract String formatPlaceholders(String var1, Language var2);

    public abstract List<String> formatPlaceholders(List<String> var1);

    public abstract List<String> formatPlaceholders(List<String> var1, Language var2);
}

