/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.event.ChatPluginEvent;
import me.remigio07.chatplugin.api.common.event.EventSubscriber;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;

public abstract class EventManager
implements ChatPluginManager {
    protected static EventManager instance;
    protected static final String FLOODGATE_ERROR_MESSAGE = "Invalid ChatPlugin-Floodgate configuration: {0} has connected using Floodgate but their name does not start with the \"{1}\" username prefix set at \"{2} config.yml. This is most likely caused by the setting on the proxy not matching the local one. The proxy and every server under the network should use the same username prefix.";
    protected boolean enabled;
    protected Map<Class<? extends ChatPluginEvent>, List<EventSubscriber<? extends ChatPluginEvent>>> subscribers = new ConcurrentHashMap<Class<? extends ChatPluginEvent>, List<EventSubscriber<? extends ChatPluginEvent>>>();
    protected long loadTime;

    @Override
    public void unload() throws ChatPluginManagerException {
        this.enabled = false;
        this.subscribers.clear();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isReloadable() {
        return false;
    }

    public <E extends ChatPluginEvent> List<EventSubscriber<E>> getSubscribers(Class<E> event) {
        return this.subscribers.getOrDefault(event, Collections.emptyList()).stream().map(subscriber -> subscriber).collect(Collectors.toList());
    }

    public <E extends ChatPluginEvent> void call(E event) {
        List<EventSubscriber<?>> subscribers = this.getSubscribers(event.getClass());
        if (subscribers != null && !subscribers.isEmpty()) {
            subscribers.forEach(subscriber -> {
                try {
                    ((EventSubscriber)subscriber).getConsumer().accept(event);
                }
                catch (Throwable t) {
                    LogManager.log("{0} occurred while calling event {1}: {2}", 2, t.getClass().getSimpleName(), event.getClass().getSimpleName(), t.getLocalizedMessage());
                    t.printStackTrace();
                }
            });
        }
    }

    public <E extends ChatPluginEvent> EventSubscriber<E> subscribe(Class<E> event, Consumer<E> consumer) {
        EventSubscriber<E> subscriber = new EventSubscriber<E>(event, consumer);
        this.subscribers.put(event, Utils.addAndGet(this.subscribers.getOrDefault(event, Collections.emptyList()), Arrays.asList(subscriber)));
        return subscriber;
    }

    public <E extends ChatPluginEvent> void unsubscribe(EventSubscriber<E> eventSubscriber) {
        this.subscribers.put(eventSubscriber.getEvent(), Utils.removeAndGet(this.subscribers.getOrDefault(eventSubscriber.getEvent(), Collections.emptyList()), Arrays.asList(eventSubscriber)));
    }

    public static EventManager getInstance() {
        return instance;
    }
}

