/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.discord;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.discord.DiscordBot;
import me.remigio07.chatplugin.api.common.discord.DiscordIntegrationManager;
import me.remigio07.chatplugin.api.common.discord.DiscordMessage;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookup;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.punishment.Punishment;
import me.remigio07.chatplugin.api.common.punishment.ban.BanManager;
import me.remigio07.chatplugin.api.common.punishment.mute.MuteManager;
import me.remigio07.chatplugin.api.common.punishment.warning.WarningManager;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.MemoryUtils;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.adapter.discord.FieldAdapter;
import me.remigio07.chatplugin.api.common.util.adapter.user.PlayerAdapter;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagers;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;

public class DiscordMessages {
    public static final String[] EMBED_OPTIONS = new String[]{"title.text", "title.url", "description", "image", "thumbnail", "author.text", "author.url", "author.icon-url", "footer.text", "footer.icon-url", "color"};

    private static String getString(String path) {
        return DiscordMessages.getString(path, "");
    }

    private static String getString(String path, String def) {
        return ConfigurationType.DISCORD_INTEGRATION.get().getString(path, def);
    }

    private static List<String> getValues(String path) {
        ArrayList<String> values = new ArrayList<String>(EMBED_OPTIONS.length);
        for (String option : EMBED_OPTIONS) {
            values.add(DiscordMessages.getString(path + option, null));
        }
        return values;
    }

    private static List<FieldAdapter> getFields(String path) {
        return FieldAdapter.Parser.getInstance().fromYAML(ConfigurationType.DISCORD_INTEGRATION.get(), path.substring(0, path.length() - 1));
    }

    private static String formatTime(long totalMilliseconds, boolean everInsteadOfNever, boolean useZeroSecondsInstead) {
        StringBuilder sb = new StringBuilder();
        long totalSeconds = (totalMilliseconds + 999L) / 1000L;
        if (totalMilliseconds == -1L) {
            return DiscordMessages.getString(everInsteadOfNever ? "timestamps.ever" : "timestamps.never");
        }
        if (totalSeconds < 1L && !useZeroSecondsInstead) {
            return DiscordMessages.getString("timestamps.now");
        }
        int years = (int)(totalSeconds / 31536000L);
        int months = (int)((totalSeconds -= (long)(years * 31536000)) / 2592000L);
        int days = (int)((totalSeconds -= (long)(months * 2592000)) / 86400L);
        totalSeconds -= (long)(days * 86400);
        int weeks = 0;
        if (ConfigurationType.CONFIG.get().getBoolean("settings.use-week-timestamp")) {
            weeks = (int)(totalSeconds / 604800L);
            totalSeconds -= (long)(weeks * 604800);
        }
        int hours = (int)(totalSeconds / 3600L);
        int minutes = (int)((totalSeconds -= (long)(hours * 3600)) / 60L);
        totalSeconds -= (long)(minutes * 60);
        if (years != 0) {
            sb.append(years + (years == 1 ? "{year}, " : "{years}, "));
        }
        if (months != 0) {
            sb.append(months + (months == 1 ? "{month}, " : "{months}, "));
        }
        if (weeks != 0) {
            sb.append(weeks + (weeks == 1 ? "{week}, " : "{weeks}, "));
        }
        if (days != 0) {
            sb.append(days + (days == 1 ? "{day}, " : "{days}, "));
        }
        if (hours != 0) {
            sb.append(hours + (hours == 1 ? "{hour}, " : "{hours}, "));
        }
        if (minutes != 0) {
            sb.append(minutes + (minutes == 1 ? "{minute}, " : "{minutes}, "));
        }
        if (totalSeconds != 0L || useZeroSecondsInstead && minutes == 0 && hours == 0 && days == 0 && weeks == 0 && months == 0 && years == 0) {
            sb.append(totalSeconds + (totalSeconds == 1L ? "{second}" : "{seconds}"));
        } else {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString().replace("{second}", DiscordMessages.getString("timestamps.second")).replace("{seconds}", DiscordMessages.getString("timestamps.seconds")).replace("{minute}", DiscordMessages.getString("timestamps.minute")).replace("{minutes}", DiscordMessages.getString("timestamps.minutes")).replace("{hour}", DiscordMessages.getString("timestamps.hour")).replace("{hours}", DiscordMessages.getString("timestamps.hours")).replace("{day}", DiscordMessages.getString("timestamps.day")).replace("{days}", DiscordMessages.getString("timestamps.days")).replace("{week}", DiscordMessages.getString("timestamps.week")).replace("{weeks}", DiscordMessages.getString("timestamps.weeks")).replace("{month}", DiscordMessages.getString("timestamps.month")).replace("{months}", DiscordMessages.getString("timestamps.months")).replace("{year}", DiscordMessages.getString("timestamps.year")).replace("{years}", DiscordMessages.getString("timestamps.years"));
    }

    private static String formatDate(long ms) {
        return ms == -1L ? DiscordMessages.getString("timestamps.never") : "<t:" + ms / 1000L + ">";
    }

    @Target(value={ElementType.FIELD})
    public static @interface MessageArguments {
        public Class<?>[] types();

        public String[] descriptions();
    }

    public static enum Mute implements DiscordMessage
    {
        INFO,
        LIST,
        EMPTY_LIST,
        MUTED,
        UPDATED,
        UNMUTED,
        EXPIRED;


        @Override
        public String getPath() {
            return "messages.mute." + this.name().toLowerCase().replace('_', '-') + ".";
        }

        @Override
        public Object getEmbed(Object ... args) {
            return DiscordBot.getInstance().newEmbedMessage(this.name().endsWith("LIST") ? (this == LIST ? this.getMutelistValues() : DiscordMessages.getValues(this.getPath())) : this.formatValues((me.remigio07.chatplugin.api.common.punishment.mute.Mute)args[0]), this.name().endsWith("LIST") ? (this == LIST ? this.getMutelistFields() : DiscordMessages.getFields(this.getPath())) : this.formatFields((me.remigio07.chatplugin.api.common.punishment.mute.Mute)args[0]));
        }

        private List<String> getMutelistValues() {
            List ids = MuteManager.getInstance().getActiveMutes().stream().map(Punishment::getID).collect(Collectors.toList());
            ArrayList<String> values = new ArrayList<String>();
            if (ids.isEmpty()) {
                return DiscordMessages.getValues(this.getPath());
            }
            String mutes = Utils.getStringFromList(ids, false, true);
            for (String value : DiscordMessages.getValues(this.getPath())) {
                values.add(value == null ? null : value.replace("{mutes}", mutes));
            }
            return values;
        }

        private List<FieldAdapter> getMutelistFields() {
            List ids = MuteManager.getInstance().getActiveMutes().stream().map(Punishment::getID).collect(Collectors.toList());
            List fields = DiscordMessages.getFields(this.getPath());
            if (ids.isEmpty()) {
                return DiscordMessages.getFields(this.getPath());
            }
            String mutes = Utils.getStringFromList(ids, false, true);
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{mutes}", mutes));
                field.setText(field.getText() == null ? null : field.getText().replace("{mutes}", mutes));
            }
            return fields;
        }

        private List<String> formatValues(me.remigio07.chatplugin.api.common.punishment.mute.Mute mute) {
            return DiscordMessages.getValues(this.getPath()).stream().map(value -> value == null ? null : value.replace("{id}", String.valueOf(mute.getID())).replace("{player}", mute.getPlayer().getName()).replace("{player_uuid}", mute.getPlayer().getUUID().toString()).replace("{staff_member}", mute.getStaffMember()).replace("{who_unmuted}", mute.getWhoUnmuted() == null ? DiscordMessages.getString("placeholders.nobody") : mute.getWhoUnmuted()).replace("{reason}", mute.getReason() == null ? DiscordMessages.getString("messages.mute.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(mute.getReason()))).replace("{server}", mute.getServer()).replace("{date}", DiscordMessages.formatDate(mute.getDate())).replace("{unmute_date}", DiscordMessages.formatDate(mute.getUnmuteDate())).replace("{expiration_date}", mute.getDuration() == -1L ? DiscordMessages.getString("timestamps.never") : DiscordMessages.formatDate(mute.getDate() + mute.getDuration())).replace("{duration}", DiscordMessages.formatTime(mute.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(mute.getRemainingTime(), true, true)).replace("{active}", Mute.getFormat("active." + (mute.isActive() ? "yes" : "no"))).replace("{global}", Mute.getFormat("global." + (mute.isGlobal() ? "yes" : "no"))).replace("{silent}", Mute.getFormat("silent." + (mute.isSilent() ? "yes" : "no")))).collect(Collectors.toList());
        }

        private List<FieldAdapter> formatFields(me.remigio07.chatplugin.api.common.punishment.mute.Mute mute) {
            List fields = DiscordMessages.getFields(this.getPath());
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{id}", String.valueOf(mute.getID())).replace("{player}", mute.getPlayer().getName()).replace("{player_uuid}", mute.getPlayer().getUUID().toString()).replace("{staff_member}", mute.getStaffMember()).replace("{who_unmuted}", mute.getWhoUnmuted() == null ? DiscordMessages.getString("placeholders.nobody") : mute.getWhoUnmuted()).replace("{reason}", mute.getReason() == null ? DiscordMessages.getString("messages.mute.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(mute.getReason()))).replace("{server}", mute.getServer()).replace("{date}", DiscordMessages.formatDate(mute.getDate())).replace("{unmute_date}", DiscordMessages.formatDate(mute.getUnmuteDate())).replace("{expiration_date}", mute.getDuration() == -1L ? DiscordMessages.getString("timestamps.never") : DiscordMessages.formatDate(mute.getDate() + mute.getDuration())).replace("{duration}", DiscordMessages.formatTime(mute.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(mute.getRemainingTime(), true, true)).replace("{active}", Mute.getFormat("active." + (mute.isActive() ? "yes" : "no"))).replace("{global}", Mute.getFormat("global." + (mute.isGlobal() ? "yes" : "no"))).replace("{silent}", Mute.getFormat("silent." + (mute.isSilent() ? "yes" : "no"))));
                field.setText(field.getText() == null ? null : field.getText().replace("{id}", String.valueOf(mute.getID())).replace("{player}", mute.getPlayer().getName()).replace("{player_uuid}", mute.getPlayer().getUUID().toString()).replace("{staff_member}", mute.getStaffMember()).replace("{who_unmuted}", mute.getWhoUnmuted() == null ? DiscordMessages.getString("placeholders.nobody") : mute.getWhoUnmuted()).replace("{reason}", mute.getReason() == null ? DiscordMessages.getString("messages.mute.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(mute.getReason()))).replace("{server}", mute.getServer()).replace("{date}", DiscordMessages.formatDate(mute.getDate())).replace("{unmute_date}", DiscordMessages.formatDate(mute.getUnmuteDate())).replace("{expiration_date}", mute.getDuration() == -1L ? DiscordMessages.getString("timestamps.never") : DiscordMessages.formatDate(mute.getDate() + mute.getDuration())).replace("{duration}", DiscordMessages.formatTime(mute.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(mute.getRemainingTime(), true, true)).replace("{active}", Mute.getFormat("active." + (mute.isActive() ? "yes" : "no"))).replace("{global}", Mute.getFormat("global." + (mute.isGlobal() ? "yes" : "no"))).replace("{silent}", Mute.getFormat("silent." + (mute.isSilent() ? "yes" : "no"))));
            }
            return fields;
        }

        private static String getFormat(String type) {
            return DiscordMessages.getString("messages.mute.formats." + type);
        }
    }

    public static enum Kick implements DiscordMessage
    {
        INFO,
        KICKED;


        @Override
        public String getPath() {
            return "messages.kick." + this.name().toLowerCase().replace('_', '-') + ".";
        }

        @Override
        public Object getEmbed(Object ... args) {
            return DiscordBot.getInstance().newEmbedMessage(this.formatValues((me.remigio07.chatplugin.api.common.punishment.kick.Kick)args[0]), this.formatFields((me.remigio07.chatplugin.api.common.punishment.kick.Kick)args[0]));
        }

        private List<String> formatValues(me.remigio07.chatplugin.api.common.punishment.kick.Kick kick) {
            return DiscordMessages.getValues(this.getPath()).stream().map(value -> value == null ? null : value.replace("{id}", String.valueOf(kick.getID())).replace("{player}", kick.getPlayer().getName()).replace("{player_uuid}", kick.getPlayer().getUUID().toString()).replace("{ip_address}", kick.getIPAddress() == null ? DiscordMessages.getString("placeholders.not-present") : kick.getIPAddress().getHostAddress()).replace("{staff_member}", kick.getStaffMember()).replace("{reason}", kick.getReason() == null ? DiscordMessages.getString("messages.kick.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(kick.getReason()))).replace("{server}", kick.getServer()).replace("{type}", Kick.getFormat("types." + kick.getType().name().toLowerCase())).replace("{date}", DiscordMessages.formatDate(kick.getDate())).replace("{silent}", Kick.getFormat("silent." + (kick.isSilent() ? "yes" : "no")))).collect(Collectors.toList());
        }

        private List<FieldAdapter> formatFields(me.remigio07.chatplugin.api.common.punishment.kick.Kick kick) {
            List fields = DiscordMessages.getFields(this.getPath());
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{id}", String.valueOf(kick.getID())).replace("{player}", kick.getPlayer().getName()).replace("{player_uuid}", kick.getPlayer().getUUID().toString()).replace("{ip_address}", kick.getIPAddress() == null ? DiscordMessages.getString("placeholders.not-present") : kick.getIPAddress().getHostAddress()).replace("{staff_member}", kick.getStaffMember()).replace("{reason}", kick.getReason() == null ? DiscordMessages.getString("messages.kick.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(kick.getReason()))).replace("{server}", kick.getServer()).replace("{type}", Kick.getFormat("types." + kick.getType().name().toLowerCase())).replace("{date}", DiscordMessages.formatDate(kick.getDate())).replace("{silent}", Kick.getFormat("silent." + (kick.isSilent() ? "yes" : "no"))));
                field.setText(field.getText() == null ? null : field.getText().replace("{id}", String.valueOf(kick.getID())).replace("{player}", kick.getPlayer().getName()).replace("{player_uuid}", kick.getPlayer().getUUID().toString()).replace("{ip_address}", kick.getIPAddress() == null ? DiscordMessages.getString("placeholders.not-present") : kick.getIPAddress().getHostAddress()).replace("{staff_member}", kick.getStaffMember()).replace("{reason}", kick.getReason() == null ? DiscordMessages.getString("messages.kick.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(kick.getReason()))).replace("{server}", kick.getServer()).replace("{type}", Kick.getFormat("types." + kick.getType().name().toLowerCase())).replace("{date}", DiscordMessages.formatDate(kick.getDate())).replace("{silent}", Kick.getFormat("silent." + (kick.isSilent() ? "yes" : "no"))));
            }
            return fields;
        }

        private static String getFormat(String type) {
            return DiscordMessages.getString("messages.kick.formats." + type);
        }
    }

    public static enum Warning implements DiscordMessage
    {
        INFO,
        LIST,
        EMPTY_LIST,
        WARNED,
        REMOVED,
        CLEARED,
        EXPIRED;


        @Override
        public String getPath() {
            return "messages.warning." + this.name().toLowerCase().replace('_', '-') + ".";
        }

        @Override
        public Object getEmbed(Object ... args) {
            switch (this.ordinal()) {
                case 1: {
                    return DiscordBot.getInstance().newEmbedMessage(this.getWarnlistValues(), this.getWarnlistFields());
                }
                case 2: {
                    return DiscordBot.getInstance().newEmbedMessage(DiscordMessages.getValues(this.getPath()), DiscordMessages.getFields(this.getPath()));
                }
                case 5: {
                    return DiscordBot.getInstance().newEmbedMessage(this.getClearWarningsValues((me.remigio07.chatplugin.api.common.player.OfflinePlayer)args[0], (String)args[1]), this.getClearWarningsFields((me.remigio07.chatplugin.api.common.player.OfflinePlayer)args[0], (String)args[1]));
                }
            }
            return DiscordBot.getInstance().newEmbedMessage(this.formatValues((me.remigio07.chatplugin.api.common.punishment.warning.Warning)args[0]), this.formatFields((me.remigio07.chatplugin.api.common.punishment.warning.Warning)args[0]));
        }

        private List<String> getWarnlistValues() {
            List ids = WarningManager.getInstance().getActiveWarnings().stream().map(Punishment::getID).collect(Collectors.toList());
            ArrayList<String> list = new ArrayList<String>(EMBED_OPTIONS.length);
            if (ids.isEmpty()) {
                return DiscordMessages.getValues(this.getPath());
            }
            String values = Utils.getStringFromList(ids, false, true);
            for (String value : DiscordMessages.getValues(this.getPath())) {
                list.add(value == null ? null : value.replace("{warnings}", values));
            }
            return list;
        }

        private List<FieldAdapter> getWarnlistFields() {
            List ids = WarningManager.getInstance().getActiveWarnings().stream().map(Punishment::getID).collect(Collectors.toList());
            List fields = DiscordMessages.getFields(this.getPath());
            if (ids.isEmpty()) {
                return DiscordMessages.getFields(this.getPath());
            }
            String warnings = Utils.getStringFromList(ids, false, true);
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{bans}", warnings));
                field.setText(field.getText() == null ? null : field.getText().replace("{bans}", warnings));
            }
            return fields;
        }

        private List<String> formatValues(me.remigio07.chatplugin.api.common.punishment.warning.Warning warning) {
            return DiscordMessages.getValues(this.getPath()).stream().map(value -> value == null ? null : value.replace("{id}", String.valueOf(warning.getID())).replace("{player}", warning.getPlayer().getName()).replace("{player_uuid}", warning.getPlayer().getUUID().toString()).replace("{staff_member}", warning.getStaffMember()).replace("{who_unwarned}", warning.getWhoUnwarned() == null ? DiscordMessages.getString("placeholders.nobody") : warning.getWhoUnwarned()).replace("{reason}", warning.getReason() == null ? DiscordMessages.getString("messages.warning.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(warning.getReason()))).replace("{server}", warning.getServer()).replace("{date}", DiscordMessages.formatDate(warning.getDate())).replace("{unwarn_date}", DiscordMessages.formatDate(warning.getUnwarnDate())).replace("{expiration_date}", DiscordMessages.formatDate(warning.getDate() + warning.getDuration())).replace("{duration}", DiscordMessages.formatTime(warning.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(warning.getRemainingTime(), true, true)).replace("{amount}", String.valueOf(WarningManager.getInstance().getActiveWarnings(warning.getPlayer(), warning.getServer()).stream().filter(other -> other.getDate() <= warning.getDate()).count())).replace("{max_amount}", String.valueOf(ConfigurationType.CONFIG.get().getInt("warning.max-warnings-placeholder." + warning.getServer()))).replace("{active}", Warning.getFormat("active." + (warning.isActive() ? "yes" : "no"))).replace("{global}", Warning.getFormat("global." + (warning.isGlobal() ? "yes" : "no"))).replace("{silent}", Warning.getFormat("silent." + (warning.isSilent() ? "yes" : "no")))).collect(Collectors.toList());
        }

        private List<FieldAdapter> formatFields(me.remigio07.chatplugin.api.common.punishment.warning.Warning warning) {
            List fields = DiscordMessages.getFields(this.getPath());
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{id}", String.valueOf(warning.getID())).replace("{player}", warning.getPlayer().getName()).replace("{player_uuid}", warning.getPlayer().getUUID().toString()).replace("{staff_member}", warning.getStaffMember()).replace("{who_unwarned}", warning.getWhoUnwarned() == null ? DiscordMessages.getString("placeholders.nobody") : warning.getWhoUnwarned()).replace("{reason}", warning.getReason() == null ? DiscordMessages.getString("messages.warning.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(warning.getReason()))).replace("{server}", warning.getServer()).replace("{date}", DiscordMessages.formatDate(warning.getDate())).replace("{unwarn_date}", DiscordMessages.formatDate(warning.getUnwarnDate())).replace("{expiration_date}", DiscordMessages.formatDate(warning.getDate() + warning.getDuration())).replace("{duration}", DiscordMessages.formatTime(warning.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(warning.getRemainingTime(), true, true)).replace("{amount}", String.valueOf(WarningManager.getInstance().getActiveWarnings(warning.getPlayer(), warning.getServer()).stream().filter(other -> other.getDate() <= warning.getDate()).count())).replace("{max_amount}", String.valueOf(ConfigurationType.CONFIG.get().getInt("warning.max-warnings-placeholder." + warning.getServer()))).replace("{active}", Warning.getFormat("active." + (warning.isActive() ? "yes" : "no"))).replace("{global}", Warning.getFormat("global." + (warning.isGlobal() ? "yes" : "no"))).replace("{silent}", Warning.getFormat("silent." + (warning.isSilent() ? "yes" : "no"))));
                field.setText(field.getText() == null ? null : field.getText().replace("{id}", String.valueOf(warning.getID())).replace("{player}", warning.getPlayer().getName()).replace("{player_uuid}", warning.getPlayer().getUUID().toString()).replace("{staff_member}", warning.getStaffMember()).replace("{who_unwarned}", warning.getWhoUnwarned() == null ? DiscordMessages.getString("placeholders.nobody") : warning.getWhoUnwarned()).replace("{reason}", warning.getReason() == null ? DiscordMessages.getString("messages.warning.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(warning.getReason()))).replace("{server}", warning.getServer()).replace("{date}", DiscordMessages.formatDate(warning.getDate())).replace("{unwarn_date}", DiscordMessages.formatDate(warning.getUnwarnDate())).replace("{expiration_date}", DiscordMessages.formatDate(warning.getDate() + warning.getDuration())).replace("{duration}", DiscordMessages.formatTime(warning.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(warning.getRemainingTime(), true, true)).replace("{amount}", String.valueOf(WarningManager.getInstance().getActiveWarnings(warning.getPlayer(), warning.getServer()).stream().filter(other -> other.getDate() <= warning.getDate()).count())).replace("{max_amount}", String.valueOf(ConfigurationType.CONFIG.get().getInt("warning.max-warnings-placeholder." + warning.getServer()))).replace("{active}", Warning.getFormat("active." + (warning.isActive() ? "yes" : "no"))).replace("{global}", Warning.getFormat("global." + (warning.isGlobal() ? "yes" : "no"))).replace("{silent}", Warning.getFormat("silent." + (warning.isSilent() ? "yes" : "no"))));
            }
            return fields;
        }

        private List<String> getClearWarningsValues(me.remigio07.chatplugin.api.common.player.OfflinePlayer player, String whoUnwarned) {
            ArrayList<String> list = new ArrayList<String>(EMBED_OPTIONS.length);
            for (String option : EMBED_OPTIONS) {
                String value = DiscordMessages.getString(this.getPath() + option, null);
                list.add(value == null ? null : value.replace("{player}", player.getName()).replace("{player_uuid}", player.getUUID().toString()).replace("{who_unwarned}", whoUnwarned == null ? DiscordMessages.getString("placeholders.nobody") : whoUnwarned));
            }
            return list;
        }

        private List<FieldAdapter> getClearWarningsFields(me.remigio07.chatplugin.api.common.player.OfflinePlayer player, String whoUnwarned) {
            List fields = DiscordMessages.getFields(this.getPath());
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{player}", player.getName()).replace("{player_uuid}", player.getUUID().toString()).replace("{who_unwarned}", whoUnwarned == null ? DiscordMessages.getString("placeholders.nobody") : whoUnwarned));
                field.setText(field.getText() == null ? null : field.getText().replace("{player}", player.getName()).replace("{player_uuid}", player.getUUID().toString()).replace("{who_unwarned}", whoUnwarned == null ? DiscordMessages.getString("placeholders.nobody") : whoUnwarned));
            }
            return fields;
        }

        private static String getFormat(String type) {
            return DiscordMessages.getString("messages.warning.formats." + type);
        }
    }

    public static enum Ban implements DiscordMessage
    {
        INFO,
        LIST,
        EMPTY_LIST,
        BANNED,
        UPDATED,
        UNBANNED,
        EXPIRED;


        @Override
        public String getPath() {
            return "messages.ban." + this.name().toLowerCase().replace('_', '-') + ".";
        }

        @Override
        public Object getEmbed(Object ... args) {
            return DiscordBot.getInstance().newEmbedMessage(this.name().endsWith("LIST") ? (this == LIST ? this.getBanlistValues() : DiscordMessages.getValues(this.getPath())) : this.formatValues((me.remigio07.chatplugin.api.common.punishment.ban.Ban)args[0]), this.name().endsWith("LIST") ? (this == LIST ? this.getBanlistFields() : DiscordMessages.getFields(this.getPath())) : this.formatFields((me.remigio07.chatplugin.api.common.punishment.ban.Ban)args[0]));
        }

        private List<String> getBanlistValues() {
            List ids = BanManager.getInstance().getActiveBans().stream().map(Punishment::getID).collect(Collectors.toList());
            ArrayList<String> values = new ArrayList<String>(EMBED_OPTIONS.length);
            if (ids.isEmpty()) {
                return DiscordMessages.getValues(this.getPath());
            }
            String bans = Utils.getStringFromList(ids, false, true);
            for (String value : DiscordMessages.getValues(this.getPath())) {
                values.add(value == null ? null : value.replace("{bans}", bans));
            }
            return values;
        }

        private List<FieldAdapter> getBanlistFields() {
            List ids = BanManager.getInstance().getActiveBans().stream().map(Punishment::getID).collect(Collectors.toList());
            List fields = DiscordMessages.getFields(this.getPath());
            if (ids.isEmpty()) {
                return DiscordMessages.getFields(this.getPath());
            }
            String bans = Utils.getStringFromList(ids, false, true);
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{bans}", bans));
                field.setText(field.getText() == null ? null : field.getText().replace("{bans}", bans));
            }
            return fields;
        }

        private List<String> formatValues(me.remigio07.chatplugin.api.common.punishment.ban.Ban ban) {
            return DiscordMessages.getValues(this.getPath()).stream().map(value -> value == null ? null : value.replace("{id}", String.valueOf(ban.getID())).replace("{player}", ban.getPlayer() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getPlayer().getName()).replace("{player_uuid}", ban.getPlayer() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getPlayer().getUUID().toString()).replace("{ip_address}", ban.getIPAddress() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getIPAddress().getHostAddress()).replace("{staff_member}", ban.getStaffMember()).replace("{who_unbanned}", ban.getWhoUnbanned() == null ? DiscordMessages.getString("placeholders.nobody") : ban.getWhoUnbanned()).replace("{reason}", ban.getReason() == null ? DiscordMessages.getString("messages.ban.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(ban.getReason()))).replace("{server}", ban.getServer()).replace("{type}", Ban.getFormat("types." + ban.getType().name().toLowerCase())).replace("{date}", DiscordMessages.formatDate(ban.getDate())).replace("{unban_date}", DiscordMessages.formatDate(ban.getUnbanDate())).replace("{expiration_date}", ban.getDuration() == -1L ? DiscordMessages.getString("timestamps.never") : DiscordMessages.formatDate(ban.getDate() + ban.getDuration())).replace("{duration}", DiscordMessages.formatTime(ban.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(ban.getRemainingTime(), true, true)).replace("{active}", Ban.getFormat("active." + (ban.isActive() ? "yes" : "no"))).replace("{global}", Ban.getFormat("global." + (ban.isGlobal() ? "yes" : "no"))).replace("{silent}", Ban.getFormat("silent." + (ban.isSilent() ? "yes" : "no")))).collect(Collectors.toList());
        }

        private List<FieldAdapter> formatFields(me.remigio07.chatplugin.api.common.punishment.ban.Ban ban) {
            List fields = DiscordMessages.getFields(this.getPath());
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : field.getTitle().replace("{id}", String.valueOf(ban.getID())).replace("{player}", ban.getPlayer() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getPlayer().getName()).replace("{player_uuid}", ban.getPlayer() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getPlayer().getUUID().toString()).replace("{ip_address}", ban.getIPAddress() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getIPAddress().getHostAddress()).replace("{staff_member}", ban.getStaffMember()).replace("{who_unbanned}", ban.getWhoUnbanned() == null ? DiscordMessages.getString("placeholders.nobody") : ban.getWhoUnbanned()).replace("{reason}", ban.getReason() == null ? DiscordMessages.getString("messages.ban.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(ban.getReason()))).replace("{server}", ban.getServer()).replace("{type}", Ban.getFormat("types." + ban.getType().name().toLowerCase())).replace("{date}", DiscordMessages.formatDate(ban.getDate())).replace("{unban_date}", DiscordMessages.formatDate(ban.getUnbanDate())).replace("{expiration_date}", ban.getDuration() == -1L ? DiscordMessages.getString("timestamps.never") : DiscordMessages.formatDate(ban.getDate() + ban.getDuration())).replace("{duration}", DiscordMessages.formatTime(ban.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(ban.getRemainingTime(), true, true)).replace("{active}", Ban.getFormat("active." + (ban.isActive() ? "yes" : "no"))).replace("{global}", Ban.getFormat("global." + (ban.isGlobal() ? "yes" : "no"))).replace("{silent}", Ban.getFormat("silent." + (ban.isSilent() ? "yes" : "no"))));
                field.setText(field.getText() == null ? null : field.getText().replace("{id}", String.valueOf(ban.getID())).replace("{player}", ban.getPlayer() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getPlayer().getName()).replace("{player_uuid}", ban.getPlayer() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getPlayer().getUUID().toString()).replace("{ip_address}", ban.getIPAddress() == null ? DiscordMessages.getString("placeholders.not-present") : ban.getIPAddress().getHostAddress()).replace("{staff_member}", ban.getStaffMember()).replace("{who_unbanned}", ban.getWhoUnbanned() == null ? DiscordMessages.getString("placeholders.nobody") : ban.getWhoUnbanned()).replace("{reason}", ban.getReason() == null ? DiscordMessages.getString("messages.ban.unspecified-reason") : ChatColor.stripColor(ChatColor.translate(ban.getReason()))).replace("{server}", ban.getServer()).replace("{type}", Ban.getFormat("types." + ban.getType().name().toLowerCase())).replace("{date}", DiscordMessages.formatDate(ban.getDate())).replace("{unban_date}", DiscordMessages.formatDate(ban.getUnbanDate())).replace("{expiration_date}", ban.getDuration() == -1L ? DiscordMessages.getString("timestamps.never") : DiscordMessages.formatDate(ban.getDate() + ban.getDuration())).replace("{duration}", DiscordMessages.formatTime(ban.getDuration(), true, true)).replace("{remaining_time}", DiscordMessages.formatTime(ban.getRemainingTime(), true, true)).replace("{active}", Ban.getFormat("active." + (ban.isActive() ? "yes" : "no"))).replace("{global}", Ban.getFormat("global." + (ban.isGlobal() ? "yes" : "no"))).replace("{silent}", Ban.getFormat("silent." + (ban.isSilent() ? "yes" : "no"))));
            }
            return fields;
        }

        private static String getFormat(String type) {
            return DiscordMessages.getString("messages.ban.formats." + type);
        }
    }

    public static enum Misc implements DiscordMessage
    {
        INEXISTENT_ID,
        NO_PERMISSION,
        GUILD_ONLY_ACTION,
        DISABLED_FEATURE,
        INVALID_IP_ADDRESS,
        AT_LEAST_ONE_ONLINE,
        IP_LOOKUP;


        @Override
        public String getPath() {
            return "messages." + this.name().toLowerCase().replace('_', '-') + ".";
        }

        @Override
        public Object getEmbed(Object ... args) {
            return DiscordBot.getInstance().newEmbedMessage(this == IP_LOOKUP ? ((IPLookup)args[0]).formatPlaceholders(DiscordMessages.getValues(this.getPath())) : DiscordMessages.getValues(this.getPath()), this == IP_LOOKUP ? this.getIPLookupFields((IPLookup)args[0]) : DiscordMessages.getFields(this.getPath()));
        }

        private List<FieldAdapter> getIPLookupFields(IPLookup ipLookup) {
            List fields = DiscordMessages.getFields(this.getPath());
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                FieldAdapter field;
                field.setTitle((field = (FieldAdapter)iterator.next()).getTitle() == null ? null : ipLookup.formatPlaceholders(field.getTitle()));
                field.setText(field.getText() == null ? null : ipLookup.formatPlaceholders(field.getText()));
            }
            return fields;
        }
    }

    public static enum OfflinePlayer implements DiscordMessage
    {
        PLAYER_PUNISHMENTS;


        @Override
        public String getPath() {
            throw new UnsupportedOperationException("Not available yet");
        }

        @Override
        public Object getEmbed(Object ... args) {
            throw new UnsupportedOperationException("Not available yet");
        }
    }

    public static enum OnlinePlayer implements DiscordMessage
    {
        PLAYER_INFO;


        @Override
        public String getPath() {
            throw new UnsupportedOperationException("Not available yet");
        }

        @Override
        public Object getEmbed(Object ... args) {
            throw new UnsupportedOperationException("Not available yet");
        }
    }

    public static enum Main implements DiscordMessage
    {
        HELP,
        INFO,
        RELOAD_START,
        RELOAD_END,
        STATUS,
        VERSION;


        @Override
        public String getPath() {
            return "messages.main." + this.name().toLowerCase().replace('_', '-') + ".";
        }

        @Override
        public Object getEmbed(Object ... args) {
            return DiscordBot.getInstance().newEmbedMessage(this == STATUS ? this.getStatusValues() : this.getVersionValues(), this == STATUS ? this.getStatusFields() : this.getVersionFields());
        }

        private List<String> getVersionValues() {
            ArrayList<String> values = new ArrayList<String>(EMBED_OPTIONS.length);
            for (String option : EMBED_OPTIONS) {
                values.add(this.translateVersion(DiscordMessages.getString(this.getPath() + option, null)));
            }
            return values;
        }

        private List<String> getStatusValues() {
            ArrayList<String> values = new ArrayList<String>(EMBED_OPTIONS.length);
            for (String option : EMBED_OPTIONS) {
                values.add(this.translateStatus(DiscordMessages.getString(this.getPath() + option, null)));
            }
            return values;
        }

        private List<FieldAdapter> getVersionFields() {
            List fields = DiscordMessages.getFields(this.getPath());
            for (FieldAdapter field : fields) {
                field.setTitle(this.translateVersion(field.getTitle()));
                field.setText(this.translateVersion(field.getText()));
            }
            return fields;
        }

        private List<FieldAdapter> getStatusFields() {
            List fields = DiscordMessages.getFields(this.getPath());
            for (FieldAdapter field : fields) {
                field.setTitle(this.translateStatus(field.getTitle()));
                field.setText(this.translateStatus(field.getText()));
            }
            return fields;
        }

        private String translateVersion(String input) {
            return input == null ? null : input.replace("{chatplugin_version}", "1.10.5").replace("{jda_version}", DiscordIntegrationManager.getInstance().getJDAVersion());
        }

        public String translateStatus(String input) {
            return input == null ? null : this.translateVersion(input.replace("{online_minecraft}", String.valueOf(PlayerAdapter.getOnlinePlayers().size())).replace("{discord_users}", String.valueOf(DiscordBot.getInstance().getUsers())).replace("{enabled_players}", String.valueOf(PlayerManager.getInstance().getPlayers().size())).replace("{enabled_managers}", String.valueOf(ChatPluginManagers.getInstance().getEnabledManagers().size())).replace("{max_players}", String.valueOf(Utils.getMaxPlayers())).replace("{date}", DiscordMessages.formatDate(System.currentTimeMillis())).replace("{startup_time}", String.valueOf(ChatPlugin.getInstance().getStartupTime())).replace("{last_reload_time}", String.valueOf(ChatPlugin.getInstance().getLastReloadTime())).replace("{java_version}", System.getProperty("java.version")).replace("{environment}", VersionUtils.getImplementationName()).replace("{environment_version}", VersionUtils.getImplementationVersion()).replace("{uptime}", DiscordMessages.formatTime(ManagementFactory.getRuntimeMXBean().getUptime(), false, false)).replace("{max_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().maxMemory(), MemoryUtils.MEGABYTE)).replace("{total_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().totalMemory(), MemoryUtils.MEGABYTE)).replace("{used_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory(), MemoryUtils.MEGABYTE)).replace("{free_memory}", MemoryUtils.formatMemory(Runtime.getRuntime().freeMemory(), MemoryUtils.MEGABYTE)).replace("{total_storage}", MemoryUtils.formatMemory(Utils.getTotalStorage(), MemoryUtils.GIGABYTE)).replace("{used_storage}", MemoryUtils.formatMemory(Utils.getTotalStorage() - Utils.getFreeStorage(), MemoryUtils.GIGABYTE)).replace("{free_storage}", MemoryUtils.formatMemory(Utils.getFreeStorage(), MemoryUtils.GIGABYTE)).replace("{os_name}", System.getProperty("os.name")).replace("{os_arch}", System.getProperty("os.arch")).replace("{os_version}", System.getProperty("os.version")).replace("{active_threads}", String.valueOf(Thread.activeCount())));
        }
    }
}

