/*
 * Decompiled with CFR 0.152.
 */
package eu.raidersheaven.rhanvils.listeners;

import eu.raidersheaven.rhanvils.handlers.ColorFormatHandler;
import eu.raidersheaven.rhanvils.main.Main;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnvilListenerNEW
implements Listener {
    private static final Set<Enchantment> UNMERGEABLE_ENCHANTS = Set.of(Enchantment.AQUA_AFFINITY, Enchantment.CHANNELING, Enchantment.BINDING_CURSE, Enchantment.VANISHING_CURSE, Enchantment.FLAME, Enchantment.INFINITY, Enchantment.MENDING, Enchantment.SILK_TOUCH, Enchantment.MULTISHOT);
    private static final Map<Enchantment, Integer> VANILLA_MAX_LEVELS = Map.ofEntries(Map.entry(Enchantment.AQUA_AFFINITY, 1), Map.entry(Enchantment.BINDING_CURSE, 1), Map.entry(Enchantment.VANISHING_CURSE, 1), Map.entry(Enchantment.FLAME, 1), Map.entry(Enchantment.INFINITY, 1), Map.entry(Enchantment.MENDING, 1), Map.entry(Enchantment.MULTISHOT, 1), Map.entry(Enchantment.FIRE_ASPECT, 2), Map.entry(Enchantment.FROST_WALKER, 2), Map.entry(Enchantment.KNOCKBACK, 2), Map.entry(Enchantment.PUNCH, 2), Map.entry(Enchantment.DEPTH_STRIDER, 3), Map.entry(Enchantment.FORTUNE, 3), Map.entry(Enchantment.LOOTING, 3), Map.entry(Enchantment.LOYALTY, 3), Map.entry(Enchantment.LUCK_OF_THE_SEA, 3), Map.entry(Enchantment.LURE, 3), Map.entry(Enchantment.QUICK_CHARGE, 3), Map.entry(Enchantment.RESPIRATION, 3), Map.entry(Enchantment.RIPTIDE, 3), Map.entry(Enchantment.SOUL_SPEED, 3), Map.entry(Enchantment.SWEEPING_EDGE, 3), Map.entry(Enchantment.SWIFT_SNEAK, 3), Map.entry(Enchantment.THORNS, 3), Map.entry(Enchantment.UNBREAKING, 3), Map.entry(Enchantment.WIND_BURST, 3), Map.entry(Enchantment.PROTECTION, 4), Map.entry(Enchantment.BLAST_PROTECTION, 4), Map.entry(Enchantment.FIRE_PROTECTION, 4), Map.entry(Enchantment.PROJECTILE_PROTECTION, 4), Map.entry(Enchantment.PIERCING, 4), Map.entry(Enchantment.FEATHER_FALLING, 4), Map.entry(Enchantment.BREACH, 4), Map.entry(Enchantment.EFFICIENCY, 5), Map.entry(Enchantment.SHARPNESS, 5), Map.entry(Enchantment.SMITE, 5), Map.entry(Enchantment.BANE_OF_ARTHROPODS, 5), Map.entry(Enchantment.DENSITY, 5), Map.entry(Enchantment.IMPALING, 5), Map.entry(Enchantment.POWER, 5));

    private int getVanillaMaxLevel(Enchantment ench) {
        return VANILLA_MAX_LEVELS.getOrDefault(ench, ench.getMaxLevel());
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        String renameText;
        boolean rightIsBook;
        AnvilInventory inv = event.getInventory();
        Player player = (Player)event.getView().getPlayer();
        if (!player.hasPermission("RHAnvils.use")) {
            return;
        }
        ItemStack result = event.getResult();
        if (result == null || result.getType() == Material.AIR) {
            return;
        }
        ItemStack left = inv.getItem(0);
        ItemStack right = inv.getItem(1);
        boolean leftIsBook = left != null && left.getType() == Material.ENCHANTED_BOOK;
        boolean bl = rightIsBook = right != null && right.getType() == Material.ENCHANTED_BOOK;
        if (leftIsBook || rightIsBook) {
            String renameText2 = event.getView().getRenameText();
            ItemMeta resultMeta = result.getItemMeta();
            if (resultMeta != null && renameText2 != null && !(renameText2 = renameText2.trim()).isEmpty()) {
                Component displayName = ColorFormatHandler.formatComponent(renameText2);
                resultMeta.displayName(displayName);
                result.setItemMeta(resultMeta);
            }
            result.setData(DataComponentTypes.REPAIR_COST, (Object)0);
            event.setResult(result);
            return;
        }
        ItemMeta leftMeta = left != null && left.hasItemMeta() ? left.getItemMeta() : null;
        ItemMeta rightMeta = right != null && right.hasItemMeta() ? right.getItemMeta() : null;
        ItemMeta resultMeta = result.getItemMeta();
        if (resultMeta != null) {
            HashMap<Enchantment, Integer> merged = new HashMap<Enchantment, Integer>();
            Map leftEnchants = leftMeta != null ? leftMeta.getEnchants() : Map.of();
            Map rightEnchants = rightMeta != null ? rightMeta.getEnchants() : Map.of();
            HashSet allEnchants = new HashSet();
            allEnchants.addAll(leftEnchants.keySet());
            allEnchants.addAll(rightEnchants.keySet());
            for (Enchantment enchantment : allEnchants) {
                int lvlL = leftEnchants.getOrDefault(enchantment, 0);
                int lvlR = rightEnchants.getOrDefault(enchantment, 0);
                if (UNMERGEABLE_ENCHANTS.contains(enchantment)) {
                    merged.put(enchantment, 1);
                    continue;
                }
                int vanillaMax = this.getVanillaMaxLevel(enchantment);
                int newLvl = lvlL >= vanillaMax && lvlR > vanillaMax || lvlR >= vanillaMax && lvlL > vanillaMax ? Math.max(lvlL, lvlR) : (lvlR > vanillaMax && lvlL >= vanillaMax ? lvlR : (lvlL > vanillaMax && lvlR >= vanillaMax ? lvlL : (lvlL > 0 && lvlL == lvlR ? Math.min(lvlL + 1, 10) : Math.min(Math.max(lvlL, lvlR), 10))));
                merged.put(enchantment, newLvl);
            }
            resultMeta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)resultMeta).removeEnchant(arg_0));
            for (Map.Entry entry : merged.entrySet()) {
                resultMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            result.setItemMeta(resultMeta);
        }
        if ((renameText = event.getView().getRenameText()) != null && !(renameText = renameText.trim()).isEmpty() && (resultMeta = result.getItemMeta()) != null) {
            Component displayName = ColorFormatHandler.formatComponent(renameText);
            resultMeta.displayName(displayName);
            result.setItemMeta(resultMeta);
        }
        result.setData(DataComponentTypes.REPAIR_COST, (Object)0);
        event.setResult(result);
    }

    @EventHandler
    public void onAnvilResultTake(InventoryClickEvent event) {
        if (!(event.getInventory() instanceof AnvilInventory)) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack taken = event.getCurrentItem();
        if (taken == null || taken.getType() == Material.AIR) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
            boolean applied = false;
            if (event.getClick().isShiftClick()) {
                for (int i = 0; i < player.getInventory().getSize(); ++i) {
                    ItemStack invItem = player.getInventory().getItem(i);
                    if (invItem == null || !invItem.isSimilar(taken)) continue;
                    invItem.setData(DataComponentTypes.REPAIR_COST, (Object)0);
                    player.getInventory().setItem(i, invItem);
                    applied = true;
                    break;
                }
            } else {
                ItemStack cursor = player.getItemOnCursor();
                if (cursor != null && cursor.getType() != Material.AIR) {
                    cursor.setData(DataComponentTypes.REPAIR_COST, (Object)0);
                    player.setItemOnCursor(cursor);
                    applied = true;
                }
            }
            if (applied) {
                Bukkit.getConsoleSender().sendMessage(MiniMessage.miniMessage().deserialize((Object)("<dark_gray>[<b><gradient:#E9FF62:#F662FF>RHAnvils</gradient></b>] <gray>Der Spieler <yellow>" + player.getName() + "</yellow> hat sein Item ohne Kostenerh\u00f6hung modifiziert")));
                player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_BREAK, SoundCategory.MASTER, 0.8f, 1.3f);
                player.showTitle(Title.title((Component)Component.empty(), (Component)MiniMessage.miniMessage().deserialize((Object)"<gradient:#E9FF62:#F662FF>Kosten minimiert</gradient>"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(200L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(200L))));
            }
        }, 1L);
    }
}

