/*
 * Decompiled with CFR 0.152.
 */
package eu.raidersheaven.rhanvils.listeners;

import eu.raidersheaven.rhanvils.handlers.ColorFormatHandler;
import eu.raidersheaven.rhanvils.main.Main;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnvilListener111
implements Listener {
    private static final Set<Enchantment> UNMERGEABLE_ENCHANTS = Set.of(Enchantment.AQUA_AFFINITY, Enchantment.CHANNELING, Enchantment.BINDING_CURSE, Enchantment.VANISHING_CURSE, Enchantment.FLAME, Enchantment.INFINITY, Enchantment.MENDING, Enchantment.SILK_TOUCH, Enchantment.MULTISHOT);

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        String renameText;
        AnvilInventory inv = event.getInventory();
        Player player = (Player)event.getView().getPlayer();
        if (!player.hasPermission("RHAnvils.use")) {
            return;
        }
        ItemStack result = event.getResult();
        if (result == null || result.getType() == Material.AIR) {
            return;
        }
        ItemStack left = inv.getItem(0);
        ItemStack right = inv.getItem(1);
        if (left != null && left.getType() == Material.ENCHANTED_BOOK || right != null && right.getType() == Material.ENCHANTED_BOOK) {
            if (result.hasItemMeta()) {
                try {
                    result.setData(DataComponentTypes.REPAIR_COST, (Object)0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.setResult(result);
            }
            return;
        }
        ItemMeta leftMeta = left != null && left.hasItemMeta() ? left.getItemMeta() : null;
        ItemMeta rightMeta = right != null && right.hasItemMeta() ? right.getItemMeta() : null;
        ItemMeta resultMeta = result.getItemMeta();
        if (resultMeta != null) {
            HashMap<Enchantment, Integer> merged = new HashMap<Enchantment, Integer>();
            Map leftEnchants = leftMeta != null ? leftMeta.getEnchants() : Map.of();
            Map rightEnchants = rightMeta != null ? rightMeta.getEnchants() : Map.of();
            HashSet allEnchants = new HashSet();
            allEnchants.addAll(leftEnchants.keySet());
            allEnchants.addAll(rightEnchants.keySet());
            for (Enchantment enchantment : allEnchants) {
                int lvlL = leftEnchants.getOrDefault(enchantment, 0);
                int lvlR = rightEnchants.getOrDefault(enchantment, 0);
                if (UNMERGEABLE_ENCHANTS.contains(enchantment)) {
                    merged.put(enchantment, 1);
                    continue;
                }
                int newLvl = lvlL > 0 && lvlL == lvlR ? Math.min(lvlL + 1, 10) : Math.min(Math.max(lvlL, lvlR), 10);
                merged.put(enchantment, newLvl);
            }
            resultMeta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)resultMeta).removeEnchant(arg_0));
            for (Map.Entry entry : merged.entrySet()) {
                resultMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            result.setItemMeta(resultMeta);
        }
        if ((renameText = event.getView().getRenameText()) != null && !(renameText = renameText.trim()).isEmpty() && (resultMeta = result.getItemMeta()) != null) {
            Component displayName = ColorFormatHandler.formatComponent(renameText);
            resultMeta.displayName(displayName);
            result.setItemMeta(resultMeta);
        }
        result.setData(DataComponentTypes.REPAIR_COST, (Object)0);
        event.setResult(result);
    }

    @EventHandler
    public void onAnvilResultTake(InventoryClickEvent event) {
        if (!(event.getInventory() instanceof AnvilInventory)) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack taken = event.getCurrentItem();
        if (taken == null || taken.getType() == Material.AIR) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
            boolean applied = false;
            if (event.getClick().isShiftClick()) {
                for (int i = 0; i < player.getInventory().getSize(); ++i) {
                    ItemStack invItem = player.getInventory().getItem(i);
                    if (invItem == null || !invItem.isSimilar(taken)) continue;
                    invItem.setData(DataComponentTypes.REPAIR_COST, (Object)0);
                    player.getInventory().setItem(i, invItem);
                    applied = true;
                    break;
                }
            } else {
                ItemStack cursor = player.getItemOnCursor();
                if (cursor != null && cursor.getType() != Material.AIR) {
                    cursor.setData(DataComponentTypes.REPAIR_COST, (Object)0);
                    player.setItemOnCursor(cursor);
                    applied = true;
                }
            }
            if (applied) {
                Bukkit.getConsoleSender().sendMessage(MiniMessage.miniMessage().deserialize((Object)("<dark_gray>[<b><gradient:#E9FF62:#F662FF>RHAnvils</gradient></b>] <gray>Der Spieler <yellow>" + player.getName() + "</yellow> hat sein Item ohne Kostenerh\u00f6hung modifiziert")));
                player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_BREAK, SoundCategory.MASTER, 0.8f, 1.3f);
                player.showTitle(Title.title((Component)Component.empty(), (Component)MiniMessage.miniMessage().deserialize((Object)"<gradient:#E9FF62:#F662FF>Kosten minimiert</gradient>"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(200L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(200L))));
            }
        }, 1L);
    }
}

