/*
 * Decompiled with CFR 0.152.
 */
package xyz.reknown.fastercrystals.listeners.packet;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.DiggingAction;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.reknown.fastercrystals.FasterCrystals;
import xyz.reknown.fastercrystals.enums.AnimPackets;
import xyz.reknown.fastercrystals.user.User;

public class LastPacketListener
extends SimplePacketListenerAbstract {
    public LastPacketListener() {
        super(PacketListenerPriority.MONITOR);
    }

    public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
        FasterCrystals plugin = (FasterCrystals)JavaPlugin.getPlugin(FasterCrystals.class);
        Player player = (Player)event.getPlayer();
        if (player == null) {
            return;
        }
        User user = plugin.getUsers().get(player);
        if (user == null) {
            return;
        }
        AnimPackets animPacket = this.getAnimPacket(event);
        if (user.getLastPacket() == AnimPackets.ANIMATION) {
            user.setIgnoreAnim(animPacket == AnimPackets.INV_DROP || animPacket == AnimPackets.CREATIVE_INV_ACTION);
        }
        user.setLastPacket(animPacket);
    }

    private AnimPackets getAnimPacket(PacketPlayReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.ANIMATION) {
            return AnimPackets.ANIMATION;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            WrapperPlayClientPlayerDigging wrapper = new WrapperPlayClientPlayerDigging((PacketReceiveEvent)event);
            if (wrapper.getAction() == DiggingAction.DROP_ITEM || wrapper.getAction() == DiggingAction.DROP_ITEM_STACK) {
                return AnimPackets.IGNORE;
            }
            if (wrapper.getAction() == DiggingAction.START_DIGGING) {
                return AnimPackets.START_DIGGING;
            }
        } else if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW) {
            WrapperPlayClientClickWindow wrapper = new WrapperPlayClientClickWindow((PacketReceiveEvent)event);
            if (wrapper.getWindowClickType() == WrapperPlayClientClickWindow.WindowClickType.THROW || wrapper.getWindowClickType() == WrapperPlayClientClickWindow.WindowClickType.PICKUP && wrapper.getSlot() == -999) {
                return AnimPackets.INV_DROP;
            }
        } else {
            WrapperPlayClientInteractEntity wrapper;
            if (event.getPacketType() == PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
                return AnimPackets.CREATIVE_INV_ACTION;
            }
            if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT || event.getPacketType() == PacketType.Play.Client.USE_ITEM) {
                return AnimPackets.IGNORE;
            }
            if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY && (wrapper = new WrapperPlayClientInteractEntity((PacketReceiveEvent)event)).getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                return AnimPackets.ATTACK;
            }
        }
        return AnimPackets.MISC;
    }
}

