/*
 * Decompiled with CFR 0.152.
 */
package xyz.reknown.fastercrystals.listeners.packet;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.InteractionHand;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import xyz.reknown.fastercrystals.FasterCrystals;
import xyz.reknown.fastercrystals.user.User;

public class InteractEntityListener
extends SimplePacketListenerAbstract {
    private static final Set<Material> ALLOWED_BLOCKS = Set.of(Material.OBSIDIAN, Material.BEDROCK);

    public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.INTERACT_ENTITY) {
            return;
        }
        WrapperPlayClientInteractEntity wrapper = new WrapperPlayClientInteractEntity((PacketReceiveEvent)event);
        if (wrapper.getAction() != WrapperPlayClientInteractEntity.InteractAction.INTERACT_AT) {
            return;
        }
        FasterCrystals plugin = (FasterCrystals)JavaPlugin.getPlugin(FasterCrystals.class);
        Player player = (Player)event.getPlayer();
        if (player == null || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        User user = plugin.getUsers().get(player);
        if (user == null || !user.isFasterCrystals()) {
            return;
        }
        ItemStack item = wrapper.getHand() == InteractionHand.MAIN_HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        if (item.getType() != Material.END_CRYSTAL) {
            return;
        }
        int entityId = wrapper.getEntityId();
        EnderCrystal entity = plugin.getCrystalIds().get(entityId);
        if (entity == null) {
            return;
        }
        Location eyeLoc = player.getEyeLocation();
        Vector direction = eyeLoc.getDirection();
        FoliaScheduler.getRegionScheduler().run((Plugin)plugin, eyeLoc, task -> {
            Location blockLoc = entity.getLocation().subtract(0.5, 1.0, 0.5);
            RayTraceResult result = eyeLoc.getWorld().rayTraceBlocks(eyeLoc, direction, player.getAttribute(Attribute.PLAYER_BLOCK_INTERACTION_RANGE).getValue());
            if (result == null || !ALLOWED_BLOCKS.contains(result.getHitBlock().getType())) {
                return;
            }
            if (!result.getHitBlock().getLocation().equals((Object)blockLoc)) {
                return;
            }
            plugin.spawnCrystal(entity.getLocation(), player, item);
        });
    }
}

