/*
 * Decompiled with CFR 0.152.
 */
package xyz.reknown.fastercrystals.commands;

import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.reknown.fastercrystals.FasterCrystals;

public class FastercrystalsCommand
implements CommandExecutor,
TabCompleter {
    private static final Set<String> ON_STRINGS = Set.of("true", "on");
    private static final Set<String> OFF_STRINGS = Set.of("false", "off");
    private final FasterCrystals plugin;

    public FastercrystalsCommand(FasterCrystals plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        boolean toggle;
        String subCommand;
        if (args.length == 1 && (subCommand = args[0].toLowerCase()).equals("reload")) {
            if (!sender.hasPermission("fastercrystals.reload")) {
                sender.sendMessage((Component)Component.text((String)"You do not have permissions to do this!", (TextColor)NamedTextColor.RED));
                return true;
            }
            this.plugin.reloadConfig();
            sender.sendMessage((Component)Component.text((String)"Reloaded FasterCrystals config!", (TextColor)NamedTextColor.GREEN));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Only players can use this command!", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("fastercrystals.toggle")) {
            sender.sendMessage((Component)Component.text((String)"You do not have permissions to do this!", (TextColor)NamedTextColor.RED));
            return true;
        }
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "fastcrystals");
        if (args.length > 0) {
            String toggleStr = args[0].toLowerCase();
            if (ON_STRINGS.contains(toggleStr)) {
                toggle = true;
            } else {
                if (!OFF_STRINGS.contains(toggleStr)) {
                    sender.sendMessage((Component)Component.text((String)("Invalid input: " + toggleStr), (TextColor)NamedTextColor.RED));
                    return true;
                }
                toggle = false;
            }
        } else {
            toggle = (Byte)pdc.getOrDefault(key, PersistentDataType.BYTE, (Object)1) == 0;
        }
        pdc.set(key, PersistentDataType.BYTE, (Object)((byte)(toggle ? 1 : 0)));
        String stateKey = "state." + (toggle ? "on" : "off");
        String state = this.plugin.getConfig().getString(stateKey);
        String text = this.plugin.getConfig().getString("text");
        MiniMessage mm = MiniMessage.miniMessage();
        Component component = mm.deserialize(text, (TagResolver)Placeholder.parsed((String)"state", (String)state));
        player.sendMessage(component);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return List.of("reload", "on", "off");
    }
}

