/*
 * Decompiled with CFR 0.152.
 */
package xyz.reknown.fastercrystals;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.reknown.fastercrystals.api.FasterCrystalsAPI;
import xyz.reknown.fastercrystals.bstats.Metrics;
import xyz.reknown.fastercrystals.commands.FastercrystalsCommand;
import xyz.reknown.fastercrystals.listeners.bukkit.EntityRemoveFromWorldListener;
import xyz.reknown.fastercrystals.listeners.bukkit.EntitySpawnListener;
import xyz.reknown.fastercrystals.listeners.bukkit.PlayerJoinListener;
import xyz.reknown.fastercrystals.listeners.bukkit.PlayerQuitListener;
import xyz.reknown.fastercrystals.listeners.bukkit.WorldUnloadListener;
import xyz.reknown.fastercrystals.listeners.packet.AnimationListener;
import xyz.reknown.fastercrystals.listeners.packet.InteractEntityListener;
import xyz.reknown.fastercrystals.listeners.packet.LastPacketListener;
import xyz.reknown.fastercrystals.papi.FasterCrystalsExpansion;
import xyz.reknown.fastercrystals.user.Users;

public class FasterCrystals
extends JavaPlugin {
    private List<SimplePacketListenerAbstract> listeners;
    private Users users;
    private Map<Integer, EnderCrystal> crystalIds;
    private static final Set<Material> AIR_TYPES = Set.of(Material.AIR, Material.CAVE_AIR, Material.VOID_AIR);

    public void onEnable() {
        FasterCrystalsAPI.init(this);
        this.saveDefaultConfig();
        this.crystalIds = FoliaScheduler.isFolia() ? new ConcurrentHashMap() : new HashMap();
        this.users = new Users();
        FastercrystalsCommand command = new FastercrystalsCommand(this);
        this.getCommand("fastercrystals").setExecutor((CommandExecutor)command);
        this.getCommand("fastercrystals").setTabCompleter((TabCompleter)command);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityRemoveFromWorldListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntitySpawnListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldUnloadListener(), (Plugin)this);
        this.listeners = List.of(new AnimationListener(), new InteractEntityListener(), new LastPacketListener());
        for (SimplePacketListenerAbstract listener : this.listeners) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)listener);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new FasterCrystalsExpansion().register();
        }
        int pluginId = 22397;
        new Metrics(this, pluginId);
    }

    public void onDisable() {
        for (SimplePacketListenerAbstract listener : this.listeners) {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)listener);
        }
    }

    public void spawnCrystal(Location loc, Player player, ItemStack item) {
        Location clonedLoc = loc.clone().subtract(0.5, 0.0, 0.5);
        if (!AIR_TYPES.contains(clonedLoc.getBlock().getType())) {
            return;
        }
        clonedLoc.add(0.5, 1.0, 0.5);
        ArrayList nearbyEntities = new ArrayList(clonedLoc.getWorld().getNearbyEntities(clonedLoc, 0.5, 1.0, 0.5, entity -> {
            Player p;
            return !(entity instanceof Player) || (p = (Player)entity).getGameMode() != GameMode.SPECTATOR;
        }));
        if (nearbyEntities.isEmpty()) {
            loc.getWorld().spawn(clonedLoc.subtract(0.0, 1.0, 0.0), EnderCrystal.class, entity -> entity.setShowingBottom(false));
            if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
                item.setAmount(item.getAmount() - 1);
            }
        }
    }

    @Generated
    public List<SimplePacketListenerAbstract> getListeners() {
        return this.listeners;
    }

    @Generated
    public Users getUsers() {
        return this.users;
    }

    @Generated
    public Map<Integer, EnderCrystal> getCrystalIds() {
        return this.crystalIds;
    }
}

