/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.utils;

import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.collections.ArraysKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005JC\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052.\u0010\f\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e0\r\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJC\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00052.\u0010\u0012\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e0\r\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0001JC\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00052.\u0010\u0017\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e0\r\"\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ltech/bedson/playerworldmanager/utils/DebugLogger;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "tag", "", "(Lorg/bukkit/plugin/java/JavaPlugin;Ljava/lang/String;)V", "bukkitLogger", "Ljava/util/logging/Logger;", "debug", "", "message", "context", "", "Ltech/bedson/playerworldmanager/libs/kotlin/Pair;", "(Ljava/lang/String;[Ltech/bedson/playerworldmanager/libs/kotlin/Pair;)V", "debugMethodEntry", "methodName", "params", "debugMethodExit", "returnValue", "debugState", "objectName", "state", "error", "exception", "", "info", "isDebugEnabled", "", "severe", "warning", "Companion", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nDebugLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugLogger.kt\ntech/bedson/playerworldmanager/utils/DebugLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1#2:159\n1855#3,2:160\n*S KotlinDebug\n*F\n+ 1 DebugLogger.kt\ntech/bedson/playerworldmanager/utils/DebugLogger\n*L\n151#1:160,2\n*E\n"})
public final class DebugLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final String tag;
    @NotNull
    private final Logger bukkitLogger;
    @Nullable
    private static Boolean debugEnabled;
    private static long lastConfigCheck;
    private static final long CONFIG_CACHE_MS = 5000L;

    public DebugLogger(@NotNull JavaPlugin plugin, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.plugin = plugin;
        this.tag = tag;
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.bukkitLogger = logger;
    }

    private final boolean isDebugEnabled() {
        long now = System.currentTimeMillis();
        if (debugEnabled == null || now - lastConfigCheck > 5000L) {
            debugEnabled = this.plugin.getConfig().getBoolean("debug", false);
            lastConfigCheck = now;
        }
        Boolean bl = debugEnabled;
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.isDebugEnabled()) {
            this.bukkitLogger.info("[DEBUG][" + this.tag + "] " + message);
        }
    }

    public final void debug(@NotNull String message, Pair<String, ? extends Object> ... context) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(context, "context");
        if (this.isDebugEnabled()) {
            String contextStr2 = ArraysKt.joinToString$default(context, (CharSequence)", ", null, null, 0, null, (Function1)debug.contextStr.1.INSTANCE, 30, null);
            this.bukkitLogger.info("[DEBUG][" + this.tag + "] " + message + " | " + contextStr2);
        }
    }

    public final void debugMethodEntry(@NotNull String methodName, Pair<String, ? extends Object> ... params) {
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Intrinsics.checkNotNullParameter(params, "params");
        if (this.isDebugEnabled()) {
            String paramStr2 = !(params.length == 0) ? ArraysKt.joinToString$default(params, (CharSequence)", ", null, null, 0, null, (Function1)debugMethodEntry.paramStr.1.INSTANCE, 30, null) : "no params";
            this.bukkitLogger.info("[DEBUG][" + this.tag + "] >>> " + methodName + "(" + paramStr2 + ")");
        }
    }

    public final void debugMethodExit(@NotNull String methodName, @Nullable Object returnValue) {
        block2: {
            Object object;
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter(methodName, "methodName");
                    if (!this.isDebugEnabled()) break block2;
                    object = returnValue;
                    if (object == null) break block3;
                    Object it = object;
                    boolean bl = false;
                    String string = " -> " + it;
                    object = string;
                    if (string != null) break block4;
                }
                object = "";
            }
            Object returnStr = object;
            this.bukkitLogger.info("[DEBUG][" + this.tag + "] <<< " + methodName + (String)returnStr);
        }
    }

    public static /* synthetic */ void debugMethodExit$default(DebugLogger debugLogger, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        debugLogger.debugMethodExit(string, object);
    }

    public final void debugState(@NotNull String objectName, Pair<String, ? extends Object> ... state) {
        Intrinsics.checkNotNullParameter(objectName, "objectName");
        Intrinsics.checkNotNullParameter(state, "state");
        if (this.isDebugEnabled()) {
            String stateStr2 = ArraysKt.joinToString$default(state, (CharSequence)", ", null, null, 0, null, (Function1)debugState.stateStr.1.INSTANCE, 30, null);
            this.bukkitLogger.info("[DEBUG][" + this.tag + "] STATE " + objectName + ": " + stateStr2);
        }
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.bukkitLogger.info("[" + this.tag + "] " + message);
    }

    public final void warning(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.bukkitLogger.warning("[" + this.tag + "] " + message);
    }

    public final void severe(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.bukkitLogger.severe("[" + this.tag + "] " + message);
    }

    public final void error(@NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.bukkitLogger.severe("[" + this.tag + "] " + message);
        if (exception != null) {
            this.bukkitLogger.severe("[" + this.tag + "] Exception: " + exception.getMessage());
            if (this.isDebugEnabled()) {
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
                Iterable $this$forEach$iv = ArraysKt.take((Object[])stackTraceElementArray, 10);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StackTraceElement frame = (StackTraceElement)element$iv;
                    boolean bl = false;
                    this.bukkitLogger.severe("[" + this.tag + "]   at " + frame);
                }
            }
        }
    }

    public static /* synthetic */ void error$default(DebugLogger debugLogger, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        debugLogger.error(string, throwable);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltech/bedson/playerworldmanager/utils/DebugLogger$Companion;", "", "()V", "CONFIG_CACHE_MS", "", "debugEnabled", "", "Ljava/lang/Boolean;", "lastConfigCheck", "refreshDebugState", "", "PlayerWorldManager"})
    public static final class Companion {
        private Companion() {
        }

        public final void refreshDebugState() {
            debugEnabled = null;
            lastConfigCheck = 0L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

