/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.models;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.SetsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.models.SimpleLocation;
import tech.bedson.playerworldmanager.models.TimeLock;
import tech.bedson.playerworldmanager.models.WeatherLock;
import tech.bedson.playerworldmanager.models.WorldBorderSettings;
import tech.bedson.playerworldmanager.models.WorldRole;
import tech.bedson.playerworldmanager.models.WorldType;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\bF\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 y2\u00020\u0001:\u0001yB\u00b9\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 J\t\u0010P\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003J\t\u0010S\u001a\u00020\u0017H\u00c6\u0003J\t\u0010T\u001a\u00020\u0019H\u00c6\u0003J\t\u0010U\u001a\u00020\u001bH\u00c6\u0003J\t\u0010V\u001a\u00020\u000eH\u00c6\u0003J\t\u0010W\u001a\u00020\u0013H\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\u001fH\u00c2\u0003J\t\u0010Y\u001a\u00020\u0005H\u00c6\u0003J\t\u0010Z\u001a\u00020\u0003H\u00c6\u0003J\t\u0010[\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\\\u001a\u00020\tH\u00c6\u0003J\u0010\u0010]\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010:J\t\u0010^\u001a\u00020\u000bH\u00c6\u0003J\t\u0010_\u001a\u00020\u000eH\u00c6\u0003J\u000f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u00c6\u0003J\u00d0\u0001\u0010a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u00132\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00c6\u0001\u00a2\u0006\u0002\u0010bJ\u0013\u0010c\u001a\u00020\u000e2\b\u0010d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00030fJ\u0010\u0010g\u001a\u0004\u0018\u00010\u00132\u0006\u0010h\u001a\u00020\u0003J\u0010\u0010i\u001a\u0004\u0018\u00010\u00132\u0006\u0010h\u001a\u00020\u0003J\u0014\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00030f2\u0006\u0010k\u001a\u00020\u0013J\u000e\u0010l\u001a\u00020\u000e2\u0006\u0010h\u001a\u00020\u0003J\u000e\u0010m\u001a\u00020\u000e2\u0006\u0010h\u001a\u00020\u0003J\u0016\u0010n\u001a\u00020\u000e2\u0006\u0010h\u001a\u00020\u00032\u0006\u0010o\u001a\u00020\u0013J\t\u0010p\u001a\u00020qH\u00d6\u0001J\u0006\u0010r\u001a\u00020sJ\u000e\u0010t\u001a\u00020s2\u0006\u0010h\u001a\u00020\u0003J\u0016\u0010u\u001a\u00020s2\u0006\u0010h\u001a\u00020\u00032\u0006\u0010k\u001a\u00020\u0013J\u0006\u0010v\u001a\u00020\u0005J\u0006\u0010w\u001a\u00020\u0005J\t\u0010x\u001a\u00020\u0005H\u00d6\u0001R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010+\"\u0004\b,\u0010-R\u001a\u0010\u001c\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010+\"\u0004\b.\u0010-R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00100R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010(R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001a\u0010\u001d\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010;\u001a\u0004\b9\u0010:R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR$\u0010I\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010O\u00a8\u0006z"}, d2={"Ltech/bedson/playerworldmanager/models/PlayerWorld;", "", "id", "Ljava/util/UUID;", "name", "", "ownerUuid", "ownerName", "worldType", "Ltech/bedson/playerworldmanager/models/WorldType;", "seed", "", "createdAt", "isEnabled", "", "invitedPlayers", "", "playerRoles", "", "Ltech/bedson/playerworldmanager/models/WorldRole;", "spawnLocation", "Ltech/bedson/playerworldmanager/models/SimpleLocation;", "defaultGameMode", "Lorg/bukkit/GameMode;", "timeLock", "Ltech/bedson/playerworldmanager/models/TimeLock;", "weatherLock", "Ltech/bedson/playerworldmanager/models/WeatherLock;", "isPublic", "publicJoinRole", "_worldBorder", "Ltech/bedson/playerworldmanager/models/WorldBorderSettings;", "(Ljava/util/UUID;Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ltech/bedson/playerworldmanager/models/WorldType;Ljava/lang/Long;JZLjava/util/Set;Ljava/util/Map;Ltech/bedson/playerworldmanager/models/SimpleLocation;Lorg/bukkit/GameMode;Ltech/bedson/playerworldmanager/models/TimeLock;Ltech/bedson/playerworldmanager/models/WeatherLock;ZLtech/bedson/playerworldmanager/models/WorldRole;Ltech/bedson/playerworldmanager/models/WorldBorderSettings;)V", "getCreatedAt", "()J", "getDefaultGameMode", "()Lorg/bukkit/GameMode;", "setDefaultGameMode", "(Lorg/bukkit/GameMode;)V", "getId", "()Ljava/util/UUID;", "getInvitedPlayers", "()Ljava/util/Set;", "()Z", "setEnabled", "(Z)V", "setPublic", "getName", "()Ljava/lang/String;", "getOwnerName", "getOwnerUuid", "getPlayerRoles", "()Ljava/util/Map;", "getPublicJoinRole", "()Ltech/bedson/playerworldmanager/models/WorldRole;", "setPublicJoinRole", "(Ltech/bedson/playerworldmanager/models/WorldRole;)V", "getSeed", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getSpawnLocation", "()Ltech/bedson/playerworldmanager/models/SimpleLocation;", "setSpawnLocation", "(Ltech/bedson/playerworldmanager/models/SimpleLocation;)V", "getTimeLock", "()Ltech/bedson/playerworldmanager/models/TimeLock;", "setTimeLock", "(Ltech/bedson/playerworldmanager/models/TimeLock;)V", "getWeatherLock", "()Ltech/bedson/playerworldmanager/models/WeatherLock;", "setWeatherLock", "(Ltech/bedson/playerworldmanager/models/WeatherLock;)V", "value", "worldBorder", "getWorldBorder", "()Ltech/bedson/playerworldmanager/models/WorldBorderSettings;", "setWorldBorder", "(Ltech/bedson/playerworldmanager/models/WorldBorderSettings;)V", "getWorldType", "()Ltech/bedson/playerworldmanager/models/WorldType;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ltech/bedson/playerworldmanager/models/WorldType;Ljava/lang/Long;JZLjava/util/Set;Ljava/util/Map;Ltech/bedson/playerworldmanager/models/SimpleLocation;Lorg/bukkit/GameMode;Ltech/bedson/playerworldmanager/models/TimeLock;Ltech/bedson/playerworldmanager/models/WeatherLock;ZLtech/bedson/playerworldmanager/models/WorldRole;Ltech/bedson/playerworldmanager/models/WorldBorderSettings;)Ltech/bedson/playerworldmanager/models/PlayerWorld;", "equals", "other", "getAllPlayers", "", "getExplicitPlayerRole", "playerUuid", "getPlayerRole", "getPlayersWithRole", "role", "hasAccess", "hasExplicitAccess", "hasRole", "minRole", "hashCode", "", "migrateInvitedPlayersToRoles", "", "removePlayer", "setPlayerRole", "toCompactDebugString", "toDebugString", "toString", "Companion", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nPlayerWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerWorld.kt\ntech/bedson/playerworldmanager/models/PlayerWorld\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,244:1\n1#2:245\n494#3,7:246\n*S KotlinDebug\n*F\n+ 1 PlayerWorld.kt\ntech/bedson/playerworldmanager/models/PlayerWorld\n*L\n111#1:246,7\n*E\n"})
public final class PlayerWorld {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID id;
    @NotNull
    private final String name;
    @NotNull
    private final UUID ownerUuid;
    @NotNull
    private final String ownerName;
    @NotNull
    private final WorldType worldType;
    @Nullable
    private final Long seed;
    private final long createdAt;
    private boolean isEnabled;
    @NotNull
    private final Set<UUID> invitedPlayers;
    @NotNull
    private final Map<UUID, WorldRole> playerRoles;
    @Nullable
    private SimpleLocation spawnLocation;
    @NotNull
    private GameMode defaultGameMode;
    @NotNull
    private TimeLock timeLock;
    @NotNull
    private WeatherLock weatherLock;
    private boolean isPublic;
    @NotNull
    private WorldRole publicJoinRole;
    @Nullable
    private WorldBorderSettings _worldBorder;

    public PlayerWorld(@NotNull UUID id, @NotNull String name, @NotNull UUID ownerUuid, @NotNull String ownerName, @NotNull WorldType worldType, @Nullable Long seed, long createdAt, boolean isEnabled, @NotNull Set<UUID> invitedPlayers, @NotNull Map<UUID, WorldRole> playerRoles, @Nullable SimpleLocation spawnLocation, @NotNull GameMode defaultGameMode, @NotNull TimeLock timeLock, @NotNull WeatherLock weatherLock, boolean isPublic, @NotNull WorldRole publicJoinRole, @Nullable WorldBorderSettings _worldBorder) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(ownerUuid, "ownerUuid");
        Intrinsics.checkNotNullParameter(ownerName, "ownerName");
        Intrinsics.checkNotNullParameter((Object)worldType, "worldType");
        Intrinsics.checkNotNullParameter(invitedPlayers, "invitedPlayers");
        Intrinsics.checkNotNullParameter(playerRoles, "playerRoles");
        Intrinsics.checkNotNullParameter(defaultGameMode, "defaultGameMode");
        Intrinsics.checkNotNullParameter((Object)timeLock, "timeLock");
        Intrinsics.checkNotNullParameter((Object)weatherLock, "weatherLock");
        Intrinsics.checkNotNullParameter((Object)publicJoinRole, "publicJoinRole");
        this.id = id;
        this.name = name;
        this.ownerUuid = ownerUuid;
        this.ownerName = ownerName;
        this.worldType = worldType;
        this.seed = seed;
        this.createdAt = createdAt;
        this.isEnabled = isEnabled;
        this.invitedPlayers = invitedPlayers;
        this.playerRoles = playerRoles;
        this.spawnLocation = spawnLocation;
        this.defaultGameMode = defaultGameMode;
        this.timeLock = timeLock;
        this.weatherLock = weatherLock;
        this.isPublic = isPublic;
        this.publicJoinRole = publicJoinRole;
        this._worldBorder = _worldBorder;
    }

    public /* synthetic */ PlayerWorld(UUID uUID, String string, UUID uUID2, String string2, WorldType worldType, Long l, long l2, boolean bl, Set set, Map map, SimpleLocation simpleLocation, GameMode gameMode, TimeLock timeLock, WeatherLock weatherLock, boolean bl2, WorldRole worldRole, WorldBorderSettings worldBorderSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            bl = true;
        }
        if ((n & 0x100) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 0x200) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 0x400) != 0) {
            simpleLocation = null;
        }
        if ((n & 0x800) != 0) {
            gameMode = GameMode.SURVIVAL;
        }
        if ((n & 0x1000) != 0) {
            timeLock = TimeLock.CYCLE;
        }
        if ((n & 0x2000) != 0) {
            weatherLock = WeatherLock.CYCLE;
        }
        if ((n & 0x4000) != 0) {
            bl2 = false;
        }
        if ((n & 0x8000) != 0) {
            worldRole = WorldRole.VISITOR;
        }
        if ((n & 0x10000) != 0) {
            worldBorderSettings = null;
        }
        this(uUID, string, uUID2, string2, worldType, l, l2, bl, set, map, simpleLocation, gameMode, timeLock, weatherLock, bl2, worldRole, worldBorderSettings);
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    @NotNull
    public final String getOwnerName() {
        return this.ownerName;
    }

    @NotNull
    public final WorldType getWorldType() {
        return this.worldType;
    }

    @Nullable
    public final Long getSeed() {
        return this.seed;
    }

    public final long getCreatedAt() {
        return this.createdAt;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final Set<UUID> getInvitedPlayers() {
        return this.invitedPlayers;
    }

    @NotNull
    public final Map<UUID, WorldRole> getPlayerRoles() {
        return this.playerRoles;
    }

    @Nullable
    public final SimpleLocation getSpawnLocation() {
        return this.spawnLocation;
    }

    public final void setSpawnLocation(@Nullable SimpleLocation simpleLocation) {
        this.spawnLocation = simpleLocation;
    }

    @NotNull
    public final GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public final void setDefaultGameMode(@NotNull GameMode gameMode) {
        Intrinsics.checkNotNullParameter(gameMode, "<set-?>");
        this.defaultGameMode = gameMode;
    }

    @NotNull
    public final TimeLock getTimeLock() {
        return this.timeLock;
    }

    public final void setTimeLock(@NotNull TimeLock timeLock) {
        Intrinsics.checkNotNullParameter((Object)timeLock, "<set-?>");
        this.timeLock = timeLock;
    }

    @NotNull
    public final WeatherLock getWeatherLock() {
        return this.weatherLock;
    }

    public final void setWeatherLock(@NotNull WeatherLock weatherLock) {
        Intrinsics.checkNotNullParameter((Object)weatherLock, "<set-?>");
        this.weatherLock = weatherLock;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    public final void setPublic(boolean bl) {
        this.isPublic = bl;
    }

    @NotNull
    public final WorldRole getPublicJoinRole() {
        return this.publicJoinRole;
    }

    public final void setPublicJoinRole(@NotNull WorldRole worldRole) {
        Intrinsics.checkNotNullParameter((Object)worldRole, "<set-?>");
        this.publicJoinRole = worldRole;
    }

    @NotNull
    public final WorldBorderSettings getWorldBorder() {
        WorldBorderSettings worldBorderSettings = this._worldBorder;
        if (worldBorderSettings == null) {
            WorldBorderSettings worldBorderSettings2;
            WorldBorderSettings it = worldBorderSettings2 = WorldBorderSettings.Companion.default();
            boolean bl = false;
            this._worldBorder = it;
            worldBorderSettings = worldBorderSettings2;
        }
        return worldBorderSettings;
    }

    public final void setWorldBorder(@NotNull WorldBorderSettings value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this._worldBorder = value;
    }

    @Nullable
    public final WorldRole getPlayerRole(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        return Intrinsics.areEqual(playerUuid, this.ownerUuid) ? WorldRole.OWNER : (this.playerRoles.containsKey(playerUuid) ? this.playerRoles.get(playerUuid) : (this.invitedPlayers.contains(playerUuid) ? WorldRole.MEMBER : (this.isPublic ? this.publicJoinRole : null)));
    }

    @Nullable
    public final WorldRole getExplicitPlayerRole(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        return Intrinsics.areEqual(playerUuid, this.ownerUuid) ? WorldRole.OWNER : (this.playerRoles.containsKey(playerUuid) ? this.playerRoles.get(playerUuid) : (this.invitedPlayers.contains(playerUuid) ? WorldRole.MEMBER : null));
    }

    public final boolean hasAccess(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        return this.getPlayerRole(playerUuid) != null;
    }

    public final boolean hasExplicitAccess(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        return this.getExplicitPlayerRole(playerUuid) != null;
    }

    public final boolean hasRole(@NotNull UUID playerUuid, @NotNull WorldRole minRole) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter((Object)minRole, "minRole");
        WorldRole worldRole = this.getPlayerRole(playerUuid);
        if (worldRole == null) {
            return false;
        }
        WorldRole role = worldRole;
        return role.isAtLeast(minRole);
    }

    public final void setPlayerRole(@NotNull UUID playerUuid, @NotNull WorldRole role) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter((Object)role, "role");
        if (!(role != WorldRole.OWNER)) {
            boolean $i$a$-require-PlayerWorld$setPlayerRole$32 = false;
            String $i$a$-require-PlayerWorld$setPlayerRole$32 = "Cannot set OWNER role directly. Use transfer ownership instead.";
            throw new IllegalArgumentException($i$a$-require-PlayerWorld$setPlayerRole$32.toString());
        }
        if (!(!Intrinsics.areEqual(playerUuid, this.ownerUuid))) {
            boolean bl = false;
            String string = "Cannot change the owner's role.";
            throw new IllegalArgumentException(string.toString());
        }
        this.playerRoles.put(playerUuid, role);
        this.invitedPlayers.add(playerUuid);
    }

    public final void removePlayer(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        if (!(!Intrinsics.areEqual(playerUuid, this.ownerUuid))) {
            boolean bl = false;
            String string = "Cannot remove the owner from their own world.";
            throw new IllegalArgumentException(string.toString());
        }
        this.playerRoles.remove(playerUuid);
        this.invitedPlayers.remove(playerUuid);
    }

    @NotNull
    public final Set<UUID> getPlayersWithRole(@NotNull WorldRole role) {
        Set<UUID> set;
        Intrinsics.checkNotNullParameter((Object)role, "role");
        if (WhenMappings.$EnumSwitchMapping$0[role.ordinal()] == 1) {
            set = SetsKt.setOf(this.ownerUuid);
        } else {
            Map<UUID, WorldRole> $this$filterValues$iv = this.playerRoles;
            boolean $i$f$filterValues = false;
            LinkedHashMap<UUID, WorldRole> result$iv = new LinkedHashMap<UUID, WorldRole>();
            for (Map.Entry<UUID, WorldRole> entry$iv : $this$filterValues$iv.entrySet()) {
                WorldRole it = entry$iv.getValue();
                boolean bl = false;
                if (!(it == role)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            set = ((Map)result$iv).keySet();
        }
        return set;
    }

    @NotNull
    public final Set<UUID> getAllPlayers() {
        return SetsKt.plus(SetsKt.plus(SetsKt.setOf(this.ownerUuid), (Iterable)this.playerRoles.keySet()), (Iterable)this.invitedPlayers);
    }

    public final void migrateInvitedPlayersToRoles() {
        for (UUID playerUuid : this.invitedPlayers) {
            if (Intrinsics.areEqual(playerUuid, this.ownerUuid) || this.playerRoles.containsKey(playerUuid)) continue;
            this.playerRoles.put(playerUuid, WorldRole.MEMBER);
        }
    }

    @NotNull
    public final String toDebugString() {
        return "PlayerWorld(id=" + this.id + ", name=" + this.name + ", owner=" + this.ownerName + "/" + this.ownerUuid + ", type=" + this.worldType + ", seed=" + this.seed + ", enabled=" + this.isEnabled + ", members=" + this.playerRoles.size() + ", gameMode=" + this.defaultGameMode + ", timeLock=" + this.timeLock + ", weatherLock=" + this.weatherLock + ", isPublic=" + this.isPublic + ", publicJoinRole=" + this.publicJoinRole + ", border=" + this.getWorldBorder().getSize() + ")";
    }

    @NotNull
    public final String toCompactDebugString() {
        return "PlayerWorld[" + this.name + ", owner=" + this.ownerName + ", type=" + this.worldType + ", public=" + this.isPublic + "]";
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final UUID component3() {
        return this.ownerUuid;
    }

    @NotNull
    public final String component4() {
        return this.ownerName;
    }

    @NotNull
    public final WorldType component5() {
        return this.worldType;
    }

    @Nullable
    public final Long component6() {
        return this.seed;
    }

    public final long component7() {
        return this.createdAt;
    }

    public final boolean component8() {
        return this.isEnabled;
    }

    @NotNull
    public final Set<UUID> component9() {
        return this.invitedPlayers;
    }

    @NotNull
    public final Map<UUID, WorldRole> component10() {
        return this.playerRoles;
    }

    @Nullable
    public final SimpleLocation component11() {
        return this.spawnLocation;
    }

    @NotNull
    public final GameMode component12() {
        return this.defaultGameMode;
    }

    @NotNull
    public final TimeLock component13() {
        return this.timeLock;
    }

    @NotNull
    public final WeatherLock component14() {
        return this.weatherLock;
    }

    public final boolean component15() {
        return this.isPublic;
    }

    @NotNull
    public final WorldRole component16() {
        return this.publicJoinRole;
    }

    private final WorldBorderSettings component17() {
        return this._worldBorder;
    }

    @NotNull
    public final PlayerWorld copy(@NotNull UUID id, @NotNull String name, @NotNull UUID ownerUuid, @NotNull String ownerName, @NotNull WorldType worldType, @Nullable Long seed, long createdAt, boolean isEnabled, @NotNull Set<UUID> invitedPlayers, @NotNull Map<UUID, WorldRole> playerRoles, @Nullable SimpleLocation spawnLocation, @NotNull GameMode defaultGameMode, @NotNull TimeLock timeLock, @NotNull WeatherLock weatherLock, boolean isPublic, @NotNull WorldRole publicJoinRole, @Nullable WorldBorderSettings _worldBorder) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(ownerUuid, "ownerUuid");
        Intrinsics.checkNotNullParameter(ownerName, "ownerName");
        Intrinsics.checkNotNullParameter((Object)worldType, "worldType");
        Intrinsics.checkNotNullParameter(invitedPlayers, "invitedPlayers");
        Intrinsics.checkNotNullParameter(playerRoles, "playerRoles");
        Intrinsics.checkNotNullParameter(defaultGameMode, "defaultGameMode");
        Intrinsics.checkNotNullParameter((Object)timeLock, "timeLock");
        Intrinsics.checkNotNullParameter((Object)weatherLock, "weatherLock");
        Intrinsics.checkNotNullParameter((Object)publicJoinRole, "publicJoinRole");
        return new PlayerWorld(id, name, ownerUuid, ownerName, worldType, seed, createdAt, isEnabled, invitedPlayers, playerRoles, spawnLocation, defaultGameMode, timeLock, weatherLock, isPublic, publicJoinRole, _worldBorder);
    }

    public static /* synthetic */ PlayerWorld copy$default(PlayerWorld playerWorld, UUID uUID, String string, UUID uUID2, String string2, WorldType worldType, Long l, long l2, boolean bl, Set set, Map map, SimpleLocation simpleLocation, GameMode gameMode, TimeLock timeLock, WeatherLock weatherLock, boolean bl2, WorldRole worldRole, WorldBorderSettings worldBorderSettings, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = playerWorld.id;
        }
        if ((n & 2) != 0) {
            string = playerWorld.name;
        }
        if ((n & 4) != 0) {
            uUID2 = playerWorld.ownerUuid;
        }
        if ((n & 8) != 0) {
            string2 = playerWorld.ownerName;
        }
        if ((n & 0x10) != 0) {
            worldType = playerWorld.worldType;
        }
        if ((n & 0x20) != 0) {
            l = playerWorld.seed;
        }
        if ((n & 0x40) != 0) {
            l2 = playerWorld.createdAt;
        }
        if ((n & 0x80) != 0) {
            bl = playerWorld.isEnabled;
        }
        if ((n & 0x100) != 0) {
            set = playerWorld.invitedPlayers;
        }
        if ((n & 0x200) != 0) {
            map = playerWorld.playerRoles;
        }
        if ((n & 0x400) != 0) {
            simpleLocation = playerWorld.spawnLocation;
        }
        if ((n & 0x800) != 0) {
            gameMode = playerWorld.defaultGameMode;
        }
        if ((n & 0x1000) != 0) {
            timeLock = playerWorld.timeLock;
        }
        if ((n & 0x2000) != 0) {
            weatherLock = playerWorld.weatherLock;
        }
        if ((n & 0x4000) != 0) {
            bl2 = playerWorld.isPublic;
        }
        if ((n & 0x8000) != 0) {
            worldRole = playerWorld.publicJoinRole;
        }
        if ((n & 0x10000) != 0) {
            worldBorderSettings = playerWorld._worldBorder;
        }
        return playerWorld.copy(uUID, string, uUID2, string2, worldType, l, l2, bl, set, map, simpleLocation, gameMode, timeLock, weatherLock, bl2, worldRole, worldBorderSettings);
    }

    @NotNull
    public String toString() {
        return "PlayerWorld(id=" + this.id + ", name=" + this.name + ", ownerUuid=" + this.ownerUuid + ", ownerName=" + this.ownerName + ", worldType=" + this.worldType + ", seed=" + this.seed + ", createdAt=" + this.createdAt + ", isEnabled=" + this.isEnabled + ", invitedPlayers=" + this.invitedPlayers + ", playerRoles=" + this.playerRoles + ", spawnLocation=" + this.spawnLocation + ", defaultGameMode=" + this.defaultGameMode + ", timeLock=" + this.timeLock + ", weatherLock=" + this.weatherLock + ", isPublic=" + this.isPublic + ", publicJoinRole=" + this.publicJoinRole + ", _worldBorder=" + this._worldBorder + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.ownerUuid.hashCode();
        result = result * 31 + this.ownerName.hashCode();
        result = result * 31 + this.worldType.hashCode();
        result = result * 31 + (this.seed == null ? 0 : ((Object)this.seed).hashCode());
        result = result * 31 + Long.hashCode(this.createdAt);
        result = result * 31 + Boolean.hashCode(this.isEnabled);
        result = result * 31 + ((Object)this.invitedPlayers).hashCode();
        result = result * 31 + ((Object)this.playerRoles).hashCode();
        result = result * 31 + (this.spawnLocation == null ? 0 : this.spawnLocation.hashCode());
        result = result * 31 + this.defaultGameMode.hashCode();
        result = result * 31 + this.timeLock.hashCode();
        result = result * 31 + this.weatherLock.hashCode();
        result = result * 31 + Boolean.hashCode(this.isPublic);
        result = result * 31 + this.publicJoinRole.hashCode();
        result = result * 31 + (this._worldBorder == null ? 0 : this._worldBorder.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlayerWorld)) {
            return false;
        }
        PlayerWorld playerWorld = (PlayerWorld)other;
        if (!Intrinsics.areEqual(this.id, playerWorld.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.name, playerWorld.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ownerUuid, playerWorld.ownerUuid)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ownerName, playerWorld.ownerName)) {
            return false;
        }
        if (this.worldType != playerWorld.worldType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.seed, playerWorld.seed)) {
            return false;
        }
        if (this.createdAt != playerWorld.createdAt) {
            return false;
        }
        if (this.isEnabled != playerWorld.isEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual(this.invitedPlayers, playerWorld.invitedPlayers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.playerRoles, playerWorld.playerRoles)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spawnLocation, playerWorld.spawnLocation)) {
            return false;
        }
        if (this.defaultGameMode != playerWorld.defaultGameMode) {
            return false;
        }
        if (this.timeLock != playerWorld.timeLock) {
            return false;
        }
        if (this.weatherLock != playerWorld.weatherLock) {
            return false;
        }
        if (this.isPublic != playerWorld.isPublic) {
            return false;
        }
        if (this.publicJoinRole != playerWorld.publicJoinRole) {
            return false;
        }
        return Intrinsics.areEqual(this._worldBorder, playerWorld._worldBorder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u00c5\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u00132\b\b\u0002\u0010\"\u001a\u00020\u00182\b\b\u0002\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Ltech/bedson/playerworldmanager/models/PlayerWorld$Companion;", "", "()V", "createWithLogging", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "id", "Ljava/util/UUID;", "name", "", "ownerUuid", "ownerName", "worldType", "Ltech/bedson/playerworldmanager/models/WorldType;", "seed", "", "createdAt", "isEnabled", "", "invitedPlayers", "", "playerRoles", "", "Ltech/bedson/playerworldmanager/models/WorldRole;", "spawnLocation", "Ltech/bedson/playerworldmanager/models/SimpleLocation;", "defaultGameMode", "Lorg/bukkit/GameMode;", "timeLock", "Ltech/bedson/playerworldmanager/models/TimeLock;", "weatherLock", "Ltech/bedson/playerworldmanager/models/WeatherLock;", "isPublic", "publicJoinRole", "worldBorder", "Ltech/bedson/playerworldmanager/models/WorldBorderSettings;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ljava/util/UUID;Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ltech/bedson/playerworldmanager/models/WorldType;Ljava/lang/Long;JZLjava/util/Set;Ljava/util/Map;Ltech/bedson/playerworldmanager/models/SimpleLocation;Lorg/bukkit/GameMode;Ltech/bedson/playerworldmanager/models/TimeLock;Ltech/bedson/playerworldmanager/models/WeatherLock;ZLtech/bedson/playerworldmanager/models/WorldRole;Ltech/bedson/playerworldmanager/models/WorldBorderSettings;)Ltech/bedson/playerworldmanager/models/PlayerWorld;", "PlayerWorldManager"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlayerWorld createWithLogging(@NotNull JavaPlugin plugin, @NotNull UUID id, @NotNull String name, @NotNull UUID ownerUuid, @NotNull String ownerName, @NotNull WorldType worldType, @Nullable Long seed, long createdAt, boolean isEnabled, @NotNull Set<UUID> invitedPlayers, @NotNull Map<UUID, WorldRole> playerRoles, @Nullable SimpleLocation spawnLocation, @NotNull GameMode defaultGameMode, @NotNull TimeLock timeLock, @NotNull WeatherLock weatherLock, boolean isPublic, @NotNull WorldRole publicJoinRole, @NotNull WorldBorderSettings worldBorder) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(ownerUuid, "ownerUuid");
            Intrinsics.checkNotNullParameter(ownerName, "ownerName");
            Intrinsics.checkNotNullParameter((Object)worldType, "worldType");
            Intrinsics.checkNotNullParameter(invitedPlayers, "invitedPlayers");
            Intrinsics.checkNotNullParameter(playerRoles, "playerRoles");
            Intrinsics.checkNotNullParameter(defaultGameMode, "defaultGameMode");
            Intrinsics.checkNotNullParameter((Object)timeLock, "timeLock");
            Intrinsics.checkNotNullParameter((Object)weatherLock, "weatherLock");
            Intrinsics.checkNotNullParameter((Object)publicJoinRole, "publicJoinRole");
            Intrinsics.checkNotNullParameter(worldBorder, "worldBorder");
            DebugLogger debugLogger = new DebugLogger(plugin, "PlayerWorld");
            Pair[] pairArray = new Pair[]{TuplesKt.to("id", id), TuplesKt.to("name", name), TuplesKt.to("owner", ownerName), TuplesKt.to("ownerUuid", ownerUuid), TuplesKt.to("type", worldType), TuplesKt.to("seed", seed), TuplesKt.to("isPublic", isPublic), TuplesKt.to("publicJoinRole", publicJoinRole)};
            debugLogger.debug("Creating PlayerWorld", pairArray);
            return new PlayerWorld(id, name, ownerUuid, ownerName, worldType, seed, createdAt, isEnabled, invitedPlayers, playerRoles, spawnLocation, defaultGameMode, timeLock, weatherLock, isPublic, publicJoinRole, worldBorder);
        }

        public static /* synthetic */ PlayerWorld createWithLogging$default(Companion companion, JavaPlugin javaPlugin, UUID uUID, String string, UUID uUID2, String string2, WorldType worldType, Long l, long l2, boolean bl, Set set, Map map, SimpleLocation simpleLocation, GameMode gameMode, TimeLock timeLock, WeatherLock weatherLock, boolean bl2, WorldRole worldRole, WorldBorderSettings worldBorderSettings, int n, Object object) {
            if ((n & 0x100) != 0) {
                bl = true;
            }
            if ((n & 0x200) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 0x400) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 0x800) != 0) {
                simpleLocation = null;
            }
            if ((n & 0x1000) != 0) {
                gameMode = GameMode.SURVIVAL;
            }
            if ((n & 0x2000) != 0) {
                timeLock = TimeLock.CYCLE;
            }
            if ((n & 0x4000) != 0) {
                weatherLock = WeatherLock.CYCLE;
            }
            if ((n & 0x8000) != 0) {
                bl2 = false;
            }
            if ((n & 0x10000) != 0) {
                worldRole = WorldRole.VISITOR;
            }
            if ((n & 0x20000) != 0) {
                worldBorderSettings = WorldBorderSettings.Companion.default();
            }
            return companion.createWithLogging(javaPlugin, uUID, string, uUID2, string2, worldType, l, l2, bl, set, map, simpleLocation, gameMode, timeLock, weatherLock, bl2, worldRole, worldBorderSettings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorldRole.values().length];
            try {
                nArray[WorldRole.OWNER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

