/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.models;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.models.ChatMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\t\u0010\u0018\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Ltech/bedson/playerworldmanager/models/ChatSettings;", "", "playerUuid", "Ljava/util/UUID;", "chatMode", "Ltech/bedson/playerworldmanager/models/ChatMode;", "(Ljava/util/UUID;Ltech/bedson/playerworldmanager/models/ChatMode;)V", "getChatMode", "()Ltech/bedson/playerworldmanager/models/ChatMode;", "setChatMode", "(Ltech/bedson/playerworldmanager/models/ChatMode;)V", "getPlayerUuid", "()Ljava/util/UUID;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toCompactDebugString", "", "toDebugString", "toString", "PlayerWorldManager"})
public final class ChatSettings {
    @NotNull
    private final UUID playerUuid;
    @NotNull
    private ChatMode chatMode;

    public ChatSettings(@NotNull UUID playerUuid, @NotNull ChatMode chatMode) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter((Object)chatMode, "chatMode");
        this.playerUuid = playerUuid;
        this.chatMode = chatMode;
    }

    public /* synthetic */ ChatSettings(UUID uUID, ChatMode chatMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chatMode = ChatMode.GLOBAL;
        }
        this(uUID, chatMode);
    }

    @NotNull
    public final UUID getPlayerUuid() {
        return this.playerUuid;
    }

    @NotNull
    public final ChatMode getChatMode() {
        return this.chatMode;
    }

    public final void setChatMode(@NotNull ChatMode chatMode) {
        Intrinsics.checkNotNullParameter((Object)chatMode, "<set-?>");
        this.chatMode = chatMode;
    }

    @NotNull
    public final String toDebugString() {
        return "ChatSettings(player=" + this.playerUuid + ", mode=" + this.chatMode + ")";
    }

    @NotNull
    public final String toCompactDebugString() {
        return "ChatSettings[" + this.chatMode + "]";
    }

    @NotNull
    public final UUID component1() {
        return this.playerUuid;
    }

    @NotNull
    public final ChatMode component2() {
        return this.chatMode;
    }

    @NotNull
    public final ChatSettings copy(@NotNull UUID playerUuid, @NotNull ChatMode chatMode) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter((Object)chatMode, "chatMode");
        return new ChatSettings(playerUuid, chatMode);
    }

    public static /* synthetic */ ChatSettings copy$default(ChatSettings chatSettings, UUID uUID, ChatMode chatMode, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = chatSettings.playerUuid;
        }
        if ((n & 2) != 0) {
            chatMode = chatSettings.chatMode;
        }
        return chatSettings.copy(uUID, chatMode);
    }

    @NotNull
    public String toString() {
        return "ChatSettings(playerUuid=" + this.playerUuid + ", chatMode=" + this.chatMode + ")";
    }

    public int hashCode() {
        int result = this.playerUuid.hashCode();
        result = result * 31 + this.chatMode.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatSettings)) {
            return false;
        }
        ChatSettings chatSettings = (ChatSettings)other;
        if (!Intrinsics.areEqual(this.playerUuid, chatSettings.playerUuid)) {
            return false;
        }
        return this.chatMode == chatSettings.chatMode;
    }
}

