/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntries;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntriesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010%\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010&\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010!J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010)\u001a\u00020\u0018J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ltech/bedson/playerworldmanager/managers/WorldUnloadManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "autoUnloadEnabled", "", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "emptyWorldTimestamps", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "logger", "Ljava/util/logging/Logger;", "scheduledUnloads", "Lio/papermc/paper/threadedregions/scheduler/ScheduledTask;", "unloadDelayMinutes", "unloadedWorlds", "cancelScheduledUnload", "", "worldId", "checkAllWorldsForUnload", "checkAndUnloadWorld", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "countPlayersInWorld", "", "excludePlayer", "Lorg/bukkit/entity/Player;", "initialize", "isWorldUnloaded", "markWorldLoaded", "onPlayerEnterWorld", "onPlayerLeaveWorld", "leavingPlayer", "scheduleUnload", "shutdown", "unloadWorld", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nWorldUnloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldUnloadManager.kt\ntech/bedson/playerworldmanager/managers/WorldUnloadManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1855#2,2:384\n1774#2,4:386\n*S KotlinDebug\n*F\n+ 1 WorldUnloadManager.kt\ntech/bedson/playerworldmanager/managers/WorldUnloadManager\n*L\n70#1:384,2\n183#1:386,4\n*E\n"})
public final class WorldUnloadManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final ConcurrentHashMap<UUID, Long> emptyWorldTimestamps;
    @NotNull
    private final ConcurrentHashMap<UUID, ScheduledTask> scheduledUnloads;
    @NotNull
    private final ConcurrentHashMap<UUID, Boolean> unloadedWorlds;
    private long unloadDelayMinutes;
    private boolean autoUnloadEnabled;

    public WorldUnloadManager(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.dataManager = dataManager;
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
        this.debugLogger = new DebugLogger(this.plugin, "WorldUnloadManager");
        this.emptyWorldTimestamps = new ConcurrentHashMap();
        this.scheduledUnloads = new ConcurrentHashMap();
        this.unloadedWorlds = new ConcurrentHashMap();
        this.unloadDelayMinutes = 5L;
        this.autoUnloadEnabled = true;
    }

    public final void initialize() {
        this.debugLogger.debugMethodEntry("initialize", new Pair[0]);
        this.unloadDelayMinutes = this.plugin.getConfig().getLong("worlds.auto-unload.delay-minutes", 5L);
        boolean bl = this.autoUnloadEnabled = this.unloadDelayMinutes >= 0L;
        if (!this.autoUnloadEnabled) {
            this.logger.info("[WorldUnloadManager] Auto-unload is disabled (delay-minutes = " + this.unloadDelayMinutes + ")");
            Pair[] pairArray = new Pair[]{TuplesKt.to("delayMinutes", this.unloadDelayMinutes)};
            this.debugLogger.debug("Auto-unload disabled", pairArray);
        } else {
            this.logger.info("[WorldUnloadManager] Auto-unload enabled with " + this.unloadDelayMinutes + " minute delay");
            Pair[] pairArray = new Pair[]{TuplesKt.to("delayMinutes", this.unloadDelayMinutes)};
            this.debugLogger.debug("Auto-unload enabled", pairArray);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "initialize", null, 2, null);
    }

    public final void shutdown() {
        this.debugLogger.debugMethodEntry("shutdown", new Pair[0]);
        Collection<ScheduledTask> collection = this.scheduledUnloads.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScheduledTask task = (ScheduledTask)element$iv;
            boolean bl = false;
            task.cancel();
        }
        this.scheduledUnloads.clear();
        this.emptyWorldTimestamps.clear();
        this.logger.info("[WorldUnloadManager] Shutdown complete");
        DebugLogger.debugMethodExit$default(this.debugLogger, "shutdown", null, 2, null);
    }

    public final void onPlayerLeaveWorld(@NotNull PlayerWorld world, @Nullable Player leavingPlayer) {
        String overworldName;
        String defaultWorldName;
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to("worldName", world.getName());
        pairArray[1] = TuplesKt.to("worldId", world.getId());
        Player player = leavingPlayer;
        pairArray[2] = TuplesKt.to("leavingPlayer", player != null ? player.getName() : null);
        this.debugLogger.debugMethodEntry("onPlayerLeaveWorld", pairArray);
        if (!this.autoUnloadEnabled) {
            pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Auto-unload disabled, skipping", pairArray);
            this.debugLogger.debugMethodExit("onPlayerLeaveWorld", "disabled");
            return;
        }
        String string = this.plugin.getConfig().getString("default-world", "world");
        if (string == null) {
            string = defaultWorldName = "world";
        }
        if (Intrinsics.areEqual(overworldName = this.worldManager.getWorldName(world, World.Environment.NORMAL), defaultWorldName)) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Skipping default world", pairArray2);
            this.debugLogger.debugMethodExit("onPlayerLeaveWorld", "default world");
            return;
        }
        World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
        if (bukkitWorld == null) {
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Bukkit world not found", pairArray3);
            this.debugLogger.debugMethodExit("onPlayerLeaveWorld", "world not loaded");
            return;
        }
        int totalPlayers = this.countPlayersInWorld(world, leavingPlayer);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("totalPlayers", totalPlayers)};
        this.debugLogger.debug("Player count check", pairArray4);
        if (totalPlayers == 0) {
            this.scheduleUnload(world);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "onPlayerLeaveWorld", null, 2, null);
    }

    public static /* synthetic */ void onPlayerLeaveWorld$default(WorldUnloadManager worldUnloadManager, PlayerWorld playerWorld, Player player, int n, Object object) {
        if ((n & 2) != 0) {
            player = null;
        }
        worldUnloadManager.onPlayerLeaveWorld(playerWorld, player);
    }

    public final void onPlayerEnterWorld(@NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debugMethodEntry("onPlayerEnterWorld", pairArray);
        this.cancelScheduledUnload(world.getId());
        this.emptyWorldTimestamps.remove(world.getId());
        DebugLogger.debugMethodExit$default(this.debugLogger, "onPlayerEnterWorld", null, 2, null);
    }

    public final boolean isWorldUnloaded(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        return Intrinsics.areEqual(this.unloadedWorlds.get(worldId), true);
    }

    public final void markWorldLoaded(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debug("Marking world as loaded", pairArray);
        this.unloadedWorlds.remove(worldId);
    }

    private final int countPlayersInWorld(PlayerWorld world, Player excludePlayer) {
        int totalPlayers = 0;
        for (World.Environment env : EntriesMappings.entries$0) {
            int n;
            World bukkitWorld = this.worldManager.getBukkitWorld(world, env);
            if (bukkitWorld == null) continue;
            List list = bukkitWorld.getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            Iterable $this$count$iv = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Player player = (Player)element$iv;
                    boolean bl = false;
                    if (!(excludePlayer == null || !Intrinsics.areEqual(player.getUniqueId(), excludePlayer.getUniqueId())) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int playerCount = n;
            totalPlayers += playerCount;
        }
        return totalPlayers;
    }

    static /* synthetic */ int countPlayersInWorld$default(WorldUnloadManager worldUnloadManager, PlayerWorld playerWorld, Player player, int n, Object object) {
        if ((n & 2) != 0) {
            player = null;
        }
        return worldUnloadManager.countPlayersInWorld(playerWorld, player);
    }

    private final void scheduleUnload(PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("delayMinutes", this.unloadDelayMinutes)};
        this.debugLogger.debugMethodEntry("scheduleUnload", pairArray);
        if (this.scheduledUnloads.containsKey(world.getId())) {
            pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Unload already scheduled", pairArray);
            this.debugLogger.debugMethodExit("scheduleUnload", "already scheduled");
            return;
        }
        ((Map)this.emptyWorldTimestamps).put(world.getId(), System.currentTimeMillis());
        ScheduledTask scheduledTask = Bukkit.getAsyncScheduler().runDelayed((Plugin)this.plugin, arg_0 -> WorldUnloadManager.scheduleUnload$lambda$3(this, world, arg_0), this.unloadDelayMinutes, TimeUnit.MINUTES);
        Intrinsics.checkNotNullExpressionValue(scheduledTask, "runDelayed(...)");
        ScheduledTask task = scheduledTask;
        ((Map)this.scheduledUnloads).put(world.getId(), task);
        this.logger.info("[WorldUnloadManager] Scheduled unload for world '" + world.getName() + "' in " + this.unloadDelayMinutes + " minutes");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("delayMinutes", this.unloadDelayMinutes)};
        this.debugLogger.debug("Unload scheduled", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "scheduleUnload", null, 2, null);
    }

    private final void cancelScheduledUnload(UUID worldId) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("cancelScheduledUnload", pairArray);
        ScheduledTask task = this.scheduledUnloads.remove(worldId);
        if (task != null) {
            task.cancel();
            this.logger.info("[WorldUnloadManager] Cancelled scheduled unload for world ID: " + worldId);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldId", worldId)};
            this.debugLogger.debug("Cancelled scheduled unload", pairArray2);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "cancelScheduledUnload", null, 2, null);
    }

    private final void checkAndUnloadWorld(PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debugMethodEntry("checkAndUnloadWorld", pairArray);
        this.scheduledUnloads.remove(world.getId());
        PlayerWorld currentWorld = this.dataManager.loadWorld(world.getId());
        if (currentWorld == null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("World no longer exists in data", pairArray2);
            this.debugLogger.debugMethodExit("checkAndUnloadWorld", "world deleted");
            return;
        }
        int totalPlayers = WorldUnloadManager.countPlayersInWorld$default(this, currentWorld, null, 2, null);
        if (totalPlayers > 0) {
            this.logger.info("[WorldUnloadManager] World '" + world.getName() + "' is no longer empty, skipping unload");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("playerCount", totalPlayers)};
            this.debugLogger.debug("World no longer empty", pairArray3);
            this.emptyWorldTimestamps.remove(world.getId());
            this.debugLogger.debugMethodExit("checkAndUnloadWorld", "not empty");
            return;
        }
        this.unloadWorld(currentWorld);
        DebugLogger.debugMethodExit$default(this.debugLogger, "checkAndUnloadWorld", null, 2, null);
    }

    private final void unloadWorld(PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debugMethodEntry("unloadWorld", pairArray);
        this.logger.info("[WorldUnloadManager] Unloading empty world '" + world.getName() + "'");
        int unloadedCount = 0;
        for (World.Environment env : EntriesMappings.entries$0) {
            Pair[] pairArray2;
            String worldName = this.worldManager.getWorldName(world, env);
            World bukkitWorld = Bukkit.getWorld((String)worldName);
            if (bukkitWorld == null) continue;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", worldName), TuplesKt.to("environment", env)};
            this.debugLogger.debug("Unloading dimension", pairArray3);
            boolean success = Bukkit.unloadWorld((World)bukkitWorld, (boolean)true);
            if (success) {
                ++unloadedCount;
                pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName)};
                this.debugLogger.debug("Dimension unloaded successfully", pairArray2);
                continue;
            }
            this.logger.warning("[WorldUnloadManager] Failed to unload dimension: " + worldName);
            pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName)};
            this.debugLogger.debug("Dimension unload failed", pairArray2);
        }
        if (unloadedCount > 0) {
            ((Map)this.unloadedWorlds).put(world.getId(), true);
            this.emptyWorldTimestamps.remove(world.getId());
            this.logger.info("[WorldUnloadManager] Successfully unloaded world '" + world.getName() + "' (" + unloadedCount + " dimensions)");
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("dimensionsUnloaded", unloadedCount)};
            this.debugLogger.debug("World unloaded successfully", pairArray4);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "unloadWorld", null, 2, null);
    }

    public final void checkAllWorldsForUnload() {
        this.debugLogger.debugMethodEntry("checkAllWorldsForUnload", new Pair[0]);
        if (!this.autoUnloadEnabled) {
            this.debugLogger.debug("Auto-unload disabled, skipping check");
            this.debugLogger.debugMethodExit("checkAllWorldsForUnload", "disabled");
            return;
        }
        String string = this.plugin.getConfig().getString("default-world", "world");
        if (string == null) {
            string = "world";
        }
        String defaultWorldName = string;
        List<PlayerWorld> allWorlds = this.dataManager.getAllWorlds();
        for (PlayerWorld world : allWorlds) {
            int totalPlayers;
            World bukkitWorld;
            String overworldName;
            if (this.scheduledUnloads.containsKey(world.getId()) || Intrinsics.areEqual(this.unloadedWorlds.get(world.getId()), true) || Intrinsics.areEqual(overworldName = this.worldManager.getWorldName(world, World.Environment.NORMAL), defaultWorldName) || (bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null)) == null || (totalPlayers = WorldUnloadManager.countPlayersInWorld$default(this, world, null, 2, null)) != 0) continue;
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Found empty world", pairArray);
            this.scheduleUnload(world);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "checkAllWorldsForUnload", null, 2, null);
    }

    private static final void scheduleUnload$lambda$3$lambda$2(WorldUnloadManager this$0, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        this$0.checkAndUnloadWorld($world);
    }

    private static final void scheduleUnload$lambda$3(WorldUnloadManager this$0, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        Bukkit.getGlobalRegionScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldUnloadManager.scheduleUnload$lambda$3$lambda$2(this$0, $world, arg_0));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<World.Environment> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])World.Environment.values()));
        }
    }
}

