/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.ArraysKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.ranges.RangesKt;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.models.LocationData;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorldState;
import tech.bedson.playerworldmanager.models.SerializedPotionEffect;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010J\u001f\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0010J\u0016\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0010J\u0016\u0010'\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010J\u001a\u0010(\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010)\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010*\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010J!\u0010+\u001a\u0004\u0018\u00010\u00102\u0010\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010-J\u0014\u0010.\u001a\u0004\u0018\u00010\u00102\b\u0010/\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u00100\u001a\u0004\u0018\u00010\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Ltech/bedson/playerworldmanager/managers/WorldStateManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "gson", "Lcom/google/gson/Gson;", "logger", "Ljava/util/logging/Logger;", "clearAllWorldStates", "", "baseWorldName", "", "clearPlayerState", "player", "Lorg/bukkit/entity/Player;", "clearPotionEffects", "clearWorldStatesForWorld", "worldName", "deserializeArmor", "", "Lorg/bukkit/inventory/ItemStack;", "base64", "(Ljava/lang/String;)[Lorg/bukkit/inventory/ItemStack;", "deserializeInventory", "expectedSize", "", "(Ljava/lang/String;I)[Lorg/bukkit/inventory/ItemStack;", "deserializeItem", "getSavedLocation", "Ltech/bedson/playerworldmanager/models/LocationData;", "playerUuid", "Ljava/util/UUID;", "hasStateForWorld", "", "restorePlayerState", "restorePotionEffects", "json", "savePlayerState", "serializeInventory", "items", "([Lorg/bukkit/inventory/ItemStack;)Ljava/lang/String;", "serializeItem", "item", "serializePotionEffects", "effects", "", "Lorg/bukkit/potion/PotionEffect;", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nWorldStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldStateManager.kt\ntech/bedson/playerworldmanager/managers/WorldStateManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,509:1\n12271#2,2:510\n766#3:512\n857#3,2:513\n1549#3:515\n1620#3,3:516\n1855#3,2:519\n1855#3,2:521\n*S KotlinDebug\n*F\n+ 1 WorldStateManager.kt\ntech/bedson/playerworldmanager/managers/WorldStateManager\n*L\n339#1:510,2\n345#1:512\n345#1:513,2\n452#1:515\n452#1:516,3\n478#1:519,2\n504#1:521,2\n*E\n"})
public final class WorldStateManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final Gson gson;

    public WorldStateManager(@NotNull JavaPlugin plugin, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.dataManager = dataManager;
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
        this.debugLogger = new DebugLogger(this.plugin, "WorldStateManager");
        this.gson = new Gson();
    }

    public final void savePlayerState(@NotNull Player player, @NotNull String worldName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debugMethodEntry("savePlayerState", pairArray);
        this.logger.info("[WorldStateManager] Saving state for '" + player.getName() + "' in world '" + worldName + "'");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        PlayerData playerData = this.dataManager.getOrCreatePlayerData(uUID, string);
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("existingWorldStatesCount", playerData.getWorldStates().size())};
        this.debugLogger.debug("Retrieved player data", pairArray2);
        pairArray2 = new Pair[]{TuplesKt.to("health", player.getHealth()), TuplesKt.to("foodLevel", player.getFoodLevel()), TuplesKt.to("level", player.getLevel()), TuplesKt.to("activePotionEffects", player.getActivePotionEffects().size())};
        this.debugLogger.debug("Serializing player state", pairArray2);
        String string2 = this.serializeInventory(player.getInventory().getContents());
        String string3 = this.serializeInventory(player.getInventory().getArmorContents());
        String string4 = this.serializeItem(player.getInventory().getItemInOffHand());
        String string5 = this.serializeInventory(player.getEnderChest().getContents());
        double d = player.getHealth();
        AttributeInstance attributeInstance = player.getAttribute(Attribute.MAX_HEALTH);
        double d2 = attributeInstance != null ? attributeInstance.getValue() : 20.0;
        int n = player.getFoodLevel();
        float f = player.getSaturation();
        float f2 = player.getExhaustion();
        int n2 = player.getLevel();
        float f3 = player.getExp();
        Collection collection = player.getActivePotionEffects();
        Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
        PlayerWorldState state = new PlayerWorldState(worldName, string2, string3, string4, string5, d, d2, n, f, f2, n2, f3, this.serializePotionEffects(collection), new LocationData(worldName, location2.getX(), location2.getY(), location2.getZ(), location2.getYaw(), location2.getPitch()));
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", state.getWorldName()), TuplesKt.to("health", state.getHealth()), TuplesKt.to("foodLevel", state.getFoodLevel()), TuplesKt.to("expLevel", state.getExpLevel()), TuplesKt.to("hasInventory", state.getInventoryContents() != null), TuplesKt.to("hasArmor", state.getArmorContents() != null), TuplesKt.to("hasPotionEffects", state.getPotionEffects() != null)};
        this.debugLogger.debugState("playerWorldState", pairArray3);
        playerData.getWorldStates().put(worldName, state);
        this.dataManager.savePlayerData(playerData);
        pairArray3 = new Pair[]{TuplesKt.to("totalWorldStates", playerData.getWorldStates().size())};
        this.debugLogger.debug("Saved player data", pairArray3);
        this.logger.info("[WorldStateManager] Saved state for '" + player.getName() + "' in '" + worldName + "': health=" + state.getHealth() + ", food=" + state.getFoodLevel() + ", level=" + state.getExpLevel() + ", inventory=" + (state.getInventoryContents() != null ? "saved" : "empty"));
        this.debugLogger.debugMethodExit("savePlayerState", "success");
    }

    public final boolean restorePlayerState(@NotNull Player player, @NotNull String worldName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debugMethodEntry("restorePlayerState", pairArray);
        this.logger.info("[WorldStateManager] Restoring state for '" + player.getName() + "' from world '" + worldName + "'");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        PlayerData playerData = this.dataManager.loadPlayerData(uUID);
        Object object = playerData;
        PlayerWorldState state = object != null && (object = ((PlayerData)object).getWorldStates()) != null ? (PlayerWorldState)object.get(worldName) : null;
        Pair[] pairArray2 = new Pair[3];
        pairArray2[0] = TuplesKt.to("playerDataFound", playerData != null);
        pairArray2[1] = TuplesKt.to("stateFound", state != null);
        Object object2 = playerData;
        if (object2 == null || (object2 = ((PlayerData)object2).getWorldStates()) == null || (object2 = object2.keySet()) == null || (object2 = CollectionsKt.toList((Iterable)object2)) == null) {
            object2 = CollectionsKt.emptyList();
        }
        pairArray2[2] = TuplesKt.to("availableWorldStates", object2);
        this.debugLogger.debug("Loaded player data", pairArray2);
        if (state == null) {
            this.logger.info("[WorldStateManager] No saved state for '" + player.getName() + "' in '" + worldName + "'");
            this.debugLogger.debugMethodExit("restorePlayerState", false);
            return false;
        }
        pairArray2 = new Pair[]{TuplesKt.to("health", state.getHealth()), TuplesKt.to("foodLevel", state.getFoodLevel()), TuplesKt.to("expLevel", state.getExpLevel()), TuplesKt.to("hasInventory", state.getInventoryContents() != null), TuplesKt.to("hasPotionEffects", state.getPotionEffects() != null)};
        this.debugLogger.debug("Restoring state", pairArray2);
        this.debugLogger.debug("Clearing current potion effects");
        this.clearPotionEffects(player);
        this.debugLogger.debug("Restoring inventory");
        player.getInventory().setContents(this.deserializeInventory(state.getInventoryContents(), 36));
        player.getInventory().setArmorContents(this.deserializeArmor(state.getArmorContents()));
        player.getInventory().setItemInOffHand(this.deserializeItem(state.getOffHandItem()));
        player.getEnderChest().setContents(this.deserializeInventory(state.getEnderChestContents(), 27));
        pairArray2 = new Pair[]{TuplesKt.to("maxHealth", state.getMaxHealth()), TuplesKt.to("health", state.getHealth())};
        this.debugLogger.debug("Restoring health", pairArray2);
        AttributeInstance attributeInstance = player.getAttribute(Attribute.MAX_HEALTH);
        if (attributeInstance != null) {
            attributeInstance.setBaseValue(state.getMaxHealth());
        }
        player.setHealth(RangesKt.coerceIn(state.getHealth(), 0.0, state.getMaxHealth()));
        pairArray2 = new Pair[]{TuplesKt.to("foodLevel", state.getFoodLevel()), TuplesKt.to("saturation", Float.valueOf(state.getSaturation()))};
        this.debugLogger.debug("Restoring hunger", pairArray2);
        player.setFoodLevel(state.getFoodLevel());
        player.setSaturation(state.getSaturation());
        player.setExhaustion(state.getExhaustion());
        pairArray2 = new Pair[]{TuplesKt.to("level", state.getExpLevel()), TuplesKt.to("progress", Float.valueOf(state.getExpProgress()))};
        this.debugLogger.debug("Restoring experience", pairArray2);
        player.setLevel(state.getExpLevel());
        player.setExp(RangesKt.coerceIn(state.getExpProgress(), 0.0f, 1.0f));
        this.debugLogger.debug("Restoring potion effects");
        this.restorePotionEffects(player, state.getPotionEffects());
        this.logger.info("[WorldStateManager] Restored state for '" + player.getName() + "' from '" + worldName + "': health=" + state.getHealth() + ", food=" + state.getFoodLevel() + ", level=" + state.getExpLevel());
        this.debugLogger.debugMethodExit("restorePlayerState", true);
        return true;
    }

    public final void clearPlayerState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("clearPlayerState", pairArray);
        this.logger.info("[WorldStateManager] Clearing state for '" + player.getName() + "' (fresh start)");
        pairArray = new Pair[]{TuplesKt.to("health", player.getHealth()), TuplesKt.to("foodLevel", player.getFoodLevel()), TuplesKt.to("level", player.getLevel()), TuplesKt.to("activePotionEffects", player.getActivePotionEffects().size())};
        this.debugLogger.debug("Current player state before clear", pairArray);
        this.debugLogger.debug("Clearing potion effects");
        this.clearPotionEffects(player);
        this.debugLogger.debug("Clearing inventory");
        player.getInventory().clear();
        player.getInventory().setArmorContents(new ItemStack[4]);
        player.getInventory().setItemInOffHand(null);
        player.getEnderChest().clear();
        this.debugLogger.debug("Resetting health to full");
        AttributeInstance attributeInstance = player.getAttribute(Attribute.MAX_HEALTH);
        if (attributeInstance != null) {
            attributeInstance.setBaseValue(20.0);
        }
        player.setHealth(20.0);
        this.debugLogger.debug("Resetting hunger to full");
        player.setFoodLevel(20);
        player.setSaturation(5.0f);
        player.setExhaustion(0.0f);
        this.debugLogger.debug("Resetting experience");
        player.setLevel(0);
        player.setExp(0.0f);
        this.debugLogger.debug("Resetting gamemode to SURVIVAL");
        player.setGameMode(GameMode.SURVIVAL);
        player.updateInventory();
        this.logger.info("[WorldStateManager] Cleared state for '" + player.getName() + "' - fresh start applied");
        this.debugLogger.debugMethodExit("clearPlayerState", "success");
    }

    public final boolean hasStateForWorld(@NotNull UUID playerUuid, @NotNull String worldName) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debugMethodEntry("hasStateForWorld", pairArray);
        PlayerData playerData = this.dataManager.loadPlayerData(playerUuid);
        Object object = playerData;
        boolean hasState = object != null && (object = ((PlayerData)object).getWorldStates()) != null ? object.containsKey(worldName) : false;
        Pair[] pairArray2 = new Pair[3];
        pairArray2[0] = TuplesKt.to("playerDataFound", playerData != null);
        pairArray2[1] = TuplesKt.to("hasState", hasState);
        Object object2 = playerData;
        if (object2 == null || (object2 = ((PlayerData)object2).getWorldStates()) == null || (object2 = object2.keySet()) == null || (object2 = CollectionsKt.toList((Iterable)object2)) == null) {
            object2 = CollectionsKt.emptyList();
        }
        pairArray2[2] = TuplesKt.to("availableStates", object2);
        this.debugLogger.debug("State check result", pairArray2);
        this.debugLogger.debugMethodExit("hasStateForWorld", hasState);
        return hasState;
    }

    @Nullable
    public final LocationData getSavedLocation(@NotNull UUID playerUuid, @NotNull String worldName) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debugMethodEntry("getSavedLocation", pairArray);
        PlayerData playerData = this.dataManager.loadPlayerData(playerUuid);
        Object object = playerData;
        LocationData location = object != null && (object = ((PlayerData)object).getWorldStates()) != null && (object = (PlayerWorldState)object.get(worldName)) != null ? ((PlayerWorldState)object).getLocation() : null;
        Pair[] pairArray2 = new Pair[4];
        pairArray2[0] = TuplesKt.to("found", location != null);
        LocationData locationData = location;
        pairArray2[1] = TuplesKt.to("x", locationData != null ? Double.valueOf(locationData.getX()) : null);
        LocationData locationData2 = location;
        pairArray2[2] = TuplesKt.to("y", locationData2 != null ? Double.valueOf(locationData2.getY()) : null);
        LocationData locationData3 = location;
        pairArray2[3] = TuplesKt.to("z", locationData3 != null ? Double.valueOf(locationData3.getZ()) : null);
        this.debugLogger.debug("Location lookup result", pairArray2);
        this.debugLogger.debugMethodExit("getSavedLocation", location != null);
        return location;
    }

    public final void clearWorldStatesForWorld(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", worldName)};
        this.debugLogger.debugMethodEntry("clearWorldStatesForWorld", pairArray);
        this.logger.info("[WorldStateManager] Clearing all player states for world '" + worldName + "'");
        int clearedCount = 0;
        List<PlayerData> allPlayerData = this.dataManager.getAllPlayerData();
        for (PlayerData playerData : allPlayerData) {
            if (!playerData.getWorldStates().containsKey(worldName)) continue;
            playerData.getWorldStates().remove(worldName);
            this.dataManager.savePlayerData(playerData);
            ++clearedCount;
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", playerData.getUsername()), TuplesKt.to("worldName", worldName)};
            this.debugLogger.debug("Cleared world state", pairArray2);
        }
        this.logger.info("[WorldStateManager] Cleared " + clearedCount + " player state(s) for world '" + worldName + "'");
        this.debugLogger.debugMethodExit("clearWorldStatesForWorld", TuplesKt.to("clearedCount", clearedCount));
    }

    public final void clearAllWorldStates(@NotNull String baseWorldName) {
        Intrinsics.checkNotNullParameter(baseWorldName, "baseWorldName");
        Pair[] pairArray = new Pair[]{TuplesKt.to("baseWorldName", baseWorldName)};
        this.debugLogger.debugMethodEntry("clearAllWorldStates", pairArray);
        this.clearWorldStatesForWorld(baseWorldName);
        this.clearWorldStatesForWorld(baseWorldName + "_nether");
        this.clearWorldStatesForWorld(baseWorldName + "_the_end");
        DebugLogger.debugMethodExit$default(this.debugLogger, "clearAllWorldStates", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String serializeInventory(ItemStack[] items) {
        String string;
        block10: {
            block9: {
                boolean bl;
                block8: {
                    if (items == null) break block9;
                    ItemStack[] $this$all$iv = items;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ItemStack element$iv;
                        ItemStack it = element$iv = $this$all$iv[i];
                        boolean bl2 = false;
                        if (it == null || it.getType().isAir()) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
                if (!bl) break block10;
            }
            return null;
        }
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ArraysKt.filterNotNull(items);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!(!it.getType().isAir())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonNullItems = (List)destination$iv$iv;
            if (nonNullItems.isEmpty()) {
                return null;
            }
            byte[] bytes = ItemStack.serializeItemsAsBytes((ItemStack[])items);
            string = Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            this.logger.warning("[WorldStateManager] Failed to serialize inventory: " + e.getMessage());
            string = null;
        }
        return string;
    }

    private final ItemStack[] deserializeInventory(String base64, int expectedSize) {
        ItemStack[] itemStackArray;
        if (base64 == null) {
            return new ItemStack[expectedSize];
        }
        try {
            ItemStack[] itemStackArray2;
            byte[] bytes = Base64.getDecoder().decode(base64);
            ItemStack[] items = ItemStack.deserializeItemsFromBytes((byte[])bytes);
            if (items.length == expectedSize) {
                itemStackArray2 = items;
            } else if (items.length > expectedSize) {
                ItemStack[] itemStackArray3 = items;
                int n = 0;
                itemStackArray2 = ArraysKt.copyOfRange(itemStackArray3, n, expectedSize);
            } else {
                int n = 0;
                ItemStack[] itemStackArray4 = new ItemStack[expectedSize];
                while (n < expectedSize) {
                    int n2 = n++;
                    itemStackArray4[n2] = ArraysKt.getOrNull(items, n2);
                }
                itemStackArray2 = itemStackArray4;
            }
            itemStackArray = itemStackArray2;
        }
        catch (Exception e) {
            this.logger.warning("[WorldStateManager] Failed to deserialize inventory: " + e.getMessage());
            itemStackArray = new ItemStack[expectedSize];
        }
        return itemStackArray;
    }

    static /* synthetic */ ItemStack[] deserializeInventory$default(WorldStateManager worldStateManager, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 36;
        }
        return worldStateManager.deserializeInventory(string, n);
    }

    private final ItemStack[] deserializeArmor(String base64) {
        ItemStack[] itemStackArray;
        if (base64 == null) {
            return new ItemStack[4];
        }
        try {
            ItemStack[] itemStackArray2;
            byte[] bytes = Base64.getDecoder().decode(base64);
            ItemStack[] items = ItemStack.deserializeItemsFromBytes((byte[])bytes);
            if (items.length == 4) {
                itemStackArray2 = items;
            } else if (items.length > 4) {
                ItemStack[] itemStackArray3 = items;
                int n = 0;
                var6_9 = 4;
                itemStackArray2 = ArraysKt.copyOfRange(itemStackArray3, n, var6_9);
            } else {
                int n = 0;
                ItemStack[] itemStackArray4 = new ItemStack[4];
                while (n < 4) {
                    var6_9 = n++;
                    itemStackArray4[var6_9] = ArraysKt.getOrNull(items, var6_9);
                }
                itemStackArray2 = itemStackArray4;
            }
            itemStackArray = itemStackArray2;
        }
        catch (Exception e) {
            this.logger.warning("[WorldStateManager] Failed to deserialize armor: " + e.getMessage());
            itemStackArray = new ItemStack[4];
        }
        return itemStackArray;
    }

    private final String serializeItem(ItemStack item2) {
        String string;
        if (item2 == null || item2.getType().isAir()) {
            return null;
        }
        try {
            byte[] bytes = item2.serializeAsBytes();
            string = Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            this.logger.warning("[WorldStateManager] Failed to serialize item: " + e.getMessage());
            string = null;
        }
        return string;
    }

    private final ItemStack deserializeItem(String base64) {
        ItemStack itemStack;
        if (base64 == null) {
            return null;
        }
        try {
            byte[] bytes = Base64.getDecoder().decode(base64);
            itemStack = ItemStack.deserializeBytes((byte[])bytes);
        }
        catch (Exception e) {
            this.logger.warning("[WorldStateManager] Failed to deserialize item: " + e.getMessage());
            itemStack = null;
        }
        return itemStack;
    }

    /*
     * WARNING - void declaration
     */
    private final String serializePotionEffects(Collection<? extends PotionEffect> effects) {
        void $this$mapTo$iv$iv;
        if (effects.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = effects;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void effect;
            PotionEffect potionEffect = (PotionEffect)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = effect.getType().getKey().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            collection.add(new SerializedPotionEffect(string, effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon()));
        }
        List serialized = (List)destination$iv$iv;
        return this.gson.toJson(serialized);
    }

    private final void restorePotionEffects(Player player, String json) {
        if (json == null) {
            return;
        }
        try {
            Type type2 = new TypeToken<List<? extends SerializedPotionEffect>>(){}.getType();
            Object t = this.gson.fromJson(json, type2);
            Intrinsics.checkNotNullExpressionValue(t, "fromJson(...)");
            List effects = (List)t;
            Iterable $this$forEach$iv = effects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SerializedPotionEffect serialized = (SerializedPotionEffect)element$iv;
                boolean bl = false;
                PotionEffectType effectType = PotionEffectType.getByKey((NamespacedKey)NamespacedKey.fromString((String)serialized.getType()));
                if (effectType == null) continue;
                PotionEffect effect = new PotionEffect(effectType, serialized.getDuration(), serialized.getAmplifier(), serialized.getAmbient(), serialized.getParticles(), serialized.getIcon());
                player.addPotionEffect(effect);
            }
        }
        catch (Exception e) {
            this.logger.warning("[WorldStateManager] Failed to restore potion effects: " + e.getMessage());
        }
    }

    private final void clearPotionEffects(Player player) {
        Collection collection = player.getActivePotionEffects();
        Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PotionEffect effect = (PotionEffect)element$iv;
            boolean bl = false;
            player.removePotionEffect(effect.getType());
        }
    }
}

