/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.wanderingtrader.WanderingTraderSpawner;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.entity.Player;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.NoWhenBranchMatchedException;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.ResultKt;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntries;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntriesKt;
import tech.bedson.playerworldmanager.libs.kotlin.io.FilesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.Regex;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.managers.WorldStateManager;
import tech.bedson.playerworldmanager.managers.WorldUnloadManager;
import tech.bedson.playerworldmanager.models.LocationData;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.SimpleLocation;
import tech.bedson.playerworldmanager.models.SimpleLocationKt;
import tech.bedson.playerworldmanager.models.TimeLock;
import tech.bedson.playerworldmanager.models.WeatherLock;
import tech.bedson.playerworldmanager.models.WorldBorderSettings;
import tech.bedson.playerworldmanager.models.WorldType;
import tech.bedson.playerworldmanager.utils.DebugLogger;
import tech.bedson.playerworldmanager.utils.VoidGenerator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 W2\u00020\u0001:\u0001WB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0002J\u001a\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001b2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001bJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J1\u0010)\u001a\u0004\u0018\u00010#2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002\u00a2\u0006\u0002\u00101J1\u00102\u001a\u0004\u0018\u00010#2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002\u00a2\u0006\u0002\u00101J;\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b05042\u0006\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u0016H\u0002J\u001a\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d05042\u0006\u0010!\u001a\u00020\u001bJ\u001a\u0010<\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\u001b2\b\b\u0002\u0010+\u001a\u00020,J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fJ\u0010\u0010>\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#J\u000e\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020AJ\u0018\u0010B\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001b2\b\b\u0002\u0010+\u001a\u00020,J\u0006\u0010C\u001a\u00020\u001dJ\u000e\u0010D\u001a\u00020&2\u0006\u0010!\u001a\u00020#J\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020&042\u0006\u0010!\u001a\u00020\u001bJ\u0010\u0010F\u001a\u00020&2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0010\u0010G\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001bH\u0002J\b\u0010H\u001a\u00020\u001dH\u0002J\u0006\u0010I\u001a\u00020\u001dJ\u0016\u0010J\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020\u001d2\u0006\u0010N\u001a\u00020\u0018J\u0006\u0010O\u001a\u00020\u001dJ$\u0010P\u001a\b\u0012\u0004\u0012\u00020&042\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,J\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020&042\u0006\u0010'\u001a\u00020(J\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020&042\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\u001bJ\u0018\u0010S\u001a\u00020&2\u0006\u0010!\u001a\u00020#2\u0006\u0010T\u001a\u00020&H\u0002J\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020&042\u0006\u0010!\u001a\u00020\u001bJ\u0012\u0010V\u001a\u0004\u0018\u00010\u000f2\u0006\u00107\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Ltech/bedson/playerworldmanager/managers/WorldManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "worldStateManager", "Ltech/bedson/playerworldmanager/managers/WorldStateManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/managers/WorldStateManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "defaultWorldLimit", "", "deletedWorldNames", "", "", "logger", "Ljava/util/logging/Logger;", "maxNameLength", "namePattern", "Ltech/bedson/playerworldmanager/libs/kotlin/text/Regex;", "pendingDeletionsFile", "Ljava/io/File;", "worldUnloadManager", "Ltech/bedson/playerworldmanager/managers/WorldUnloadManager;", "worldsToCleanup", "", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "addPendingDeletions", "", "worldNames", "", "applyWorldBorder", "world", "bukkitWorld", "Lorg/bukkit/World;", "applyWorldSettings", "canCreateWorld", "", "player", "Lorg/bukkit/entity/Player;", "createDimension", "worldName", "environment", "Lorg/bukkit/World$Environment;", "worldType", "Ltech/bedson/playerworldmanager/models/WorldType;", "seed", "", "(Ljava/lang/String;Lorg/bukkit/World$Environment;Ltech/bedson/playerworldmanager/models/WorldType;Ljava/lang/Long;)Lorg/bukkit/World;", "createOrLoadDimension", "createWorld", "Ljava/util/concurrent/CompletableFuture;", "Ltech/bedson/playerworldmanager/libs/kotlin/Result;", "owner", "name", "(Lorg/bukkit/entity/Player;Ljava/lang/String;Ltech/bedson/playerworldmanager/models/WorldType;Ljava/lang/Long;)Ljava/util/concurrent/CompletableFuture;", "deleteDirectory", "directory", "deleteWorld", "getBukkitWorld", "getLoadedWorlds", "getPlayerWorldFromBukkitWorld", "getWorldCount", "playerUuid", "Ljava/util/UUID;", "getWorldName", "initialize", "isPluginWorld", "loadWorld", "loadWorldSync", "markWorldForCleanup", "processCleanupList", "processPendingDeletions", "setSpawnLocation", "location", "Lorg/bukkit/Location;", "setWorldUnloadManager", "manager", "shutdown", "teleportToDimension", "teleportToVanillaWorld", "teleportToWorld", "unloadDimensionNMS", "save", "unloadWorld", "validateWorldName", "Companion", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nWorldManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldManager.kt\ntech/bedson/playerworldmanager/managers/WorldManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1990:1\n1855#2,2:1991\n1549#2:1993\n1620#2,3:1994\n1549#2:1997\n1620#2,3:1998\n288#2,2:2003\n288#2,2:2005\n288#2,2:2007\n766#2:2009\n857#2,2:2010\n1549#2:2014\n1620#2,3:2015\n1855#2,2:2018\n766#2:2020\n857#2,2:2021\n1855#2,2:2023\n1549#2:2025\n1620#2,3:2026\n1549#2:2031\n1620#2,3:2032\n1549#2:2035\n1620#2,3:2036\n37#3,2:2001\n37#3,2:2029\n37#3,2:2039\n13309#4,2:2012\n*S KotlinDebug\n*F\n+ 1 WorldManager.kt\ntech/bedson/playerworldmanager/managers/WorldManager\n*L\n128#1:1991,2\n160#1:1993\n160#1:1994,3\n163#1:1997\n163#1:1998,3\n230#1:2003,2\n889#1:2005,2\n1370#1:2007,2\n1404#1:2009\n1404#1:2010,2\n1896#1:2014\n1896#1:2015,3\n1899#1:2018,2\n1942#1:2020\n1942#1:2021,2\n1954#1:2023,2\n385#1:2025\n385#1:2026,3\n765#1:2031\n765#1:2032,3\n768#1:2035\n768#1:2036,3\n170#1:2001,2\n392#1:2029,2\n771#1:2039,2\n1829#1:2012,2\n*E\n"})
public final class WorldManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final WorldStateManager worldStateManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DebugLogger debugLogger;
    @Nullable
    private WorldUnloadManager worldUnloadManager;
    @NotNull
    private final Regex namePattern;
    private final int maxNameLength;
    private final int defaultWorldLimit;
    @NotNull
    private final File pendingDeletionsFile;
    @NotNull
    private final Set<String> deletedWorldNames;
    @NotNull
    private final List<PlayerWorld> worldsToCleanup;
    @NotNull
    private static final String NETHER_SUFFIX = "_nether";
    @NotNull
    private static final String END_SUFFIX = "_the_end";

    public WorldManager(@NotNull JavaPlugin plugin, @NotNull DataManager dataManager, @NotNull WorldStateManager worldStateManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(worldStateManager, "worldStateManager");
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.worldStateManager = worldStateManager;
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
        this.debugLogger = new DebugLogger(this.plugin, "WorldManager");
        this.namePattern = new Regex("^[a-zA-Z0-9_]+$");
        this.maxNameLength = 32;
        this.defaultWorldLimit = 3;
        this.pendingDeletionsFile = new File(this.plugin.getDataFolder(), "pending-deletions.txt");
        this.deletedWorldNames = new LinkedHashSet();
        this.worldsToCleanup = new ArrayList();
    }

    public final void setWorldUnloadManager(@NotNull WorldUnloadManager manager) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        this.worldUnloadManager = manager;
    }

    public final void initialize() {
        this.debugLogger.debugMethodEntry("initialize", new Pair[0]);
        this.logger.info("Initializing WorldManager...");
        this.debugLogger.debug("Processing pending deletions from previous server runs");
        this.processPendingDeletions();
        List<PlayerWorld> worlds = this.dataManager.getAllWorlds();
        this.logger.info("Found " + worlds.size() + " worlds to load");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldCount", worlds.size())};
        this.debugLogger.debug("Retrieved worlds from DataManager", pairArray);
        int successCount = 0;
        int failCount = 0;
        Iterable $this$forEach$iv = worlds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("name", world.getName()), TuplesKt.to("id", world.getId()), TuplesKt.to("owner", world.getOwnerName())};
            this.debugLogger.debug("Loading world", pairArray2);
            boolean success = this.loadWorldSync(world);
            if (success) {
                this.logger.info("Loaded world: " + world.getName() + " (owner: " + world.getOwnerName() + ")");
                ++successCount;
                continue;
            }
            this.logger.warning("Failed to load world: " + world.getName());
            ++failCount;
        }
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("successCount", successCount), TuplesKt.to("failCount", failCount)};
        this.debugLogger.debug("World loading complete", pairArray3);
        this.debugLogger.debug("Processing cleanup list for orphaned worlds");
        this.processCleanupList();
        this.logger.info("WorldManager initialization complete");
        DebugLogger.debugMethodExit$default(this.debugLogger, "initialize", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void shutdown() {
        PlayerWorld it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.debugLogger.debugMethodEntry("shutdown", new Pair[0]);
        this.logger.info("Shutting down WorldManager...");
        List<PlayerWorld> worlds = this.getLoadedWorlds();
        this.logger.info("Unloading " + worlds.size() + " worlds...");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldCount", worlds.size())};
        this.debugLogger.debug("Preparing to unload worlds", pairArray);
        pairArray = new Pair[1];
        Object[] objectArray = (Pair[])worlds;
        String string = "loadedWorlds";
        int n = 0;
        Pair[] pairArray2 = pairArray;
        String string2 = "shutdown";
        Object object = this.debugLogger;
        boolean $i$f$map = false;
        void var5_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to(string, collection);
        ((DebugLogger)object).debugState(string2, pairArray);
        $this$map$iv = worlds;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void world;
            it = (PlayerWorld)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
            this.debugLogger.debug("Scheduling world unload", pairArray3);
            object.add(this.unloadWorld((PlayerWorld)world));
        }
        List futures = (List)destination$iv$iv;
        objectArray = new Pair[]{TuplesKt.to("futureCount", futures.size())};
        this.debugLogger.debug("Waiting for all unloads to complete", (Pair<String, ? extends Object>[])objectArray);
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf((CompletableFuture[])Arrays.copyOf(objectArray, objectArray.length)).join();
        this.logger.info("WorldManager shutdown complete");
        DebugLogger.debugMethodExit$default(this.debugLogger, "shutdown", null, 2, null);
    }

    @NotNull
    public final CompletableFuture<Result<PlayerWorld>> createWorld(@NotNull Player owner, @NotNull String name, @NotNull WorldType worldType, @Nullable Long seed) {
        Object v8;
        Pair[] $this$firstOrNull$iv;
        CompletableFuture<Result<PlayerWorld>> future;
        block5: {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter((Object)worldType, "worldType");
            Pair[] pairArray = new Pair[]{TuplesKt.to("ownerName", owner.getName()), TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("name", name), TuplesKt.to("worldType", worldType), TuplesKt.to("seed", seed)};
            this.debugLogger.debugMethodEntry("createWorld", pairArray);
            String string = owner.getName();
            Object object = seed;
            if (object == null) {
                object = "random";
            }
            this.logger.info("[WorldManager] createWorld: Player '" + string + "' attempting to create world '" + name + "' (Type: " + worldType + ", Seed: " + object + ")");
            future = new CompletableFuture<Result<PlayerWorld>>();
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("name", name)};
            this.debugLogger.debug("Validating world name", pairArray2);
            String validationError = this.validateWorldName(name);
            if (validationError != null) {
                this.logger.warning("[WorldManager] createWorld: Validation failed for world '" + name + "': " + validationError);
                Pair[] pairArray3 = new Pair[]{TuplesKt.to("name", name), TuplesKt.to("error", validationError)};
                this.debugLogger.debug("World name validation failed", pairArray3);
                this.debugLogger.debugMethodExit("createWorld", "failure: " + validationError);
                future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException(validationError)))));
                return future;
            }
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("name", name)};
            this.debugLogger.debug("World name validation passed", pairArray4);
            UUID uUID = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            int currentWorldCount = this.getWorldCount(uUID);
            UUID uUID2 = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            PlayerData playerData = this.dataManager.loadPlayerData(uUID2);
            int worldLimit = playerData != null ? playerData.getWorldLimit() : this.defaultWorldLimit;
            Pair[] pairArray5 = new Pair[]{TuplesKt.to("currentCount", currentWorldCount), TuplesKt.to("limit", worldLimit)};
            this.debugLogger.debug("Checking world limit", pairArray5);
            if (!this.canCreateWorld(owner)) {
                UUID uUID3 = owner.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
                PlayerData playerData2 = this.dataManager.loadPlayerData(uUID3);
                int limit = playerData2 != null ? playerData2.getWorldLimit() : this.defaultWorldLimit;
                this.logger.warning("[WorldManager] createWorld: Player '" + owner.getName() + "' has reached world limit (" + limit + " worlds)");
                Pair[] pairArray6 = new Pair[]{TuplesKt.to("player", owner.getName()), TuplesKt.to("currentCount", currentWorldCount), TuplesKt.to("limit", limit)};
                this.debugLogger.debug("World limit reached", pairArray6);
                this.debugLogger.debugMethodExit("createWorld", "failure: world limit reached");
                future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new IllegalStateException("You have reached your world limit (" + limit + " worlds)")))));
                return future;
            }
            Pair[] limit = new Pair[]{TuplesKt.to("currentCount", currentWorldCount), TuplesKt.to("limit", worldLimit)};
            this.debugLogger.debug("World limit check passed", limit);
            UUID uUID4 = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
            List<PlayerWorld> existingWorlds = this.dataManager.getWorldsByOwner(uUID4);
            Pair[] pairArray7 = new Pair[]{TuplesKt.to("existingWorldCount", existingWorlds.size())};
            this.debugLogger.debug("Checking for existing world with same name", pairArray7);
            $this$firstOrNull$iv = (Pair[])existingWorlds;
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                PlayerWorld it = (PlayerWorld)t;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), name, true)) continue;
                v8 = t;
                break block5;
            }
            v8 = null;
        }
        PlayerWorld existingWorld = v8;
        if (existingWorld != null) {
            this.logger.warning("[WorldManager] createWorld: Player '" + owner.getName() + "' already has a world named '" + name + "'");
            $this$firstOrNull$iv = new Pair[]{TuplesKt.to("existingWorldId", existingWorld.getId())};
            this.debugLogger.debug("Duplicate world name found", $this$firstOrNull$iv);
            this.debugLogger.debugMethodExit("createWorld", "failure: duplicate name");
            future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You already have a world named '" + name + "'")))));
            return future;
        }
        this.debugLogger.debug("No duplicate world name found");
        UUID worldId = UUID.randomUUID();
        Pair[] $i$f$firstOrNull = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debug("Creating PlayerWorld object", $i$f$firstOrNull);
        Intrinsics.checkNotNull(worldId);
        UUID uUID = owner.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        String string = owner.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        PlayerWorld playerWorld = new PlayerWorld(worldId, name, uUID, string, worldType, seed, System.currentTimeMillis(), false, null, null, null, null, null, null, false, null, null, 130944, null);
        this.logger.info("[WorldManager] createWorld: Created PlayerWorld object with ID: " + playerWorld.getId());
        Pair[] pairArray = new Pair[]{TuplesKt.to("id", playerWorld.getId()), TuplesKt.to("name", playerWorld.getName()), TuplesKt.to("ownerUuid", playerWorld.getOwnerUuid()), TuplesKt.to("worldType", playerWorld.getWorldType()), TuplesKt.to("seed", playerWorld.getSeed()), TuplesKt.to("createdAt", playerWorld.getCreatedAt())};
        this.debugLogger.debugState("playerWorld", pairArray);
        this.debugLogger.debug("Scheduling world creation on GlobalRegionScheduler");
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldManager.createWorld$lambda$4(this, playerWorld, worldType, seed, future, owner, arg_0));
        this.debugLogger.debug("Returning future for async world creation");
        return future;
    }

    public static /* synthetic */ CompletableFuture createWorld$default(WorldManager worldManager, Player player, String string, WorldType worldType, Long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = null;
        }
        return worldManager.createWorld(player, string, worldType, l);
    }

    @NotNull
    public final CompletableFuture<Result<Unit>> deleteWorld(@NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("ownerUuid", world.getOwnerUuid())};
        this.debugLogger.debugMethodEntry("deleteWorld", pairArray);
        pairArray = new Pair[]{TuplesKt.to("name", world.getName()), TuplesKt.to("id", world.getId()), TuplesKt.to("type", world.getWorldType()), TuplesKt.to("invitedPlayers", world.getInvitedPlayers().size())};
        this.debugLogger.debugState("worldToDelete", pairArray);
        this.logger.info("[WorldManager] deleteWorld: Attempting to delete world '" + world.getName() + "' (ID: " + world.getId() + ", Owner: " + world.getOwnerName() + ")");
        CompletableFuture<Result<Unit>> future = new CompletableFuture<Result<Unit>>();
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldManager.deleteWorld$lambda$8(this, future, world, arg_0));
        this.debugLogger.debug("Returning future for async world deletion");
        return future;
    }

    @NotNull
    public final CompletableFuture<Boolean> loadWorld(@NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("isEnabled", world.isEnabled())};
        this.debugLogger.debugMethodEntry("loadWorld", pairArray);
        this.logger.info("[WorldManager] loadWorld: Loading world '" + world.getName() + "' (ID: " + world.getId() + ", Owner: " + world.getOwnerName() + ")");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (!world.isEnabled()) {
            this.logger.info("[WorldManager] loadWorld: World '" + world.getName() + "' is disabled, skipping load");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("World is disabled, skipping load", pairArray2);
            this.debugLogger.debugMethodExit("loadWorld", false);
            future.complete(false);
            return future;
        }
        String overworldName = this.getWorldName(world, World.Environment.NORMAL);
        File overworldFolder = new File(this.plugin.getServer().getWorldContainer(), overworldName);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("overworldName", overworldName), TuplesKt.to("folderPath", overworldFolder.getAbsolutePath()), TuplesKt.to("exists", overworldFolder.exists())};
        this.debugLogger.debug("Checking world folder existence", pairArray3);
        if (!overworldFolder.exists()) {
            this.logger.warning("[WorldManager] loadWorld: World folder '" + overworldName + "' does not exist, skipping world '" + world.getName() + "'");
            pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("World folder missing, marking for cleanup", pairArray3);
            this.markWorldForCleanup(world);
            this.debugLogger.debugMethodExit("loadWorld", false);
            future.complete(false);
            return future;
        }
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldManager.loadWorld$lambda$9(this, overworldName, world, future, arg_0));
        this.debugLogger.debug("Returning future for async world load");
        return future;
    }

    private final boolean loadWorldSync(PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("isEnabled", world.isEnabled()), TuplesKt.to("worldType", world.getWorldType())};
        this.debugLogger.debugMethodEntry("loadWorldSync", pairArray);
        this.logger.info("[WorldManager] loadWorldSync: Loading world '" + world.getName() + "' (ID: " + world.getId() + ", Owner: " + world.getOwnerName() + ")");
        if (!world.isEnabled()) {
            this.logger.info("[WorldManager] loadWorldSync: World '" + world.getName() + "' is disabled, skipping load");
            pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("World is disabled, skipping sync load", pairArray);
            this.debugLogger.debugMethodExit("loadWorldSync", false);
            return false;
        }
        String overworldName = this.getWorldName(world, World.Environment.NORMAL);
        File overworldFolder = new File(this.plugin.getServer().getWorldContainer(), overworldName);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("overworldName", overworldName), TuplesKt.to("folderPath", overworldFolder.getAbsolutePath()), TuplesKt.to("exists", overworldFolder.exists())};
        this.debugLogger.debug("Checking overworld folder for sync load", pairArray2);
        if (!overworldFolder.exists()) {
            this.logger.warning("[WorldManager] loadWorldSync: World folder '" + overworldName + "' does not exist, skipping world '" + world.getName() + "'");
            pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Overworld folder missing, marking for cleanup", pairArray2);
            this.markWorldForCleanup(world);
            this.debugLogger.debugMethodExit("loadWorldSync", false);
            return false;
        }
        try {
            boolean success = true;
            this.logger.info("[WorldManager] loadWorldSync: Loading overworld dimension '" + overworldName + "'");
            if (Bukkit.getWorld((String)overworldName) == null) {
                World overworld = this.createOrLoadDimension(overworldName, World.Environment.NORMAL, world.getWorldType(), world.getSeed());
                if (overworld == null) {
                    this.logger.warning("[WorldManager] loadWorldSync: Failed to load overworld: " + overworldName);
                    success = false;
                } else {
                    this.logger.info("[WorldManager] loadWorldSync: Successfully loaded overworld '" + overworldName + "'");
                }
            } else {
                this.logger.info("[WorldManager] loadWorldSync: Overworld '" + overworldName + "' already loaded");
            }
            String netherName = this.getWorldName(world, World.Environment.NETHER);
            File netherFolder = new File(this.plugin.getServer().getWorldContainer(), netherName);
            if (netherFolder.exists()) {
                this.logger.info("[WorldManager] loadWorldSync: Loading nether dimension '" + netherName + "'");
                if (Bukkit.getWorld((String)netherName) == null) {
                    World nether = this.createOrLoadDimension(netherName, World.Environment.NETHER, world.getWorldType(), world.getSeed());
                    if (nether == null) {
                        this.logger.warning("[WorldManager] loadWorldSync: Failed to load nether: " + netherName);
                    } else {
                        this.logger.info("[WorldManager] loadWorldSync: Successfully loaded nether '" + netherName + "'");
                    }
                } else {
                    this.logger.info("[WorldManager] loadWorldSync: Nether '" + netherName + "' already loaded");
                }
            }
            String endName = this.getWorldName(world, World.Environment.THE_END);
            File endFolder = new File(this.plugin.getServer().getWorldContainer(), endName);
            if (endFolder.exists()) {
                this.logger.info("[WorldManager] loadWorldSync: Loading end dimension '" + endName + "'");
                if (Bukkit.getWorld((String)endName) == null) {
                    World end = this.createOrLoadDimension(endName, World.Environment.THE_END, world.getWorldType(), world.getSeed());
                    if (end == null) {
                        this.logger.warning("[WorldManager] loadWorldSync: Failed to load end: " + endName);
                    } else {
                        this.logger.info("[WorldManager] loadWorldSync: Successfully loaded end '" + endName + "'");
                    }
                } else {
                    this.logger.info("[WorldManager] loadWorldSync: End '" + endName + "' already loaded");
                }
            }
            if (success) {
                this.logger.info("[WorldManager] loadWorldSync: Applying world settings for '" + world.getName() + "'");
                this.applyWorldSettings(world);
            }
            this.logger.info("[WorldManager] loadWorldSync: Load complete for world '" + world.getName() + "' - Success: " + success);
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("success", success)};
            this.debugLogger.debug("Sync load complete", pairArray3);
            this.debugLogger.debugMethodExit("loadWorldSync", success);
            return success;
        }
        catch (Exception e) {
            this.logger.severe("[WorldManager] loadWorldSync: Error loading world " + world.getName() + ": " + e.getMessage());
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Sync load failed with exception", pairArray4);
            this.debugLogger.debugMethodExit("loadWorldSync", false);
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public final CompletableFuture<Boolean> unloadWorld(@NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("ownerName", world.getOwnerName())};
        this.debugLogger.debugMethodEntry("unloadWorld", pairArray);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.debugLogger.debug("Scheduling world unload on GlobalRegionScheduler");
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldManager.unloadWorld$lambda$12(this, world, future, arg_0));
        return future;
    }

    @NotNull
    public final CompletableFuture<Boolean> teleportToWorld(@NotNull Player player, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debugMethodEntry("teleportToWorld", pairArray);
        this.logger.info("[WorldManager] teleportToWorld: Teleporting player '" + player.getName() + "' to world '" + world.getName() + "'");
        WorldUnloadManager worldUnloadManager = this.worldUnloadManager;
        boolean isUnloaded = (worldUnloadManager != null ? worldUnloadManager.isWorldUnloaded(world.getId()) : false) || WorldManager.getBukkitWorld$default(this, world, null, 2, null) == null;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("isUnloaded", isUnloaded)};
        this.debugLogger.debug("World load status check", pairArray2);
        if (isUnloaded) {
            this.logger.info("[WorldManager] teleportToWorld: World '" + world.getName() + "' is unloaded, loading first...");
            player.sendMessage((Component)Component.text("Loading world...", (TextColor)NamedTextColor.YELLOW));
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            this.loadWorld(world).thenAccept(arg_0 -> WorldManager.teleportToWorld$lambda$13(new Function1<Boolean, Unit>(this, world, player, future){
                final /* synthetic */ WorldManager this$0;
                final /* synthetic */ PlayerWorld $world;
                final /* synthetic */ Player $player;
                final /* synthetic */ CompletableFuture<Boolean> $future;
                {
                    this.this$0 = $receiver;
                    this.$world = $world;
                    this.$player = $player;
                    this.$future = $future;
                    super(1);
                }

                public final void invoke(Boolean loadSuccess) {
                    Intrinsics.checkNotNull(loadSuccess);
                    if (loadSuccess.booleanValue()) {
                        WorldManager.access$getLogger$p(this.this$0).info("[WorldManager] teleportToWorld: World '" + this.$world.getName() + "' loaded successfully, proceeding with teleport");
                        WorldUnloadManager worldUnloadManager = WorldManager.access$getWorldUnloadManager$p(this.this$0);
                        if (worldUnloadManager != null) {
                            worldUnloadManager.markWorldLoaded(this.$world.getId());
                        }
                        this.this$0.teleportToDimension(this.$player, this.$world, World.Environment.NORMAL).thenAccept(arg_0 -> teleportToWorld.1.invoke$lambda$0(new Function1<Boolean, Unit>(this.$future){
                            final /* synthetic */ CompletableFuture<Boolean> $future;
                            {
                                this.$future = $future;
                                super(1);
                            }

                            public final void invoke(Boolean teleportSuccess) {
                                this.$future.complete(teleportSuccess);
                            }
                        }, arg_0));
                    } else {
                        WorldManager.access$getLogger$p(this.this$0).warning("[WorldManager] teleportToWorld: Failed to load world '" + this.$world.getName() + "'");
                        this.$player.getScheduler().run((Plugin)WorldManager.access$getPlugin$p(this.this$0), arg_0 -> teleportToWorld.1.invoke$lambda$1(this.$player, arg_0), null);
                        this.$future.complete(false);
                    }
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                    $tmp0.invoke(p0);
                }

                private static final void invoke$lambda$1(Player $player, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    $player.sendMessage((Component)Component.text("Failed to load world", (TextColor)NamedTextColor.RED));
                }
            }, arg_0));
            this.debugLogger.debugMethodExit("teleportToWorld", "loading world first");
            return future;
        }
        CompletableFuture<Boolean> result = this.teleportToDimension(player, world, World.Environment.NORMAL);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("environment", World.Environment.NORMAL)};
        this.debugLogger.debug("Delegating to teleportToDimension", pairArray3);
        return result;
    }

    @NotNull
    public final CompletableFuture<Boolean> teleportToVanillaWorld(@NotNull Player player) {
        Location location;
        Pair[] pairArray;
        Object v1;
        Pair[] it;
        Pair[] $this$firstOrNull$iv;
        CompletableFuture<Boolean> future;
        block5: {
            Intrinsics.checkNotNullParameter(player, "player");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("currentWorld", player.getWorld().getName())};
            this.debugLogger.debugMethodEntry("teleportToVanillaWorld", pairArray2);
            this.logger.info("[WorldManager] teleportToVanillaWorld: Teleporting player '" + player.getName() + "' to vanilla world");
            future = new CompletableFuture<Boolean>();
            List list = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
            List allWorlds = list;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("totalWorlds", allWorlds.size())};
            this.debugLogger.debug("Finding vanilla world", pairArray3);
            $this$firstOrNull$iv = (Pair[])allWorlds;
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                it = (Pair[])t;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!(!this.isPluginWorld((World)it))) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        World vanillaWorld = v1;
        if (vanillaWorld == null) {
            this.logger.warning("[WorldManager] teleportToVanillaWorld: No vanilla world found");
            this.debugLogger.debug("No vanilla world found");
            this.debugLogger.debugMethodExit("teleportToVanillaWorld", false);
            future.complete(false);
            return future;
        }
        $this$firstOrNull$iv = new Pair[]{TuplesKt.to("vanillaWorldName", vanillaWorld.getName())};
        this.debugLogger.debug("Found vanilla world", $this$firstOrNull$iv);
        String string = vanillaWorld.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String vanillaWorldName = string;
        String string2 = player.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        String currentWorldName = string2;
        if (Intrinsics.areEqual(currentWorldName, vanillaWorldName)) {
            this.logger.info("[WorldManager] teleportToVanillaWorld: Player '" + player.getName() + "' is already in vanilla world '" + vanillaWorldName + "', skipping teleport");
            pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("worldName", vanillaWorldName)};
            this.debugLogger.debug("Player already in vanilla world, skipping teleport", pairArray);
            this.debugLogger.debugMethodExit("teleportToVanillaWorld", true);
            future.complete(true);
            return future;
        }
        this.logger.info("[WorldManager] teleportToVanillaWorld: Saving full state for '" + player.getName() + "' in '" + currentWorldName + "'");
        pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("currentWorld", currentWorldName)};
        this.debugLogger.debug("Saving player state before teleport", pairArray);
        this.worldStateManager.savePlayerState(player, currentWorldName);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        LocationData savedState = this.worldStateManager.getSavedLocation(uUID, vanillaWorldName);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("targetWorld", vanillaWorldName), TuplesKt.to("hasSavedState", savedState != null)};
        this.debugLogger.debug("Checking for saved location", pairArray2);
        if (savedState != null) {
            this.logger.info("[WorldManager] teleportToVanillaWorld: Using saved location for '" + player.getName() + "' in '" + vanillaWorldName + "'");
            it = new Pair[]{TuplesKt.to("x", savedState.getX()), TuplesKt.to("y", savedState.getY()), TuplesKt.to("z", savedState.getZ()), TuplesKt.to("yaw", Float.valueOf(savedState.getYaw())), TuplesKt.to("pitch", Float.valueOf(savedState.getPitch()))};
            this.debugLogger.debug("Using saved location", it);
            location = new Location(vanillaWorld, savedState.getX(), savedState.getY(), savedState.getZ(), savedState.getYaw(), savedState.getPitch());
        } else {
            this.logger.info("[WorldManager] teleportToVanillaWorld: Using world spawn for '" + vanillaWorldName + "' (first visit)");
            Location location2 = vanillaWorld.getSpawnLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getSpawnLocation(...)");
            Location spawn = location2;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("x", spawn.getX()), TuplesKt.to("y", spawn.getY()), TuplesKt.to("z", spawn.getZ())};
            this.debugLogger.debug("Using world spawn (first visit)", pairArray3);
            location = spawn;
        }
        Location location3 = location;
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        boolean isFirstVisit = !this.worldStateManager.hasStateForWorld(uUID2, vanillaWorldName);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("isFirstVisit", isFirstVisit)};
        this.debugLogger.debug("First visit check", pairArray4);
        pairArray4 = new Pair[]{TuplesKt.to("destination", vanillaWorldName), TuplesKt.to("x", location3.getX()), TuplesKt.to("y", location3.getY()), TuplesKt.to("z", location3.getZ())};
        this.debugLogger.debug("Initiating async teleport", pairArray4);
        player.teleportAsync(location3).thenAccept(arg_0 -> WorldManager.teleportToVanillaWorld$lambda$15(new Function1<Boolean, Unit>(this, player, vanillaWorldName, future, isFirstVisit){
            final /* synthetic */ WorldManager this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ String $vanillaWorldName;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            final /* synthetic */ boolean $isFirstVisit;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$vanillaWorldName = $vanillaWorldName;
                this.$future = $future;
                this.$isFirstVisit = $isFirstVisit;
                super(1);
            }

            public final void invoke(Boolean success) {
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    WorldManager.access$getLogger$p(this.this$0).info("[WorldManager] teleportToVanillaWorld: Teleport successful for '" + this.$player.getName() + "' to '" + this.$vanillaWorldName + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", this.$player.getName()), TuplesKt.to("destination", this.$vanillaWorldName)};
                    WorldManager.access$getDebugLogger$p(this.this$0).debug("Async teleport successful", pairArray);
                    WorldManager.access$getDebugLogger$p(this.this$0).debug("Scheduling state restoration on entity scheduler");
                    this.$player.getScheduler().run((Plugin)WorldManager.access$getPlugin$p(this.this$0), arg_0 -> teleportToVanillaWorld.1.invoke$lambda$0(this.$isFirstVisit, this.this$0, this.$vanillaWorldName, this.$player, arg_0), null);
                } else {
                    WorldManager.access$getLogger$p(this.this$0).warning("[WorldManager] teleportToVanillaWorld: Failed to teleport '" + this.$player.getName() + "' to '" + this.$vanillaWorldName + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", this.$player.getName())};
                    WorldManager.access$getDebugLogger$p(this.this$0).debug("Async teleport failed", pairArray);
                    WorldManager.access$getDebugLogger$p(this.this$0).debugMethodExit("teleportToVanillaWorld", false);
                }
                this.$future.complete(success);
            }

            private static final void invoke$lambda$0(boolean $isFirstVisit, WorldManager this$0, String $vanillaWorldName, Player $player, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($vanillaWorldName, "$vanillaWorldName");
                Intrinsics.checkNotNullParameter($player, "$player");
                if ($isFirstVisit) {
                    WorldManager.access$getLogger$p(this$0).info("[WorldManager] teleportToVanillaWorld: First visit to '" + $vanillaWorldName + "', clearing player state");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $vanillaWorldName)};
                    WorldManager.access$getDebugLogger$p(this$0).debug("First visit - clearing player state", pairArray);
                    WorldManager.access$getWorldStateManager$p(this$0).clearPlayerState($player);
                    WorldManager.access$getWorldStateManager$p(this$0).savePlayerState($player, $vanillaWorldName);
                    WorldManager.access$getDebugLogger$p(this$0).debug("Saved cleared state for future visits");
                } else {
                    WorldManager.access$getLogger$p(this$0).info("[WorldManager] teleportToVanillaWorld: Restoring state for '" + $player.getName() + "' in '" + $vanillaWorldName + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $vanillaWorldName)};
                    WorldManager.access$getDebugLogger$p(this$0).debug("Returning visit - restoring saved state", pairArray);
                    WorldManager.access$getWorldStateManager$p(this$0).restorePlayerState($player, $vanillaWorldName);
                }
                WorldManager.access$getDebugLogger$p(this$0).debugMethodExit("teleportToVanillaWorld", true);
            }
        }, arg_0));
        return future;
    }

    @NotNull
    public final CompletableFuture<Boolean> teleportToDimension(@NotNull Player player, @NotNull PlayerWorld world, @NotNull World.Environment environment) {
        Pair[] pairArray;
        Location location;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(environment, "environment");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("environment", environment)};
        this.debugLogger.debugMethodEntry("teleportToDimension", pairArray2);
        this.logger.info("[WorldManager] teleportToDimension: Teleporting player '" + player.getName() + "' to world '" + world.getName() + "' dimension " + environment);
        String targetWorldName = this.getWorldName(world, environment);
        String string = player.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String currentWorldName = string;
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("targetWorldName", targetWorldName), TuplesKt.to("currentWorldName", currentWorldName)};
        this.debugLogger.debug("World name resolution", pairArray3);
        if (Intrinsics.areEqual(currentWorldName, targetWorldName)) {
            this.logger.info("[WorldManager] teleportToDimension: Player '" + player.getName() + "' is already in world '" + targetWorldName + "', skipping teleport");
            pairArray3 = new Pair[]{TuplesKt.to("worldName", targetWorldName)};
            this.debugLogger.debug("Player already in target world, skipping", pairArray3);
            this.debugLogger.debugMethodExit("teleportToDimension", true);
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
            Intrinsics.checkNotNullExpressionValue(completableFuture, "completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        World bukkitWorld = this.getBukkitWorld(world, environment);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("found", bukkitWorld != null), TuplesKt.to("targetWorldName", targetWorldName)};
        this.debugLogger.debug("Bukkit world lookup", pairArray4);
        if (bukkitWorld == null) {
            this.logger.warning("[WorldManager] teleportToDimension: Bukkit world not loaded for '" + world.getName() + "' dimension " + environment);
            pairArray4 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("environment", environment)};
            this.debugLogger.debug("Bukkit world not found/loaded", pairArray4);
            this.debugLogger.debugMethodExit("teleportToDimension", false);
            future.complete(false);
            return future;
        }
        this.logger.info("[WorldManager] teleportToDimension: Saving full state for '" + player.getName() + "' in '" + currentWorldName + "'");
        pairArray4 = new Pair[]{TuplesKt.to("currentWorld", currentWorldName)};
        this.debugLogger.debug("Saving player state before dimension teleport", pairArray4);
        this.worldStateManager.savePlayerState(player, currentWorldName);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        LocationData savedState = this.worldStateManager.getSavedLocation(uUID, targetWorldName);
        Pair[] pairArray5 = new Pair[]{TuplesKt.to("targetWorld", targetWorldName), TuplesKt.to("hasSavedState", savedState != null), TuplesKt.to("hasCustomSpawn", world.getSpawnLocation() != null)};
        this.debugLogger.debug("Checking for saved state in target world", pairArray5);
        if (savedState != null) {
            this.logger.info("[WorldManager] teleportToDimension: Using saved location for '" + player.getName() + "' in '" + targetWorldName + "'");
            Pair[] pairArray6 = new Pair[]{TuplesKt.to("x", savedState.getX()), TuplesKt.to("y", savedState.getY()), TuplesKt.to("z", savedState.getZ()), TuplesKt.to("yaw", Float.valueOf(savedState.getYaw())), TuplesKt.to("pitch", Float.valueOf(savedState.getPitch()))};
            this.debugLogger.debug("Using saved location", pairArray6);
            location = new Location(bukkitWorld, savedState.getX(), savedState.getY(), savedState.getZ(), savedState.getYaw(), savedState.getPitch());
        } else if (environment == World.Environment.NORMAL && world.getSpawnLocation() != null) {
            this.logger.info("[WorldManager] teleportToDimension: Using custom spawn for '" + world.getName() + "' (first visit)");
            SimpleLocation simpleLocation = world.getSpawnLocation();
            Intrinsics.checkNotNull(simpleLocation);
            SimpleLocation customSpawn = simpleLocation;
            pairArray = new Pair[]{TuplesKt.to("x", customSpawn.getX()), TuplesKt.to("y", customSpawn.getY()), TuplesKt.to("z", customSpawn.getZ())};
            this.debugLogger.debug("Using custom spawn location (first visit)", pairArray);
            location = SimpleLocationKt.toBukkitLocation(customSpawn, bukkitWorld);
        } else {
            this.logger.info("[WorldManager] teleportToDimension: Using world spawn for '" + targetWorldName + "' (first visit)");
            Location location2 = bukkitWorld.getSpawnLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getSpawnLocation(...)");
            Location spawn = location2;
            pairArray = new Pair[]{TuplesKt.to("x", spawn.getX()), TuplesKt.to("y", spawn.getY()), TuplesKt.to("z", spawn.getZ())};
            this.debugLogger.debug("Using world spawn location (first visit/default)", pairArray);
            location = spawn;
        }
        Location location3 = location;
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        boolean isFirstVisit = !this.worldStateManager.hasStateForWorld(uUID2, targetWorldName);
        pairArray = new Pair[]{TuplesKt.to("isFirstVisit", isFirstVisit)};
        this.debugLogger.debug("First visit check for dimension teleport", pairArray);
        pairArray = new Pair[]{TuplesKt.to("destination", targetWorldName), TuplesKt.to("x", location3.getX()), TuplesKt.to("y", location3.getY()), TuplesKt.to("z", location3.getZ())};
        this.debugLogger.debug("Initiating async dimension teleport", pairArray);
        player.teleportAsync(location3).thenAccept(arg_0 -> WorldManager.teleportToDimension$lambda$16(new Function1<Boolean, Unit>(this, player, targetWorldName, future, isFirstVisit, world){
            final /* synthetic */ WorldManager this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ String $targetWorldName;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            final /* synthetic */ boolean $isFirstVisit;
            final /* synthetic */ PlayerWorld $world;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$targetWorldName = $targetWorldName;
                this.$future = $future;
                this.$isFirstVisit = $isFirstVisit;
                this.$world = $world;
                super(1);
            }

            public final void invoke(Boolean success) {
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    WorldManager.access$getLogger$p(this.this$0).info("[WorldManager] teleportToDimension: Teleport successful for '" + this.$player.getName() + "' to '" + this.$targetWorldName + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", this.$player.getName()), TuplesKt.to("destination", this.$targetWorldName)};
                    WorldManager.access$getDebugLogger$p(this.this$0).debug("Async dimension teleport successful", pairArray);
                    WorldManager.access$getDebugLogger$p(this.this$0).debug("Scheduling state restoration on entity scheduler after dimension teleport");
                    this.$player.getScheduler().run((Plugin)WorldManager.access$getPlugin$p(this.this$0), arg_0 -> teleportToDimension.1.invoke$lambda$0(this.$isFirstVisit, this.this$0, this.$targetWorldName, this.$player, this.$world, arg_0), null);
                } else {
                    WorldManager.access$getLogger$p(this.this$0).warning("[WorldManager] teleportToDimension: Failed to teleport '" + this.$player.getName() + "' to '" + this.$targetWorldName + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", this.$player.getName())};
                    WorldManager.access$getDebugLogger$p(this.this$0).debug("Async dimension teleport failed", pairArray);
                    WorldManager.access$getDebugLogger$p(this.this$0).debugMethodExit("teleportToDimension", false);
                }
                this.$future.complete(success);
            }

            private static final void invoke$lambda$0(boolean $isFirstVisit, WorldManager this$0, String $targetWorldName, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
                Pair[] pairArray;
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($targetWorldName, "$targetWorldName");
                Intrinsics.checkNotNullParameter($player, "$player");
                Intrinsics.checkNotNullParameter($world, "$world");
                if ($isFirstVisit) {
                    WorldManager.access$getLogger$p(this$0).info("[WorldManager] teleportToDimension: First visit to '" + $targetWorldName + "', clearing player state");
                    pairArray = new Pair[]{TuplesKt.to("worldName", $targetWorldName)};
                    WorldManager.access$getDebugLogger$p(this$0).debug("First visit to dimension - clearing state", pairArray);
                    WorldManager.access$getWorldStateManager$p(this$0).clearPlayerState($player);
                    WorldManager.access$getWorldStateManager$p(this$0).savePlayerState($player, $targetWorldName);
                    WorldManager.access$getDebugLogger$p(this$0).debug("Saved cleared state for future dimension visits");
                } else {
                    WorldManager.access$getLogger$p(this$0).info("[WorldManager] teleportToDimension: Restoring state for '" + $player.getName() + "' in '" + $targetWorldName + "'");
                    pairArray = new Pair[]{TuplesKt.to("worldName", $targetWorldName)};
                    WorldManager.access$getDebugLogger$p(this$0).debug("Returning to dimension - restoring state", pairArray);
                    WorldManager.access$getWorldStateManager$p(this$0).restorePlayerState($player, $targetWorldName);
                }
                pairArray = new Pair[]{TuplesKt.to("gameMode", $world.getDefaultGameMode())};
                WorldManager.access$getDebugLogger$p(this$0).debug("Setting gamemode from world settings", pairArray);
                $player.setGameMode($world.getDefaultGameMode());
                WorldManager.access$getDebugLogger$p(this$0).debugMethodExit("teleportToDimension", true);
            }
        }, arg_0));
        return future;
    }

    @Nullable
    public final World getBukkitWorld(@NotNull PlayerWorld world, @NotNull World.Environment environment) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(environment, "environment");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("environment", environment)};
        this.debugLogger.debugMethodEntry("getBukkitWorld", pairArray);
        String worldName = this.getWorldName(world, environment);
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("searchName", worldName), TuplesKt.to("found", bukkitWorld != null)};
        this.debugLogger.debug("Bukkit world lookup result", pairArray2);
        World world2 = bukkitWorld;
        this.debugLogger.debugMethodExit("getBukkitWorld", world2 != null ? world2.getName() : null);
        return bukkitWorld;
    }

    public static /* synthetic */ World getBukkitWorld$default(WorldManager worldManager, PlayerWorld playerWorld, World.Environment environment, int n, Object object) {
        if ((n & 2) != 0) {
            environment = World.Environment.NORMAL;
        }
        return worldManager.getBukkitWorld(playerWorld, environment);
    }

    @NotNull
    public final String getWorldName(@NotNull PlayerWorld world, @NotNull World.Environment environment) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(environment, "environment");
        String string = (world.getOwnerName() + "_" + world.getName()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String baseName = StringsKt.replace$default(string, " ", "_", false, 4, null);
        return switch (WhenMappings.$EnumSwitchMapping$0[environment.ordinal()]) {
            case 1 -> baseName;
            case 2 -> baseName + NETHER_SUFFIX;
            case 3 -> baseName + END_SUFFIX;
            default -> baseName;
        };
    }

    public static /* synthetic */ String getWorldName$default(WorldManager worldManager, PlayerWorld playerWorld, World.Environment environment, int n, Object object) {
        if ((n & 2) != 0) {
            environment = World.Environment.NORMAL;
        }
        return worldManager.getWorldName(playerWorld, environment);
    }

    public final boolean canCreateWorld(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("canCreateWorld", pairArray);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        int currentCount = this.getWorldCount(uUID);
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        PlayerData playerData = this.dataManager.loadPlayerData(uUID2);
        int limit = playerData != null ? playerData.getWorldLimit() : this.defaultWorldLimit;
        boolean canCreate = currentCount < limit;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("currentCount", currentCount), TuplesKt.to("limit", limit), TuplesKt.to("canCreate", canCreate)};
        this.debugLogger.debug("World creation permission check", pairArray2);
        this.debugLogger.debugMethodExit("canCreateWorld", canCreate);
        return canCreate;
    }

    public final int getWorldCount(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("getWorldCount", pairArray);
        int count = this.dataManager.getWorldsByOwner(playerUuid).size();
        this.debugLogger.debugMethodExit("getWorldCount", count);
        return count;
    }

    public final void applyWorldSettings(@NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("timeLock", world.getTimeLock()), TuplesKt.to("weatherLock", world.getWeatherLock()), TuplesKt.to("defaultGameMode", world.getDefaultGameMode())};
        this.debugLogger.debugMethodEntry("applyWorldSettings", pairArray);
        this.logger.info("[WorldManager] applyWorldSettings: Applying settings to world '" + world.getName() + "' (TimeLock: " + world.getTimeLock() + ", WeatherLock: " + world.getWeatherLock() + ")");
        World world2 = WorldManager.getBukkitWorld$default(this, world, null, 2, null);
        if (world2 == null) {
            WorldManager $this$applyWorldSettings_u24lambda_u2417 = this;
            boolean bl = false;
            $this$applyWorldSettings_u24lambda_u2417.logger.warning("[WorldManager] applyWorldSettings: Could not get Bukkit world for '" + world.getName() + "'");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            $this$applyWorldSettings_u24lambda_u2417.debugLogger.debug("Cannot apply settings - Bukkit world not found", pairArray2);
            $this$applyWorldSettings_u24lambda_u2417.debugLogger.debugMethodExit("applyWorldSettings", "failed - no bukkit world");
            return;
        }
        World bukkitWorld = world2;
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("bukkitWorldName", bukkitWorld.getName())};
        this.debugLogger.debug("Found Bukkit world for settings", pairArray3);
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldManager.applyWorldSettings$lambda$18(world, this, bukkitWorld, arg_0));
        this.debugLogger.debugMethodExit("applyWorldSettings", "scheduled");
    }

    public final void applyWorldBorder(@NotNull PlayerWorld world, @Nullable World bukkitWorld) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("borderSize", world.getWorldBorder().getSize())};
        this.debugLogger.debugMethodEntry("applyWorldBorder", pairArray);
        World world2 = bukkitWorld;
        if (world2 == null && (world2 = WorldManager.getBukkitWorld$default(this, world, null, 2, null)) == null) {
            WorldManager $this$applyWorldBorder_u24lambda_u2419 = this;
            boolean bl = false;
            $this$applyWorldBorder_u24lambda_u2419.logger.warning("[WorldManager] applyWorldBorder: Could not get Bukkit world for '" + world.getName() + "'");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            $this$applyWorldBorder_u24lambda_u2419.debugLogger.debug("Cannot apply border - Bukkit world not found", pairArray2);
            $this$applyWorldBorder_u24lambda_u2419.debugLogger.debugMethodExit("applyWorldBorder", "failed - no bukkit world");
            return;
        }
        World targetWorld = world2;
        WorldBorder worldBorder = targetWorld.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder border = worldBorder;
        WorldBorderSettings settings = world.getWorldBorder();
        this.logger.info("[WorldManager] applyWorldBorder: Applying border to '" + world.getName() + "' - Size: " + settings.getSize() + ", Center: " + settings.getCenterX() + "," + settings.getCenterZ());
        border.setCenter(new Location(targetWorld, settings.getCenterX(), 0.0, settings.getCenterZ()));
        border.setSize(settings.getSize());
        border.setDamageAmount(settings.getDamageAmount());
        border.setDamageBuffer(settings.getDamageBuffer());
        border.setWarningDistance(settings.getWarningDistance());
        border.setWarningTime(settings.getWarningTime());
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("size", settings.getSize()), TuplesKt.to("centerX", settings.getCenterX()), TuplesKt.to("centerZ", settings.getCenterZ()), TuplesKt.to("damageAmount", settings.getDamageAmount()), TuplesKt.to("damageBuffer", settings.getDamageBuffer()), TuplesKt.to("warningDistance", settings.getWarningDistance()), TuplesKt.to("warningTime", settings.getWarningTime())};
        this.debugLogger.debug("World border applied", pairArray3);
        this.debugLogger.debugMethodExit("applyWorldBorder", "success");
    }

    public static /* synthetic */ void applyWorldBorder$default(WorldManager worldManager, PlayerWorld playerWorld, World world, int n, Object object) {
        if ((n & 2) != 0) {
            world = null;
        }
        worldManager.applyWorldBorder(playerWorld, world);
    }

    public final void setSpawnLocation(@NotNull PlayerWorld world, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(location, "location");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("x", location.getX()), TuplesKt.to("y", location.getY()), TuplesKt.to("z", location.getZ()), TuplesKt.to("yaw", Float.valueOf(location.getYaw())), TuplesKt.to("pitch", Float.valueOf(location.getPitch()))};
        this.debugLogger.debugMethodEntry("setSpawnLocation", pairArray);
        this.logger.info("[WorldManager] setSpawnLocation: Setting spawn location for world '" + world.getName() + "' to " + location.getX() + ", " + location.getY() + ", " + location.getZ());
        world.setSpawnLocation(SimpleLocationKt.toSimpleLocation(location));
        this.debugLogger.debug("Saving world with new spawn location");
        this.dataManager.saveWorld(world);
        World bukkitWorld = WorldManager.getBukkitWorld$default(this, world, null, 2, null);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("bukkitWorldFound", bukkitWorld != null)};
        this.debugLogger.debug("Updating Bukkit world spawn", pairArray2);
        World world2 = bukkitWorld;
        if (world2 != null) {
            world2.setSpawnLocation(location);
        }
        this.logger.info("[WorldManager] setSpawnLocation: Successfully updated spawn location for '" + world.getName() + "'");
        this.debugLogger.debugMethodExit("setSpawnLocation", "success");
    }

    @Nullable
    public final PlayerWorld getPlayerWorldFromBukkitWorld(@NotNull World bukkitWorld) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter(bukkitWorld, "bukkitWorld");
            Pair[] pairArray = new Pair[]{TuplesKt.to("bukkitWorldName", bukkitWorld.getName())};
            this.debugLogger.debugMethodEntry("getPlayerWorldFromBukkitWorld", pairArray);
            String string = bukkitWorld.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String worldName = string;
            String baseName = StringsKt.removeSuffix(StringsKt.removeSuffix(worldName, (CharSequence)NETHER_SUFFIX), (CharSequence)END_SUFFIX);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("original", worldName), TuplesKt.to("baseName", baseName)};
            this.debugLogger.debug("Extracted base name", pairArray2);
            List<PlayerWorld> allWorlds = this.dataManager.getAllWorlds();
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("totalWorlds", allWorlds.size())};
            this.debugLogger.debug("Searching for matching PlayerWorld", pairArray3);
            Iterable $this$firstOrNull$iv = allWorlds;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerWorld world = (PlayerWorld)element$iv;
                boolean bl = false;
                String string2 = (world.getOwnerName() + "_" + world.getName()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                String expectedBaseName = StringsKt.replace$default(string2, " ", "_", false, 4, null);
                if (!Intrinsics.areEqual(baseName, expectedBaseName)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        PlayerWorld result = v2;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to("found", result != null);
        PlayerWorld playerWorld = result;
        pairArray[1] = TuplesKt.to("resultWorldName", playerWorld != null ? playerWorld.getName() : null);
        PlayerWorld playerWorld2 = result;
        pairArray[2] = TuplesKt.to("resultWorldId", playerWorld2 != null ? playerWorld2.getId() : null);
        this.debugLogger.debug("PlayerWorld lookup result", pairArray);
        PlayerWorld playerWorld3 = result;
        this.debugLogger.debugMethodExit("getPlayerWorldFromBukkitWorld", playerWorld3 != null ? playerWorld3.getName() : null);
        return result;
    }

    public final boolean isPluginWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("isPluginWorld", pairArray);
        boolean isPlugin = this.getPlayerWorldFromBukkitWorld(world) != null;
        this.debugLogger.debugMethodExit("isPluginWorld", isPlugin);
        return isPlugin;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerWorld> getLoadedWorlds() {
        void $this$filterTo$iv$iv;
        this.debugLogger.debugMethodEntry("getLoadedWorlds", new Pair[0]);
        List<PlayerWorld> allWorlds = this.dataManager.getAllWorlds();
        Iterable $this$filter$iv = allWorlds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerWorld world = (PlayerWorld)element$iv$iv;
            boolean bl = false;
            if (!(WorldManager.getBukkitWorld$default(this, world, null, 2, null) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List loadedWorlds = (List)destination$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("totalWorlds", allWorlds.size()), TuplesKt.to("loadedWorlds", loadedWorlds.size())};
        this.debugLogger.debug("Loaded worlds count", pairArray);
        this.debugLogger.debugMethodExit("getLoadedWorlds", loadedWorlds.size());
        return loadedWorlds;
    }

    private final String validateWorldName(String name) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("name", name), TuplesKt.to("nameLength", name.length())};
        this.debugLogger.debugMethodEntry("validateWorldName", pairArray);
        String result = StringsKt.isBlank(name) ? "World name cannot be empty" : (name.length() > this.maxNameLength ? "World name is too long (max " + this.maxNameLength + " characters)" : (!this.namePattern.matches(name) ? "World name can only contain letters, numbers, and underscores" : null));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("name", name), TuplesKt.to("isValid", result == null), TuplesKt.to("error", result)};
        this.debugLogger.debug("World name validation result", pairArray2);
        this.debugLogger.debugMethodExit("validateWorldName", result);
        return result;
    }

    private final World createDimension(String worldName, World.Environment environment, WorldType worldType, Long seed) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", worldName), TuplesKt.to("environment", environment), TuplesKt.to("worldType", worldType), TuplesKt.to("seed", seed)};
        this.debugLogger.debugMethodEntry("createDimension", pairArray);
        Object object = seed;
        if (object == null) {
            object = "random";
        }
        this.logger.info("[WorldManager] createDimension: Creating dimension '" + worldName + "' (Environment: " + environment + ", Type: " + worldType + ", Seed: " + object + ")");
        try {
            List list;
            String bukkitWorldTypeName;
            String generatorSettings;
            LevelStorageSource.LevelStorageAccess levelStorageAccess;
            Server server = Bukkit.getServer();
            Intrinsics.checkNotNull(server, "null cannot be cast to non-null type org.bukkit.craftbukkit.CraftServer");
            CraftServer craftServer = (CraftServer)server;
            DedicatedServer dedicatedServer = craftServer.getServer();
            Intrinsics.checkNotNull(dedicatedServer, "null cannot be cast to non-null type net.minecraft.server.dedicated.DedicatedServer");
            DedicatedServer console = dedicatedServer;
            World existingWorld = craftServer.getWorld(worldName);
            if (existingWorld != null) {
                if (this.deletedWorldNames.contains(worldName)) {
                    this.logger.info("[WorldManager] createDimension: Skipping cached deleted world '" + worldName + "', will create fresh");
                    this.deletedWorldNames.remove(worldName);
                } else {
                    this.logger.warning("[WorldManager] createDimension: World '" + worldName + "' already exists");
                    return existingWorld;
                }
            }
            ResourceKey actualDimension = switch (WhenMappings.$EnumSwitchMapping$0[environment.ordinal()]) {
                case 1 -> LevelStem.OVERWORLD;
                case 2 -> LevelStem.NETHER;
                case 3 -> LevelStem.END;
                case 4 -> LevelStem.OVERWORLD;
                default -> throw new NoWhenBranchMatchedException();
            };
            File file = craftServer.getWorldContainer();
            Intrinsics.checkNotNullExpressionValue(file, "getWorldContainer(...)");
            File worldContainer = file;
            File worldFolder = new File(worldContainer, worldName);
            if (worldFolder.exists() && !worldFolder.isDirectory()) {
                this.logger.severe("[WorldManager] createDimension: World folder '" + worldName + "' exists but is not a directory");
                return null;
            }
            try {
                levelStorageAccess = LevelStorageSource.createDefault((Path)worldContainer.toPath()).validateAndCreateAccess(worldName, actualDimension);
                Intrinsics.checkNotNull(levelStorageAccess);
            }
            catch (IOException ex) {
                this.logger.severe("[WorldManager] createDimension: IOException creating storage access: " + ex.getMessage());
                ex.printStackTrace();
                return null;
            }
            catch (ContentValidationException ex) {
                this.logger.severe("[WorldManager] createDimension: Content validation error: " + ex.getMessage());
                ex.printStackTrace();
                return null;
            }
            LevelStorageSource.LevelStorageAccess levelStorageAccess2 = levelStorageAccess;
            ChunkGenerator generator = null;
            BiomeProvider biomeProvider = null;
            if (worldType == WorldType.VOID) {
                generator = new VoidGenerator();
            }
            Dynamic dataTag = null;
            if (levelStorageAccess2.hasWorldData()) {
                try {
                    dataTag = levelStorageAccess2.getDataTag();
                    LevelSummary summary = levelStorageAccess2.getSummary(dataTag);
                    if (summary.requiresManualConversion()) {
                        this.logger.severe("[WorldManager] createDimension: World requires manual conversion");
                        levelStorageAccess2.close();
                        return null;
                    }
                    if (!summary.isCompatible()) {
                        this.logger.severe("[WorldManager] createDimension: World was created by incompatible version");
                        levelStorageAccess2.close();
                        return null;
                    }
                }
                catch (Exception ex) {
                    Exception exception = ex;
                    if ((exception instanceof NbtException ? true : exception instanceof ReportedNbtException) ? true : exception instanceof IOException) {
                        this.logger.warning("[WorldManager] createDimension: Failed to load world data, attempting fallback");
                        try {
                            levelStorageAccess2.getDataTagFallback();
                            levelStorageAccess2.restoreLevelDataFromOld();
                        }
                        catch (Exception fallbackEx) {
                            this.logger.severe("[WorldManager] createDimension: Fallback failed: " + fallbackEx.getMessage());
                            levelStorageAccess2.close();
                            return null;
                        }
                    }
                    throw ex;
                }
            }
            WorldLoader.DataLoadContext dataLoadContext = console.worldLoaderContext;
            Intrinsics.checkNotNullExpressionValue(dataLoadContext, "worldLoaderContext");
            WorldLoader.DataLoadContext context = dataLoadContext;
            RegistryAccess.Frozen frozen = context.datapackDimensions();
            Intrinsics.checkNotNullExpressionValue(frozen, "datapackDimensions(...)");
            RegistryAccess.Frozen registryAccess = frozen;
            Registry contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
            PrimaryLevelData primaryLevelData = null;
            if (levelStorageAccess2.hasWorldData()) {
                Dynamic dataTag2 = levelStorageAccess2.getDataTag();
                LevelDataAndDimensions levelDataAndDimensions = LevelStorageSource.getLevelDataAndDimensions((Dynamic)dataTag2, (WorldDataConfiguration)context.dataConfiguration(), (Registry)contextLevelStemRegistry, (HolderLookup.Provider)context.datapackWorldgen());
                WorldData worldData = levelDataAndDimensions.worldData();
                Intrinsics.checkNotNull(worldData, "null cannot be cast to non-null type net.minecraft.world.level.storage.PrimaryLevelData");
                primaryLevelData = (PrimaryLevelData)worldData;
                RegistryAccess.Frozen frozen2 = levelDataAndDimensions.dimensions().dimensionsRegistryAccess();
                Intrinsics.checkNotNullExpressionValue(frozen2, "dimensionsRegistryAccess(...)");
                registryAccess = frozen2;
            } else {
                Long l = seed;
                long actualSeed = l != null ? l : System.currentTimeMillis();
                WorldOptions worldOptions = new WorldOptions(actualSeed, true, false);
                generatorSettings = "{}";
                bukkitWorldTypeName = switch (WhenMappings.$EnumSwitchMapping$3[worldType.ordinal()]) {
                    case 1 -> "normal";
                    case 2 -> "flat";
                    case 3 -> "amplified";
                    case 4 -> "large_biomes";
                    case 5 -> "flat";
                    default -> throw new NoWhenBranchMatchedException();
                };
                DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(GsonHelper.parse((String)generatorSettings), bukkitWorldTypeName);
                LevelSettings levelSettings = new LevelSettings(worldName, GameType.SURVIVAL, false, Difficulty.EASY, false, new GameRules(context.dataConfiguration().enabledFeatures()), context.dataConfiguration());
                WorldDimensions worldDimensions = properties.create(context.datapackWorldgen());
                WorldDimensions.Complete complete = worldDimensions.bake(contextLevelStemRegistry);
                Lifecycle lifecycle = complete.lifecycle().add(context.datapackWorldgen().allRegistriesLifecycle());
                primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, complete.specialWorldProperty(), lifecycle);
                RegistryAccess.Frozen frozen3 = complete.dimensionsRegistryAccess();
                Intrinsics.checkNotNullExpressionValue(frozen3, "dimensionsRegistryAccess(...)");
                registryAccess = frozen3;
            }
            primaryLevelData.customDimensions = contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
            primaryLevelData.checkName(worldName);
            primaryLevelData.setModdedInfo(console.getServerModName(), console.getModdedStatus().shouldReportAsModified());
            long obfuscatedSeed = BiomeManager.obfuscateSeed((long)primaryLevelData.worldGenOptions().seed());
            if (environment == World.Environment.NORMAL) {
                generatorSettings = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((ServerLevelData)primaryLevelData));
                Intrinsics.checkNotNull(generatorSettings);
                list = (List)((Object)generatorSettings);
            } else {
                generatorSettings = ImmutableList.of();
                Intrinsics.checkNotNull(generatorSettings);
                list = (List)((Object)generatorSettings);
            }
            List spawners = list;
            bukkitWorldTypeName = (LevelStem)contextLevelStemRegistry.getValue(actualDimension);
            if (bukkitWorldTypeName == null) {
                throw new IllegalStateException("Cannot find dimension " + actualDimension + " in registry");
            }
            String customStem = bukkitWorldTypeName;
            WorldInfo worldInfo = (WorldInfo)new CraftWorldInfo(primaryLevelData, levelStorageAccess2, environment, (DimensionType)customStem.type().value(), customStem.generator(), console.registryAccess());
            if (generator != null) {
                biomeProvider = generator.getDefaultBiomeProvider(worldInfo);
            }
            String string = worldName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            ResourceKey worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)Identifier.fromNamespaceAndPath((String)"playerworldmanager", (String)string));
            ServerLevel serverLevel = new ServerLevel((MinecraftServer)console, console.executor, levelStorageAccess2, primaryLevelData, worldKey, (LevelStem)customStem, primaryLevelData.isDebugWorld(), obfuscatedSeed, spawners, true, console.overworld().getRandomSequences(), environment, generator, biomeProvider);
            console.addLevel(serverLevel);
            console.initWorld(serverLevel, primaryLevelData, primaryLevelData.worldGenOptions());
            serverLevel.setSpawnSettings(true);
            console.prepareLevel(serverLevel);
            CraftWorld craftWorld = serverLevel.getWorld();
            Intrinsics.checkNotNull(craftWorld, "null cannot be cast to non-null type org.bukkit.craftbukkit.CraftWorld");
            CraftWorld craftWorld2 = craftWorld;
            this.logger.info("[WorldManager] createDimension: Successfully created dimension '" + worldName + "' using NMS");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName), TuplesKt.to("bukkitWorldName", craftWorld2.getName())};
            this.debugLogger.debug("Dimension created successfully via NMS", pairArray2);
            this.debugLogger.debugMethodExit("createDimension", craftWorld2.getName());
            return (World)craftWorld2;
        }
        catch (Exception e) {
            this.logger.severe("[WorldManager] createDimension: Failed to create dimension " + worldName + ": " + e.getMessage());
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", worldName), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Dimension creation failed", pairArray3);
            this.debugLogger.debugMethodExit("createDimension", null);
            e.printStackTrace();
            return null;
        }
    }

    private final boolean unloadDimensionNMS(World world, boolean save) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("save", save)};
        this.debugLogger.debugMethodEntry("unloadDimensionNMS", pairArray);
        try {
            Intrinsics.checkNotNull(world, "null cannot be cast to non-null type org.bukkit.craftbukkit.CraftWorld");
            CraftWorld craftWorld = (CraftWorld)world;
            ServerLevel serverLevel = craftWorld.getHandle();
            Server server = Bukkit.getServer();
            Intrinsics.checkNotNull(server, "null cannot be cast to non-null type org.bukkit.craftbukkit.CraftServer");
            DedicatedServer console = ((CraftServer)server).getServer();
            if (serverLevel == console.overworld() || serverLevel == console.getLevel(Level.NETHER) || serverLevel == console.getLevel(Level.END)) {
                this.logger.warning("[WorldManager] unloadDimensionNMS: Cannot unload main world '" + ((CraftWorld)world).getName() + "'");
                this.debugLogger.debugMethodExit("unloadDimensionNMS", false);
                return false;
            }
            this.logger.info("[WorldManager] unloadDimensionNMS: Removing world '" + ((CraftWorld)world).getName() + "' from server (Folia mode - no chunk save)");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", ((CraftWorld)world).getName())};
            this.debugLogger.debug("Removing from server levels map", pairArray2);
            console.removeLevel(serverLevel);
            try {
                pairArray2 = new Pair[]{TuplesKt.to("worldName", ((CraftWorld)world).getName())};
                this.debugLogger.debug("Closing level storage access", pairArray2);
                serverLevel.levelStorageAccess.close();
            }
            catch (Exception e) {
                this.logger.warning("[WorldManager] unloadDimensionNMS: Could not close level storage for '" + ((CraftWorld)world).getName() + "': " + e.getMessage());
            }
            this.logger.info("[WorldManager] unloadDimensionNMS: Removed dimension '" + ((CraftWorld)world).getName() + "' from server");
            this.debugLogger.debugMethodExit("unloadDimensionNMS", true);
            return true;
        }
        catch (Exception e) {
            this.logger.severe("[WorldManager] unloadDimensionNMS: Failed to unload dimension " + world.getName() + ": " + e.getMessage());
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Dimension unload failed", pairArray3);
            this.debugLogger.debugMethodExit("unloadDimensionNMS", false);
            e.printStackTrace();
            return false;
        }
    }

    private final World createOrLoadDimension(String worldName, World.Environment environment, WorldType worldType, Long seed) {
        World result;
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", worldName), TuplesKt.to("environment", environment), TuplesKt.to("worldType", worldType), TuplesKt.to("seed", seed)};
        this.debugLogger.debugMethodEntry("createOrLoadDimension", pairArray);
        File worldFolder = new File(this.plugin.getServer().getWorldContainer(), worldName);
        boolean folderExists = worldFolder.exists();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("folderPath", worldFolder.getAbsolutePath()), TuplesKt.to("exists", folderExists)};
        this.debugLogger.debug("World folder check", pairArray2);
        if (folderExists) {
            this.logger.info("[WorldManager] createOrLoadDimension: Loading existing world '" + worldName + "'");
            this.debugLogger.debug("Loading existing world folder");
        } else {
            this.logger.info("[WorldManager] createOrLoadDimension: Creating new world '" + worldName + "'");
            this.debugLogger.debug("Creating new world (folder does not exist)");
        }
        this.debugLogger.debug("Delegating to createDimension");
        World world = result = this.createDimension(worldName, environment, worldType, seed);
        this.debugLogger.debugMethodExit("createOrLoadDimension", world != null ? world.getName() : null);
        return result;
    }

    private final void deleteDirectory(File directory) {
        if (!directory.exists()) {
            return;
        }
        if (directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull(file);
                    this.deleteDirectory(file);
                }
            }
        }
        directory.delete();
    }

    private final void addPendingDeletions(List<String> worldNames) {
        try {
            Set existingDeletions = this.pendingDeletionsFile.exists() ? CollectionsKt.toMutableSet(FilesKt.readLines$default(this.pendingDeletionsFile, null, 1, null)) : (Set)new LinkedHashSet();
            existingDeletions.addAll((Collection)worldNames);
            FilesKt.writeText$default(this.pendingDeletionsFile, CollectionsKt.joinToString$default(existingDeletions, "\n", null, null, 0, null, null, 62, null), null, 2, null);
            this.logger.info("[WorldManager] addPendingDeletions: Added " + worldNames.size() + " worlds to pending deletions list");
        }
        catch (Exception e) {
            this.logger.severe("[WorldManager] addPendingDeletions: Failed to write pending deletions: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final void markWorldForCleanup(PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("ownerName", world.getOwnerName())};
        this.debugLogger.debugMethodEntry("markWorldForCleanup", pairArray);
        this.worldsToCleanup.add(world);
        pairArray = new Pair[]{TuplesKt.to("cleanupListSize", this.worldsToCleanup.size())};
        this.debugLogger.debug("World added to cleanup list", pairArray);
        this.logger.warning("[WorldManager] markWorldForCleanup: World '" + world.getName() + "' (owner: " + world.getOwnerName() + ") marked for cleanup - folder missing");
        DebugLogger.debugMethodExit$default(this.debugLogger, "markWorldForCleanup", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void processCleanupList() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("cleanupListSize", this.worldsToCleanup.size())};
        this.debugLogger.debugMethodEntry("processCleanupList", pairArray);
        if (this.worldsToCleanup.isEmpty()) {
            this.logger.info("[WorldManager] processCleanupList: No orphaned worlds to clean up");
            this.debugLogger.debug("Cleanup list is empty, nothing to process");
            DebugLogger.debugMethodExit$default(this.debugLogger, "processCleanupList", null, 2, null);
            return;
        }
        this.logger.info("[WorldManager] processCleanupList: Processing " + this.worldsToCleanup.size() + " orphaned world(s)");
        pairArray = new Pair[1];
        Iterable iterable = this.worldsToCleanup;
        String string = "worldNames";
        int n = 0;
        Pair[] pairArray2 = pairArray;
        String string2 = "Processing orphaned worlds";
        DebugLogger debugLogger = this.debugLogger;
        boolean $i$f$map = false;
        void var4_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to(string, collection);
        debugLogger.debug(string2, pairArray);
        Iterable $this$forEach$iv = this.worldsToCleanup;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            try {
                this.dataManager.deleteWorld(world.getId());
                PlayerData playerData = this.dataManager.loadPlayerData(world.getOwnerUuid());
                if (playerData != null) {
                    playerData.getOwnedWorlds().remove(world.getId());
                    this.dataManager.savePlayerData(playerData);
                }
                this.logger.info("[WorldManager] processCleanupList: Removed orphaned world '" + world.getName() + "' (owner: " + world.getOwnerName() + ") from database");
            }
            catch (Exception e) {
                this.logger.severe("[WorldManager] processCleanupList: Failed to clean up world '" + world.getName() + "': " + e.getMessage());
                e.printStackTrace();
            }
        }
        int cleanedCount = this.worldsToCleanup.size();
        this.logger.info("[WorldManager] processCleanupList: Cleanup complete - removed " + cleanedCount + " orphaned world(s)");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("cleanedCount", cleanedCount)};
        this.debugLogger.debug("Cleanup complete", pairArray3);
        this.worldsToCleanup.clear();
        DebugLogger.debugMethodExit$default(this.debugLogger, "processCleanupList", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void processPendingDeletions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("pendingDeletionsFile", this.pendingDeletionsFile.getAbsolutePath())};
        this.debugLogger.debugMethodEntry("processPendingDeletions", pairArray);
        if (!this.pendingDeletionsFile.exists()) {
            this.logger.info("[WorldManager] processPendingDeletions: No pending deletions file found");
            this.debugLogger.debug("Pending deletions file does not exist");
            DebugLogger.debugMethodExit$default(this.debugLogger, "processPendingDeletions", null, 2, null);
            return;
        }
        this.debugLogger.debug("Pending deletions file exists");
        try {
            void $this$filterTo$iv$iv;
            Pair[] $this$filter$iv = (Pair[])FilesKt.readLines$default(this.pendingDeletionsFile, null, 1, null);
            boolean $i$f$filter = false;
            Pair[] pairArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank(it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List worldNames = (List)destination$iv$iv;
            if (worldNames.isEmpty()) {
                this.logger.info("[WorldManager] processPendingDeletions: Pending deletions file is empty");
                this.pendingDeletionsFile.delete();
                return;
            }
            this.logger.info("[WorldManager] processPendingDeletions: Found " + worldNames.size() + " worlds pending deletion");
            File file = this.plugin.getServer().getWorldContainer();
            Intrinsics.checkNotNullExpressionValue(file, "getWorldContainer(...)");
            File serverFolder = file;
            int deletedCount = 0;
            Iterable $this$forEach$iv = worldNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String worldName = (String)element$iv;
                boolean bl = false;
                File worldFolder = new File(serverFolder, worldName);
                if (worldFolder.exists()) {
                    try {
                        this.deleteDirectory(worldFolder);
                        this.logger.info("[WorldManager] processPendingDeletions: Deleted world folder: " + worldName);
                        ++deletedCount;
                    }
                    catch (Exception e) {
                        this.logger.warning("[WorldManager] processPendingDeletions: Failed to delete world folder " + worldName + ": " + e.getMessage());
                    }
                    continue;
                }
                this.logger.info("[WorldManager] processPendingDeletions: World folder " + worldName + " already deleted");
            }
            this.pendingDeletionsFile.delete();
            this.debugLogger.debug("Cleared pending deletions file");
            this.logger.info("[WorldManager] processPendingDeletions: Completed - deleted " + deletedCount + " of " + worldNames.size() + " world folders");
            pairArray2 = new Pair[]{TuplesKt.to("deletedCount", deletedCount), TuplesKt.to("totalPending", worldNames.size())};
            this.debugLogger.debug("Pending deletions processing complete", pairArray2);
            DebugLogger.debugMethodExit$default(this.debugLogger, "processPendingDeletions", null, 2, null);
        }
        catch (Exception e) {
            this.logger.severe("[WorldManager] processPendingDeletions: Error processing pending deletions: " + e.getMessage());
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Error processing pending deletions", pairArray3);
            this.debugLogger.debugMethodExit("processPendingDeletions", "error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static final void createWorld$lambda$4(WorldManager this$0, PlayerWorld $playerWorld, WorldType $worldType, Long $seed, CompletableFuture $future, Player $owner, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($playerWorld, "$playerWorld");
        Intrinsics.checkNotNullParameter((Object)$worldType, "$worldType");
        Intrinsics.checkNotNullParameter($future, "$future");
        Intrinsics.checkNotNullParameter($owner, "$owner");
        try {
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $playerWorld.getName())};
            this$0.debugLogger.debug("GlobalRegionScheduler task started for world creation", pairArray);
            this$0.logger.info("[WorldManager] createWorld: Creating overworld dimension for '" + $playerWorld.getName() + "'");
            String overworldName = this$0.getWorldName($playerWorld, World.Environment.NORMAL);
            World overworld = this$0.createDimension(overworldName, World.Environment.NORMAL, $worldType, $seed);
            if (overworld == null) {
                this$0.logger.severe("[WorldManager] createWorld: Failed to create overworld for '" + $playerWorld.getName() + "'");
                $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new RuntimeException("Failed to create overworld")))));
                return;
            }
            this$0.logger.info("[WorldManager] createWorld: Successfully created overworld '" + overworldName + "'");
            Location location = overworld.getSpawnLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getSpawnLocation(...)");
            Location spawnLocation = location;
            $playerWorld.setSpawnLocation(SimpleLocationKt.toSimpleLocation(spawnLocation));
            this$0.logger.info("[WorldManager] createWorld: Set spawn location for '" + $playerWorld.getName() + "' at " + spawnLocation.getX() + ", " + spawnLocation.getY() + ", " + spawnLocation.getZ());
            this$0.logger.info("[WorldManager] createWorld: Creating nether dimension for '" + $playerWorld.getName() + "'");
            String netherName = this$0.getWorldName($playerWorld, World.Environment.NETHER);
            World nether = this$0.createDimension(netherName, World.Environment.NETHER, $worldType, $seed);
            if (nether == null) {
                this$0.logger.warning("[WorldManager] createWorld: Failed to create nether dimension for " + $playerWorld.getName());
            } else {
                this$0.logger.info("[WorldManager] createWorld: Successfully created nether '" + netherName + "'");
            }
            this$0.logger.info("[WorldManager] createWorld: Creating end dimension for '" + $playerWorld.getName() + "'");
            String endName = this$0.getWorldName($playerWorld, World.Environment.THE_END);
            World end = this$0.createDimension(endName, World.Environment.THE_END, $worldType, $seed);
            if (end == null) {
                this$0.logger.warning("[WorldManager] createWorld: Failed to create end dimension for " + $playerWorld.getName());
            } else {
                this$0.logger.info("[WorldManager] createWorld: Successfully created end '" + endName + "'");
            }
            this$0.dataManager.saveWorld($playerWorld);
            DataManager dataManager = this$0.dataManager;
            UUID uUID = $owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            String string = $owner.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            PlayerData playerData = dataManager.getOrCreatePlayerData(uUID, string);
            playerData.getOwnedWorlds().add($playerWorld.getId());
            this$0.dataManager.savePlayerData(playerData);
            this$0.logger.info("[WorldManager] createWorld: Added world '" + $playerWorld.getName() + "' to player '" + $owner.getName() + "' owned worlds list");
            this$0.applyWorldSettings($playerWorld);
            this$0.logger.info("[WorldManager] createWorld: Successfully created world '" + $playerWorld.getName() + "' for " + $owner.getName());
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", $playerWorld.getName()), TuplesKt.to("worldId", $playerWorld.getId()), TuplesKt.to("owner", $owner.getName())};
            this$0.debugLogger.debug("World creation successful", pairArray2);
            this$0.debugLogger.debugMethodExit("createWorld", "success: " + $playerWorld.getId());
            $future.complete(Result.box-impl(Result.constructor-impl($playerWorld)));
        }
        catch (Exception e) {
            this$0.logger.severe("[WorldManager] createWorld: Error creating world '" + $playerWorld.getName() + "': " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $playerWorld.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this$0.debugLogger.debug("World creation failed with exception", pairArray);
            this$0.debugLogger.debugMethodExit("createWorld", "failure: " + e.getMessage());
            e.printStackTrace();
            $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(e))));
        }
    }

    private static final void deleteWorld$lambda$8$lambda$7$lambda$6(WorldManager this$0, PlayerWorld $world, CompletableFuture $future, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($future, "$future");
        try {
            this$0.logger.info("[WorldManager] deleteWorld: Skipping world unload (not supported on Folia)");
            this$0.logger.info("[WorldManager] deleteWorld: World will remain loaded until server restart");
            this$0.logger.info("[WorldManager] deleteWorld: Marking world '" + $world.getName() + "' for deletion");
            List worldNames = new ArrayList();
            for (World.Environment environment : EntriesMappings.entries$0) {
                String worldName = this$0.getWorldName($world, environment);
                worldNames.add(worldName);
                this$0.deletedWorldNames.add(worldName);
            }
            this$0.addPendingDeletions(worldNames);
            this$0.logger.info("[WorldManager] deleteWorld: Added " + worldNames.size() + " dimension names to deletedWorldNames set");
            this$0.logger.info("[WorldManager] deleteWorld: Deleting world folders from disk for '" + $world.getName() + "'");
            File file = this$0.plugin.getServer().getWorldContainer();
            Intrinsics.checkNotNullExpressionValue(file, "getWorldContainer(...)");
            File serverFolder = file;
            for (World.Environment env : EntriesMappings.entries$0) {
                String worldName = this$0.getWorldName($world, env);
                File worldFolder = new File(serverFolder, worldName);
                if (worldFolder.exists()) {
                    this$0.deleteDirectory(worldFolder);
                    this$0.logger.info("[WorldManager] deleteWorld: Deleted world folder: " + worldName);
                    continue;
                }
                this$0.logger.info("[WorldManager] deleteWorld: World folder " + worldName + " does not exist, skipping deletion");
            }
            this$0.dataManager.deleteWorld($world.getId());
            PlayerData playerData = this$0.dataManager.loadPlayerData($world.getOwnerUuid());
            if (playerData != null) {
                playerData.getOwnedWorlds().remove($world.getId());
                this$0.dataManager.savePlayerData(playerData);
                this$0.logger.info("[WorldManager] deleteWorld: Removed world '" + $world.getName() + "' from player '" + $world.getOwnerName() + "' owned worlds list");
            } else {
                this$0.logger.warning("[WorldManager] deleteWorld: Could not load player data for owner UUID: " + $world.getOwnerUuid());
            }
            String baseWorldName = this$0.getWorldName($world, World.Environment.NORMAL);
            this$0.worldStateManager.clearAllWorldStates(baseWorldName);
            this$0.logger.info("[WorldManager] deleteWorld: Cleared all player world states for '" + $world.getName() + "'");
            this$0.logger.info("[WorldManager] deleteWorld: Successfully deleted world '" + $world.getName() + "' (owner: " + $world.getOwnerName() + ")");
            this$0.logger.info("[WorldManager] deleteWorld: Note: World remains in memory until server restart");
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("worldId", $world.getId())};
            this$0.debugLogger.debug("World deletion successful", pairArray);
            this$0.debugLogger.debugMethodExit("deleteWorld", "success");
            $future.complete(Result.box-impl(Result.constructor-impl(Unit.INSTANCE)));
        }
        catch (Exception e) {
            this$0.logger.severe("[WorldManager] deleteWorld: Error deleting world '" + $world.getName() + "': " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this$0.debugLogger.debug("World deletion failed with exception", pairArray);
            this$0.debugLogger.debugMethodExit("deleteWorld", "failure: " + e.getMessage());
            e.printStackTrace();
            $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(e))));
        }
    }

    private static final void deleteWorld$lambda$8$lambda$7(WorldManager this$0, PlayerWorld $world, CompletableFuture $future) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($future, "$future");
        this$0.logger.info("[WorldManager] deleteWorld: All players teleported, proceeding with world deletion");
        Bukkit.getGlobalRegionScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManager.deleteWorld$lambda$8$lambda$7$lambda$6(this$0, $world, $future, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void deleteWorld$lambda$8(WorldManager this$0, CompletableFuture $future, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($future, "$future");
        Intrinsics.checkNotNullParameter($world, "$world");
        try {
            void $this$mapTo$iv$iv;
            List list = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
            World defaultWorld = (World)CollectionsKt.firstOrNull(list);
            if (defaultWorld == null) {
                this$0.logger.severe("[WorldManager] deleteWorld: No default world found for teleporting players");
                $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new RuntimeException("No default world found")))));
                return;
            }
            this$0.logger.info("[WorldManager] deleteWorld: Preparing to teleport players from world '" + $world.getName() + "' to default spawn");
            List playersToTeleport = new ArrayList();
            for (World.Environment env : EntriesMappings.entries$0) {
                World bukkitWorld = this$0.getBukkitWorld($world, env);
                if (bukkitWorld == null) continue;
                List list2 = bukkitWorld.getPlayers();
                Intrinsics.checkNotNullExpressionValue(list2, "getPlayers(...)");
                playersToTeleport.addAll(list2);
            }
            this$0.logger.info("[WorldManager] deleteWorld: Found " + playersToTeleport.size() + " player(s) to teleport from world '" + $world.getName() + "'");
            Iterable $this$map$iv = playersToTeleport;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void player;
                Player player2 = (Player)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                this$0.logger.info("[WorldManager] deleteWorld: Teleporting player '" + player.getName() + "' from '" + $world.getName() + "' to default spawn with state restore");
                collection.add(this$0.teleportToVanillaWorld((Player)player));
            }
            List teleportFutures = (List)destination$iv$iv;
            int playerCount = playersToTeleport.size();
            Collection $this$toTypedArray$iv = teleportFutures;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenRun(() -> WorldManager.deleteWorld$lambda$8$lambda$7(this$0, $world, $future));
        }
        catch (Exception e) {
            this$0.logger.severe("[WorldManager] deleteWorld: Error in initial deletion phase for world '" + $world.getName() + "': " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this$0.debugLogger.debug("World deletion initial phase failed", pairArray);
            this$0.debugLogger.debugMethodExit("deleteWorld", "failure: " + e.getMessage());
            e.printStackTrace();
            $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(e))));
        }
    }

    private static final void loadWorld$lambda$9(WorldManager this$0, String $overworldName, PlayerWorld $world, CompletableFuture $future, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($overworldName, "$overworldName");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($future, "$future");
        try {
            boolean success = true;
            this$0.logger.info("[WorldManager] loadWorld: Loading overworld dimension '" + $overworldName + "'");
            if (Bukkit.getWorld((String)$overworldName) == null) {
                World overworld = this$0.createOrLoadDimension($overworldName, World.Environment.NORMAL, $world.getWorldType(), $world.getSeed());
                if (overworld == null) {
                    this$0.logger.warning("[WorldManager] loadWorld: Failed to load overworld: " + $overworldName);
                    success = false;
                } else {
                    this$0.logger.info("[WorldManager] loadWorld: Successfully loaded overworld '" + $overworldName + "'");
                }
            } else {
                this$0.logger.info("[WorldManager] loadWorld: Overworld '" + $overworldName + "' already loaded");
            }
            String netherName = this$0.getWorldName($world, World.Environment.NETHER);
            File netherFolder = new File(this$0.plugin.getServer().getWorldContainer(), netherName);
            if (netherFolder.exists()) {
                this$0.logger.info("[WorldManager] loadWorld: Loading nether dimension '" + netherName + "'");
                if (Bukkit.getWorld((String)netherName) == null) {
                    World nether = this$0.createOrLoadDimension(netherName, World.Environment.NETHER, $world.getWorldType(), $world.getSeed());
                    if (nether == null) {
                        this$0.logger.warning("[WorldManager] loadWorld: Failed to load nether: " + netherName);
                    } else {
                        this$0.logger.info("[WorldManager] loadWorld: Successfully loaded nether '" + netherName + "'");
                    }
                } else {
                    this$0.logger.info("[WorldManager] loadWorld: Nether '" + netherName + "' already loaded");
                }
            } else {
                this$0.logger.info("[WorldManager] loadWorld: Nether folder '" + netherName + "' does not exist, skipping");
            }
            String endName = this$0.getWorldName($world, World.Environment.THE_END);
            File endFolder = new File(this$0.plugin.getServer().getWorldContainer(), endName);
            if (endFolder.exists()) {
                this$0.logger.info("[WorldManager] loadWorld: Loading end dimension '" + endName + "'");
                if (Bukkit.getWorld((String)endName) == null) {
                    World end = this$0.createOrLoadDimension(endName, World.Environment.THE_END, $world.getWorldType(), $world.getSeed());
                    if (end == null) {
                        this$0.logger.warning("[WorldManager] loadWorld: Failed to load end: " + endName);
                    } else {
                        this$0.logger.info("[WorldManager] loadWorld: Successfully loaded end '" + endName + "'");
                    }
                } else {
                    this$0.logger.info("[WorldManager] loadWorld: End '" + endName + "' already loaded");
                }
            } else {
                this$0.logger.info("[WorldManager] loadWorld: End folder '" + endName + "' does not exist, skipping");
            }
            if (success) {
                this$0.logger.info("[WorldManager] loadWorld: Applying world settings for '" + $world.getName() + "'");
                this$0.applyWorldSettings($world);
            }
            this$0.logger.info("[WorldManager] loadWorld: Load complete for world '" + $world.getName() + "' - Success: " + success);
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("success", success)};
            this$0.debugLogger.debug("World load complete", pairArray);
            this$0.debugLogger.debugMethodExit("loadWorld", success);
            $future.complete(success);
        }
        catch (Exception e) {
            this$0.logger.severe("[WorldManager] loadWorld: Error loading world " + $world.getName() + ": " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this$0.debugLogger.debug("World load failed with exception", pairArray);
            this$0.debugLogger.debugMethodExit("loadWorld", false);
            e.printStackTrace();
            $future.complete(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void unloadWorld$lambda$12(WorldManager this$0, PlayerWorld $world, CompletableFuture $future, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($future, "$future");
        try {
            boolean success = true;
            Object object = new Pair[]{TuplesKt.to("worldName", $world.getName())};
            this$0.debugLogger.debug("GlobalRegionScheduler task started for world unload", (Pair<String, ? extends Object>)object);
            for (World.Environment env : EntriesMappings.entries$0) {
                String worldName = this$0.getWorldName($world, env);
                World bukkitWorld = Bukkit.getWorld((String)worldName);
                Pair[] pairArray = new Pair[]{TuplesKt.to("environment", env), TuplesKt.to("worldName", worldName), TuplesKt.to("isLoaded", bukkitWorld != null)};
                this$0.debugLogger.debug("Checking dimension for unload", pairArray);
                if (bukkitWorld == null) continue;
                List list = Bukkit.getWorlds();
                Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
                World defaultWorld = (World)CollectionsKt.firstOrNull(list);
                int playerCount = bukkitWorld.getPlayers().size();
                Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName), TuplesKt.to("playerCount", playerCount)};
                this$0.debugLogger.debug("Players in dimension", pairArray2);
                if (defaultWorld != null) {
                    List list2 = bukkitWorld.getPlayers();
                    Intrinsics.checkNotNullExpressionValue(list2, "getPlayers(...)");
                    if (!((Collection)list2).isEmpty()) {
                        Player it;
                        Collection<String> collection;
                        Iterable $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        DebugLogger debugLogger = this$0.debugLogger;
                        pairArray2 = new Pair[2];
                        List list3 = bukkitWorld.getPlayers();
                        Intrinsics.checkNotNullExpressionValue(list3, "getPlayers(...)");
                        Object[] objectArray = (CompletableFuture[])list3;
                        String string = "playerNames";
                        int n = 0;
                        Pair[] pairArray3 = pairArray2;
                        String string2 = "Teleporting players out of dimension";
                        Object object2 = debugLogger;
                        boolean $i$f$map = false;
                        void var14_18 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            Player player = (Player)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getName());
                        }
                        collection = (List)destination$iv$iv;
                        pairArray3[n] = TuplesKt.to(string, collection);
                        pairArray2[1] = TuplesKt.to("destination", defaultWorld.getName());
                        ((DebugLogger)object2).debug(string2, pairArray2);
                        List list4 = bukkitWorld.getPlayers();
                        Intrinsics.checkNotNullExpressionValue(list4, "getPlayers(...)");
                        $this$map$iv = list4;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void player;
                            it = (Player)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl = false;
                            object2.add(player.teleportAsync(defaultWorld.getSpawnLocation()));
                        }
                        List teleportFutures = (List)destination$iv$iv;
                        Collection $this$toTypedArray$iv = teleportFutures;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        objectArray = thisCollection$iv.toArray(new CompletableFuture[0]);
                        CompletableFuture.allOf(Arrays.copyOf(objectArray, objectArray.length)).join();
                        objectArray = new Pair[]{TuplesKt.to("worldName", worldName)};
                        this$0.debugLogger.debug("All players teleported from dimension", (Pair<String, ? extends Object>[])objectArray);
                    }
                }
                pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName), TuplesKt.to("withSave", true)};
                this$0.debugLogger.debug("Attempting to unload dimension via NMS", pairArray2);
                if (!this$0.unloadDimensionNMS(bukkitWorld, true)) {
                    this$0.logger.warning("Failed to unload world: " + worldName);
                    pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName)};
                    this$0.debugLogger.debug("Dimension unload failed", pairArray2);
                    success = false;
                    continue;
                }
                pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName)};
                this$0.debugLogger.debug("Dimension unloaded successfully", pairArray2);
            }
            object = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("success", success)};
            this$0.debugLogger.debug("World unload complete", (Pair<String, ? extends Object>)object);
            this$0.debugLogger.debugMethodExit("unloadWorld", success);
            $future.complete(success);
        }
        catch (Exception e) {
            this$0.logger.severe("Error unloading world " + $world.getName() + ": " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this$0.debugLogger.debug("World unload failed with exception", pairArray);
            this$0.debugLogger.debugMethodExit("unloadWorld", false);
            e.printStackTrace();
            $future.complete(false);
        }
    }

    private static final void teleportToWorld$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void teleportToVanillaWorld$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void teleportToDimension$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void applyWorldSettings$lambda$18(PlayerWorld $world, WorldManager this$0, World $bukkitWorld, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($bukkitWorld, "$bukkitWorld");
        switch (WhenMappings.$EnumSwitchMapping$1[$world.getTimeLock().ordinal()]) {
            case 1: {
                this$0.logger.info("[WorldManager] applyWorldSettings: Setting time to DAY (locked) for '" + $world.getName() + "'");
                $bukkitWorld.setGameRule(org.bukkit.GameRules.ADVANCE_TIME, (Object)false);
                $bukkitWorld.setTime(6000L);
                break;
            }
            case 2: {
                this$0.logger.info("[WorldManager] applyWorldSettings: Setting time to NIGHT (locked) for '" + $world.getName() + "'");
                $bukkitWorld.setGameRule(org.bukkit.GameRules.ADVANCE_TIME, (Object)false);
                $bukkitWorld.setTime(18000L);
                break;
            }
            case 3: {
                this$0.logger.info("[WorldManager] applyWorldSettings: Enabling time CYCLE for '" + $world.getName() + "'");
                $bukkitWorld.setGameRule(org.bukkit.GameRules.ADVANCE_TIME, (Object)true);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$2[$world.getWeatherLock().ordinal()]) {
            case 1: {
                this$0.logger.info("[WorldManager] applyWorldSettings: Setting weather to CLEAR (locked) for '" + $world.getName() + "'");
                $bukkitWorld.setGameRule(org.bukkit.GameRules.ADVANCE_WEATHER, (Object)false);
                $bukkitWorld.setStorm(false);
                $bukkitWorld.setThundering(false);
                break;
            }
            case 2: {
                this$0.logger.info("[WorldManager] applyWorldSettings: Setting weather to RAIN (locked) for '" + $world.getName() + "'");
                $bukkitWorld.setGameRule(org.bukkit.GameRules.ADVANCE_WEATHER, (Object)false);
                $bukkitWorld.setStorm(true);
                $bukkitWorld.setThundering(false);
                break;
            }
            case 3: {
                this$0.logger.info("[WorldManager] applyWorldSettings: Enabling weather CYCLE for '" + $world.getName() + "'");
                $bukkitWorld.setGameRule(org.bukkit.GameRules.ADVANCE_WEATHER, (Object)true);
            }
        }
        this$0.applyWorldBorder($world, $bukkitWorld);
        this$0.logger.info("[WorldManager] applyWorldSettings: Successfully applied settings to world '" + $world.getName() + "'");
    }

    public static final /* synthetic */ Logger access$getLogger$p(WorldManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ WorldUnloadManager access$getWorldUnloadManager$p(WorldManager $this) {
        return $this.worldUnloadManager;
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(WorldManager $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(WorldManager $this) {
        return $this.debugLogger;
    }

    public static final /* synthetic */ WorldStateManager access$getWorldStateManager$p(WorldManager $this) {
        return $this.worldStateManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltech/bedson/playerworldmanager/managers/WorldManager$Companion;", "", "()V", "END_SUFFIX", "", "NETHER_SUFFIX", "PlayerWorldManager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<World.Environment> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])World.Environment.values()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[World.Environment.values().length];
            try {
                nArray[World.Environment.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.NETHER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.THE_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.CUSTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TimeLock.values().length];
            try {
                nArray[TimeLock.DAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeLock.NIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeLock.CYCLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WeatherLock.values().length];
            try {
                nArray[WeatherLock.CLEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeatherLock.RAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeatherLock.CYCLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[WorldType.values().length];
            try {
                nArray[WorldType.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldType.FLAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldType.AMPLIFIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldType.LARGE_BIOMES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldType.VOID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

