/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.MapsKt;
import tech.bedson.playerworldmanager.libs.kotlin.io.FilesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerStatistics;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldStatistics;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0013J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010#\u001a\u00020\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0016\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u0016\u0010&\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u0016\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J \u0010(\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\b\b\u0002\u0010)\u001a\u00020*J\u0016\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u001e\u0010,\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u0016\u00100\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013J\u0006\u00102\u001a\u00020\u0016J\u000e\u00103\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\u0016\u00104\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Ltech/bedson/playerworldmanager/managers/StatsManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/managers/WorldManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "gson", "Lcom/google/gson/Gson;", "logger", "Ljava/util/logging/Logger;", "statsFolder", "Ljava/io/File;", "worldStats", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ltech/bedson/playerworldmanager/models/WorldStatistics;", "deleteWorldStats", "", "worldId", "endPlayerSession", "playerUuid", "getAllWorldStats", "", "getPlayerStats", "Ltech/bedson/playerworldmanager/models/PlayerStatistics;", "getWorldIdFromBukkitWorld", "bukkitWorld", "Lorg/bukkit/World;", "getWorldStats", "getWorldStatsByBukkitWorld", "loadAll", "loadWorldStats", "recordAnimalKilled", "recordBlockBroken", "recordBlockPlaced", "recordItemCrafted", "amount", "", "recordMobKilled", "recordPlayTime", "durationMs", "", "recordPlayerDeath", "recordPlayerKill", "killerUuid", "saveAll", "saveWorldStats", "startPlayerSession", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nStatsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsManager.kt\ntech/bedson/playerworldmanager/managers/StatsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,335:1\n1855#2,2:336\n1855#2,2:341\n3792#3:338\n4307#3,2:339\n*S KotlinDebug\n*F\n+ 1 StatsManager.kt\ntech/bedson/playerworldmanager/managers/StatsManager\n*L\n279#1:336,2\n297#1:341,2\n293#1:338\n293#1:339,2\n*E\n"})
public final class StatsManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final Gson gson;
    @NotNull
    private final File statsFolder;
    @NotNull
    private final ConcurrentHashMap<UUID, WorldStatistics> worldStats;

    public StatsManager(@NotNull JavaPlugin plugin, @NotNull DataManager dataManager, @NotNull WorldManager worldManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.worldManager = worldManager;
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
        this.debugLogger = new DebugLogger(this.plugin, "StatsManager");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        this.gson = gson;
        this.statsFolder = new File(this.plugin.getDataFolder(), "stats");
        this.worldStats = new ConcurrentHashMap();
        this.statsFolder.mkdirs();
    }

    @NotNull
    public final WorldStatistics getWorldStats(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Object object = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("getWorldStats", (Pair<String, ? extends Object>)object);
        object = this.worldStats.get(worldId);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
            this.debugLogger.debug("Cache hit", pairArray);
            this.debugLogger.debugMethodExit("getWorldStats", "cached");
            return it;
        }
        WorldStatistics worldStatistics = this.loadWorldStats(worldId);
        if (worldStatistics == null) {
            worldStatistics = new WorldStatistics(worldId, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, null, 1022, null);
        }
        WorldStatistics stats = worldStatistics;
        ((Map)this.worldStats).put(worldId, stats);
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("isNew", stats.getBlocksPlaced() == 0L)};
        this.debugLogger.debug("Stats loaded/created", pairArray);
        this.debugLogger.debugMethodExit("getWorldStats", stats.toDebugString());
        return stats;
    }

    @Nullable
    public final WorldStatistics getWorldStatsByBukkitWorld(@NotNull World bukkitWorld) {
        Intrinsics.checkNotNullParameter(bukkitWorld, "bukkitWorld");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", bukkitWorld.getName())};
        this.debugLogger.debugMethodEntry("getWorldStatsByBukkitWorld", pairArray);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(bukkitWorld);
        if (playerWorld == null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", bukkitWorld.getName())};
            this.debugLogger.debug("No PlayerWorld found for Bukkit world", pairArray2);
            this.debugLogger.debugMethodExit("getWorldStatsByBukkitWorld", null);
            return null;
        }
        WorldStatistics stats = this.getWorldStats(playerWorld.getId());
        this.debugLogger.debugMethodExit("getWorldStatsByBukkitWorld", stats.toDebugString());
        return stats;
    }

    @Nullable
    public final UUID getWorldIdFromBukkitWorld(@NotNull World bukkitWorld) {
        Intrinsics.checkNotNullParameter(bukkitWorld, "bukkitWorld");
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(bukkitWorld);
        return playerWorld != null ? playerWorld.getId() : null;
    }

    @NotNull
    public final PlayerStatistics getPlayerStats(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("getPlayerStats", pairArray);
        WorldStatistics worldStats = this.getWorldStats(worldId);
        PlayerStatistics playerStats = worldStats.getOrCreatePlayerStats(playerUuid);
        this.debugLogger.debugMethodExit("getPlayerStats", playerStats.toDebugString());
        return playerStats;
    }

    public final void recordBlockPlaced(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("recordBlockPlaced", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        long l = stats.getBlocksPlaced();
        stats.setBlocksPlaced(l + 1L);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(playerUuid);
        long l2 = pairArray2.getBlocksPlaced();
        pairArray2.setBlocksPlaced(l2 + 1L);
        pairArray2 = new Pair[]{TuplesKt.to("totalBlocksPlaced", stats.getBlocksPlaced())};
        this.debugLogger.debug("Block placed recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordBlockPlaced", null, 2, null);
    }

    public final void recordBlockBroken(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("recordBlockBroken", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        long l = stats.getBlocksBroken();
        stats.setBlocksBroken(l + 1L);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(playerUuid);
        long l2 = pairArray2.getBlocksBroken();
        pairArray2.setBlocksBroken(l2 + 1L);
        pairArray2 = new Pair[]{TuplesKt.to("totalBlocksBroken", stats.getBlocksBroken())};
        this.debugLogger.debug("Block broken recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordBlockBroken", null, 2, null);
    }

    public final void recordMobKilled(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("recordMobKilled", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        long l = stats.getMobsKilled();
        stats.setMobsKilled(l + 1L);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(playerUuid);
        long l2 = pairArray2.getMobsKilled();
        pairArray2.setMobsKilled(l2 + 1L);
        pairArray2 = new Pair[]{TuplesKt.to("totalMobsKilled", stats.getMobsKilled())};
        this.debugLogger.debug("Mob killed recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordMobKilled", null, 2, null);
    }

    public final void recordAnimalKilled(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("recordAnimalKilled", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        long l = stats.getAnimalsKilled();
        stats.setAnimalsKilled(l + 1L);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(playerUuid);
        long l2 = pairArray2.getAnimalsKilled();
        pairArray2.setAnimalsKilled(l2 + 1L);
        pairArray2 = new Pair[]{TuplesKt.to("totalAnimalsKilled", stats.getAnimalsKilled())};
        this.debugLogger.debug("Animal killed recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordAnimalKilled", null, 2, null);
    }

    public final void recordPlayerKill(@NotNull UUID worldId, @NotNull UUID killerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(killerUuid, "killerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("killerUuid", killerUuid)};
        this.debugLogger.debugMethodEntry("recordPlayerKill", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        long l = stats.getPlayerKills();
        stats.setPlayerKills(l + 1L);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(killerUuid);
        long l2 = pairArray2.getPlayerKills();
        pairArray2.setPlayerKills(l2 + 1L);
        pairArray2 = new Pair[]{TuplesKt.to("totalPlayerKills", stats.getPlayerKills())};
        this.debugLogger.debug("Player kill recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordPlayerKill", null, 2, null);
    }

    public final void recordPlayerDeath(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("recordPlayerDeath", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        long l = stats.getPlayerDeaths();
        stats.setPlayerDeaths(l + 1L);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(playerUuid);
        long l2 = pairArray2.getDeaths();
        pairArray2.setDeaths(l2 + 1L);
        pairArray2 = new Pair[]{TuplesKt.to("totalPlayerDeaths", stats.getPlayerDeaths())};
        this.debugLogger.debug("Player death recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordPlayerDeath", null, 2, null);
    }

    public final void recordItemCrafted(@NotNull UUID worldId, @NotNull UUID playerUuid, int amount) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("amount", amount)};
        this.debugLogger.debugMethodEntry("recordItemCrafted", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        stats.setItemsCrafted(stats.getItemsCrafted() + (long)amount);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(playerUuid);
        pairArray2.setItemsCrafted(pairArray2.getItemsCrafted() + (long)amount);
        pairArray2 = new Pair[]{TuplesKt.to("totalItemsCrafted", stats.getItemsCrafted())};
        this.debugLogger.debug("Item crafted recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordItemCrafted", null, 2, null);
    }

    public static /* synthetic */ void recordItemCrafted$default(StatsManager statsManager, UUID uUID, UUID uUID2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        statsManager.recordItemCrafted(uUID, uUID2, n);
    }

    public final void recordPlayTime(@NotNull UUID worldId, @NotNull UUID playerUuid, long durationMs) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("durationMs", durationMs)};
        this.debugLogger.debugMethodEntry("recordPlayTime", pairArray);
        WorldStatistics stats = this.getWorldStats(worldId);
        stats.setTimePlayed(stats.getTimePlayed() + durationMs);
        Pair[] pairArray2 = stats.getOrCreatePlayerStats(playerUuid);
        pairArray2.setTimePlayed(pairArray2.getTimePlayed() + durationMs);
        pairArray2 = new Pair[]{TuplesKt.to("totalTimePlayed", stats.getTimePlayed())};
        this.debugLogger.debug("Play time recorded", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "recordPlayTime", null, 2, null);
    }

    public final void startPlayerSession(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("startPlayerSession", pairArray);
        PlayerStatistics playerStats = this.getPlayerStats(worldId, playerUuid);
        playerStats.setLastJoinTime(System.currentTimeMillis());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("lastJoinTime", playerStats.getLastJoinTime())};
        this.debugLogger.debug("Session started", pairArray2);
        DebugLogger.debugMethodExit$default(this.debugLogger, "startPlayerSession", null, 2, null);
    }

    public final void endPlayerSession(@NotNull UUID worldId, @NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("endPlayerSession", pairArray);
        PlayerStatistics playerStats = this.getPlayerStats(worldId, playerUuid);
        if (playerStats.getLastJoinTime() > 0L) {
            long duration = System.currentTimeMillis() - playerStats.getLastJoinTime();
            this.recordPlayTime(worldId, playerUuid, duration);
            playerStats.setLastJoinTime(0L);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("sessionDuration", duration)};
            this.debugLogger.debug("Session ended", pairArray2);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "endPlayerSession", null, 2, null);
    }

    private final WorldStatistics loadWorldStats(UUID worldId) {
        WorldStatistics worldStatistics;
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("loadWorldStats", pairArray);
        File file = new File(this.statsFolder, worldId + ".json");
        if (!file.exists()) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldId", worldId)};
            this.debugLogger.debug("Stats file not found", pairArray2);
            this.debugLogger.debugMethodExit("loadWorldStats", null);
            return null;
        }
        try {
            String json = FilesKt.readText$default(file, null, 1, null);
            WorldStatistics stats = this.gson.fromJson(json, WorldStatistics.class);
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldId", worldId)};
            this.debugLogger.debug("Stats loaded from disk", pairArray3);
            this.debugLogger.debugMethodExit("loadWorldStats", "success");
            worldStatistics = stats;
        }
        catch (Exception e) {
            this.logger.warning("[StatsManager] Failed to load stats for world " + worldId + ": " + e.getMessage());
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("error", e.getMessage())};
            this.debugLogger.debug("Failed to load stats", pairArray4);
            this.debugLogger.debugMethodExit("loadWorldStats", "error");
            worldStatistics = null;
        }
        return worldStatistics;
    }

    public final void saveWorldStats(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("saveWorldStats", pairArray);
        WorldStatistics worldStatistics = this.worldStats.get(worldId);
        if (worldStatistics == null) {
            return;
        }
        WorldStatistics stats = worldStatistics;
        File file = new File(this.statsFolder, worldId + ".json");
        try {
            String string = this.gson.toJson(stats);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            FilesKt.writeText$default(file, string, null, 2, null);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldId", worldId)};
            this.debugLogger.debug("Stats saved to disk", pairArray2);
            this.debugLogger.debugMethodExit("saveWorldStats", "success");
        }
        catch (Exception e) {
            this.logger.severe("[StatsManager] Failed to save stats for world " + worldId + ": " + e.getMessage());
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("error", e.getMessage())};
            this.debugLogger.debug("Failed to save stats", pairArray3);
            this.debugLogger.debugMethodExit("saveWorldStats", "error");
        }
    }

    public final void saveAll() {
        this.debugLogger.debugMethodEntry("saveAll", new Pair[0]);
        this.logger.info("[StatsManager] Saving all statistics (" + this.worldStats.size() + " worlds)...");
        Set set = this.worldStats.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID worldId = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(worldId);
            this.saveWorldStats(worldId);
        }
        this.logger.info("[StatsManager] Statistics saved successfully");
        DebugLogger.debugMethodExit$default(this.debugLogger, "saveAll", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadAll() {
        List list;
        this.debugLogger.debugMethodEntry("loadAll", new Pair[0]);
        this.logger.info("[StatsManager] Loading all statistics from disk...");
        File[] fileArray = this.statsFolder.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!Intrinsics.areEqual(FilesKt.getExtension((File)it), "json")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List files = list;
        int successCount = 0;
        int failCount = 0;
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull(file);
                UUID worldId = UUID.fromString(FilesKt.getNameWithoutExtension(file));
                WorldStatistics stats = this.gson.fromJson(FilesKt.readText$default(file, null, 1, null), WorldStatistics.class);
                Map map = this.worldStats;
                Intrinsics.checkNotNull(worldId);
                Intrinsics.checkNotNull(stats);
                map.put(worldId, stats);
                int n = successCount;
                successCount = n + 1;
            }
            catch (Exception e) {
                this.logger.warning("[StatsManager] Failed to load stats file " + file.getName() + ": " + e.getMessage());
                ++failCount;
            }
        }
        this.logger.info("[StatsManager] Loaded " + successCount + " statistics files (" + failCount + " failed)");
        Pair[] pairArray = new Pair[]{TuplesKt.to("successCount", successCount), TuplesKt.to("failCount", failCount)};
        this.debugLogger.debug("Statistics loaded", pairArray);
        DebugLogger.debugMethodExit$default(this.debugLogger, "loadAll", null, 2, null);
    }

    public final void deleteWorldStats(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("deleteWorldStats", pairArray);
        this.worldStats.remove(worldId);
        File file = new File(this.statsFolder, worldId + ".json");
        if (file.exists()) {
            file.delete();
            this.logger.info("[StatsManager] Deleted statistics for world " + worldId);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "deleteWorldStats", null, 2, null);
    }

    @NotNull
    public final Map<UUID, WorldStatistics> getAllWorldStats() {
        return MapsKt.toMap((Map)this.worldStats);
    }
}

