/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.ResultKt;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldInvite;
import tech.bedson.playerworldmanager.models.WorldRole;
import tech.bedson.playerworldmanager.utils.DebugLogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001c\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ)\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J)\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0013J)\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001e\u001a\u00020\u001cJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0$2\u0006\u0010!\u001a\u00020\"J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020 J\u0016\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0016\u0010)\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0016\u0010*\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J1\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u001c\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b.\u0010/J;\u00100\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\"2\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00112\b\b\u0002\u0010&\u001a\u00020 \u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b3\u00104J9\u00105\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020 \u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b8\u00109J1\u0010:\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010&\u001a\u00020 \u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b;\u0010<J)\u0010=\u001a\b\u0012\u0004\u0012\u00020(0\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b>\u0010?J1\u0010@\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u001c\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bC\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006D"}, d2={"Ltech/bedson/playerworldmanager/managers/InviteManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/managers/WorldManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "acceptInvite", "Ltech/bedson/playerworldmanager/libs/kotlin/Result;", "", "invite", "Ltech/bedson/playerworldmanager/models/WorldInvite;", "player", "Lorg/bukkit/entity/Player;", "acceptInvite-gIAlu-s", "(Ltech/bedson/playerworldmanager/models/WorldInvite;Lorg/bukkit/entity/Player;)Ljava/lang/Object;", "cancelInvite", "owner", "cancelInvite-gIAlu-s", "denyInvite", "denyInvite-gIAlu-s", "getPendingInvites", "", "playerUuid", "Ljava/util/UUID;", "getPendingInvitesForWorld", "worldId", "getPlayerRole", "Ltech/bedson/playerworldmanager/models/WorldRole;", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "getPlayersWithAccess", "", "getPlayersWithRole", "role", "hasAccess", "", "hasExplicitAccess", "isInvited", "kickPlayer", "kicker", "playerToKick", "kickPlayer-0E7RQCE", "(Ltech/bedson/playerworldmanager/models/PlayerWorld;Lorg/bukkit/entity/Player;Ljava/util/UUID;)Ljava/lang/Object;", "sendInvite", "inviter", "invitee", "sendInvite-BWLJW6A", "(Ltech/bedson/playerworldmanager/models/PlayerWorld;Lorg/bukkit/entity/Player;Lorg/bukkit/entity/Player;Ltech/bedson/playerworldmanager/models/WorldRole;)Ljava/lang/Object;", "setPlayerRole", "targetUuid", "newRole", "setPlayerRole-BWLJW6A", "(Ltech/bedson/playerworldmanager/models/PlayerWorld;Lorg/bukkit/entity/Player;Ljava/util/UUID;Ltech/bedson/playerworldmanager/models/WorldRole;)Ljava/lang/Object;", "setPublicJoinRole", "setPublicJoinRole-0E7RQCE", "(Ltech/bedson/playerworldmanager/models/PlayerWorld;Lorg/bukkit/entity/Player;Ltech/bedson/playerworldmanager/models/WorldRole;)Ljava/lang/Object;", "toggleWorldVisibility", "toggleWorldVisibility-gIAlu-s", "(Ltech/bedson/playerworldmanager/models/PlayerWorld;Lorg/bukkit/entity/Player;)Ljava/lang/Object;", "transferOwnership", "currentOwner", "newOwnerUuid", "transferOwnership-0E7RQCE", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nInviteManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InviteManager.kt\ntech/bedson/playerworldmanager/managers/InviteManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,856:1\n1#2:857\n*E\n"})
public final class InviteManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final DebugLogger debugLogger;

    public InviteManager(@NotNull JavaPlugin plugin, @NotNull DataManager dataManager, @NotNull WorldManager worldManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.worldManager = worldManager;
        this.debugLogger = new DebugLogger(this.plugin, "InviteManager");
    }

    @NotNull
    public final Object sendInvite-BWLJW6A(@NotNull PlayerWorld world, @NotNull Player inviter, @NotNull Player invitee, @NotNull WorldRole role) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(inviter, "inviter");
        Intrinsics.checkNotNullParameter(invitee, "invitee");
        Intrinsics.checkNotNullParameter((Object)role, "role");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("inviterName", inviter.getName()), TuplesKt.to("inviterUuid", inviter.getUniqueId()), TuplesKt.to("inviteeName", invitee.getName()), TuplesKt.to("inviteeUuid", invitee.getUniqueId()), TuplesKt.to("assignedRole", role)};
        this.debugLogger.debugMethodEntry("sendInvite", pairArray);
        this.plugin.getLogger().info("[InviteManager] sendInvite: Player '" + inviter.getName() + "' attempting to invite '" + invitee.getName() + "' to world '" + world.getName() + "' with role '" + role + "'");
        UUID uUID = inviter.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        WorldRole inviterRole = world.getPlayerRole(uUID);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("inviterRole", inviterRole)};
        this.debugLogger.debug("Verifying inviter has invite permission", pairArray2);
        if (inviterRole == null || !inviterRole.canInvite()) {
            this.plugin.getLogger().warning("[InviteManager] sendInvite: Player '" + inviter.getName() + "' does not have permission to invite in world '" + world.getName() + "'");
            this.debugLogger.debug("Invite rejected - inviter lacks permission");
            this.debugLogger.debugMethodExit("sendInvite", "failure: no permission");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You don't have permission to invite players to this world")));
        }
        if (inviterRole == WorldRole.MANAGER && role == WorldRole.MANAGER) {
            this.plugin.getLogger().warning("[InviteManager] sendInvite: Manager '" + inviter.getName() + "' attempted to invite as MANAGER");
            this.debugLogger.debug("Invite rejected - managers cannot invite as manager");
            this.debugLogger.debugMethodExit("sendInvite", "failure: cannot invite as manager");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Only the owner can invite players as managers")));
        }
        if (Intrinsics.areEqual(world.getOwnerUuid(), invitee.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] sendInvite: Cannot invite owner '" + invitee.getName() + "' to their own world '" + world.getName() + "'");
            this.debugLogger.debug("Invite rejected - cannot invite self");
            this.debugLogger.debugMethodExit("sendInvite", "failure: self invite");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You cannot invite yourself to your own world")));
        }
        pairArray2 = new Pair[]{TuplesKt.to("playerRolesCount", world.getPlayerRoles().size())};
        this.debugLogger.debug("Checking if invitee already has access", pairArray2);
        UUID uUID2 = invitee.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        if (world.hasExplicitAccess(uUID2)) {
            this.plugin.getLogger().warning("[InviteManager] sendInvite: Player '" + invitee.getName() + "' already has access to world '" + world.getName() + "'");
            this.debugLogger.debug("Invite rejected - already has access");
            this.debugLogger.debugMethodExit("sendInvite", "failure: already has access");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException(invitee.getName() + " already has access to this world")));
        }
        this.debugLogger.debug("Checking for existing pending invite");
        UUID uUID3 = world.getId();
        UUID uUID4 = invitee.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
        WorldInvite existingInvite = this.dataManager.getInvite(uUID3, uUID4);
        if (existingInvite != null) {
            this.plugin.getLogger().warning("[InviteManager] sendInvite: Player '" + invitee.getName() + "' already has a pending invite to world '" + world.getName() + "'");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("existingInviteSentAt", existingInvite.getSentAt())};
            this.debugLogger.debug("Invite rejected - pending invite exists", pairArray3);
            this.debugLogger.debugMethodExit("sendInvite", "failure: pending invite exists");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException(invitee.getName() + " already has a pending invite to this world")));
        }
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("role", role)};
        this.debugLogger.debug("Creating new invite with role", pairArray4);
        UUID uUID5 = world.getId();
        String string = world.getName();
        UUID uUID6 = inviter.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID6, "getUniqueId(...)");
        String string2 = inviter.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        UUID uUID7 = invitee.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID7, "getUniqueId(...)");
        String string3 = invitee.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        WorldInvite invite = new WorldInvite(uUID5, string, uUID6, string2, uUID7, string3, System.currentTimeMillis(), role);
        Pair[] pairArray5 = new Pair[]{TuplesKt.to("worldId", invite.getWorldId()), TuplesKt.to("inviteeUuid", invite.getInviteeUuid()), TuplesKt.to("sentAt", invite.getSentAt()), TuplesKt.to("assignedRole", invite.getAssignedRole())};
        this.debugLogger.debugState("newInvite", pairArray5);
        this.dataManager.addInvite(invite);
        this.plugin.getLogger().info("[InviteManager] sendInvite: Created and saved invite for '" + invitee.getName() + "' to world '" + world.getName() + "'");
        inviter.sendMessage(((TextComponent)((TextComponent)Component.text("Invite sent to ", (TextColor)NamedTextColor.GREEN).append(Component.text(invitee.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" for world ", (TextColor)NamedTextColor.GREEN))).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
        String roleText = switch (WhenMappings.$EnumSwitchMapping$0[role.ordinal()]) {
            case 1 -> " as a manager";
            case 2 -> "";
            case 3 -> " as a visitor";
            default -> "";
        };
        invitee.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text(inviter.getName(), (TextColor)NamedTextColor.GOLD).append(Component.text(" has invited you to the world ", (TextColor)NamedTextColor.YELLOW))).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(roleText, (TextColor)NamedTextColor.YELLOW))).append(Component.text("!", (TextColor)NamedTextColor.YELLOW)));
        invitee.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/world invite accept " + world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to accept", (TextColor)NamedTextColor.YELLOW)));
        this.plugin.getLogger().info("[InviteManager] sendInvite: Successfully sent invite from '" + inviter.getName() + "' to '" + invitee.getName() + "' for world '" + world.getName() + "'");
        this.debugLogger.debugMethodExit("sendInvite", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    public static /* synthetic */ Object sendInvite-BWLJW6A$default(InviteManager inviteManager, PlayerWorld playerWorld, Player player, Player player2, WorldRole worldRole, int n, Object object) {
        if ((n & 8) != 0) {
            worldRole = WorldRole.MEMBER;
        }
        return inviteManager.sendInvite-BWLJW6A(playerWorld, player, player2, worldRole);
    }

    @NotNull
    public final Object acceptInvite-gIAlu-s(@NotNull WorldInvite invite, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(invite, "invite");
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("worldId", invite.getWorldId()), TuplesKt.to("ownerName", invite.getOwnerName())};
        this.debugLogger.debugMethodEntry("acceptInvite", pairArray);
        this.plugin.getLogger().info("[InviteManager] acceptInvite: Player '" + player.getName() + "' attempting to accept invite to world '" + invite.getWorldName() + "'");
        pairArray = new Pair[]{TuplesKt.to("inviteInviteeUuid", invite.getInviteeUuid()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debug("Verifying player is invitee", pairArray);
        if (!Intrinsics.areEqual(invite.getInviteeUuid(), player.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] acceptInvite: Player '" + player.getName() + "' is not the invitee for this invite (expected UUID: " + invite.getInviteeUuid() + ")");
            this.debugLogger.debug("Accept rejected - not the invitee");
            this.debugLogger.debugMethodExit("acceptInvite", "failure: not invitee");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("This invite is not for you")));
        }
        pairArray = new Pair[]{TuplesKt.to("worldId", invite.getWorldId())};
        this.debugLogger.debug("Loading world from data manager", pairArray);
        PlayerWorld world = this.dataManager.loadWorld(invite.getWorldId());
        if (world == null) {
            this.plugin.getLogger().warning("[InviteManager] acceptInvite: World '" + invite.getWorldName() + "' (ID: " + invite.getWorldId() + ") no longer exists");
            this.debugLogger.debug("Accept rejected - world no longer exists");
            this.debugLogger.debugMethodExit("acceptInvite", "failure: world not found");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalStateException("World no longer exists")));
        }
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debug("World loaded successfully", pairArray2);
        WorldRole assignedRole = invite.getAssignedRole();
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("previousCount", world.getPlayerRoles().size()), TuplesKt.to("assignedRole", assignedRole)};
        this.debugLogger.debug("Adding player with role", pairArray3);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        world.setPlayerRole(uUID, assignedRole);
        this.dataManager.saveWorld(world);
        this.plugin.getLogger().info("[InviteManager] acceptInvite: Added player '" + player.getName() + "' to world '" + world.getName() + "' with role '" + assignedRole + "'");
        pairArray3 = new Pair[]{TuplesKt.to("newCount", world.getPlayerRoles().size()), TuplesKt.to("role", assignedRole)};
        this.debugLogger.debug("Player added with role", pairArray3);
        this.debugLogger.debug("Removing pending invite");
        this.dataManager.removeInvite(invite);
        String roleDescription = switch (WhenMappings.$EnumSwitchMapping$0[assignedRole.ordinal()]) {
            case 1 -> " You are a manager.";
            case 3 -> " You are a visitor (spectator mode).";
            default -> "";
        };
        player.sendMessage(((TextComponent)Component.text("You have accepted the invite to ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("!" + roleDescription, (TextColor)NamedTextColor.GREEN)));
        Player owner = Bukkit.getPlayer((UUID)world.getOwnerUuid());
        if (owner != null) {
            owner.sendMessage(((TextComponent)Component.text(player.getName(), (TextColor)NamedTextColor.GOLD).append(Component.text(" has accepted your invite to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
            this.plugin.getLogger().info("[InviteManager] acceptInvite: Notified owner '" + owner.getName() + "' that '" + player.getName() + "' accepted the invite");
        }
        this.plugin.getLogger().info("[InviteManager] acceptInvite: Successfully processed invite acceptance for '" + player.getName() + "' to world '" + world.getName() + "'");
        this.debugLogger.debugMethodExit("acceptInvite", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    @NotNull
    public final Object denyInvite-gIAlu-s(@NotNull WorldInvite invite, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(invite, "invite");
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("worldId", invite.getWorldId())};
        this.debugLogger.debugMethodEntry("denyInvite", pairArray);
        this.plugin.getLogger().info("[InviteManager] denyInvite: Player '" + player.getName() + "' attempting to deny invite to world '" + invite.getWorldName() + "'");
        pairArray = new Pair[]{TuplesKt.to("inviteInviteeUuid", invite.getInviteeUuid()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debug("Verifying player is invitee", pairArray);
        if (!Intrinsics.areEqual(invite.getInviteeUuid(), player.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] denyInvite: Player '" + player.getName() + "' is not the invitee for this invite (expected UUID: " + invite.getInviteeUuid() + ")");
            this.debugLogger.debug("Deny rejected - not the invitee");
            this.debugLogger.debugMethodExit("denyInvite", "failure: not invitee");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("This invite is not for you")));
        }
        this.debugLogger.debug("Removing pending invite");
        this.dataManager.removeInvite(invite);
        this.plugin.getLogger().info("[InviteManager] denyInvite: Removed pending invite for '" + player.getName() + "' to world '" + invite.getWorldName() + "'");
        player.sendMessage(Component.text("You have declined the invite to ", (TextColor)NamedTextColor.YELLOW).append(Component.text(invite.getWorldName(), (TextColor)NamedTextColor.GOLD)));
        Player owner = Bukkit.getPlayer((UUID)invite.getOwnerUuid());
        if (owner != null) {
            owner.sendMessage(((TextComponent)Component.text(player.getName(), (TextColor)NamedTextColor.GOLD).append(Component.text(" has declined your invite to ", (TextColor)NamedTextColor.YELLOW))).append(Component.text(invite.getWorldName(), (TextColor)NamedTextColor.GOLD)));
            this.plugin.getLogger().info("[InviteManager] denyInvite: Notified owner '" + owner.getName() + "' that '" + player.getName() + "' declined the invite");
        }
        this.plugin.getLogger().info("[InviteManager] denyInvite: Successfully processed invite denial for '" + player.getName() + "' to world '" + invite.getWorldName() + "'");
        this.debugLogger.debugMethodExit("denyInvite", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    @NotNull
    public final Object cancelInvite-gIAlu-s(@NotNull WorldInvite invite, @NotNull Player owner) {
        Player invitee;
        Intrinsics.checkNotNullParameter(invite, "invite");
        Intrinsics.checkNotNullParameter(owner, "owner");
        Pair[] pairArray = new Pair[]{TuplesKt.to("ownerName", owner.getName()), TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("worldId", invite.getWorldId()), TuplesKt.to("inviteeName", invite.getInviteeName())};
        this.debugLogger.debugMethodEntry("cancelInvite", pairArray);
        pairArray = new Pair[]{TuplesKt.to("inviteOwnerUuid", invite.getOwnerUuid()), TuplesKt.to("playerUuid", owner.getUniqueId())};
        this.debugLogger.debug("Verifying player is owner", pairArray);
        if (!Intrinsics.areEqual(invite.getOwnerUuid(), owner.getUniqueId())) {
            this.debugLogger.debug("Cancel rejected - not the owner");
            this.debugLogger.debugMethodExit("cancelInvite", "failure: not owner");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You didn't send this invite")));
        }
        this.debugLogger.debug("Removing pending invite");
        this.dataManager.removeInvite(invite);
        owner.sendMessage(((TextComponent)Component.text("Invite to ", (TextColor)NamedTextColor.YELLOW).append(Component.text(invite.getInviteeName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" has been cancelled", (TextColor)NamedTextColor.YELLOW)));
        Player player = invitee = Bukkit.getPlayer((UUID)invite.getInviteeUuid());
        if (player != null) {
            player.sendMessage(((TextComponent)Component.text("The invite to ", (TextColor)NamedTextColor.YELLOW).append(Component.text(invite.getWorldName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" has been cancelled", (TextColor)NamedTextColor.YELLOW)));
        }
        this.debugLogger.debugMethodExit("cancelInvite", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    @NotNull
    public final Object kickPlayer-0E7RQCE(@NotNull PlayerWorld world, @NotNull Player kicker, @NotNull UUID playerToKick) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(kicker, "kicker");
        Intrinsics.checkNotNullParameter(playerToKick, "playerToKick");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("kickerName", kicker.getName()), TuplesKt.to("kickerUuid", kicker.getUniqueId()), TuplesKt.to("playerToKickUuid", playerToKick)};
        this.debugLogger.debugMethodEntry("kickPlayer", pairArray);
        this.plugin.getLogger().info("[InviteManager] kickPlayer: Player '" + kicker.getName() + "' attempting to kick player UUID '" + playerToKick + "' from world '" + world.getName() + "'");
        UUID uUID = kicker.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        WorldRole kickerRole = world.getPlayerRole(uUID);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("kickerRole", kickerRole)};
        this.debugLogger.debug("Verifying caller has kick permission", pairArray2);
        if (kickerRole == null || !kickerRole.canKick()) {
            this.plugin.getLogger().warning("[InviteManager] kickPlayer: Player '" + kicker.getName() + "' does not have permission to kick in world '" + world.getName() + "'");
            this.debugLogger.debug("Kick rejected - caller lacks permission");
            this.debugLogger.debugMethodExit("kickPlayer", "failure: no permission");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You don't have permission to kick players from this world")));
        }
        if (Intrinsics.areEqual(playerToKick, kicker.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] kickPlayer: Player '" + kicker.getName() + "' attempted to kick themselves from world '" + world.getName() + "'");
            this.debugLogger.debug("Kick rejected - cannot kick self");
            this.debugLogger.debugMethodExit("kickPlayer", "failure: self kick");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You cannot kick yourself from the world")));
        }
        WorldRole playerRole = world.getExplicitPlayerRole(playerToKick);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("playerRole", playerRole)};
        this.debugLogger.debug("Checking target player's role", pairArray3);
        if (playerRole == null) {
            this.plugin.getLogger().warning("[InviteManager] kickPlayer: Player UUID '" + playerToKick + "' does not have access to world '" + world.getName() + "'");
            this.debugLogger.debug("Kick rejected - player has no access");
            this.debugLogger.debugMethodExit("kickPlayer", "failure: no access");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("This player does not have access to this world")));
        }
        if (playerRole == WorldRole.OWNER) {
            this.plugin.getLogger().warning("[InviteManager] kickPlayer: Cannot kick owner from world '" + world.getName() + "'");
            this.debugLogger.debug("Kick rejected - cannot kick owner");
            this.debugLogger.debugMethodExit("kickPlayer", "failure: cannot kick owner");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Cannot kick the world owner")));
        }
        if (kickerRole == WorldRole.MANAGER && playerRole == WorldRole.MANAGER) {
            this.plugin.getLogger().warning("[InviteManager] kickPlayer: Manager '" + kicker.getName() + "' attempted to kick another manager from world '" + world.getName() + "'");
            this.debugLogger.debug("Kick rejected - managers cannot kick other managers");
            this.debugLogger.debugMethodExit("kickPlayer", "failure: cannot kick manager");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Managers cannot kick other managers")));
        }
        Pair[] pairArray4 = Bukkit.getOfflinePlayer((UUID)playerToKick).getName();
        if (pairArray4 == null) {
            pairArray4 = playerToKick.toString();
        }
        Pair[] pairArray5 = pairArray4;
        Intrinsics.checkNotNull(pairArray5);
        Pair[] kickedPlayerName = pairArray5;
        this.plugin.getLogger().info("[InviteManager] kickPlayer: Kicking player '" + (String)kickedPlayerName + "' from world '" + world.getName() + "'");
        pairArray5 = new Pair[]{TuplesKt.to("previousCount", world.getPlayerRoles().size())};
        this.debugLogger.debug("Removing player's access", pairArray5);
        world.removePlayer(playerToKick);
        this.dataManager.saveWorld(world);
        this.plugin.getLogger().info("[InviteManager] kickPlayer: Removed player '" + (String)kickedPlayerName + "' from world '" + world.getName() + "'");
        pairArray5 = new Pair[]{TuplesKt.to("newCount", world.getPlayerRoles().size())};
        this.debugLogger.debug("Player removed", pairArray5);
        Player kickedPlayer = Bukkit.getPlayer((UUID)playerToKick);
        if (kickedPlayer != null && kickedPlayer.isOnline()) {
            PlayerWorld playerWorld;
            World world2 = kickedPlayer.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            PlayerWorld playerWorld2 = playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(world2);
            if (Intrinsics.areEqual(playerWorld2 != null ? playerWorld2.getId() : null, world.getId())) {
                this.plugin.getLogger().info("[InviteManager] kickPlayer: Player '" + (String)kickedPlayerName + "' is currently in world '" + world.getName() + "', teleporting out");
                List list = Bukkit.getWorlds();
                Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
                World defaultWorld = (World)CollectionsKt.firstOrNull(list);
                if (defaultWorld != null) {
                    kickedPlayer.getScheduler().run((Plugin)this.plugin, arg_0 -> InviteManager.kickPlayer_0E7RQCE$lambda$1(kickedPlayer, defaultWorld, world, this, (String)kickedPlayerName, arg_0), null);
                } else {
                    this.plugin.getLogger().warning("[InviteManager] kickPlayer: No default world found to teleport '" + (String)kickedPlayerName + "' to");
                }
            } else {
                this.plugin.getLogger().info("[InviteManager] kickPlayer: Player '" + (String)kickedPlayerName + "' is not currently in world '" + world.getName() + "', sending notification only");
                kickedPlayer.sendMessage(Component.text("You have been removed from ", (TextColor)NamedTextColor.YELLOW).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
            }
        } else {
            this.plugin.getLogger().info("[InviteManager] kickPlayer: Player '" + (String)kickedPlayerName + "' is offline, no teleport needed");
        }
        kicker.sendMessage(((TextComponent)((TextComponent)Component.text("Kicked ", (TextColor)NamedTextColor.GREEN).append(Component.text((String)kickedPlayerName, (TextColor)NamedTextColor.GOLD))).append(Component.text(" from ", (TextColor)NamedTextColor.GREEN))).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
        this.plugin.getLogger().info("[InviteManager] kickPlayer: Successfully kicked player '" + (String)kickedPlayerName + "' from world '" + world.getName() + "'");
        this.debugLogger.debugMethodExit("kickPlayer", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    @NotNull
    public final List<WorldInvite> getPendingInvites(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("getPendingInvites", pairArray);
        List<WorldInvite> invites = this.dataManager.getInvitesForPlayer(playerUuid);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", invites.size())};
        this.debugLogger.debug("Retrieved pending invites", pairArray2);
        this.debugLogger.debugMethodExit("getPendingInvites", invites.size());
        return invites;
    }

    @NotNull
    public final List<WorldInvite> getPendingInvitesForWorld(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("getPendingInvitesForWorld", pairArray);
        List<WorldInvite> invites = this.dataManager.getInvitesForWorld(worldId);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", invites.size())};
        this.debugLogger.debug("Retrieved pending invites for world", pairArray2);
        this.debugLogger.debugMethodExit("getPendingInvitesForWorld", invites.size());
        return invites;
    }

    public final boolean hasExplicitAccess(@NotNull UUID playerUuid, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("hasExplicitAccess", pairArray);
        boolean hasAccess = world.hasExplicitAccess(playerUuid);
        this.debugLogger.debugMethodExit("hasExplicitAccess", hasAccess);
        return hasAccess;
    }

    public final boolean hasAccess(@NotNull UUID playerUuid, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debugMethodEntry("hasAccess", pairArray);
        WorldRole role = world.getPlayerRole(playerUuid);
        boolean hasAccess = role != null;
        this.plugin.getLogger().info("[InviteManager] hasAccess: Checking access for player UUID '" + playerUuid + "' to world '" + world.getName() + "' - Role: " + role + ", Result: " + hasAccess);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("role", role), TuplesKt.to("hasAccess", hasAccess)};
        this.debugLogger.debug("Access check result", pairArray2);
        this.debugLogger.debugMethodExit("hasAccess", hasAccess);
        return hasAccess;
    }

    public final boolean isInvited(@NotNull UUID playerUuid, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("isInvited", pairArray);
        boolean isOwner = Intrinsics.areEqual(world.getOwnerUuid(), playerUuid);
        boolean hasRole = world.getPlayerRoles().containsKey(playerUuid) || world.getInvitedPlayers().contains(playerUuid);
        boolean result = hasRole && !isOwner;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("isOwner", isOwner), TuplesKt.to("hasRole", hasRole), TuplesKt.to("result", result)};
        this.debugLogger.debug("isInvited check", pairArray2);
        this.debugLogger.debugMethodExit("isInvited", result);
        return result;
    }

    @Nullable
    public final WorldRole getPlayerRole(@NotNull UUID playerUuid, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("getPlayerRole", pairArray);
        WorldRole role = world.getPlayerRole(playerUuid);
        this.debugLogger.debugMethodExit("getPlayerRole", (Object)role);
        return role;
    }

    @NotNull
    public final Set<UUID> getPlayersWithAccess(@NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("getPlayersWithAccess", pairArray);
        Set<UUID> players = CollectionsKt.toSet((Iterable)world.getPlayerRoles().keySet());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", players.size())};
        this.debugLogger.debug("Retrieved players with access", pairArray2);
        this.debugLogger.debugMethodExit("getPlayersWithAccess", players.size());
        return players;
    }

    @NotNull
    public final Set<UUID> getPlayersWithRole(@NotNull PlayerWorld world, @NotNull WorldRole role) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter((Object)role, "role");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("role", role)};
        this.debugLogger.debugMethodEntry("getPlayersWithRole", pairArray);
        Set<UUID> players = world.getPlayersWithRole(role);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", players.size())};
        this.debugLogger.debug("Retrieved players with role", pairArray2);
        this.debugLogger.debugMethodExit("getPlayersWithRole", players.size());
        return players;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object setPlayerRole-BWLJW6A(@NotNull PlayerWorld world, @NotNull Player owner, @NotNull UUID targetUuid, @NotNull WorldRole newRole) {
        String string;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(targetUuid, "targetUuid");
        Intrinsics.checkNotNullParameter((Object)newRole, "newRole");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", owner.getName()), TuplesKt.to("targetUuid", targetUuid), TuplesKt.to("newRole", newRole)};
        this.debugLogger.debugMethodEntry("setPlayerRole", pairArray);
        this.plugin.getLogger().info("[InviteManager] setPlayerRole: Player '" + owner.getName() + "' attempting to set role '" + newRole + "' for UUID '" + targetUuid + "' in world '" + world.getName() + "'");
        if (!Intrinsics.areEqual(world.getOwnerUuid(), owner.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] setPlayerRole: Player '" + owner.getName() + "' is not the owner of world '" + world.getName() + "'");
            this.debugLogger.debugMethodExit("setPlayerRole", "failure: not owner");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Only the owner can change player roles")));
        }
        if (newRole == WorldRole.OWNER) {
            this.plugin.getLogger().warning("[InviteManager] setPlayerRole: Cannot set OWNER role directly");
            this.debugLogger.debugMethodExit("setPlayerRole", "failure: cannot set owner");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Cannot set OWNER role. Use transfer ownership instead.")));
        }
        if (Intrinsics.areEqual(targetUuid, owner.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] setPlayerRole: Owner attempted to change their own role");
            this.debugLogger.debugMethodExit("setPlayerRole", "failure: self modification");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You cannot change your own role")));
        }
        if (!world.hasExplicitAccess(targetUuid)) {
            this.plugin.getLogger().warning("[InviteManager] setPlayerRole: Target UUID '" + targetUuid + "' does not have access to world '" + world.getName() + "'");
            this.debugLogger.debugMethodExit("setPlayerRole", "failure: no access");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("This player does not have access to the world")));
        }
        String string2 = Bukkit.getOfflinePlayer((UUID)targetUuid).getName();
        if (string2 == null) {
            string2 = targetUuid.toString();
        }
        String string3 = string2;
        Intrinsics.checkNotNull(string3);
        String targetName = string3;
        WorldRole previousRole = world.getPlayerRole(targetUuid);
        world.setPlayerRole(targetUuid, newRole);
        this.dataManager.saveWorld(world);
        this.plugin.getLogger().info("[InviteManager] setPlayerRole: Changed role for '" + targetName + "' from '" + previousRole + "' to '" + newRole + "' in world '" + world.getName() + "'");
        Player player = owner;
        TextComponent textComponent = (TextComponent)((TextComponent)Component.text("Changed ", (TextColor)NamedTextColor.GREEN).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("'s role to ", (TextColor)NamedTextColor.GREEN));
        String string4 = newRole.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        String string5 = string4;
        if (((CharSequence)string5).length() > 0) {
            void it22;
            char c = string5.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            TextComponent textComponent2 = textComponent;
            Player player2 = player;
            boolean bl = false;
            String string6 = String.valueOf((char)it22);
            Intrinsics.checkNotNull(string6, "null cannot be cast to non-null type java.lang.String");
            String string7 = string6.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string7, "toUpperCase(...)");
            String string8 = string7;
            player = player2;
            textComponent = textComponent2;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string8);
            String it22 = string5;
            int n = 1;
            String string9 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue(string9, "substring(...)");
            string = stringBuilder2.append(string9).toString();
        } else {
            string = string5;
        }
        player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        Player targetPlayer = Bukkit.getPlayer((UUID)targetUuid);
        if (targetPlayer != null) {
            String roleMessage = switch (WhenMappings.$EnumSwitchMapping$0[newRole.ordinal()]) {
                case 1 -> "You are now a manager of ";
                case 2 -> "You are now a member of ";
                case 3 -> "You are now a visitor in ";
                default -> "Your role has changed in ";
            };
            targetPlayer.sendMessage(Component.text(roleMessage, (TextColor)NamedTextColor.YELLOW).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("setPlayerRole", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    @NotNull
    public final Object toggleWorldVisibility-gIAlu-s(@NotNull PlayerWorld world, @NotNull Player owner) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(owner, "owner");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", owner.getName()), TuplesKt.to("currentVisibility", world.isPublic())};
        this.debugLogger.debugMethodEntry("toggleWorldVisibility", pairArray);
        if (!Intrinsics.areEqual(world.getOwnerUuid(), owner.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] toggleWorldVisibility: Player '" + owner.getName() + "' is not the owner of world '" + world.getName() + "'");
            this.debugLogger.debugMethodExit("toggleWorldVisibility", "failure: not owner");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Only the owner can change world visibility")));
        }
        world.setPublic(!world.isPublic());
        this.dataManager.saveWorld(world);
        this.plugin.getLogger().info("[InviteManager] toggleWorldVisibility: World '" + world.getName() + "' is now " + (world.isPublic() ? "public" : "private"));
        String visibilityText = world.isPublic() ? "public" : "private";
        owner.sendMessage(((TextComponent)((TextComponent)Component.text("World ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" is now ", (TextColor)NamedTextColor.GREEN))).append(Component.text(visibilityText, (TextColor)NamedTextColor.GOLD)));
        this.debugLogger.debugMethodExit("toggleWorldVisibility", world.isPublic());
        return Result.constructor-impl(world.isPublic());
    }

    @NotNull
    public final Object setPublicJoinRole-0E7RQCE(@NotNull PlayerWorld world, @NotNull Player owner, @NotNull WorldRole role) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter((Object)role, "role");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", owner.getName()), TuplesKt.to("role", role)};
        this.debugLogger.debugMethodEntry("setPublicJoinRole", pairArray);
        if (!Intrinsics.areEqual(world.getOwnerUuid(), owner.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] setPublicJoinRole: Player '" + owner.getName() + "' is not the owner of world '" + world.getName() + "'");
            this.debugLogger.debugMethodExit("setPublicJoinRole", "failure: not owner");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Only the owner can change public join settings")));
        }
        if (role != WorldRole.MEMBER && role != WorldRole.VISITOR) {
            this.plugin.getLogger().warning("[InviteManager] setPublicJoinRole: Invalid role '" + role + "' for public join");
            this.debugLogger.debugMethodExit("setPublicJoinRole", "failure: invalid role");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Public join role must be Member or Visitor")));
        }
        world.setPublicJoinRole(role);
        this.dataManager.saveWorld(world);
        this.plugin.getLogger().info("[InviteManager] setPublicJoinRole: World '" + world.getName() + "' public join role set to '" + role + "'");
        String roleText = role == WorldRole.MEMBER ? "Member (can play)" : "Visitor (spectator only)";
        owner.sendMessage(((TextComponent)((TextComponent)Component.text("Players joining ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" publicly will be: ", (TextColor)NamedTextColor.GREEN))).append(Component.text(roleText, (TextColor)NamedTextColor.GOLD)));
        this.debugLogger.debugMethodExit("setPublicJoinRole", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    @NotNull
    public final Object transferOwnership-0E7RQCE(@NotNull PlayerWorld world, @NotNull Player currentOwner, @NotNull UUID newOwnerUuid) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(currentOwner, "currentOwner");
        Intrinsics.checkNotNullParameter(newOwnerUuid, "newOwnerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("currentOwnerName", currentOwner.getName()), TuplesKt.to("currentOwnerUuid", currentOwner.getUniqueId()), TuplesKt.to("newOwnerUuid", newOwnerUuid)};
        this.debugLogger.debugMethodEntry("transferOwnership", pairArray);
        this.plugin.getLogger().info("[InviteManager] transferOwnership: Player '" + currentOwner.getName() + "' attempting to transfer ownership of world '" + world.getName() + "' to UUID '" + newOwnerUuid + "'");
        pairArray = new Pair[]{TuplesKt.to("worldOwnerUuid", world.getOwnerUuid()), TuplesKt.to("callerUuid", currentOwner.getUniqueId())};
        this.debugLogger.debug("Verifying current owner", pairArray);
        if (!Intrinsics.areEqual(world.getOwnerUuid(), currentOwner.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] transferOwnership: Player '" + currentOwner.getName() + "' is not the owner of world '" + world.getName() + "'");
            this.debugLogger.debug("Transfer rejected - not the current owner");
            this.debugLogger.debugMethodExit("transferOwnership", "failure: not owner");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You don't own this world")));
        }
        if (Intrinsics.areEqual(newOwnerUuid, currentOwner.getUniqueId())) {
            this.plugin.getLogger().warning("[InviteManager] transferOwnership: Player '" + currentOwner.getName() + "' attempted to transfer ownership to themselves");
            this.debugLogger.debug("Transfer rejected - cannot transfer to self");
            this.debugLogger.debugMethodExit("transferOwnership", "failure: self transfer");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("You already own this world")));
        }
        pairArray = new Pair[]{TuplesKt.to("playerRolesCount", world.getPlayerRoles().size())};
        this.debugLogger.debug("Checking if new owner has access", pairArray);
        if (!world.hasExplicitAccess(newOwnerUuid)) {
            this.plugin.getLogger().warning("[InviteManager] transferOwnership: New owner UUID '" + newOwnerUuid + "' does not have access to world '" + world.getName() + "'");
            this.debugLogger.debug("Transfer rejected - new owner has no access");
            this.debugLogger.debugMethodExit("transferOwnership", "failure: no access");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("The new owner must have access to the world first")));
        }
        this.debugLogger.debug("Looking up new owner by UUID");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)newOwnerUuid);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer newOwner = offlinePlayer;
        String newOwnerName = newOwner.getName();
        if (newOwnerName == null) {
            this.plugin.getLogger().severe("[InviteManager] transferOwnership: Could not find name for new owner UUID '" + newOwnerUuid + "'");
            this.debugLogger.debug("Transfer rejected - could not find new owner name");
            this.debugLogger.debugMethodExit("transferOwnership", "failure: name not found");
            return Result.constructor-impl(ResultKt.createFailure(new IllegalStateException("Could not find new owner's name")));
        }
        this.plugin.getLogger().info("[InviteManager] transferOwnership: Transferring ownership to player '" + newOwnerName + "'");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("newOwnerName", newOwnerName)};
        this.debugLogger.debug("New owner found", pairArray2);
        UUID oldOwnerUuid = world.getOwnerUuid();
        String oldOwnerName = world.getOwnerName();
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("oldOwnerUuid", oldOwnerUuid), TuplesKt.to("oldOwnerName", oldOwnerName), TuplesKt.to("newOwnerUuid", newOwnerUuid), TuplesKt.to("newOwnerName", newOwnerName)};
        this.debugLogger.debug("Preparing ownership transfer", pairArray3);
        PlayerWorld updatedWorld = PlayerWorld.copy$default(world, null, null, newOwnerUuid, newOwnerName, null, null, 0L, false, null, null, null, null, null, null, false, null, null, 131059, null);
        this.debugLogger.debug("Created updated world with new owner");
        updatedWorld.getPlayerRoles().remove(newOwnerUuid);
        updatedWorld.getInvitedPlayers().remove(newOwnerUuid);
        this.plugin.getLogger().info("[InviteManager] transferOwnership: Removed new owner '" + newOwnerName + "' from player roles");
        updatedWorld.getPlayerRoles().put(oldOwnerUuid, WorldRole.MANAGER);
        updatedWorld.getInvitedPlayers().add(oldOwnerUuid);
        this.plugin.getLogger().info("[InviteManager] transferOwnership: Added old owner '" + oldOwnerName + "' as manager");
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("count", updatedWorld.getPlayerRoles().size())};
        this.debugLogger.debug("Updated player roles", pairArray4);
        this.debugLogger.debug("Saving updated world");
        this.dataManager.saveWorld(updatedWorld);
        PlayerData oldOwnerData = this.dataManager.getOrCreatePlayerData(oldOwnerUuid, oldOwnerName);
        oldOwnerData.getOwnedWorlds().remove(world.getId());
        this.dataManager.savePlayerData(oldOwnerData);
        this.plugin.getLogger().info("[InviteManager] transferOwnership: Removed world '" + world.getName() + "' from old owner '" + oldOwnerName + "' owned worlds");
        PlayerData newOwnerData = this.dataManager.getOrCreatePlayerData(newOwnerUuid, newOwnerName);
        newOwnerData.getOwnedWorlds().add(world.getId());
        this.dataManager.savePlayerData(newOwnerData);
        this.plugin.getLogger().info("[InviteManager] transferOwnership: Added world '" + world.getName() + "' to new owner '" + newOwnerName + "' owned worlds");
        currentOwner.sendMessage(((TextComponent)((TextComponent)Component.text("Transferred ownership of ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(newOwnerName, (TextColor)NamedTextColor.GOLD)));
        Player newOwnerPlayer = Bukkit.getPlayer((UUID)newOwnerUuid);
        if (newOwnerPlayer != null) {
            newOwnerPlayer.sendMessage(((TextComponent)Component.text("You are now the owner of ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("!", (TextColor)NamedTextColor.GREEN)));
            this.plugin.getLogger().info("[InviteManager] transferOwnership: Notified new owner '" + newOwnerName + "' of ownership transfer");
        }
        this.plugin.getLogger().info("[InviteManager] transferOwnership: Successfully transferred ownership of world '" + world.getName() + "' from '" + oldOwnerName + "' to '" + newOwnerName + "'");
        this.debugLogger.debugMethodExit("transferOwnership", "success");
        return Result.constructor-impl(Unit.INSTANCE);
    }

    private static final void kickPlayer_0E7RQCE$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void kickPlayer_0E7RQCE$lambda$1(Player $kickedPlayer, World $defaultWorld, PlayerWorld $world, InviteManager this$0, String $kickedPlayerName, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($kickedPlayerName, "$kickedPlayerName");
        $kickedPlayer.teleportAsync($defaultWorld.getSpawnLocation()).thenAccept(arg_0 -> InviteManager.kickPlayer_0E7RQCE$lambda$1$lambda$0(new Function1<Boolean, Unit>($kickedPlayer, $world, this$0, $kickedPlayerName){
            final /* synthetic */ Player $kickedPlayer;
            final /* synthetic */ PlayerWorld $world;
            final /* synthetic */ InviteManager this$0;
            final /* synthetic */ String $kickedPlayerName;
            {
                this.$kickedPlayer = $kickedPlayer;
                this.$world = $world;
                this.this$0 = $receiver;
                this.$kickedPlayerName = $kickedPlayerName;
                super(1);
            }

            public final void invoke(Boolean it) {
                this.$kickedPlayer.sendMessage(Component.text("You have been kicked from ", (TextColor)NamedTextColor.RED).append(Component.text(this.$world.getName(), (TextColor)NamedTextColor.GOLD)));
                InviteManager.access$getPlugin$p(this.this$0).getLogger().info("[InviteManager] kickPlayer: Successfully teleported '" + this.$kickedPlayerName + "' out of world '" + this.$world.getName() + "'");
            }
        }, arg_0));
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(InviteManager $this) {
        return $this.plugin;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorldRole.values().length];
            try {
                nArray[WorldRole.MANAGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldRole.MEMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldRole.VISITOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

