/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.io.FilesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldInvite;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0013J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140 J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170 J\u0018\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0006\u0010&\u001a\u00020\u0013J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0006\u0010\u001d\u001a\u00020\u0013J\u0016\u0010(\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170 2\u0006\u0010,\u001a\u00020\u0013J\u0006\u0010-\u001a\u00020\u001aJ\u0006\u0010.\u001a\u00020\u001aJ\u0010\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u0013J\u0010\u00100\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0013J\u0010\u00101\u001a\u0004\u0018\u00010\u00172\u0006\u00102\u001a\u00020*J\u000e\u00103\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rJ\u0006\u00104\u001a\u00020\u001aJ\u0006\u00105\u001a\u00020\u001aJ\u000e\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u0014J\u000e\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ltech/bedson/playerworldmanager/managers/DataManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "dataFolder", "Ljava/io/File;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ljava/io/File;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "gson", "Lcom/google/gson/Gson;", "invites", "", "Ltech/bedson/playerworldmanager/models/WorldInvite;", "invitesFile", "logger", "Ljava/util/logging/Logger;", "playerData", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ltech/bedson/playerworldmanager/models/PlayerData;", "playersFolder", "worlds", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "worldsFolder", "addInvite", "", "invite", "cleanupOrphanedWorld", "worldId", "deleteWorld", "getAllInvites", "", "getAllPlayerData", "getAllWorlds", "getInvite", "inviteeUuid", "getInvitesForPlayer", "playerUuid", "getInvitesForWorld", "getOrCreatePlayerData", "username", "", "getWorldsByOwner", "ownerUuid", "loadAll", "loadInvites", "loadPlayerData", "loadWorld", "loadWorldByName", "name", "removeInvite", "saveAll", "saveInvites", "savePlayerData", "data", "saveWorld", "world", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nDataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataManager.kt\ntech/bedson/playerworldmanager/managers/DataManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,601:1\n288#2,2:602\n766#2:606\n857#2,2:607\n766#2:609\n857#2,2:610\n1549#2:612\n1620#2,3:613\n766#2:616\n857#2,2:617\n766#2:619\n857#2,2:620\n288#2,2:622\n1855#2,2:627\n1855#2,2:632\n1855#2,2:634\n1855#2,2:636\n13309#3,2:604\n3792#3:624\n4307#3,2:625\n3792#3:629\n4307#3,2:630\n*S KotlinDebug\n*F\n+ 1 DataManager.kt\ntech/bedson/playerworldmanager/managers/DataManager\n*L\n128#1:602,2\n211#1:606\n211#1:607,2\n238#1:609\n238#1:610,2\n239#1:612\n239#1:613,3\n445#1:616\n445#1:617,2\n459#1:619\n459#1:620,2\n473#1:622,2\n511#1:627,2\n537#1:632,2\n585#1:634,2\n590#1:636,2\n138#1:604,2\n506#1:624\n506#1:625,2\n532#1:629\n532#1:630,2\n*E\n"})
public final class DataManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final Gson gson;
    @NotNull
    private final File worldsFolder;
    @NotNull
    private final File playersFolder;
    @NotNull
    private final File invitesFile;
    @NotNull
    private final ConcurrentHashMap<UUID, PlayerWorld> worlds;
    @NotNull
    private final ConcurrentHashMap<UUID, PlayerData> playerData;
    @NotNull
    private final List<WorldInvite> invites;

    public DataManager(@NotNull JavaPlugin plugin, @NotNull File dataFolder) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        this.plugin = plugin;
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
        this.debugLogger = new DebugLogger(this.plugin, "DataManager");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        this.gson = gson;
        this.worldsFolder = new File(dataFolder, "worlds");
        this.playersFolder = new File(dataFolder, "players");
        this.invitesFile = new File(dataFolder, "invites.json");
        this.worlds = new ConcurrentHashMap();
        this.playerData = new ConcurrentHashMap();
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, "synchronizedList(...)");
        this.invites = list;
        this.worldsFolder.mkdirs();
        this.playersFolder.mkdirs();
        dataFolder.mkdirs();
    }

    public final void saveWorld(@NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("ownerName", world.getOwnerName())};
        this.debugLogger.debugMethodEntry("saveWorld", pairArray);
        ((Map)this.worlds).put(world.getId(), world);
        pairArray = new Pair[]{TuplesKt.to("cacheSize", this.worlds.size())};
        this.debugLogger.debug("Added world to cache", pairArray);
        File file = new File(this.worldsFolder, world.getId() + ".json");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("filePath", file.getAbsolutePath())};
        this.debugLogger.debug("Writing to file", pairArray2);
        try {
            String json = this.gson.toJson(world);
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("jsonLength", json.length())};
            this.debugLogger.debug("Serialized world to JSON", pairArray3);
            Intrinsics.checkNotNull(json);
            FilesKt.writeText$default(file, json, null, 2, null);
            this.debugLogger.debugMethodExit("saveWorld", "success");
        }
        catch (Exception e) {
            this.logger.severe("[DataManager] Failed to save world " + world.getName() + " (" + world.getId() + "): " + e.getMessage());
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Failed to save world", pairArray4);
            this.debugLogger.debugMethodExit("saveWorld", "failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Nullable
    public final PlayerWorld loadWorld(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Object object = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("loadWorld", (Pair<String, ? extends Object>)object);
        object = this.worlds.get(worldId);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", ((PlayerWorld)it).getName()), TuplesKt.to("worldId", ((PlayerWorld)it).getId())};
            this.debugLogger.debug("Cache hit", pairArray);
            this.debugLogger.debugMethodExit("loadWorld", ((PlayerWorld)it).getName());
            return it;
        }
        this.debugLogger.debug("Cache miss, loading from disk");
        File file = new File(this.worldsFolder, worldId + ".json");
        Object object2 = new Pair[]{TuplesKt.to("filePath", file.getAbsolutePath()), TuplesKt.to("exists", file.exists())};
        this.debugLogger.debug("Checking file existence", (Pair<String, ? extends Object>)object2);
        if (!file.exists()) {
            this.debugLogger.debugMethodExit("loadWorld", null);
            return null;
        }
        try {
            String json = FilesKt.readText$default(file, null, 1, null);
            Pair[] it = new Pair[]{TuplesKt.to("jsonLength", json.length())};
            this.debugLogger.debug("Read file", it);
            PlayerWorld world = this.gson.fromJson(json, PlayerWorld.class);
            Map map = this.worlds;
            Intrinsics.checkNotNull(world);
            map.put(worldId, world);
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Deserialized and cached world", pairArray);
            this.debugLogger.debugMethodExit("loadWorld", world.getName());
            object2 = world;
        }
        catch (Exception e) {
            this.logger.severe("[DataManager] Failed to load world " + worldId + ": " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Failed to load world", pairArray);
            this.debugLogger.debugMethodExit("loadWorld", null);
            e.printStackTrace();
            object2 = null;
        }
        return object2;
    }

    @Nullable
    public final PlayerWorld loadWorldByName(@NotNull String name) {
        Object v1;
        Pair[] $this$firstOrNull$iv;
        Object object;
        block6: {
            Intrinsics.checkNotNullParameter(name, "name");
            object = new Pair[]{TuplesKt.to("name", name)};
            this.debugLogger.debugMethodEntry("loadWorldByName", (Pair<String, ? extends Object>)object);
            object = new Pair[]{TuplesKt.to("cacheSize", this.worlds.size())};
            this.debugLogger.debug("Checking cache", (Pair<String, ? extends Object>)object);
            Collection<PlayerWorld> collection = this.worlds.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            $this$firstOrNull$iv = (Pair[])collection;
            boolean $i$f$firstOrNull = false;
            for (Object pairArray : $this$firstOrNull$iv) {
                PlayerWorld it = (PlayerWorld)pairArray;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), name, true)) continue;
                v1 = pairArray;
                break block6;
            }
            v1 = null;
        }
        object = v1;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Pair[] n = new Pair[]{TuplesKt.to("worldId", ((PlayerWorld)it).getId())};
            this.debugLogger.debug("Cache hit", n);
            this.debugLogger.debugMethodExit("loadWorldByName", ((PlayerWorld)it).getName());
            return it;
        }
        this.debugLogger.debug("Cache miss, searching disk files");
        File[] files = this.worldsFolder.listFiles();
        $this$firstOrNull$iv = new Pair[]{TuplesKt.to("fileCount", files != null ? files.length : 0)};
        this.debugLogger.debug("Scanning world folder", $this$firstOrNull$iv);
        if (files != null) {
            File[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Pair[] pairArray;
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull(file);
                if (!Intrinsics.areEqual(FilesKt.getExtension(file), "json")) continue;
                try {
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to("fileName", file.getName())};
                    this.debugLogger.debug("Reading file", pairArray2);
                    PlayerWorld world = this.gson.fromJson(FilesKt.readText$default(file, null, 1, null), PlayerWorld.class);
                    Map map = this.worlds;
                    UUID uUID = world.getId();
                    Intrinsics.checkNotNull(world);
                    map.put(uUID, world);
                    if (!StringsKt.equals(world.getName(), name, true)) continue;
                    pairArray = new Pair[]{TuplesKt.to("worldId", world.getId())};
                    this.debugLogger.debug("Found matching world", pairArray);
                    this.debugLogger.debugMethodExit("loadWorldByName", world.getName());
                    return world;
                }
                catch (Exception e) {
                    this.logger.warning("[DataManager] Failed to load world file " + file.getName() + ": " + e.getMessage());
                    pairArray = new Pair[]{TuplesKt.to("fileName", file.getName()), TuplesKt.to("error", e.getMessage())};
                    this.debugLogger.debug("Failed to parse file", pairArray);
                }
            }
        }
        this.debugLogger.debugMethodExit("loadWorldByName", null);
        return null;
    }

    public final void deleteWorld(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("deleteWorld", pairArray);
        PlayerWorld world = this.worlds.remove(worldId);
        if (world != null) {
            var3_3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("newCacheSize", this.worlds.size())};
            this.debugLogger.debug("Removed from cache", var3_3);
        } else {
            var3_3 = new Pair[]{TuplesKt.to("worldId", worldId)};
            this.debugLogger.debug("World was not in cache", var3_3);
        }
        File file = new File(this.worldsFolder, worldId + ".json");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("filePath", file.getAbsolutePath()), TuplesKt.to("exists", file.exists())};
        this.debugLogger.debug("Checking file for deletion", pairArray2);
        if (file.exists()) {
            file.delete();
            this.debugLogger.debug("File deleted successfully");
        } else {
            this.debugLogger.debug("File did not exist");
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "deleteWorld", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanupOrphanedWorld(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("cleanupOrphanedWorld", pairArray);
        PlayerWorld world = this.worlds.remove(worldId);
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("found", world != null);
        PlayerWorld playerWorld = world;
        pairArray2[1] = TuplesKt.to("worldName", playerWorld != null ? playerWorld.getName() : null);
        this.debugLogger.debug("Removed from worlds map", pairArray2);
        if (world != null) {
            void $this$filterTo$iv$iv;
            Pair[] pairArray3;
            File worldFile = new File(this.worldsFolder, worldId + ".json");
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("filePath", worldFile.getAbsolutePath()), TuplesKt.to("exists", worldFile.exists())};
            this.debugLogger.debug("Checking world file", pairArray4);
            if (worldFile.exists()) {
                worldFile.delete();
                this.debugLogger.debug("World file deleted");
            }
            pairArray4 = new Pair[]{TuplesKt.to("ownerUuid", world.getOwnerUuid())};
            this.debugLogger.debug("Loading owner player data", pairArray4);
            PlayerData playerData = this.loadPlayerData(world.getOwnerUuid());
            if (playerData != null) {
                boolean removed = playerData.getOwnedWorlds().remove(worldId);
                pairArray3 = new Pair[]{TuplesKt.to("removed", removed), TuplesKt.to("remainingWorlds", playerData.getOwnedWorlds().size())};
                this.debugLogger.debug("Removed from owner's ownedWorlds", pairArray3);
                this.savePlayerData(playerData);
            }
            Iterable $this$filter$iv = this.invites;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                WorldInvite it = (WorldInvite)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getWorldId(), worldId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List invitesToRemove = (List)destination$iv$iv;
            pairArray3 = new Pair[]{TuplesKt.to("count", invitesToRemove.size())};
            this.debugLogger.debug("Found invites to remove", pairArray3);
            this.invites.removeAll(invitesToRemove);
            if (!((Collection)invitesToRemove).isEmpty()) {
                this.saveInvites();
            }
            pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName())};
            this.debugLogger.debug("Orphaned world cleanup complete", pairArray3);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "cleanupOrphanedWorld", null, 2, null);
    }

    @NotNull
    public final List<PlayerWorld> getAllWorlds() {
        this.debugLogger.debugMethodEntry("getAllWorlds", new Pair[0]);
        Collection<PlayerWorld> collection = this.worlds.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        List<PlayerWorld> worldList = CollectionsKt.toList((Iterable)collection);
        Pair[] pairArray = new Pair[]{TuplesKt.to("count", worldList.size())};
        this.debugLogger.debug("Retrieved all worlds", pairArray);
        this.debugLogger.debugMethodExit("getAllWorlds", worldList.size());
        return worldList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerWorld> getWorldsByOwner(@NotNull UUID ownerUuid) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ownerUuid, "ownerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("ownerUuid", ownerUuid)};
        this.debugLogger.debugMethodEntry("getWorldsByOwner", pairArray);
        Collection<PlayerWorld> collection2 = this.worlds.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $this$filter$iv = collection2;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerWorld it = (PlayerWorld)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOwnerUuid(), ownerUuid)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ownedWorlds = (List)destination$iv$iv;
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("count", ownedWorlds.size());
        Iterable $i$f$filter22 = ownedWorlds;
        String string = "worldNames";
        int n = 1;
        Pair[] pairArray3 = pairArray2;
        String string2 = "Retrieved worlds by owner";
        DebugLogger debugLogger = this.debugLogger;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlayerWorld bl = (PlayerWorld)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv2;
        pairArray3[n] = TuplesKt.to(string, collection);
        debugLogger.debug(string2, pairArray2);
        this.debugLogger.debugMethodExit("getWorldsByOwner", ownedWorlds.size());
        return ownedWorlds;
    }

    public final void savePlayerData(@NotNull PlayerData data) {
        Intrinsics.checkNotNullParameter(data, "data");
        Pair[] pairArray = new Pair[]{TuplesKt.to("username", data.getUsername()), TuplesKt.to("uuid", data.getUuid()), TuplesKt.to("ownedWorldsCount", data.getOwnedWorlds().size()), TuplesKt.to("worldStatesCount", data.getWorldStates().size())};
        this.debugLogger.debugMethodEntry("savePlayerData", pairArray);
        ((Map)this.playerData).put(data.getUuid(), data);
        pairArray = new Pair[]{TuplesKt.to("cacheSize", this.playerData.size())};
        this.debugLogger.debug("Added player data to cache", pairArray);
        File file = new File(this.playersFolder, data.getUuid() + ".json");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("filePath", file.getAbsolutePath())};
        this.debugLogger.debug("Writing to file", pairArray2);
        try {
            String json = this.gson.toJson(data);
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("jsonLength", json.length())};
            this.debugLogger.debug("Serialized player data to JSON", pairArray3);
            Intrinsics.checkNotNull(json);
            FilesKt.writeText$default(file, json, null, 2, null);
            this.debugLogger.debugMethodExit("savePlayerData", "success");
        }
        catch (Exception e) {
            this.logger.severe("[DataManager] Failed to save player data for " + data.getUsername() + " (" + data.getUuid() + "): " + e.getMessage());
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Failed to save player data", pairArray4);
            this.debugLogger.debugMethodExit("savePlayerData", "failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Nullable
    public final PlayerData loadPlayerData(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Object object = new Pair[]{TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("loadPlayerData", (Pair<String, ? extends Object>)object);
        object = this.playerData.get(playerUuid);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("username", ((PlayerData)it).getUsername())};
            this.debugLogger.debug("Cache hit", pairArray);
            this.debugLogger.debugMethodExit("loadPlayerData", ((PlayerData)it).getUsername());
            return it;
        }
        this.debugLogger.debug("Cache miss, loading from disk");
        File file = new File(this.playersFolder, playerUuid + ".json");
        Object object2 = new Pair[]{TuplesKt.to("filePath", file.getAbsolutePath()), TuplesKt.to("exists", file.exists())};
        this.debugLogger.debug("Checking file existence", (Pair<String, ? extends Object>)object2);
        if (!file.exists()) {
            this.debugLogger.debugMethodExit("loadPlayerData", null);
            return null;
        }
        try {
            String json = FilesKt.readText$default(file, null, 1, null);
            Pair[] it = new Pair[]{TuplesKt.to("jsonLength", json.length())};
            this.debugLogger.debug("Read file", it);
            PlayerData data = this.gson.fromJson(json, PlayerData.class);
            Map map = this.playerData;
            Intrinsics.checkNotNull(data);
            map.put(playerUuid, data);
            Pair[] pairArray = new Pair[]{TuplesKt.to("username", data.getUsername())};
            this.debugLogger.debug("Deserialized and cached player data", pairArray);
            this.debugLogger.debugMethodExit("loadPlayerData", data.getUsername());
            object2 = data;
        }
        catch (Exception e) {
            this.logger.severe("[DataManager] Failed to load player data for " + playerUuid + ": " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Failed to load player data", pairArray);
            this.debugLogger.debugMethodExit("loadPlayerData", null);
            e.printStackTrace();
            object2 = null;
        }
        return object2;
    }

    @NotNull
    public final PlayerData getOrCreatePlayerData(@NotNull UUID playerUuid, @NotNull String username) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(username, "username");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("username", username)};
        this.debugLogger.debugMethodEntry("getOrCreatePlayerData", pairArray);
        PlayerData existingData = this.loadPlayerData(playerUuid);
        if (existingData != null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("username", existingData.getUsername())};
            this.debugLogger.debug("Found existing player data", pairArray2);
            this.debugLogger.debugMethodExit("getOrCreatePlayerData", "existing: " + existingData.getUsername());
            return existingData;
        }
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("username", username)};
        this.debugLogger.debug("Creating new player data", pairArray3);
        PlayerData newData = new PlayerData(playerUuid, username, 0, null, null, null, null, null, 252, null);
        this.savePlayerData(newData);
        this.debugLogger.debugMethodExit("getOrCreatePlayerData", "created: " + username);
        return newData;
    }

    @NotNull
    public final List<PlayerData> getAllPlayerData() {
        this.debugLogger.debugMethodEntry("getAllPlayerData", new Pair[0]);
        Collection<PlayerData> collection = this.playerData.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        List<PlayerData> allData = CollectionsKt.toList((Iterable)collection);
        Pair[] pairArray = new Pair[]{TuplesKt.to("count", allData.size())};
        this.debugLogger.debug("Retrieved all player data", pairArray);
        this.debugLogger.debugMethodExit("getAllPlayerData", allData.size());
        return allData;
    }

    public final void saveInvites() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("inviteCount", this.invites.size())};
        this.debugLogger.debugMethodEntry("saveInvites", pairArray);
        pairArray = new Pair[]{TuplesKt.to("filePath", this.invitesFile.getAbsolutePath())};
        this.debugLogger.debug("Writing to file", pairArray);
        try {
            String json = this.gson.toJson(this.invites);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("jsonLength", json.length())};
            this.debugLogger.debug("Serialized invites to JSON", pairArray2);
            Intrinsics.checkNotNull(json);
            FilesKt.writeText$default(this.invitesFile, json, null, 2, null);
            this.debugLogger.debugMethodExit("saveInvites", "success");
        }
        catch (Exception e) {
            this.logger.severe("[DataManager] Failed to save invites: " + e.getMessage());
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Failed to save invites", pairArray3);
            this.debugLogger.debugMethodExit("saveInvites", "failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void loadInvites() {
        this.debugLogger.debugMethodEntry("loadInvites", new Pair[0]);
        Pair[] pairArray = new Pair[]{TuplesKt.to("filePath", this.invitesFile.getAbsolutePath()), TuplesKt.to("exists", this.invitesFile.exists())};
        this.debugLogger.debug("Checking file existence", pairArray);
        if (!this.invitesFile.exists()) {
            this.debugLogger.debugMethodExit("loadInvites", "skipped - no file");
            return;
        }
        try {
            String json = FilesKt.readText$default(this.invitesFile, null, 1, null);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("jsonLength", json.length())};
            this.debugLogger.debug("Read file", pairArray2);
            WorldInvite[] loadedInvites = this.gson.fromJson(json, WorldInvite[].class);
            this.invites.clear();
            Collection collection = this.invites;
            Intrinsics.checkNotNull(loadedInvites);
            CollectionsKt.addAll(collection, loadedInvites);
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("count", this.invites.size())};
            this.debugLogger.debug("Loaded invites into memory", pairArray3);
            this.logger.info("[DataManager] loadInvites: Successfully loaded " + this.invites.size() + " invites");
            this.debugLogger.debugMethodExit("loadInvites", this.invites.size());
        }
        catch (Exception e) {
            this.logger.severe("[DataManager] loadInvites: Failed to load invites: " + e.getMessage());
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
            this.debugLogger.debug("Failed to load invites", pairArray4);
            this.debugLogger.debugMethodExit("loadInvites", "failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void addInvite(@NotNull WorldInvite invite) {
        Intrinsics.checkNotNullParameter(invite, "invite");
        Pair[] pairArray = new Pair[]{TuplesKt.to("inviteeName", invite.getInviteeName()), TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("worldId", invite.getWorldId())};
        this.debugLogger.debugMethodEntry("addInvite", pairArray);
        this.logger.info("[DataManager] addInvite: Adding invite for '" + invite.getInviteeName() + "' to world '" + invite.getWorldName() + "' (World ID: " + invite.getWorldId() + ")");
        this.invites.add(invite);
        pairArray = new Pair[]{TuplesKt.to("newInviteCount", this.invites.size())};
        this.debugLogger.debug("Added invite to list", pairArray);
        this.saveInvites();
        this.debugLogger.debugMethodExit("addInvite", "success");
    }

    public final void removeInvite(@NotNull WorldInvite invite) {
        Intrinsics.checkNotNullParameter(invite, "invite");
        Pair[] pairArray = new Pair[]{TuplesKt.to("inviteeName", invite.getInviteeName()), TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("worldId", invite.getWorldId())};
        this.debugLogger.debugMethodEntry("removeInvite", pairArray);
        this.logger.info("[DataManager] removeInvite: Removing invite for '" + invite.getInviteeName() + "' to world '" + invite.getWorldName() + "' (World ID: " + invite.getWorldId() + ")");
        boolean removed = this.invites.remove(invite);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("wasRemoved", removed), TuplesKt.to("newInviteCount", this.invites.size())};
        this.debugLogger.debug("Removed invite from list", pairArray2);
        this.saveInvites();
        this.debugLogger.debugMethodExit("removeInvite", removed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WorldInvite> getInvitesForPlayer(@NotNull UUID playerUuid) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("getInvitesForPlayer", pairArray);
        Iterable $this$filter$iv = this.invites;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WorldInvite it = (WorldInvite)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getInviteeUuid(), playerUuid)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playerInvites = (List)destination$iv$iv;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("totalInvites", this.invites.size()), TuplesKt.to("matchingInvites", playerInvites.size())};
        this.debugLogger.debug("Filtered invites for player", pairArray2);
        this.debugLogger.debugMethodExit("getInvitesForPlayer", playerInvites.size());
        return playerInvites;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WorldInvite> getInvitesForWorld(@NotNull UUID worldId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("getInvitesForWorld", pairArray);
        Iterable $this$filter$iv = this.invites;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WorldInvite it = (WorldInvite)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getWorldId(), worldId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List worldInvites = (List)destination$iv$iv;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("totalInvites", this.invites.size()), TuplesKt.to("matchingInvites", worldInvites.size())};
        this.debugLogger.debug("Filtered invites for world", pairArray2);
        this.debugLogger.debugMethodExit("getInvitesForWorld", worldInvites.size());
        return worldInvites;
    }

    @Nullable
    public final WorldInvite getInvite(@NotNull UUID worldId, @NotNull UUID inviteeUuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(worldId, "worldId");
            Intrinsics.checkNotNullParameter(inviteeUuid, "inviteeUuid");
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("inviteeUuid", inviteeUuid)};
            this.debugLogger.debugMethodEntry("getInvite", pairArray);
            Iterable $this$firstOrNull$iv = this.invites;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WorldInvite it = (WorldInvite)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getWorldId(), worldId) && Intrinsics.areEqual(it.getInviteeUuid(), inviteeUuid))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        WorldInvite invite = v0;
        Pair[] pairArray = new Pair[]{TuplesKt.to("found", invite != null)};
        this.debugLogger.debug("Invite lookup result", pairArray);
        this.debugLogger.debugMethodExit("getInvite", invite != null);
        return invite;
    }

    @NotNull
    public final List<WorldInvite> getAllInvites() {
        this.debugLogger.debugMethodEntry("getAllInvites", new Pair[0]);
        List<WorldInvite> allInvites = CollectionsKt.toList((Iterable)this.invites);
        Pair[] pairArray = new Pair[]{TuplesKt.to("count", allInvites.size())};
        this.debugLogger.debug("Retrieved all invites", pairArray);
        this.debugLogger.debugMethodExit("getAllInvites", allInvites.size());
        return allInvites;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadAll() {
        List list;
        List list2;
        int n2;
        this.debugLogger.debugMethodEntry("loadAll", new Pair[0]);
        this.logger.info("[DataManager] loadAll: Starting to load all data from disk...");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldsFolderPath", this.worldsFolder.getAbsolutePath()), TuplesKt.to("playersFolderPath", this.playersFolder.getAbsolutePath())};
        this.debugLogger.debug("Starting bulk data load", pairArray);
        File[] fileArray = this.worldsFolder.listFiles();
        if (fileArray != null) {
            Iterator $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Pair[] element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                n2 = 0;
                Intrinsics.checkNotNull(it);
                if (!Intrinsics.areEqual(FilesKt.getExtension((File)it), "json")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List worldFiles = list2;
        this.logger.info("[DataManager] loadAll: Found " + worldFiles.size() + " world files to load");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", worldFiles.size())};
        this.debugLogger.debug("Found world files", pairArray2);
        int worldSuccessCount = 0;
        int worldFailCount = 0;
        Pair[] $this$forEach$iv = (Pair[])worldFiles;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            try {
                Pair[] pairArray3 = new Pair[]{TuplesKt.to("fileName", file.getName())};
                this.debugLogger.debug("Loading world file", pairArray3);
                Intrinsics.checkNotNull(file);
                PlayerWorld world = this.gson.fromJson(FilesKt.readText$default(file, null, 1, null), PlayerWorld.class);
                Map map = this.worlds;
                UUID uUID = world.getId();
                Intrinsics.checkNotNull(world);
                map.put(uUID, world);
                ++worldSuccessCount;
                this.logger.info("[DataManager] loadAll: Loaded world '" + world.getName() + "' (Owner: " + world.getOwnerName() + ")");
            }
            catch (Exception e) {
                Pair[] element$iv$iv;
                ++worldFailCount;
                this.logger.warning("[DataManager] loadAll: Failed to load world file " + file.getName() + ": " + e.getMessage());
                element$iv$iv = new Pair[]{TuplesKt.to("fileName", file.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
                this.debugLogger.debug("Failed to load world file", element$iv$iv);
            }
        }
        this.logger.info("[DataManager] loadAll: Successfully loaded " + this.worlds.size() + " worlds");
        $this$forEach$iv = new Pair[]{TuplesKt.to("successCount", worldSuccessCount), TuplesKt.to("failCount", worldFailCount)};
        this.debugLogger.debug("World loading complete", $this$forEach$iv);
        File[] fileArray3 = this.playersFolder.listFiles();
        if (fileArray3 != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray3;
            boolean $i$f$filter = false;
            File[] bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            n2 = ((void)$this$filterTo$iv$iv).length;
            for (int it = 0; it < n2; ++it) {
                void element$iv$iv;
                void it2 = element$iv$iv = $this$filterTo$iv$iv[it];
                boolean bl2 = false;
                Intrinsics.checkNotNull(it2);
                if (!Intrinsics.areEqual(FilesKt.getExtension((File)it2), "json")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List playerFiles = list;
        this.logger.info("[DataManager] loadAll: Found " + playerFiles.size() + " player data files to load");
        Pair[] $i$f$forEach22 = new Pair[]{TuplesKt.to("count", playerFiles.size())};
        this.debugLogger.debug("Found player data files", $i$f$forEach22);
        int playerSuccessCount = 0;
        int playerFailCount = 0;
        Iterable $this$forEach$iv2 = playerFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            File file = (File)element$iv;
            boolean bl = false;
            try {
                Pair[] n2 = new Pair[]{TuplesKt.to("fileName", file.getName())};
                this.debugLogger.debug("Loading player data file", n2);
                Intrinsics.checkNotNull(file);
                PlayerData data = this.gson.fromJson(FilesKt.readText$default(file, null, 1, null), PlayerData.class);
                Map map = this.playerData;
                UUID uUID = data.getUuid();
                Intrinsics.checkNotNull(data);
                map.put(uUID, data);
                ++playerSuccessCount;
                this.logger.info("[DataManager] loadAll: Loaded player data for '" + data.getUsername() + "'");
            }
            catch (Exception e) {
                ++playerFailCount;
                this.logger.warning("[DataManager] loadAll: Failed to load player data file " + file.getName() + ": " + e.getMessage());
                Pair[] pairArray4 = new Pair[]{TuplesKt.to("fileName", file.getName()), TuplesKt.to("exceptionType", e.getClass().getSimpleName()), TuplesKt.to("exceptionMessage", e.getMessage())};
                this.debugLogger.debug("Failed to load player data file", pairArray4);
            }
        }
        this.logger.info("[DataManager] loadAll: Successfully loaded " + this.playerData.size() + " player data records");
        Pair[] pairArray5 = new Pair[]{TuplesKt.to("successCount", playerSuccessCount), TuplesKt.to("failCount", playerFailCount)};
        this.debugLogger.debug("Player data loading complete", pairArray5);
        this.debugLogger.debug("Loading invites");
        this.loadInvites();
        this.logger.info("[DataManager] loadAll: Data loading complete - " + this.worlds.size() + " worlds, " + this.playerData.size() + " players, " + this.invites.size() + " invites");
        pairArray5 = new Pair[]{TuplesKt.to("worldsCount", this.worlds.size()), TuplesKt.to("playerDataCount", this.playerData.size()), TuplesKt.to("invitesCount", this.invites.size())};
        this.debugLogger.debugState("loadAll complete", pairArray5);
        this.debugLogger.debugMethodExit("loadAll", "success");
    }

    public final void saveAll() {
        Object it;
        this.debugLogger.debugMethodEntry("saveAll", new Pair[0]);
        this.logger.info("[DataManager] saveAll: Starting to save all data to disk...");
        this.logger.info("[DataManager] saveAll: Saving " + this.worlds.size() + " worlds, " + this.playerData.size() + " players, " + this.invites.size() + " invites");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldsCount", this.worlds.size()), TuplesKt.to("playerDataCount", this.playerData.size()), TuplesKt.to("invitesCount", this.invites.size())};
        this.debugLogger.debug("Starting bulk data save", pairArray);
        this.debugLogger.debug("Saving all worlds");
        Collection<PlayerWorld> collection = this.worlds.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PlayerWorld)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.saveWorld((PlayerWorld)it);
        }
        this.debugLogger.debug("All worlds saved");
        this.debugLogger.debug("Saving all player data");
        Collection<PlayerData> collection2 = this.playerData.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PlayerData)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.savePlayerData((PlayerData)it);
        }
        this.debugLogger.debug("All player data saved");
        this.debugLogger.debug("Saving invites");
        this.saveInvites();
        this.logger.info("[DataManager] saveAll: All data saved successfully");
        this.debugLogger.debugMethodExit("saveAll", "success");
    }
}

