/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.NoWhenBranchMatchedException;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.models.ChatMode;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\nJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltech/bedson/playerworldmanager/managers/ChatManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "chatModes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ltech/bedson/playerworldmanager/models/ChatMode;", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "clearCache", "", "playerUuid", "getChatMode", "getChatPrefix", "Lnet/kyori/adventure/text/Component;", "mode", "loadPlayerChatMode", "player", "Lorg/bukkit/entity/Player;", "savePlayerChatMode", "setChatMode", "shouldReceiveMessage", "", "sender", "receiver", "PlayerWorldManager"})
public final class ChatManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final ConcurrentHashMap<UUID, ChatMode> chatModes;

    public ChatManager(@NotNull JavaPlugin plugin, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "ChatManager");
        this.chatModes = new ConcurrentHashMap();
    }

    @NotNull
    public final ChatMode getChatMode(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("getChatMode", pairArray);
        ChatMode chatMode = this.chatModes.getOrDefault(playerUuid, ChatMode.GLOBAL);
        Intrinsics.checkNotNullExpressionValue((Object)chatMode, "getOrDefault(...)");
        ChatMode mode = chatMode;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("mode", mode), TuplesKt.to("wasInCache", this.chatModes.containsKey(playerUuid))};
        this.debugLogger.debug("Retrieved chat mode", pairArray2);
        this.debugLogger.debugMethodExit("getChatMode", (Object)mode);
        return mode;
    }

    public final void setChatMode(@NotNull UUID playerUuid, @NotNull ChatMode mode) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid), TuplesKt.to("mode", mode)};
        this.debugLogger.debugMethodEntry("setChatMode", pairArray);
        this.plugin.getLogger().info("[ChatManager] setChatMode: Setting chat mode to " + mode + " for player UUID: " + playerUuid);
        ChatMode previousMode = this.chatModes.get(playerUuid);
        ((Map)this.chatModes).put(playerUuid, mode);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("previousMode", previousMode), TuplesKt.to("newMode", mode)};
        this.debugLogger.debug("Updated cache", pairArray2);
        PlayerData playerData = this.dataManager.loadPlayerData(playerUuid);
        if (playerData != null) {
            playerData.getChatSettings().setChatMode(mode);
            this.dataManager.savePlayerData(playerData);
            this.plugin.getLogger().info("[ChatManager] setChatMode: Successfully set chat mode to " + mode + " for '" + playerData.getUsername() + "'");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("username", playerData.getUsername())};
            this.debugLogger.debug("Persisted chat mode to disk", pairArray3);
            this.debugLogger.debugMethodExit("setChatMode", "success");
        } else {
            this.plugin.getLogger().warning("[ChatManager] setChatMode: Could not load player data for UUID: " + playerUuid);
            this.debugLogger.debug("Failed to load player data for persistence");
            this.debugLogger.debugMethodExit("setChatMode", "partial - data not persisted");
        }
    }

    public final void loadPlayerChatMode(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("loadPlayerChatMode", pairArray);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        PlayerData playerData = this.dataManager.getOrCreatePlayerData(uUID, string);
        Pair[] pairArray2 = (Pair[])this.chatModes;
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        UUID uUID3 = uUID2;
        ChatMode chatMode = playerData.getChatSettings().getChatMode();
        pairArray2.put(uUID3, chatMode);
        this.plugin.getLogger().info("Loaded chat mode " + playerData.getChatSettings().getChatMode() + " for " + player.getName());
        pairArray2 = new Pair[]{TuplesKt.to("mode", playerData.getChatSettings().getChatMode()), TuplesKt.to("cacheSize", this.chatModes.size())};
        this.debugLogger.debug("Loaded chat mode into cache", pairArray2);
        this.debugLogger.debugMethodExit("loadPlayerChatMode", (Object)playerData.getChatSettings().getChatMode());
    }

    public final void savePlayerChatMode(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerName", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("savePlayerChatMode", pairArray);
        ChatMode mode = this.chatModes.get(player.getUniqueId());
        if (mode == null) {
            this.debugLogger.debug("No cached mode to save, skipping");
            this.debugLogger.debugMethodExit("savePlayerChatMode", "skipped - no cache");
            return;
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        PlayerData playerData = this.dataManager.loadPlayerData(uUID);
        if (playerData != null) {
            playerData.getChatSettings().setChatMode(mode);
            this.dataManager.savePlayerData(playerData);
            this.plugin.getLogger().info("Saved chat mode " + mode + " for " + player.getName());
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("mode", mode)};
            this.debugLogger.debug("Saved chat mode to disk", pairArray2);
            this.debugLogger.debugMethodExit("savePlayerChatMode", "success");
        } else {
            this.debugLogger.debug("Failed to load player data for saving");
            this.debugLogger.debugMethodExit("savePlayerChatMode", "failed - no player data");
        }
    }

    public final boolean shouldReceiveMessage(@NotNull Player sender, @NotNull Player receiver) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Pair[] pairArray = new Pair[]{TuplesKt.to("senderName", sender.getName()), TuplesKt.to("receiverName", receiver.getName()), TuplesKt.to("senderWorld", sender.getWorld().getName()), TuplesKt.to("receiverWorld", receiver.getWorld().getName())};
        this.debugLogger.debugMethodEntry("shouldReceiveMessage", pairArray);
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        ChatMode senderMode = this.getChatMode(uUID);
        boolean sameWorld = Intrinsics.areEqual(sender.getWorld(), receiver.getWorld());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("senderMode", senderMode), TuplesKt.to("sameWorld", sameWorld)};
        this.debugLogger.debug("Evaluating message routing", pairArray2);
        boolean result = switch (WhenMappings.$EnumSwitchMapping$0[senderMode.ordinal()]) {
            case 1 -> {
                this.debugLogger.debug("GLOBAL mode - message goes to all");
                yield true;
            }
            case 2 -> {
                Pair[] var6_7 = new Pair[]{TuplesKt.to("sameWorld", sameWorld)};
                this.debugLogger.debug("WORLD mode - checking same world", var6_7);
                yield sameWorld;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        this.plugin.getLogger().info("[ChatManager] shouldReceiveMessage: Sender '" + sender.getName() + "' (" + senderMode + ") -> Receiver '" + receiver.getName() + "', Same world: " + sameWorld + ", Result: " + result);
        this.debugLogger.debugMethodExit("shouldReceiveMessage", result);
        return result;
    }

    @NotNull
    public final Component getChatPrefix(@NotNull ChatMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Pair[] pairArray = new Pair[]{TuplesKt.to("mode", mode)};
        this.debugLogger.debugMethodEntry("getChatPrefix", pairArray);
        TextComponent textComponent = switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> Component.text("[G] ", (TextColor)NamedTextColor.GRAY);
            case 2 -> Component.text("[W] ", (TextColor)NamedTextColor.GREEN);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull(textComponent);
        TextComponent prefix = textComponent;
        this.debugLogger.debugMethodExit("getChatPrefix", mode.name());
        return prefix;
    }

    public final void clearCache(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("clearCache", pairArray);
        ChatMode removed = this.chatModes.remove(playerUuid);
        if (removed != null) {
            this.plugin.getLogger().info("[ChatManager] clearCache: Cleared chat mode cache for player UUID: " + playerUuid + " (was " + removed + ")");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("previousMode", removed), TuplesKt.to("newCacheSize", this.chatModes.size())};
            this.debugLogger.debug("Removed cache entry", pairArray2);
        } else {
            this.plugin.getLogger().info("[ChatManager] clearCache: No cache entry found for player UUID: " + playerUuid);
            this.debugLogger.debug("No cache entry to remove");
        }
        this.debugLogger.debugMethodExit("clearCache", (Object)removed);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatMode.values().length];
            try {
                nArray[ChatMode.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMode.WORLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

