/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.ResultKt;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.comparisons.ComparisonsKt;
import tech.bedson.playerworldmanager.libs.kotlin.io.FilesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.BackupManager;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.BackupSchedule;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldBackup;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J0\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0#0\"2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010(\u001a\u00020)J\u001a\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0#0\"2\u0006\u0010+\u001a\u00020\fJ\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010-\u001a\u00020\u000bJ\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u000e\u0010/\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u000bJ\u0010\u00100\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u000bH\u0002J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f02J\u0010\u00103\u001a\u0004\u0018\u00010\f2\u0006\u00104\u001a\u00020\u000bJ\u0010\u00105\u001a\u0004\u0018\u00010\u00192\u0006\u0010-\u001a\u00020\u000bJ\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\f022\u0006\u00107\u001a\u00020\u000bJ\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\f022\u0006\u0010-\u001a\u00020\u000bJ\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020:J\u0006\u0010<\u001a\u00020\u001eJ\u0006\u0010=\u001a\u00020)J\b\u0010>\u001a\u00020\u001eH\u0002J\b\u0010?\u001a\u00020\u001eH\u0002J\u001a\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0#0\"2\u0006\u0010+\u001a\u00020\fJ\u0010\u0010A\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\fH\u0002J\b\u0010B\u001a\u00020\u001eH\u0002J'\u0010C\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020)2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010:\u00a2\u0006\u0002\u0010FJ\u0006\u0010G\u001a\u00020\u001eJ\b\u0010H\u001a\u00020\u001eH\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Ltech/bedson/playerworldmanager/managers/BackupManager;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/managers/WorldManager;)V", "backups", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ltech/bedson/playerworldmanager/models/WorldBackup;", "backupsDataFolder", "Ljava/io/File;", "backupsFolder", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "gson", "Lcom/google/gson/Gson;", "logger", "Ljava/util/logging/Logger;", "schedulerTaskId", "", "schedules", "Ltech/bedson/playerworldmanager/models/BackupSchedule;", "schedulesFile", "calculateDirectorySize", "directory", "copyDirectory", "", "source", "destination", "createBackup", "Ljava/util/concurrent/CompletableFuture;", "Ltech/bedson/playerworldmanager/libs/kotlin/Result;", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "description", "", "isAutomatic", "", "deleteBackup", "backup", "deleteBackupsForWorld", "worldId", "deleteDirectory", "disableBackupSchedule", "enforceBackupLimit", "getAllBackups", "", "getBackup", "backupId", "getBackupSchedule", "getBackupsForPlayer", "playerUuid", "getBackupsForWorld", "getDefaultBackupIntervalMinutes", "", "getMaxBackupsPerWorld", "initialize", "isAutoBackupEnabled", "loadAllBackups", "loadSchedules", "restoreBackup", "saveBackup", "saveSchedules", "setBackupSchedule", "enabled", "intervalMinutes", "(Ljava/util/UUID;ZLjava/lang/Integer;)Ltech/bedson/playerworldmanager/models/BackupSchedule;", "shutdown", "startSchedulerTask", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nBackupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupManager.kt\ntech/bedson/playerworldmanager/managers/BackupManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,757:1\n766#2:758\n857#2,2:759\n1054#2:761\n766#2:762\n857#2,2:763\n1054#2:765\n1054#2:766\n1855#2,2:770\n1855#2,2:774\n1549#2:776\n1620#2,3:777\n1549#2:788\n1620#2,3:789\n1855#2,2:792\n766#2:794\n857#2,2:795\n1855#2,2:797\n3792#3:767\n4307#3,2:768\n13309#3,2:772\n13309#3,2:782\n13309#3,2:784\n13309#3,2:786\n37#4,2:780\n*S KotlinDebug\n*F\n+ 1 BackupManager.kt\ntech/bedson/playerworldmanager/managers/BackupManager\n*L\n428#1:758\n428#1:759,2\n429#1:761\n439#1:762\n439#1:763,2\n440#1:765\n456#1:766\n614#1:770,2\n680#1:774,2\n703#1:776\n703#1:777,3\n243#1:788\n243#1:789,3\n246#1:792,2\n557#1:794\n557#1:795,2\n557#1:797,2\n611#1:767\n611#1:768,2\n656#1:772,2\n721#1:782,2\n737#1:784,2\n748#1:786,2\n704#1:780,2\n*E\n"})
public final class BackupManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final Gson gson;
    @NotNull
    private final File backupsFolder;
    @NotNull
    private final File backupsDataFolder;
    @NotNull
    private final File schedulesFile;
    @NotNull
    private final ConcurrentHashMap<UUID, WorldBackup> backups;
    @NotNull
    private final ConcurrentHashMap<UUID, BackupSchedule> schedules;
    private long schedulerTaskId;

    public BackupManager(@NotNull JavaPlugin plugin, @NotNull DataManager dataManager, @NotNull WorldManager worldManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.worldManager = worldManager;
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
        this.debugLogger = new DebugLogger(this.plugin, "BackupManager");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        this.gson = gson;
        this.backupsFolder = new File(this.plugin.getDataFolder(), "backups");
        this.backupsDataFolder = new File(this.backupsFolder, "data");
        this.schedulesFile = new File(this.backupsFolder, "schedules.json");
        this.backups = new ConcurrentHashMap();
        this.schedules = new ConcurrentHashMap();
        this.schedulerTaskId = -1L;
        this.backupsFolder.mkdirs();
        this.backupsDataFolder.mkdirs();
    }

    public final int getMaxBackupsPerWorld() {
        return this.plugin.getConfig().getInt("backups.max-backups-per-world", 5);
    }

    public final int getDefaultBackupIntervalMinutes() {
        return this.plugin.getConfig().getInt("backups.default-interval-minutes", 1440);
    }

    public final boolean isAutoBackupEnabled() {
        return this.plugin.getConfig().getBoolean("backups.auto-backup-enabled", true);
    }

    @NotNull
    public final CompletableFuture<Result<WorldBackup>> createBackup(@NotNull PlayerWorld world, @Nullable String description, boolean isAutomatic) {
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("description", description), TuplesKt.to("isAutomatic", isAutomatic)};
        this.debugLogger.debugMethodEntry("createBackup", pairArray);
        CompletableFuture<Result<WorldBackup>> future = new CompletableFuture<Result<WorldBackup>>();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, arg_0 -> BackupManager.createBackup$lambda$0(this, world, future, description, isAutomatic, arg_0));
        return future;
    }

    public static /* synthetic */ CompletableFuture createBackup$default(BackupManager backupManager, PlayerWorld playerWorld, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return backupManager.createBackup(playerWorld, string, bl);
    }

    @NotNull
    public final CompletableFuture<Result<Unit>> restoreBackup(@NotNull WorldBackup backup) {
        Intrinsics.checkNotNullParameter(backup, "backup");
        Pair[] pairArray = new Pair[]{TuplesKt.to("backupId", backup.getId()), TuplesKt.to("worldId", backup.getWorldId()), TuplesKt.to("worldName", backup.getWorldName())};
        this.debugLogger.debugMethodEntry("restoreBackup", pairArray);
        CompletableFuture<Result<Unit>> future = new CompletableFuture<Result<Unit>>();
        PlayerWorld world = this.dataManager.loadWorld(backup.getWorldId());
        if (world == null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldId", backup.getWorldId())};
            this.debugLogger.debug("World not found for backup", pairArray2);
            future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new IllegalStateException("World not found")))));
            return future;
        }
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, arg_0 -> BackupManager.restoreBackup$lambda$5(backup, this, future, world, arg_0));
        return future;
    }

    @NotNull
    public final CompletableFuture<Result<Unit>> deleteBackup(@NotNull WorldBackup backup) {
        Intrinsics.checkNotNullParameter(backup, "backup");
        Pair[] pairArray = new Pair[]{TuplesKt.to("backupId", backup.getId())};
        this.debugLogger.debugMethodEntry("deleteBackup", pairArray);
        CompletableFuture<Result<Unit>> future = new CompletableFuture<Result<Unit>>();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, arg_0 -> BackupManager.deleteBackup$lambda$6(backup, this, future, arg_0));
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WorldBackup> getBackupsForWorld(@NotNull UUID worldId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("getBackupsForWorld", pairArray);
        Collection<WorldBackup> collection = this.backups.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WorldBackup it = (WorldBackup)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getWorldId(), worldId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List<WorldBackup> worldBackups = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                WorldBackup it = (WorldBackup)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCreatedAt());
                it = (WorldBackup)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getCreatedAt());
            }
        });
        this.debugLogger.debugMethodExit("getBackupsForWorld", worldBackups.size());
        return worldBackups;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WorldBackup> getBackupsForPlayer(@NotNull UUID playerUuid) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", playerUuid)};
        this.debugLogger.debugMethodEntry("getBackupsForPlayer", pairArray);
        Collection<WorldBackup> collection = this.backups.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WorldBackup it = (WorldBackup)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOwnerUuid(), playerUuid)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List<WorldBackup> playerBackups = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                WorldBackup it = (WorldBackup)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCreatedAt());
                it = (WorldBackup)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getCreatedAt());
            }
        });
        this.debugLogger.debugMethodExit("getBackupsForPlayer", playerBackups.size());
        return playerBackups;
    }

    @Nullable
    public final WorldBackup getBackup(@NotNull UUID backupId) {
        Intrinsics.checkNotNullParameter(backupId, "backupId");
        return this.backups.get(backupId);
    }

    @NotNull
    public final List<WorldBackup> getAllBackups() {
        Collection<WorldBackup> collection = this.backups.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)collection);
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                WorldBackup it = (WorldBackup)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCreatedAt());
                it = (WorldBackup)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getCreatedAt());
            }
        });
    }

    @NotNull
    public final BackupSchedule setBackupSchedule(@NotNull UUID worldId, boolean enabled, @Nullable Integer intervalMinutes) {
        int n;
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId), TuplesKt.to("enabled", enabled), TuplesKt.to("intervalMinutes", intervalMinutes)};
        this.debugLogger.debugMethodEntry("setBackupSchedule", pairArray);
        BackupSchedule existing = this.schedules.get(worldId);
        Integer n2 = intervalMinutes;
        if (n2 != null) {
            n = n2;
        } else {
            BackupSchedule backupSchedule = existing;
            Integer n3 = backupSchedule != null ? Integer.valueOf(backupSchedule.getIntervalMinutes()) : null;
            n = n3 != null ? n3.intValue() : this.getDefaultBackupIntervalMinutes();
        }
        BackupSchedule backupSchedule = existing;
        BackupSchedule schedule = new BackupSchedule(worldId, enabled, n, backupSchedule != null ? backupSchedule.getLastBackupTime() : 0L);
        ((Map)this.schedules).put(worldId, schedule);
        this.saveSchedules();
        this.debugLogger.debugMethodExit("setBackupSchedule", schedule.toString());
        return schedule;
    }

    public static /* synthetic */ BackupSchedule setBackupSchedule$default(BackupManager backupManager, UUID uUID, boolean bl, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return backupManager.setBackupSchedule(uUID, bl, n);
    }

    @Nullable
    public final BackupSchedule getBackupSchedule(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        return this.schedules.get(worldId);
    }

    public final void disableBackupSchedule(@NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("disableBackupSchedule", pairArray);
        BackupSchedule backupSchedule = this.schedules.get(worldId);
        if (backupSchedule != null) {
            BackupSchedule existing = backupSchedule;
            boolean bl = false;
            ((Map)this.schedules).put(worldId, BackupSchedule.copy$default(existing, null, false, 0, 0L, 13, null));
            this.saveSchedules();
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "disableBackupSchedule", null, 2, null);
    }

    public final void initialize() {
        this.debugLogger.debugMethodEntry("initialize", new Pair[0]);
        this.logger.info("Initializing BackupManager...");
        this.loadAllBackups();
        this.loadSchedules();
        this.startSchedulerTask();
        this.logger.info("BackupManager initialized with " + this.backups.size() + " backups and " + this.schedules.size() + " schedules");
        DebugLogger.debugMethodExit$default(this.debugLogger, "initialize", null, 2, null);
    }

    public final void shutdown() {
        this.debugLogger.debugMethodEntry("shutdown", new Pair[0]);
        this.logger.info("Shutting down BackupManager...");
        this.saveSchedules();
        this.logger.info("BackupManager shutdown complete");
        DebugLogger.debugMethodExit$default(this.debugLogger, "shutdown", null, 2, null);
    }

    private final void startSchedulerTask() {
        this.debugLogger.debug("Starting backup scheduler task");
        Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, arg_0 -> BackupManager.startSchedulerTask$lambda$16(this, arg_0), 1L, 1L, TimeUnit.MINUTES);
    }

    private final void saveBackup(WorldBackup backup) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("backupId", backup.getId())};
        this.debugLogger.debugMethodEntry("saveBackup", pairArray);
        ((Map)this.backups).put(backup.getId(), backup);
        File file = new File(this.backupsFolder, backup.getId() + ".json");
        try {
            String string = this.gson.toJson(backup);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            FilesKt.writeText$default(file, string, null, 2, null);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("file", file.getName())};
            this.debugLogger.debug("Backup metadata saved", pairArray2);
        }
        catch (Exception e) {
            this.logger.severe("[BackupManager] Failed to save backup metadata: " + e.getMessage());
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "saveBackup", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAllBackups() {
        List list;
        this.debugLogger.debugMethodEntry("loadAllBackups", new Pair[0]);
        File[] fileArray = this.backupsFolder.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!(Intrinsics.areEqual(FilesKt.getExtension((File)it), "json") && !Intrinsics.areEqual(it.getName(), "schedules.json"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List files = list;
        Pair[] pairArray = new Pair[]{TuplesKt.to("count", files.size())};
        this.debugLogger.debug("Found backup files", pairArray);
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull(file);
                WorldBackup backup = this.gson.fromJson(FilesKt.readText$default(file, null, 1, null), WorldBackup.class);
                Map map = this.backups;
                UUID uUID = backup.getId();
                Intrinsics.checkNotNull(backup);
                map.put(uUID, backup);
            }
            catch (Exception e) {
                this.logger.warning("[BackupManager] Failed to load backup file " + file.getName() + ": " + e.getMessage());
            }
        }
        this.debugLogger.debugMethodExit("loadAllBackups", this.backups.size());
    }

    private final void saveSchedules() {
        this.debugLogger.debugMethodEntry("saveSchedules", new Pair[0]);
        try {
            Collection<BackupSchedule> collection = this.schedules.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            String string = this.gson.toJson(CollectionsKt.toList((Iterable)collection));
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            FilesKt.writeText$default(this.schedulesFile, string, null, 2, null);
            Pair[] pairArray = new Pair[]{TuplesKt.to("count", this.schedules.size())};
            this.debugLogger.debug("Schedules saved", pairArray);
        }
        catch (Exception e) {
            this.logger.severe("[BackupManager] Failed to save schedules: " + e.getMessage());
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "saveSchedules", null, 2, null);
    }

    private final void loadSchedules() {
        this.debugLogger.debugMethodEntry("loadSchedules", new Pair[0]);
        if (!this.schedulesFile.exists()) {
            this.debugLogger.debug("No schedules file found");
            this.debugLogger.debugMethodExit("loadSchedules", 0);
            return;
        }
        try {
            BackupSchedule[] loadedSchedules = this.gson.fromJson(FilesKt.readText$default(this.schedulesFile, null, 1, null), BackupSchedule[].class);
            Intrinsics.checkNotNull(loadedSchedules);
            BackupSchedule[] $this$forEach$iv = loadedSchedules;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                BackupSchedule element$iv;
                BackupSchedule schedule = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                ((Map)this.schedules).put(schedule.getWorldId(), schedule);
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to("count", this.schedules.size())};
            this.debugLogger.debug("Schedules loaded", pairArray);
        }
        catch (Exception e) {
            this.logger.warning("[BackupManager] Failed to load schedules: " + e.getMessage());
        }
        this.debugLogger.debugMethodExit("loadSchedules", this.schedules.size());
    }

    private final void enforceBackupLimit(UUID worldId) {
        int maxBackups = this.getMaxBackupsPerWorld();
        List<WorldBackup> worldBackups = this.getBackupsForWorld(worldId);
        if (worldBackups.size() >= maxBackups) {
            List backupsToRemove = CollectionsKt.drop((Iterable)worldBackups, maxBackups - 1);
            Iterable $this$forEach$iv = backupsToRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorldBackup backup = (WorldBackup)element$iv;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to("backupId", backup.getId()), TuplesKt.to("worldId", worldId)};
                this.debugLogger.debug("Removing old backup to enforce limit", pairArray);
                this.deleteBackup(backup);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Unit> deleteBackupsForWorld(@NotNull UUID worldId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldId", worldId)};
        this.debugLogger.debugMethodEntry("deleteBackupsForWorld", pairArray);
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        List<WorldBackup> worldBackups = this.getBackupsForWorld(worldId);
        if (worldBackups.isEmpty()) {
            future.complete(Unit.INSTANCE);
            return future;
        }
        Iterable $this$map$iv = worldBackups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WorldBackup worldBackup = (WorldBackup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.deleteBackup((WorldBackup)it));
        }
        List deleteFutures = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = deleteFutures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenAccept(arg_0 -> BackupManager.deleteBackupsForWorld$lambda$22(new Function1<Void, Unit>(this, worldId, future){
            final /* synthetic */ BackupManager this$0;
            final /* synthetic */ UUID $worldId;
            final /* synthetic */ CompletableFuture<Unit> $future;
            {
                this.this$0 = $receiver;
                this.$worldId = $worldId;
                this.$future = $future;
                super(1);
            }

            public final void invoke(Void it) {
                BackupManager.access$getSchedules$p(this.this$0).remove(this.$worldId);
                BackupManager.access$saveSchedules(this.this$0);
                this.$future.complete(Unit.INSTANCE);
            }
        }, arg_0));
        DebugLogger.debugMethodExit$default(this.debugLogger, "deleteBackupsForWorld", null, 2, null);
        return future;
    }

    private final void copyDirectory(File source, File destination) {
        if (source.isDirectory()) {
            destination.mkdirs();
            File[] fileArray = source.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (Intrinsics.areEqual(file.getName(), "session.lock")) continue;
                    Intrinsics.checkNotNull(file);
                    this.copyDirectory(file, new File(destination, file.getName()));
                }
            }
        } else {
            FilesKt.copyTo$default(source, destination, true, 0, 4, null);
        }
    }

    private final void deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    this.deleteDirectory(it);
                }
            }
        }
        directory.delete();
    }

    private final long calculateDirectorySize(File directory) {
        long size = 0L;
        if (directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull(file);
                    size += this.calculateDirectorySize(file);
                }
            }
        } else {
            size = directory.length();
        }
        return size;
    }

    private static final void createBackup$lambda$0(BackupManager this$0, PlayerWorld $world, CompletableFuture $future, String $description, boolean $isAutomatic, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($future, "$future");
        try {
            File endFolder;
            this$0.enforceBackupLimit($world.getId());
            UUID backupId = UUID.randomUUID();
            long timestamp = System.currentTimeMillis();
            String backupFolderName = $world.getOwnerName() + "_" + $world.getName() + "_" + timestamp;
            String backupPath = "data/" + backupFolderName;
            Pair[] pairArray = new Pair[]{TuplesKt.to("backupId", backupId), TuplesKt.to("backupPath", backupPath)};
            this$0.debugLogger.debug("Creating backup", pairArray);
            String worldFolderName = $world.getOwnerName() + "_" + $world.getName();
            File worldFolder = new File(Bukkit.getServer().getWorldContainer(), worldFolderName);
            if (!worldFolder.exists()) {
                Pair[] pairArray2 = new Pair[]{TuplesKt.to("path", worldFolder.getAbsolutePath())};
                this$0.debugLogger.debug("World folder not found", pairArray2);
                $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new IllegalStateException("World folder not found: " + worldFolder.getAbsolutePath())))));
                return;
            }
            File backupDestination = new File(this$0.backupsDataFolder, backupFolderName);
            backupDestination.mkdirs();
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("source", worldFolder.getAbsolutePath()), TuplesKt.to("destination", backupDestination.getAbsolutePath())};
            this$0.debugLogger.debug("Copying world folder", pairArray3);
            this$0.copyDirectory(worldFolder, backupDestination);
            File netherFolder = new File(Bukkit.getServer().getWorldContainer(), worldFolderName + "_nether");
            if (netherFolder.exists()) {
                File netherBackup = new File(this$0.backupsDataFolder, backupFolderName + "_nether");
                this$0.copyDirectory(netherFolder, netherBackup);
                this$0.debugLogger.debug("Copied nether dimension");
            }
            if ((endFolder = new File(Bukkit.getServer().getWorldContainer(), worldFolderName + "_the_end")).exists()) {
                File endBackup = new File(this$0.backupsDataFolder, backupFolderName + "_the_end");
                this$0.copyDirectory(endFolder, endBackup);
                this$0.debugLogger.debug("Copied end dimension");
            }
            long totalSize = this$0.calculateDirectorySize(backupDestination);
            Intrinsics.checkNotNull(backupId);
            WorldBackup backup = new WorldBackup(backupId, $world.getId(), $world.getName(), $world.getOwnerUuid(), $world.getOwnerName(), timestamp, backupPath, totalSize, $description, $isAutomatic);
            this$0.saveBackup(backup);
            this$0.logger.info("[BackupManager] Created backup for world '" + $world.getName() + "': " + backup.getId());
            this$0.debugLogger.debugMethodExit("createBackup", backup.toCompactDebugString());
            $future.complete(Result.box-impl(Result.constructor-impl(backup)));
        }
        catch (Exception e) {
            this$0.logger.severe("[BackupManager] Failed to create backup for world '" + $world.getName() + "': " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("error", e.getMessage())};
            this$0.debugLogger.debug("Backup creation failed", pairArray);
            $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(e))));
        }
    }

    private static final void restoreBackup$lambda$5$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void restoreBackup$lambda$5$lambda$4(String $worldFolderName, BackupManager this$0, PlayerWorld $world, File $worldFolder, File $backupSource, String $backupFolderName, CompletableFuture $future, WorldBackup $backup, ScheduledTask scheduledTask) {
        Object object;
        List affectedPlayers;
        Intrinsics.checkNotNullParameter($worldFolderName, "$worldFolderName");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($worldFolder, "$worldFolder");
        Intrinsics.checkNotNullParameter($backupSource, "$backupSource");
        Intrinsics.checkNotNullParameter($backupFolderName, "$backupFolderName");
        Intrinsics.checkNotNullParameter($future, "$future");
        Intrinsics.checkNotNullParameter($backup, "$backup");
        World bukkitWorld = Bukkit.getWorld((String)$worldFolderName);
        Object object2 = bukkitWorld;
        if (object2 != null && (object2 = object2.getPlayers()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUniqueId());
            }
            v1 = (List)destination$iv$iv;
        } else {
            v1 = affectedPlayers = CollectionsKt.emptyList();
        }
        if ((object = bukkitWorld) != null && (object = object.getPlayers()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                player.sendMessage((Component)Component.text("World is being restored from backup. You have been moved to spawn.", (TextColor)NamedTextColor.YELLOW));
                WorldManager worldManager = this$0.worldManager;
                Intrinsics.checkNotNull(player);
                worldManager.teleportToVanillaWorld(player);
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Unloading world for backup restore", pairArray);
        CompletableFuture<Boolean> unloadFuture = this$0.worldManager.unloadWorld($world);
        unloadFuture.thenAccept(arg_0 -> BackupManager.restoreBackup$lambda$5$lambda$4$lambda$3(new Function1<Boolean, Unit>(this$0, $worldFolder, $backupSource, $backupFolderName, $worldFolderName, $world, (List<UUID>)affectedPlayers, (CompletableFuture<Result<Unit>>)$future, $backup){
            final /* synthetic */ BackupManager this$0;
            final /* synthetic */ File $worldFolder;
            final /* synthetic */ File $backupSource;
            final /* synthetic */ String $backupFolderName;
            final /* synthetic */ String $worldFolderName;
            final /* synthetic */ PlayerWorld $world;
            final /* synthetic */ List<UUID> $affectedPlayers;
            final /* synthetic */ CompletableFuture<Result<Unit>> $future;
            final /* synthetic */ WorldBackup $backup;
            {
                this.this$0 = $receiver;
                this.$worldFolder = $worldFolder;
                this.$backupSource = $backupSource;
                this.$backupFolderName = $backupFolderName;
                this.$worldFolderName = $worldFolderName;
                this.$world = $world;
                this.$affectedPlayers = $affectedPlayers;
                this.$future = $future;
                this.$backup = $backup;
                super(1);
            }

            public final void invoke(Boolean unloadSuccess) {
                if (!unloadSuccess.booleanValue()) {
                    BackupManager.access$getLogger$p(this.this$0).warning("[BackupManager] Failed to unload world for restore, attempting file copy anyway");
                }
                Bukkit.getAsyncScheduler().runNow((Plugin)BackupManager.access$getPlugin$p(this.this$0), arg_0 -> restoreBackup.1.1.2.invoke$lambda$4(this.$worldFolder, this.this$0, this.$backupSource, this.$backupFolderName, this.$worldFolderName, this.$world, this.$affectedPlayers, this.$future, this.$backup, arg_0));
            }

            private static final void invoke$lambda$4$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$4$lambda$1(BackupManager this$0, PlayerWorld $world, WorldBackup $backup, List $affectedPlayers, CompletableFuture $future, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($backup, "$backup");
                Intrinsics.checkNotNullParameter($affectedPlayers, "$affectedPlayers");
                Intrinsics.checkNotNullParameter($future, "$future");
                Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
                BackupManager.access$getDebugLogger$p(this$0).debug("Reloading world after backup restore", pairArray);
                CompletableFuture<Boolean> reloadFuture = BackupManager.access$getWorldManager$p(this$0).loadWorld($world);
                reloadFuture.thenAccept(arg_0 -> restoreBackup.1.1.2.invoke$lambda$4$lambda$1$lambda$0(new Function1<Boolean, Unit>(this$0, $world, $backup, (List<UUID>)$affectedPlayers, (CompletableFuture<Result<Unit>>)$future){
                    final /* synthetic */ BackupManager this$0;
                    final /* synthetic */ PlayerWorld $world;
                    final /* synthetic */ WorldBackup $backup;
                    final /* synthetic */ List<UUID> $affectedPlayers;
                    final /* synthetic */ CompletableFuture<Result<Unit>> $future;
                    {
                        this.this$0 = $receiver;
                        this.$world = $world;
                        this.$backup = $backup;
                        this.$affectedPlayers = $affectedPlayers;
                        this.$future = $future;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(Boolean reloadSuccess) {
                        Intrinsics.checkNotNull(reloadSuccess);
                        if (reloadSuccess.booleanValue()) {
                            void $this$forEach$iv;
                            BackupManager.access$getLogger$p(this.this$0).info("[BackupManager] Successfully restored and reloaded world '" + this.$world.getName() + "' from backup " + this.$backup.getId());
                            Iterable iterable = this.$affectedPlayers;
                            PlayerWorld playerWorld = this.$world;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                UUID playerId = (UUID)element$iv;
                                boolean bl = false;
                                Player player = Bukkit.getPlayer((UUID)playerId);
                                if (player == null) continue;
                                player.sendMessage((Component)Component.text("World '" + playerWorld.getName() + "' has been restored successfully! You can now return.", (TextColor)NamedTextColor.GREEN));
                            }
                            BackupManager.access$getDebugLogger$p(this.this$0).debugMethodExit("restoreBackup", "success");
                            this.$future.complete(Result.box-impl(Result.constructor-impl(Unit.INSTANCE)));
                        } else {
                            BackupManager.access$getLogger$p(this.this$0).severe("[BackupManager] Failed to reload world after restore");
                            Iterable $this$forEach$iv = this.$affectedPlayers;
                            PlayerWorld playerWorld = this.$world;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                UUID playerId = (UUID)element$iv;
                                boolean bl = false;
                                Player player = Bukkit.getPlayer((UUID)playerId);
                                if (player == null) continue;
                                player.sendMessage((Component)Component.text("World '" + playerWorld.getName() + "' files restored but reload failed. Try /world tp " + playerWorld.getName() + " or restart server.", (TextColor)NamedTextColor.YELLOW));
                            }
                            this.$future.complete(Result.box-impl(Result.constructor-impl(Unit.INSTANCE)));
                        }
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$4$lambda$3(List $affectedPlayers, PlayerWorld $world, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($affectedPlayers, "$affectedPlayers");
                Iterable $this$forEach$iv = $affectedPlayers;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UUID playerId = (UUID)element$iv;
                    boolean bl = false;
                    Player player = Bukkit.getPlayer((UUID)playerId);
                    if (player == null) continue;
                    player.sendMessage((Component)Component.text("Failed to restore world '" + $world.getName() + "'. Please contact an administrator.", (TextColor)NamedTextColor.RED));
                }
            }

            private static final void invoke$lambda$4(File $worldFolder, BackupManager this$0, File $backupSource, String $backupFolderName, String $worldFolderName, PlayerWorld $world, List $affectedPlayers, CompletableFuture $future, WorldBackup $backup, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($worldFolder, "$worldFolder");
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($backupSource, "$backupSource");
                Intrinsics.checkNotNullParameter($backupFolderName, "$backupFolderName");
                Intrinsics.checkNotNullParameter($worldFolderName, "$worldFolderName");
                Intrinsics.checkNotNullParameter($affectedPlayers, "$affectedPlayers");
                Intrinsics.checkNotNullParameter($future, "$future");
                Intrinsics.checkNotNullParameter($backup, "$backup");
                try {
                    File endBackup;
                    if ($worldFolder.exists()) {
                        BackupManager.access$deleteDirectory(this$0, $worldFolder);
                    }
                    BackupManager.access$copyDirectory(this$0, $backupSource, $worldFolder);
                    File netherBackup = new File(BackupManager.access$getBackupsDataFolder$p(this$0), $backupFolderName + "_nether");
                    if (netherBackup.exists()) {
                        File netherFolder = new File(Bukkit.getServer().getWorldContainer(), $worldFolderName + "_nether");
                        if (netherFolder.exists()) {
                            BackupManager.access$deleteDirectory(this$0, netherFolder);
                        }
                        BackupManager.access$copyDirectory(this$0, netherBackup, netherFolder);
                        BackupManager.access$getDebugLogger$p(this$0).debug("Restored nether dimension");
                    }
                    if ((endBackup = new File(BackupManager.access$getBackupsDataFolder$p(this$0), $backupFolderName + "_the_end")).exists()) {
                        File endFolder = new File(Bukkit.getServer().getWorldContainer(), $worldFolderName + "_the_end");
                        if (endFolder.exists()) {
                            BackupManager.access$deleteDirectory(this$0, endFolder);
                        }
                        BackupManager.access$copyDirectory(this$0, endBackup, endFolder);
                        BackupManager.access$getDebugLogger$p(this$0).debug("Restored end dimension");
                    }
                    BackupManager.access$getLogger$p(this$0).info("[BackupManager] Backup files restored for world '" + $world.getName() + "'");
                    Bukkit.getGlobalRegionScheduler().run((Plugin)BackupManager.access$getPlugin$p(this$0), arg_0 -> restoreBackup.1.1.2.invoke$lambda$4$lambda$1(this$0, $world, $backup, $affectedPlayers, $future, arg_0));
                }
                catch (Exception e) {
                    BackupManager.access$getLogger$p(this$0).severe("[BackupManager] Failed to restore backup: " + e.getMessage());
                    Pair[] pairArray = new Pair[]{TuplesKt.to("error", e.getMessage()), TuplesKt.to("affectedPlayers", $affectedPlayers.size())};
                    BackupManager.access$getDebugLogger$p(this$0).debug("Backup restoration failed", pairArray);
                    Bukkit.getGlobalRegionScheduler().run((Plugin)BackupManager.access$getPlugin$p(this$0), arg_0 -> restoreBackup.1.1.2.invoke$lambda$4$lambda$3($affectedPlayers, $world, arg_0));
                    $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(e))));
                }
            }
        }, arg_0));
    }

    private static final void restoreBackup$lambda$5(WorldBackup $backup, BackupManager this$0, CompletableFuture $future, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($backup, "$backup");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($future, "$future");
        try {
            String backupFolderName = StringsKt.removePrefix($backup.getBackupPath(), (CharSequence)"data/");
            File backupSource = new File(this$0.backupsDataFolder, backupFolderName);
            if (!backupSource.exists()) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("path", backupSource.getAbsolutePath())};
                this$0.debugLogger.debug("Backup folder not found", pairArray);
                $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(new IllegalStateException("Backup folder not found")))));
                return;
            }
            String worldFolderName = $world.getOwnerName() + "_" + $world.getName();
            File worldFolder = new File(Bukkit.getServer().getWorldContainer(), worldFolderName);
            Pair[] pairArray = new Pair[]{TuplesKt.to("source", backupSource.getAbsolutePath()), TuplesKt.to("destination", worldFolder.getAbsolutePath())};
            this$0.debugLogger.debug("Restoring backup", pairArray);
            Bukkit.getGlobalRegionScheduler().run((Plugin)this$0.plugin, arg_0 -> BackupManager.restoreBackup$lambda$5$lambda$4(worldFolderName, this$0, $world, worldFolder, backupSource, backupFolderName, $future, $backup, arg_0));
        }
        catch (Exception e) {
            this$0.logger.severe("[BackupManager] Failed to restore backup: " + e.getMessage());
            Pair[] pairArray = new Pair[]{TuplesKt.to("error", e.getMessage())};
            this$0.debugLogger.debug("Backup restoration failed", pairArray);
            $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(e))));
        }
    }

    private static final void deleteBackup$lambda$6(WorldBackup $backup, BackupManager this$0, CompletableFuture $future, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($backup, "$backup");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($future, "$future");
        try {
            File endBackup;
            File netherBackup;
            String backupFolderName = StringsKt.removePrefix($backup.getBackupPath(), (CharSequence)"data/");
            File backupFolder = new File(this$0.backupsDataFolder, backupFolderName);
            if (backupFolder.exists()) {
                this$0.deleteDirectory(backupFolder);
            }
            if ((netherBackup = new File(this$0.backupsDataFolder, backupFolderName + "_nether")).exists()) {
                this$0.deleteDirectory(netherBackup);
            }
            if ((endBackup = new File(this$0.backupsDataFolder, backupFolderName + "_the_end")).exists()) {
                this$0.deleteDirectory(endBackup);
            }
            this$0.backups.remove($backup.getId());
            File metadataFile = new File(this$0.backupsFolder, $backup.getId() + ".json");
            if (metadataFile.exists()) {
                metadataFile.delete();
            }
            this$0.logger.info("[BackupManager] Deleted backup " + $backup.getId() + " for world '" + $backup.getWorldName() + "'");
            this$0.debugLogger.debugMethodExit("deleteBackup", "success");
            $future.complete(Result.box-impl(Result.constructor-impl(Unit.INSTANCE)));
        }
        catch (Exception e) {
            this$0.logger.severe("[BackupManager] Failed to delete backup: " + e.getMessage());
            $future.complete(Result.box-impl(Result.constructor-impl(ResultKt.createFailure(e))));
        }
    }

    private static final void startSchedulerTask$lambda$16$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void startSchedulerTask$lambda$16(BackupManager this$0, ScheduledTask scheduledTask) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (!this$0.isAutoBackupEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Collection<BackupSchedule> collection = this$0.schedules.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BackupSchedule it = (BackupSchedule)element$iv$iv;
            boolean bl = false;
            if (!it.getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world;
            long intervalMs;
            BackupSchedule schedule = (BackupSchedule)element$iv;
            boolean bl = false;
            long timeSinceLastBackup = currentTime - schedule.getLastBackupTime();
            if (timeSinceLastBackup < (intervalMs = (long)schedule.getIntervalMinutes() * (long)60 * (long)1000) || (world = this$0.dataManager.loadWorld(schedule.getWorldId())) == null) continue;
            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
            this$0.debugLogger.debug("Running scheduled backup", pairArray);
            this$0.createBackup(world, "Automatic backup", true).thenAccept(arg_0 -> BackupManager.startSchedulerTask$lambda$16$lambda$15$lambda$14(new Function1<Result<? extends WorldBackup>, Unit>(this$0, schedule, currentTime, world){
                final /* synthetic */ BackupManager this$0;
                final /* synthetic */ BackupSchedule $schedule;
                final /* synthetic */ long $currentTime;
                final /* synthetic */ PlayerWorld $world;
                {
                    this.this$0 = $receiver;
                    this.$schedule = $schedule;
                    this.$currentTime = $currentTime;
                    this.$world = $world;
                    super(1);
                }

                public final void invoke(Result<? extends WorldBackup> result) {
                    block1: {
                        Throwable throwable;
                        Intrinsics.checkNotNull(result);
                        Object object = result.unbox-impl();
                        BackupManager backupManager = this.this$0;
                        Object object2 = this.$schedule;
                        long l = this.$currentTime;
                        PlayerWorld playerWorld = this.$world;
                        if (Result.isSuccess-impl(object)) {
                            WorldBackup it = (WorldBackup)object;
                            boolean bl = false;
                            Map map = BackupManager.access$getSchedules$p(backupManager);
                            UUID uUID = ((BackupSchedule)object2).getWorldId();
                            Intrinsics.checkNotNull(object2);
                            map.put(uUID, BackupSchedule.copy$default((BackupSchedule)object2, null, false, 0, l, 7, null));
                            BackupManager.access$saveSchedules(backupManager);
                            BackupManager.access$getLogger$p(backupManager).info("[BackupManager] Automatic backup completed for world '" + playerWorld.getName() + "'");
                        }
                        backupManager = this.this$0;
                        object2 = this.$world;
                        Throwable throwable2 = Result.exceptionOrNull-impl(object);
                        if (throwable2 == null) break block1;
                        Throwable error = throwable = throwable2;
                        boolean bl = false;
                        BackupManager.access$getLogger$p(backupManager).warning("[BackupManager] Automatic backup failed for world '" + ((PlayerWorld)object2).getName() + "': " + error.getMessage());
                    }
                }
            }, arg_0));
        }
    }

    private static final void deleteBackupsForWorld$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSchedules$p(BackupManager $this) {
        return $this.schedules;
    }

    public static final /* synthetic */ void access$saveSchedules(BackupManager $this) {
        $this.saveSchedules();
    }

    public static final /* synthetic */ Logger access$getLogger$p(BackupManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(BackupManager $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(BackupManager $this) {
        return $this.debugLogger;
    }

    public static final /* synthetic */ WorldManager access$getWorldManager$p(BackupManager $this) {
        return $this.worldManager;
    }

    public static final /* synthetic */ void access$deleteDirectory(BackupManager $this, File directory) {
        $this.deleteDirectory(directory);
    }

    public static final /* synthetic */ void access$copyDirectory(BackupManager $this, File source, File destination) {
        $this.copyDirectory(source, destination);
    }

    public static final /* synthetic */ File access$getBackupsDataFolder$p(BackupManager $this) {
        return $this.backupsDataFolder;
    }
}

