/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.listeners;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.managers.WorldStateManager;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/bedson/playerworldmanager/listeners/WorldSessionListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "worldStateManager", "Ltech/bedson/playerworldmanager/managers/WorldStateManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/WorldStateManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "PlayerWorldManager"})
public final class WorldSessionListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final WorldStateManager worldStateManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;

    public WorldSessionListener(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull WorldStateManager worldStateManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(worldStateManager, "worldStateManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.worldStateManager = worldStateManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "WorldSessionListener");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World currentWorld = world;
        String string = currentWorld.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String currentWorldName = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("currentWorld", currentWorldName), TuplesKt.to("location", player2.getLocation())};
        this.debugLogger.debugMethodEntry("onPlayerQuit", pairArray);
        this.plugin.getLogger().info("[WorldSessionListener] PlayerQuit: Player '" + player2.getName() + "' quitting from world '" + currentWorldName + "'");
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldName", currentWorldName), TuplesKt.to("location", player2.getLocation()), TuplesKt.to("gameMode", player2.getGameMode())};
        this.debugLogger.debug("Saving player state", pairArray);
        this.worldStateManager.savePlayerState(player2, currentWorldName);
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId())};
        this.debugLogger.debug("Getting or creating player data", pairArray);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        String string2 = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        PlayerData playerData = this.dataManager.getOrCreatePlayerData(uUID, string2);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("existingLastWorldId", playerData.getLastWorldId())};
        this.debugLogger.debug("Player data retrieved", pairArray2);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(currentWorld);
        boolean isPluginWorld = playerWorld != null;
        Pair[] pairArray3 = new Pair[4];
        pairArray3[0] = TuplesKt.to("currentWorld", currentWorldName);
        pairArray3[1] = TuplesKt.to("isPluginWorld", isPluginWorld);
        PlayerWorld playerWorld2 = playerWorld;
        pairArray3[2] = TuplesKt.to("pluginWorldName", playerWorld2 != null ? playerWorld2.getName() : null);
        PlayerWorld playerWorld3 = playerWorld;
        pairArray3[3] = TuplesKt.to("pluginWorldId", playerWorld3 != null ? playerWorld3.getId() : null);
        this.debugLogger.debug("Checking if current world is plugin world", pairArray3);
        if (playerWorld != null) {
            UUID previousLastWorldId = playerData.getLastWorldId();
            playerData.setLastWorldId(playerWorld.getId());
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("previousLastWorldId", previousLastWorldId), TuplesKt.to("newLastWorldId", playerWorld.getId()), TuplesKt.to("pluginWorldName", playerWorld.getName())};
            this.debugLogger.debug("Updated lastWorldId", pairArray4);
            this.plugin.getLogger().info("[WorldSessionListener] PlayerQuit: Set lastWorldId for '" + player2.getName() + "' to '" + playerWorld.getName() + "' (" + playerWorld.getId() + ")");
        } else {
            pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("currentWorld", currentWorldName)};
            this.debugLogger.debug("Not a plugin world - lastWorldId not updated", pairArray3);
        }
        pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("lastWorldId", playerData.getLastWorldId())};
        this.debugLogger.debug("Persisting player data to disk", pairArray3);
        this.dataManager.savePlayerData(playerData);
        this.plugin.getLogger().info("[WorldSessionListener] PlayerQuit: Player data saved for '" + player2.getName() + "'");
        this.debugLogger.debugMethodExit("onPlayerQuit", TuplesKt.to("savedLastWorldId", playerData.getLastWorldId()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("currentWorld", player2.getWorld().getName()), TuplesKt.to("hasPlayedBefore", player2.hasPlayedBefore())};
        this.debugLogger.debugMethodEntry("onPlayerJoin", pairArray);
        this.plugin.getLogger().info("[WorldSessionListener] PlayerJoin: Player '" + player2.getName() + "' joining, checking for last world");
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId())};
        this.debugLogger.debug("Loading player data", pairArray);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        PlayerData playerData = this.dataManager.loadPlayerData(uUID);
        if (playerData == null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId())};
            this.debugLogger.debug("No player data found - skipping restoration", pairArray2);
            this.plugin.getLogger().info("[WorldSessionListener] PlayerJoin: No player data for '" + player2.getName() + "', skipping world restoration");
            this.debugLogger.debugMethodExit("onPlayerJoin", TuplesKt.to("restored", false));
            return;
        }
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("lastWorldId", playerData.getLastWorldId()), TuplesKt.to("username", playerData.getUsername())};
        this.debugLogger.debug("Player data loaded", pairArray3);
        UUID lastWorldId = playerData.getLastWorldId();
        if (lastWorldId == null) {
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("player", player2.getName())};
            this.debugLogger.debug("No lastWorldId in player data - skipping restoration", pairArray4);
            this.plugin.getLogger().info("[WorldSessionListener] PlayerJoin: No lastWorldId for '" + player2.getName() + "', skipping world restoration");
            this.debugLogger.debugMethodExit("onPlayerJoin", TuplesKt.to("restored", false));
            return;
        }
        Pair[] pairArray5 = new Pair[]{TuplesKt.to("lastWorldId", lastWorldId)};
        this.debugLogger.debug("Loading last world by ID", pairArray5);
        PlayerWorld lastWorld = this.dataManager.loadWorld(lastWorldId);
        if (lastWorld == null) {
            Pair[] pairArray6 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("lastWorldId", lastWorldId)};
            this.debugLogger.debug("Last world not found in data - skipping restoration", pairArray6);
            this.plugin.getLogger().info("[WorldSessionListener] PlayerJoin: Last world (ID: " + lastWorldId + ") not found for '" + player2.getName() + "', skipping restoration");
            this.debugLogger.debugMethodExit("onPlayerJoin", TuplesKt.to("restored", false));
            return;
        }
        Pair[] pairArray7 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("lastWorldId", lastWorldId), TuplesKt.to("lastWorldName", lastWorld.getName()), TuplesKt.to("lastWorldOwner", lastWorld.getOwnerName())};
        this.debugLogger.debug("Last world found - scheduling teleport", pairArray7);
        this.plugin.getLogger().info("[WorldSessionListener] PlayerJoin: Restoring '" + player2.getName() + "' to last world '" + lastWorld.getName() + "'");
        pairArray7 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("targetWorld", lastWorld.getName())};
        this.debugLogger.debug("Scheduling teleport on entity scheduler", pairArray7);
        player2.getScheduler().run((Plugin)this.plugin, arg_0 -> WorldSessionListener.onPlayerJoin$lambda$1(this, player2, lastWorld, arg_0), null);
        this.debugLogger.debugMethodExit("onPlayerJoin", TuplesKt.to("teleportScheduled", true));
    }

    private static final void onPlayerJoin$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onPlayerJoin$lambda$1(WorldSessionListener this$0, Player $player, PlayerWorld $lastWorld, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("targetWorld", $lastWorld.getName())};
        this$0.debugLogger.debug("Entity scheduler task executing - initiating teleport", pairArray);
        this$0.worldManager.teleportToWorld($player, $lastWorld).thenAccept(arg_0 -> WorldSessionListener.onPlayerJoin$lambda$1$lambda$0(new Function1<Boolean, Unit>(this$0, $player, $lastWorld){
            final /* synthetic */ WorldSessionListener this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ PlayerWorld $lastWorld;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$lastWorld = $lastWorld;
                super(1);
            }

            public final void invoke(Boolean success) {
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    WorldSessionListener.access$getPlugin$p(this.this$0).getLogger().info("[WorldSessionListener] PlayerJoin: Successfully restored '" + this.$player.getName() + "' to world '" + this.$lastWorld.getName() + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("targetWorld", this.$lastWorld.getName()), TuplesKt.to("success", true)};
                    WorldSessionListener.access$getDebugLogger$p(this.this$0).debug("Teleport completed successfully", pairArray);
                } else {
                    WorldSessionListener.access$getPlugin$p(this.this$0).getLogger().warning("[WorldSessionListener] PlayerJoin: Failed to restore '" + this.$player.getName() + "' to world '" + this.$lastWorld.getName() + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("targetWorld", this.$lastWorld.getName()), TuplesKt.to("success", false)};
                    WorldSessionListener.access$getDebugLogger$p(this.this$0).debug("Teleport failed", pairArray);
                }
            }
        }, arg_0));
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(WorldSessionListener $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(WorldSessionListener $this) {
        return $this.debugLogger;
    }
}

