/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.listeners;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.managers.WorldUnloadManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/bedson/playerworldmanager/listeners/WorldChangeListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "worldUnloadManager", "Ltech/bedson/playerworldmanager/managers/WorldUnloadManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/WorldUnloadManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "onPlayerChangedWorld", "", "event", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "PlayerWorldManager"})
public final class WorldChangeListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final WorldUnloadManager worldUnloadManager;
    @NotNull
    private final DebugLogger debugLogger;

    public WorldChangeListener(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull WorldUnloadManager worldUnloadManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(worldUnloadManager, "worldUnloadManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.worldUnloadManager = worldUnloadManager;
        this.debugLogger = new DebugLogger(this.plugin, "WorldChangeListener");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerChangedWorld(@NotNull PlayerChangedWorldEvent event) {
        PlayerWorld toPlayerWorld;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = event.getFrom();
        Intrinsics.checkNotNullExpressionValue(world, "getFrom(...)");
        World fromWorld = world;
        World world2 = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
        World toWorld = world2;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("fromWorld", fromWorld.getName()), TuplesKt.to("toWorld", toWorld.getName())};
        this.debugLogger.debugMethodEntry("onPlayerChangedWorld", pairArray);
        PlayerWorld fromPlayerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(fromWorld);
        if (fromPlayerWorld != null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldName", fromPlayerWorld.getName()), TuplesKt.to("worldId", fromPlayerWorld.getId())};
            this.debugLogger.debug("Player left plugin world", pairArray2);
            WorldUnloadManager.onPlayerLeaveWorld$default(this.worldUnloadManager, fromPlayerWorld, null, 2, null);
        }
        if ((toPlayerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(toWorld)) != null) {
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldName", toPlayerWorld.getName()), TuplesKt.to("worldId", toPlayerWorld.getId())};
            this.debugLogger.debug("Player entered plugin world", pairArray3);
            this.worldUnloadManager.onPlayerEnterWorld(toPlayerWorld);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "onPlayerChangedWorld", null, 2, null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("world", world2.getName())};
        this.debugLogger.debugMethodEntry("onPlayerJoin", pairArray);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(world2);
        if (playerWorld != null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("worldId", playerWorld.getId())};
            this.debugLogger.debug("Player joined in plugin world", pairArray2);
            this.worldUnloadManager.onPlayerEnterWorld(playerWorld);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "onPlayerJoin", null, 2, null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("world", world2.getName())};
        this.debugLogger.debugMethodEntry("onPlayerQuit", pairArray);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(world2);
        if (playerWorld != null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("worldId", playerWorld.getId())};
            this.debugLogger.debug("Player quit from plugin world", pairArray2);
            this.worldUnloadManager.onPlayerLeaveWorld(playerWorld, player2);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "onPlayerQuit", null, 2, null);
    }
}

