/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.ArraysKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.StatsManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001cH\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltech/bedson/playerworldmanager/listeners/StatsListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "statsManager", "Ltech/bedson/playerworldmanager/managers/StatsManager;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/StatsManager;Ltech/bedson/playerworldmanager/managers/WorldManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "onBlockPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onCraftItem", "Lorg/bukkit/event/inventory/CraftItemEvent;", "onEntityDeath", "Lorg/bukkit/event/entity/EntityDeathEvent;", "onPlayerDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onWorldChange", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nStatsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsListener.kt\ntech/bedson/playerworldmanager/listeners/StatsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n766#2:234\n857#2,2:235\n1#3:237\n*S KotlinDebug\n*F\n+ 1 StatsListener.kt\ntech/bedson/playerworldmanager/listeners/StatsListener\n*L\n148#1:234\n148#1:235,2\n*E\n"})
public final class StatsListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final StatsManager statsManager;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final DebugLogger debugLogger;

    public StatsListener(@NotNull JavaPlugin plugin, @NotNull StatsManager statsManager, @NotNull WorldManager worldManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(statsManager, "statsManager");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        this.plugin = plugin;
        this.statsManager = statsManager;
        this.worldManager = worldManager;
        this.debugLogger = new DebugLogger(this.plugin, "StatsListener");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBlockPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        UUID uUID = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (uUID == null) {
            return;
        }
        UUID worldId = uUID;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldId", worldId), TuplesKt.to("blockType", event.getBlock().getType())};
        this.debugLogger.debug("Block placed", pairArray);
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.statsManager.recordBlockPlaced(worldId, uUID2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        UUID uUID = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (uUID == null) {
            return;
        }
        UUID worldId = uUID;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldId", worldId), TuplesKt.to("blockType", event.getBlock().getType())};
        this.debugLogger.debug("Block broken", pairArray);
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.statsManager.recordBlockBroken(worldId, uUID2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onEntityDeath(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
        LivingEntity entity = livingEntity;
        Player player = entity.getKiller();
        if (player == null) {
            return;
        }
        Player killer = player;
        World world = entity.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        UUID uUID = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (uUID == null) {
            return;
        }
        UUID worldId = uUID;
        if (entity instanceof Player) {
            return;
        }
        LivingEntity livingEntity2 = new LivingEntity[]{TuplesKt.to("killer", killer.getName()), TuplesKt.to("entity", entity.getType()), TuplesKt.to("worldId", worldId)};
        this.debugLogger.debug("Entity killed", (Pair<String, ? extends Object>)livingEntity2);
        livingEntity2 = entity;
        if (livingEntity2 instanceof Monster) {
            UUID uUID2 = killer.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            this.statsManager.recordMobKilled(worldId, uUID2);
        } else if (livingEntity2 instanceof Animals) {
            UUID uUID3 = killer.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
            this.statsManager.recordAnimalKilled(worldId, uUID3);
        } else {
            UUID uUID4 = killer.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
            this.statsManager.recordMobKilled(worldId, uUID4);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        UUID uUID = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (uUID == null) {
            return;
        }
        UUID worldId = uUID;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to("player", player2.getName());
        pairArray[1] = TuplesKt.to("worldId", worldId);
        Player player3 = player2.getKiller();
        pairArray[2] = TuplesKt.to("killer", player3 != null ? player3.getName() : null);
        this.debugLogger.debug("Player died", pairArray);
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.statsManager.recordPlayerDeath(worldId, uUID2);
        Player killer = player2.getKiller();
        if (killer != null && !Intrinsics.areEqual(killer, player2)) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("killer", killer.getName()), TuplesKt.to("victim", player2.getName()), TuplesKt.to("worldId", worldId)};
            this.debugLogger.debug("PvP kill recorded", pairArray2);
            UUID uUID3 = killer.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
            this.statsManager.recordPlayerKill(worldId, uUID3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onCraftItem(@NotNull CraftItemEvent event) {
        int n;
        Intrinsics.checkNotNullParameter(event, "event");
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        UUID uUID = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (uUID == null) {
            return;
        }
        UUID worldId = uUID;
        int resultAmount = event.getRecipe().getResult().getAmount();
        if (event.isShiftClick()) {
            Comparable comparable;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            CraftingInventory craftingInventory = event.getInventory();
            Object object = craftingInventory instanceof CraftingInventory ? craftingInventory : null;
            if (object == null) {
                return;
            }
            CraftingInventory inventory = object;
            ItemStack[] itemStackArray = inventory.getMatrix();
            Intrinsics.checkNotNullExpressionValue(itemStackArray, "getMatrix(...)");
            ItemStack[] matrix = itemStackArray;
            Iterable iterable = ArraysKt.filterNotNull(matrix);
            boolean $i$f$filter = false;
            Comparable comparable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!(!it.getType().isAir())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
            if (!iterator2.hasNext()) {
                comparable = null;
            } else {
                ItemStack it = (ItemStack)iterator2.next();
                boolean bl = false;
                comparable2 = Integer.valueOf(it.getAmount());
                while (iterator2.hasNext()) {
                    ItemStack it2 = (ItemStack)iterator2.next();
                    $i$a$-minOfOrNull-StatsListener$onCraftItem$amount$minIngredientCount$2 = false;
                    Comparable comparable3 = Integer.valueOf(it2.getAmount());
                    if (comparable2.compareTo(comparable3) <= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n2 = (Integer)comparable;
            int minIngredientCount = n2 != null ? n2 : 1;
            int maxCrafts = Math.min(minIngredientCount, 64 / resultAmount);
            n = maxCrafts * resultAmount;
        } else {
            n = resultAmount;
        }
        int amount = n;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldId", worldId), TuplesKt.to("item", event.getRecipe().getResult().getType()), TuplesKt.to("amount", amount), TuplesKt.to("isShiftClick", event.isShiftClick())};
        this.debugLogger.debug("Item crafted", pairArray);
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.statsManager.recordItemCrafted(worldId, uUID2, amount);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        UUID uUID = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (uUID == null) {
            return;
        }
        UUID worldId = uUID;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldId", worldId)};
        this.debugLogger.debug("Player join - starting session tracking", pairArray);
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.statsManager.startPlayerSession(worldId, uUID2);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        UUID uUID = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (uUID == null) {
            return;
        }
        UUID worldId = uUID;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldId", worldId)};
        this.debugLogger.debug("Player quit - ending session tracking", pairArray);
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.statsManager.endPlayerSession(worldId, uUID2);
        this.statsManager.saveWorldStats(worldId);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onWorldChange(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = event.getFrom();
        Intrinsics.checkNotNullExpressionValue(world, "getFrom(...)");
        UUID previousWorldId = this.statsManager.getWorldIdFromBukkitWorld(world);
        if (previousWorldId != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("previousWorldId", previousWorldId)};
            this.debugLogger.debug("World change - ending session in previous world", pairArray);
            UUID uUID = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            this.statsManager.endPlayerSession(previousWorldId, uUID);
            this.statsManager.saveWorldStats(previousWorldId);
        }
        World world2 = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
        UUID newWorldId = this.statsManager.getWorldIdFromBukkitWorld(world2);
        if (newWorldId != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("newWorldId", newWorldId)};
            this.debugLogger.debug("World change - starting session in new world", pairArray);
            UUID uUID = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            this.statsManager.startPlayerSession(newWorldId, uUID);
        }
    }
}

