/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.NoWhenBranchMatchedException;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.listeners.ChatListener;
import tech.bedson.playerworldmanager.managers.ChatManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.ChatMode;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/bedson/playerworldmanager/listeners/ChatListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "chatManager", "Ltech/bedson/playerworldmanager/managers/ChatManager;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/ChatManager;Ltech/bedson/playerworldmanager/managers/WorldManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "onAsyncChat", "", "event", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nChatListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatListener.kt\ntech/bedson/playerworldmanager/listeners/ChatListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n766#2:192\n857#2,2:193\n*S KotlinDebug\n*F\n+ 1 ChatListener.kt\ntech/bedson/playerworldmanager/listeners/ChatListener\n*L\n64#1:192\n64#1:193,2\n*E\n"})
public final class ChatListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final ChatManager chatManager;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final DebugLogger debugLogger;

    public ChatListener(@NotNull JavaPlugin plugin, @NotNull ChatManager chatManager, @NotNull WorldManager worldManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(chatManager, "chatManager");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        this.plugin = plugin;
        this.chatManager = chatManager;
        this.worldManager = worldManager;
        this.debugLogger = new DebugLogger(this.plugin, "ChatListener");
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onAsyncChat(@NotNull AsyncChatEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player sender = player;
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        ChatMode senderMode = this.chatManager.getChatMode(uUID);
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", sender.getName()), TuplesKt.to("senderUuid", sender.getUniqueId()), TuplesKt.to("senderWorld", sender.getWorld().getName()), TuplesKt.to("senderMode", senderMode), TuplesKt.to("isCancelled", event.isCancelled())};
        this.debugLogger.debugMethodEntry("onAsyncChat", pairArray);
        this.plugin.getLogger().info("[ChatListener] AsyncChat: Player '" + sender.getName() + "' sending message from world '" + sender.getWorld().getName() + "' with mode '" + senderMode + "'");
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Set allPlayers = CollectionsKt.toSet(collection);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("totalPlayers", allPlayers.size()), TuplesKt.to("playerNames", CollectionsKt.joinToString$default(allPlayers, ", ", null, null, 0, null, onAsyncChat.1.INSTANCE, 30, null))};
        this.debugLogger.debug("Retrieved online players", pairArray2);
        this.plugin.getLogger().info("[ChatListener] AsyncChat: Total online players: " + allPlayers.size());
        Pair[] $this$filter$iv = (Pair[])allPlayers;
        boolean $i$f$filter = false;
        Pair[] pairArray3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player receiver = (Player)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(receiver);
            boolean shouldReceive = this.chatManager.shouldReceiveMessage(sender, receiver);
            UUID uUID2 = receiver.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            ChatMode receiverMode = this.chatManager.getChatMode(uUID2);
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("receiver", receiver.getName()), TuplesKt.to("receiverUuid", receiver.getUniqueId()), TuplesKt.to("receiverWorld", receiver.getWorld().getName()), TuplesKt.to("receiverMode", receiverMode), TuplesKt.to("sameWorld", Intrinsics.areEqual(sender.getWorld().getName(), receiver.getWorld().getName())), TuplesKt.to("shouldReceive", shouldReceive)};
            this.debugLogger.debug("Checking receiver eligibility", pairArray4);
            this.plugin.getLogger().info("[ChatListener] AsyncChat: Check receiver '" + receiver.getName() + "' (world: '" + receiver.getWorld().getName() + "', mode: '" + receiverMode + "') - shouldReceive: " + shouldReceive);
            if (!shouldReceive) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set viewers = CollectionsKt.toMutableSet((List)destination$iv$iv);
        $this$filter$iv = new Pair[]{TuplesKt.to("originalCount", allPlayers.size()), TuplesKt.to("filteredCount", viewers.size()), TuplesKt.to("excludedCount", allPlayers.size() - viewers.size())};
        this.debugLogger.debug("Filtered viewers calculated", $this$filter$iv);
        this.plugin.getLogger().info("[ChatListener] AsyncChat: Message will be sent to " + viewers.size() + " players: " + CollectionsKt.joinToString$default(viewers, ", ", null, null, 0, null, onAsyncChat.2.INSTANCE, 30, null));
        int originalViewersCount = event.viewers().size();
        event.viewers().clear();
        event.viewers().addAll(viewers);
        Pair[] pairArray5 = new Pair[]{TuplesKt.to("originalViewersCount", originalViewersCount), TuplesKt.to("newViewersCount", event.viewers().size())};
        this.debugLogger.debug("Updated event viewers set", pairArray5);
        pairArray5 = new Pair[2];
        pairArray5[0] = TuplesKt.to("senderMode", senderMode);
        pairArray5[1] = TuplesKt.to("prefixType", switch (WhenMappings.$EnumSwitchMapping$0[senderMode.ordinal()]) {
            case 1 -> "[G]";
            case 2 -> "[W]";
            default -> throw new NoWhenBranchMatchedException();
        });
        this.debugLogger.debug("Setting custom chat renderer", pairArray5);
        event.renderer((arg_0, arg_1, arg_2, arg_3) -> ChatListener.onAsyncChat$lambda$1(senderMode, arg_0, arg_1, arg_2, arg_3));
        this.plugin.getLogger().info("[ChatListener] AsyncChat: Message processing complete for '" + sender.getName() + "'");
        this.debugLogger.debugMethodExit("onAsyncChat", TuplesKt.to("viewerCount", viewers.size()));
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("world", player2.getWorld().getName()), TuplesKt.to("hasPlayedBefore", player2.hasPlayedBefore())};
        this.debugLogger.debugMethodEntry("onPlayerJoin", pairArray);
        this.plugin.getLogger().info("[ChatListener] PlayerJoin: Player '" + player2.getName() + "' (" + player2.getUniqueId() + ") joined, loading chat mode");
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId())};
        this.debugLogger.debug("Loading chat mode from storage", pairArray);
        this.chatManager.loadPlayerChatMode(player2);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        ChatMode loadedMode = this.chatManager.getChatMode(uUID);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("loadedMode", loadedMode)};
        this.debugLogger.debug("Chat mode loaded", pairArray2);
        this.plugin.getLogger().info("[ChatListener] PlayerJoin: Chat mode loaded for '" + player2.getName() + "': " + loadedMode);
        this.debugLogger.debugMethodExit("onPlayerJoin", TuplesKt.to("loadedMode", loadedMode));
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        ChatMode currentMode = this.chatManager.getChatMode(uUID);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("world", player2.getWorld().getName()), TuplesKt.to("currentMode", currentMode)};
        this.debugLogger.debugMethodEntry("onPlayerQuit", pairArray);
        this.plugin.getLogger().info("[ChatListener] PlayerQuit: Player '" + player2.getName() + "' (" + player2.getUniqueId() + ") quit, saving chat mode: " + currentMode);
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("mode", currentMode)};
        this.debugLogger.debug("Saving chat mode to storage", pairArray);
        this.chatManager.savePlayerChatMode(player2);
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId())};
        this.debugLogger.debug("Clearing chat mode cache", pairArray);
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.chatManager.clearCache(uUID2);
        this.plugin.getLogger().info("[ChatListener] PlayerQuit: Chat mode saved and cache cleared for '" + player2.getName() + "'");
        this.debugLogger.debugMethodExit("onPlayerQuit", TuplesKt.to("savedMode", currentMode));
    }

    private static final Component onAsyncChat$lambda$1(ChatMode $senderMode, Player source, Component sourceDisplayName, Component message, Audience viewer) {
        Intrinsics.checkNotNullParameter((Object)$senderMode, "$senderMode");
        TextComponent textComponent = switch (WhenMappings.$EnumSwitchMapping$0[$senderMode.ordinal()]) {
            case 1 -> Component.text("[G] ", (TextColor)NamedTextColor.GRAY);
            case 2 -> Component.text("[W] ", (TextColor)NamedTextColor.GRAY);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull(textComponent);
        TextComponent prefix = textComponent;
        NamedTextColor usernameColor = switch (WhenMappings.$EnumSwitchMapping$0[$senderMode.ordinal()]) {
            case 1 -> NamedTextColor.GREEN;
            case 2 -> NamedTextColor.AQUA;
            default -> throw new NoWhenBranchMatchedException();
        };
        return ((TextComponent)((TextComponent)prefix.append(Component.text(source.getName(), (TextColor)usernameColor))).append(Component.text(" \u00bb ", (TextColor)NamedTextColor.DARK_GRAY))).append(message.color(NamedTextColor.WHITE));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatMode.values().length];
            try {
                nArray[ChatMode.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMode.WORLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

