/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.listeners;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldRole;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltech/bedson/playerworldmanager/listeners/AccessListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "onPlayerChangedWorld", "", "event", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onPlayerPortal", "Lorg/bukkit/event/player/PlayerPortalEvent;", "onPlayerRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "onPlayerTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "Companion", "PlayerWorldManager"})
public final class AccessListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private static final String ADMIN_BYPASS_PERMISSION = "playerworldmanager.admin.bypass";

    public AccessListener(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.debugLogger = new DebugLogger(this.plugin, "AccessListener");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onPlayerTeleport(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World fromWorld = event.getFrom().getWorld();
        Pair[] pairArray = event.getTo().getWorld();
        if (pairArray == null) {
            AccessListener $this$onPlayerTeleport_u24lambda_u240 = this;
            boolean bl = false;
            $this$onPlayerTeleport_u24lambda_u240.plugin.getLogger().warning("[AccessListener] PlayerTeleport: Player '" + player2.getName() + "' teleport to null world");
            Pair[] pairArray2 = new Pair[3];
            pairArray2[0] = TuplesKt.to("player", player2.getName());
            pairArray2[1] = TuplesKt.to("playerUuid", player2.getUniqueId());
            World world = fromWorld;
            pairArray2[2] = TuplesKt.to("fromWorld", world != null ? world.getName() : null);
            $this$onPlayerTeleport_u24lambda_u240.debugLogger.debug("Teleport destination world is null", pairArray2);
            return;
        }
        Pair[] toWorld = pairArray;
        pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to("player", player2.getName());
        pairArray[1] = TuplesKt.to("playerUuid", player2.getUniqueId());
        World world = fromWorld;
        pairArray[2] = TuplesKt.to("fromWorld", world != null ? world.getName() : null);
        pairArray[3] = TuplesKt.to("toWorld", toWorld.getName());
        pairArray[4] = TuplesKt.to("cause", event.getCause());
        pairArray[5] = TuplesKt.to("isCancelled", event.isCancelled());
        this.debugLogger.debugMethodEntry("onPlayerTeleport", pairArray);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld((World)toWorld);
        boolean isPluginWorld = playerWorld != null;
        Pair[] $this$onPlayerTeleport_u24lambda_u240 = new Pair[]{TuplesKt.to("toWorld", toWorld.getName()), TuplesKt.to("isPluginWorld", isPluginWorld)};
        this.debugLogger.debug("Checking if destination is plugin world", $this$onPlayerTeleport_u24lambda_u240);
        if (playerWorld == null) {
            this.debugLogger.debugMethodExit("onPlayerTeleport", TuplesKt.to("allowed", true));
            return;
        }
        $this$onPlayerTeleport_u24lambda_u240 = new Pair[]{TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("worldId", playerWorld.getId()), TuplesKt.to("ownerUuid", playerWorld.getOwnerUuid()), TuplesKt.to("ownerName", playerWorld.getOwnerName()), TuplesKt.to("isEnabled", playerWorld.isEnabled())};
        this.debugLogger.debug("Plugin world details", $this$onPlayerTeleport_u24lambda_u240);
        boolean hasAdminBypass = player2.hasPermission(ADMIN_BYPASS_PERMISSION);
        Pair[] bl = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("permission", ADMIN_BYPASS_PERMISSION), TuplesKt.to("hasPermission", hasAdminBypass)};
        this.debugLogger.debug("Checking admin bypass permission", bl);
        if (hasAdminBypass) {
            this.debugLogger.debugMethodExit("onPlayerTeleport", TuplesKt.to("allowed", true));
            return;
        }
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        boolean hasAccess = this.inviteManager.hasAccess(uUID, playerWorld);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("hasAccess", hasAccess)};
        this.debugLogger.debug("Access check result", pairArray3);
        if (!hasAccess) {
            event.setCancelled(true);
            pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("reason", "no access")};
            this.debugLogger.debug("Teleport CANCELLED - access denied", pairArray3);
            player2.sendMessage((Component)Component.text("You don't have access to this world.", (TextColor)NamedTextColor.RED));
        } else {
            UUID uUID2 = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            WorldRole role = this.inviteManager.getPlayerRole(uUID2, playerWorld);
            Pair[] pairArray4 = new Pair[3];
            pairArray4[0] = TuplesKt.to("player", player2.getName());
            pairArray4[1] = TuplesKt.to("role", role);
            WorldRole worldRole = role;
            pairArray4[2] = TuplesKt.to("isSpectatorOnly", worldRole != null ? worldRole.isSpectatorOnly() : false);
            this.debugLogger.debug("Checking player role for teleport", pairArray4);
            WorldRole worldRole2 = role;
            boolean bl2 = worldRole2 != null ? worldRole2.isSpectatorOnly() : false;
            if (bl2) {
                player2.getScheduler().run((Plugin)this.plugin, arg_0 -> AccessListener.onPlayerTeleport$lambda$1(player2, this, playerWorld, arg_0), null);
            }
        }
        this.debugLogger.debugMethodExit("onPlayerTeleport", TuplesKt.to("cancelled", event.isCancelled()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onPlayerPortal(@NotNull PlayerPortalEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World fromWorld = world;
        Location location = event.getTo();
        if (location == null) {
            AccessListener $this$onPlayerPortal_u24lambda_u242 = this;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("fromWorld", fromWorld.getName()), TuplesKt.to("cause", event.getCause())};
            $this$onPlayerPortal_u24lambda_u242.debugLogger.debug("Portal destination location is null", pairArray);
            return;
        }
        Location toLocation = location;
        Pair[] pairArray = toLocation.getWorld();
        if (pairArray == null) {
            AccessListener $this$onPlayerPortal_u24lambda_u243 = this;
            boolean bl = false;
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("fromWorld", fromWorld.getName()), TuplesKt.to("toLocation", toLocation)};
            $this$onPlayerPortal_u24lambda_u243.debugLogger.debug("Portal destination world is null", pairArray2);
            return;
        }
        Pair[] toWorld = pairArray;
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("fromWorld", fromWorld.getName()), TuplesKt.to("toWorld", toWorld.getName()), TuplesKt.to("cause", event.getCause()), TuplesKt.to("isCancelled", event.isCancelled())};
        this.debugLogger.debugMethodEntry("onPlayerPortal", pairArray);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld((World)toWorld);
        boolean isPluginWorld = playerWorld != null;
        Pair[] $this$onPlayerPortal_u24lambda_u243 = new Pair[]{TuplesKt.to("toWorld", toWorld.getName()), TuplesKt.to("isPluginWorld", isPluginWorld)};
        this.debugLogger.debug("Checking if destination is plugin world", $this$onPlayerPortal_u24lambda_u243);
        if (playerWorld == null) {
            this.debugLogger.debugMethodExit("onPlayerPortal", TuplesKt.to("allowed", true));
            return;
        }
        $this$onPlayerPortal_u24lambda_u243 = new Pair[]{TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("worldId", playerWorld.getId()), TuplesKt.to("ownerUuid", playerWorld.getOwnerUuid()), TuplesKt.to("ownerName", playerWorld.getOwnerName()), TuplesKt.to("isEnabled", playerWorld.isEnabled())};
        this.debugLogger.debug("Plugin world details", $this$onPlayerPortal_u24lambda_u243);
        boolean hasAdminBypass = player2.hasPermission(ADMIN_BYPASS_PERMISSION);
        Pair[] bl = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("permission", ADMIN_BYPASS_PERMISSION), TuplesKt.to("hasPermission", hasAdminBypass)};
        this.debugLogger.debug("Checking admin bypass permission", bl);
        if (hasAdminBypass) {
            this.debugLogger.debugMethodExit("onPlayerPortal", TuplesKt.to("allowed", true));
            return;
        }
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        boolean hasAccess = this.inviteManager.hasAccess(uUID, playerWorld);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("hasAccess", hasAccess)};
        this.debugLogger.debug("Access check result", pairArray3);
        if (!hasAccess) {
            event.setCancelled(true);
            pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("reason", "no access")};
            this.debugLogger.debug("Portal CANCELLED - access denied", pairArray3);
            player2.sendMessage((Component)Component.text("You don't have access to this world.", (TextColor)NamedTextColor.RED));
        }
        this.debugLogger.debugMethodExit("onPlayerPortal", TuplesKt.to("cancelled", event.isCancelled()));
    }

    @EventHandler
    public final void onPlayerChangedWorld(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        World world = event.getFrom();
        Intrinsics.checkNotNullExpressionValue(world, "getFrom(...)");
        World fromWorld = world;
        World world2 = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
        World currentWorld = world2;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("fromWorld", fromWorld.getName()), TuplesKt.to("currentWorld", currentWorld.getName())};
        this.debugLogger.debugMethodEntry("onPlayerChangedWorld", pairArray);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(currentWorld);
        boolean isPluginWorld = playerWorld != null;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("currentWorld", currentWorld.getName()), TuplesKt.to("isPluginWorld", isPluginWorld)};
        this.debugLogger.debug("Checking if current world is plugin world", pairArray2);
        if (playerWorld == null) {
            this.debugLogger.debugMethodExit("onPlayerChangedWorld", TuplesKt.to("accessCheckSkipped", true));
            return;
        }
        pairArray2 = new Pair[]{TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("worldId", playerWorld.getId()), TuplesKt.to("ownerUuid", playerWorld.getOwnerUuid()), TuplesKt.to("ownerName", playerWorld.getOwnerName()), TuplesKt.to("isEnabled", playerWorld.isEnabled())};
        this.debugLogger.debug("Plugin world details", pairArray2);
        boolean hasAdminBypass = player2.hasPermission(ADMIN_BYPASS_PERMISSION);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("permission", ADMIN_BYPASS_PERMISSION), TuplesKt.to("hasPermission", hasAdminBypass)};
        this.debugLogger.debug("Checking admin bypass permission", pairArray3);
        if (hasAdminBypass) {
            this.debugLogger.debugMethodExit("onPlayerChangedWorld", TuplesKt.to("allowed", true));
            return;
        }
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        boolean hasAccess = this.inviteManager.hasAccess(uUID, playerWorld);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("hasAccess", hasAccess)};
        this.debugLogger.debug("Access check result", pairArray4);
        if (!hasAccess) {
            List list = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
            World defaultWorld = (World)CollectionsKt.firstOrNull(list);
            Pair[] pairArray5 = new Pair[4];
            pairArray5[0] = TuplesKt.to("player", player2.getName());
            pairArray5[1] = TuplesKt.to("currentWorld", playerWorld.getName());
            pairArray5[2] = TuplesKt.to("defaultWorldAvailable", defaultWorld != null);
            World world3 = defaultWorld;
            pairArray5[3] = TuplesKt.to("defaultWorld", world3 != null ? world3.getName() : null);
            this.debugLogger.debug("No access - initiating emergency teleport", pairArray5);
            if (defaultWorld != null) {
                this.plugin.getLogger().warning("[AccessListener] Player '" + player2.getName() + "' has no access to '" + playerWorld.getName() + "', teleporting to spawn");
                player2.getScheduler().run((Plugin)this.plugin, arg_0 -> AccessListener.onPlayerChangedWorld$lambda$5(this, player2, defaultWorld, arg_0), null);
            } else {
                this.plugin.getLogger().warning("[AccessListener] No default world found to teleport '" + player2.getName() + "' back to");
                pairArray5 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("reason", "no default world available")};
                this.debugLogger.debug("Emergency teleport FAILED - no default world", pairArray5);
            }
        } else {
            UUID uUID2 = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            WorldRole role = this.inviteManager.getPlayerRole(uUID2, playerWorld);
            Pair[] pairArray6 = new Pair[3];
            pairArray6[0] = TuplesKt.to("player", player2.getName());
            pairArray6[1] = TuplesKt.to("role", role);
            WorldRole worldRole = role;
            pairArray6[2] = TuplesKt.to("isSpectatorOnly", worldRole != null ? worldRole.isSpectatorOnly() : false);
            this.debugLogger.debug("Checking player role for gamemode", pairArray6);
            WorldRole worldRole2 = role;
            boolean bl = worldRole2 != null ? worldRole2.isSpectatorOnly() : false;
            if (bl) {
                player2.getScheduler().run((Plugin)this.plugin, arg_0 -> AccessListener.onPlayerChangedWorld$lambda$6(player2, this, playerWorld, arg_0), null);
            }
        }
        this.debugLogger.debugMethodExit("onPlayerChangedWorld", TuplesKt.to("hasAccess", hasAccess));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onPlayerRespawn(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Pair[] pairArray = event.getRespawnLocation().getWorld();
        if (pairArray == null) {
            AccessListener $this$onPlayerRespawn_u24lambda_u247 = this;
            boolean bl = false;
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("respawnLocation", event.getRespawnLocation())};
            $this$onPlayerRespawn_u24lambda_u247.debugLogger.debug("Respawn world is null", pairArray2);
            return;
        }
        Pair[] respawnWorld = pairArray;
        pairArray = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("respawnWorld", respawnWorld.getName()), TuplesKt.to("isBedSpawn", event.isBedSpawn()), TuplesKt.to("isAnchorSpawn", event.isAnchorSpawn()), TuplesKt.to("respawnLocation", event.getRespawnLocation())};
        this.debugLogger.debugMethodEntry("onPlayerRespawn", pairArray);
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld((World)respawnWorld);
        boolean isPluginWorld = playerWorld != null;
        Pair[] $this$onPlayerRespawn_u24lambda_u247 = new Pair[]{TuplesKt.to("respawnWorld", respawnWorld.getName()), TuplesKt.to("isPluginWorld", isPluginWorld)};
        this.debugLogger.debug("Checking if respawn world is plugin world", $this$onPlayerRespawn_u24lambda_u247);
        if (playerWorld == null) {
            this.debugLogger.debugMethodExit("onPlayerRespawn", TuplesKt.to("allowed", true));
            return;
        }
        $this$onPlayerRespawn_u24lambda_u247 = new Pair[]{TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("worldId", playerWorld.getId()), TuplesKt.to("ownerUuid", playerWorld.getOwnerUuid()), TuplesKt.to("ownerName", playerWorld.getOwnerName()), TuplesKt.to("isEnabled", playerWorld.isEnabled())};
        this.debugLogger.debug("Plugin world details", $this$onPlayerRespawn_u24lambda_u247);
        boolean hasAdminBypass = player2.hasPermission(ADMIN_BYPASS_PERMISSION);
        Pair[] bl = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("permission", ADMIN_BYPASS_PERMISSION), TuplesKt.to("hasPermission", hasAdminBypass)};
        this.debugLogger.debug("Checking admin bypass permission", bl);
        if (hasAdminBypass) {
            this.debugLogger.debugMethodExit("onPlayerRespawn", TuplesKt.to("allowed", true));
            return;
        }
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        boolean hasAccess = this.inviteManager.hasAccess(uUID, playerWorld);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("playerUuid", player2.getUniqueId()), TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("hasAccess", hasAccess)};
        this.debugLogger.debug("Access check result", pairArray3);
        if (!hasAccess) {
            List list = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
            World defaultWorld = (World)CollectionsKt.firstOrNull(list);
            Pair[] pairArray4 = new Pair[4];
            pairArray4[0] = TuplesKt.to("player", player2.getName());
            pairArray4[1] = TuplesKt.to("originalWorld", playerWorld.getName());
            pairArray4[2] = TuplesKt.to("defaultWorldAvailable", defaultWorld != null);
            World world = defaultWorld;
            pairArray4[3] = TuplesKt.to("defaultWorld", world != null ? world.getName() : null);
            this.debugLogger.debug("No access - overriding respawn location", pairArray4);
            if (defaultWorld != null) {
                Location originalLocation = event.getRespawnLocation();
                event.setRespawnLocation(defaultWorld.getSpawnLocation());
                Pair[] pairArray5 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("originalLocation", originalLocation), TuplesKt.to("newLocation", event.getRespawnLocation())};
                this.debugLogger.debug("Respawn location overridden", pairArray5);
                player2.sendMessage((Component)Component.text("You no longer have access to that world.", (TextColor)NamedTextColor.RED));
            } else {
                this.plugin.getLogger().warning("[AccessListener] No default world found to respawn '" + player2.getName() + "'");
                pairArray4 = new Pair[]{TuplesKt.to("player", player2.getName()), TuplesKt.to("reason", "no default world available")};
                this.debugLogger.debug("Respawn override FAILED - no default world", pairArray4);
            }
        }
        this.debugLogger.debugMethodExit("onPlayerRespawn", TuplesKt.to("hasAccess", hasAccess));
    }

    private static final void onPlayerTeleport$lambda$1(Player $player, AccessListener this$0, PlayerWorld $playerWorld, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if ($player.getGameMode() != GameMode.SPECTATOR) {
            $player.setGameMode(GameMode.SPECTATOR);
            $player.sendMessage((Component)Component.text("You are visiting this world as a spectator.", (TextColor)NamedTextColor.YELLOW));
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $playerWorld.getName())};
            this$0.debugLogger.debug("Set player to spectator mode as visitor", pairArray);
        }
    }

    private static final void onPlayerChangedWorld$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onPlayerChangedWorld$lambda$5(AccessListener this$0, Player $player, World $defaultWorld, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("targetLocation", $defaultWorld.getSpawnLocation())};
        this$0.debugLogger.debug("Executing async teleport to default world spawn", pairArray);
        $player.teleportAsync($defaultWorld.getSpawnLocation()).thenAccept(arg_0 -> AccessListener.onPlayerChangedWorld$lambda$5$lambda$4(new Function1<Boolean, Unit>($player, this$0){
            final /* synthetic */ Player $player;
            final /* synthetic */ AccessListener this$0;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Boolean success) {
                this.$player.sendMessage((Component)Component.text("You don't have access to this world.", (TextColor)NamedTextColor.RED));
                Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("success", success)};
                AccessListener.access$getDebugLogger$p(this.this$0).debug("Emergency teleport completed", pairArray);
            }
        }, arg_0));
    }

    private static final void onPlayerChangedWorld$lambda$6(Player $player, AccessListener this$0, PlayerWorld $playerWorld, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if ($player.getGameMode() != GameMode.SPECTATOR) {
            $player.setGameMode(GameMode.SPECTATOR);
            $player.sendMessage((Component)Component.text("You are visiting this world as a spectator.", (TextColor)NamedTextColor.YELLOW));
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $playerWorld.getName())};
            this$0.debugLogger.debug("Set visitor to spectator mode", pairArray);
        }
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(AccessListener $this) {
        return $this.debugLogger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/bedson/playerworldmanager/listeners/AccessListener$Companion;", "", "()V", "ADMIN_BYPASS_PERMISSION", "", "PlayerWorldManager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

