/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.WorldManageGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.ChestGuiBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.StatsManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerStatistics;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldStatistics;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020'H\u0002J\u0016\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ltech/bedson/playerworldmanager/gui/WorldStatsGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "statsManager", "Ltech/bedson/playerworldmanager/managers/StatsManager;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/StatsManager;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createAnimalsKilledItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "stats", "Ltech/bedson/playerworldmanager/models/WorldStatistics;", "createBackItem", "player", "Lorg/bukkit/entity/Player;", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "createBlocksBrokenItem", "createBlocksPlacedItem", "createItemsCraftedItem", "createMobsKilledItem", "createPersonalStatsItem", "playerStats", "Ltech/bedson/playerworldmanager/models/PlayerStatistics;", "createPlayerDeathsItem", "createPlayerKillsItem", "createRefreshItem", "createTimePlayedItem", "createWorldOverviewItem", "formatDuration", "", "millis", "", "formatNumber", "number", "open", "", "PlayerWorldManager"})
public final class WorldStatsGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final StatsManager statsManager;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;

    public WorldStatsGui(@NotNull JavaPlugin plugin, @NotNull StatsManager statsManager, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(statsManager, "statsManager");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.statsManager = statsManager;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "WorldStatsGui");
    }

    public final void open(@NotNull Player player, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        WorldStatistics stats = this.statsManager.getWorldStats(world.getId());
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        PlayerStatistics playerStats = stats.getOrCreatePlayerStats(uUID);
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(Component.text("Statistics: " + world.getName(), (TextColor)NamedTextColor.GOLD))).rows(5)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(gui, "create(...)");
        Gui gui2 = gui;
        gui2.setItem(4, this.createWorldOverviewItem(world, stats));
        gui2.setItem(10, this.createBlocksPlacedItem(stats));
        gui2.setItem(11, this.createBlocksBrokenItem(stats));
        gui2.setItem(12, this.createItemsCraftedItem(stats));
        gui2.setItem(19, this.createMobsKilledItem(stats));
        gui2.setItem(20, this.createAnimalsKilledItem(stats));
        gui2.setItem(21, this.createPlayerKillsItem(stats));
        gui2.setItem(22, this.createPlayerDeathsItem(stats));
        gui2.setItem(28, this.createTimePlayedItem(stats));
        gui2.setItem(31, this.createPersonalStatsItem(player, playerStats));
        gui2.setItem(36, this.createBackItem(player, world));
        gui2.setItem(44, this.createRefreshItem(player, world));
        for (int i = 0; i < 45; ++i) {
            if (gui2.getGuiItem(i) != null) continue;
            gui2.setItem(i, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Opening GUI", pairArray2);
        gui2.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    private final GuiItem createWorldOverviewItem(PlayerWorld world, WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("World: ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getName(), (TextColor)NamedTextColor.WHITE)), Component.text("Owner: ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getOwnerName(), (TextColor)NamedTextColor.WHITE)), Component.text("Type: ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getWorldType().name(), (TextColor)NamedTextColor.WHITE)), Component.empty(), Component.text("Total Players Tracked: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(stats.getPlayerStats().size()), (TextColor)NamedTextColor.YELLOW))};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BOOK).name(Component.text("World Statistics Overview", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true))).lore(lore)).asGuiItem(WorldStatsGui::createWorldOverviewItem$lambda$0);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createBlocksPlacedItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total blocks placed in this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatNumber(stats.getBlocksPlaced()), (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.GRASS_BLOCK).name(Component.text("Blocks Placed", (TextColor)NamedTextColor.GREEN))).lore(lore)).asGuiItem(WorldStatsGui::createBlocksPlacedItem$lambda$1);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createBlocksBrokenItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total blocks broken in this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatNumber(stats.getBlocksBroken()), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.DIAMOND_PICKAXE).name(Component.text("Blocks Broken", (TextColor)NamedTextColor.YELLOW))).lore(lore)).asGuiItem(WorldStatsGui::createBlocksBrokenItem$lambda$2);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createItemsCraftedItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total items crafted in this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatNumber(stats.getItemsCrafted()), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.CRAFTING_TABLE).name(Component.text("Items Crafted", (TextColor)NamedTextColor.AQUA))).lore(lore)).asGuiItem(WorldStatsGui::createItemsCraftedItem$lambda$3);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createMobsKilledItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total hostile mobs killed", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatNumber(stats.getMobsKilled()), (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.IRON_SWORD).name(Component.text("Mobs Killed", (TextColor)NamedTextColor.RED))).lore(lore)).asGuiItem(WorldStatsGui::createMobsKilledItem$lambda$4);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createAnimalsKilledItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total passive animals killed", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatNumber(stats.getAnimalsKilled()), (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.COOKED_BEEF).name(Component.text("Animals Killed", (TextColor)NamedTextColor.LIGHT_PURPLE))).lore(lore)).asGuiItem(WorldStatsGui::createAnimalsKilledItem$lambda$5);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createPlayerKillsItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total PvP kills in this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatNumber(stats.getPlayerKills()), (TextColor)NamedTextColor.DARK_RED).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.DIAMOND_SWORD).name(Component.text("Player Kills", (TextColor)NamedTextColor.DARK_RED))).lore(lore)).asGuiItem(WorldStatsGui::createPlayerKillsItem$lambda$6);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createPlayerDeathsItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total player deaths in this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatNumber(stats.getPlayerDeaths()), (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.SKELETON_SKULL).name(Component.text("Player Deaths", (TextColor)NamedTextColor.DARK_GRAY))).lore(lore)).asGuiItem(WorldStatsGui::createPlayerDeathsItem$lambda$7);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createTimePlayedItem(WorldStatistics stats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Total time played in this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text(this.formatDuration(stats.getTimePlayed()), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.CLOCK).name(Component.text("Time Played", (TextColor)NamedTextColor.GOLD))).lore(lore)).asGuiItem(WorldStatsGui::createTimePlayedItem$lambda$8);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createPersonalStatsItem(Player player, PlayerStatistics playerStats) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Your personal statistics:", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Blocks Placed: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(playerStats.getBlocksPlaced()), (TextColor)NamedTextColor.GREEN)), Component.text("Blocks Broken: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(playerStats.getBlocksBroken()), (TextColor)NamedTextColor.YELLOW)), Component.text("Mobs Killed: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(playerStats.getMobsKilled()), (TextColor)NamedTextColor.RED)), Component.text("Animals Killed: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(playerStats.getAnimalsKilled()), (TextColor)NamedTextColor.LIGHT_PURPLE)), Component.text("Player Kills: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(playerStats.getPlayerKills()), (TextColor)NamedTextColor.DARK_RED)), Component.text("Deaths: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(playerStats.getDeaths()), (TextColor)NamedTextColor.DARK_GRAY)), Component.text("Items Crafted: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(playerStats.getItemsCrafted()), (TextColor)NamedTextColor.AQUA)), Component.text("Time Played: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatDuration(playerStats.getTimePlayed()), (TextColor)NamedTextColor.GOLD))};
        List<Component> lore = CollectionsKt.listOf(textComponentArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.PLAYER_HEAD).name(Component.text("Your Statistics", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true))).lore(lore)).asGuiItem(WorldStatsGui::createPersonalStatsItem$lambda$9);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createBackItem(Player player, PlayerWorld world) {
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Back to World Menu", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> WorldStatsGui.createBackItem$lambda$11(player, this, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createRefreshItem(Player player, PlayerWorld world) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Click to refresh statistics", (TextColor)NamedTextColor.GRAY)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.SUNFLOWER).name(Component.text("Refresh Statistics", (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldStatsGui.createRefreshItem$lambda$13(player, this, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final String formatNumber(long number) {
        String string = "%,d";
        Object[] objectArray = new Object[]{number};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private final String formatDuration(long millis) {
        if (millis == 0L) {
            return "0 minutes";
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis) % (long)24;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % (long)60;
        return days > 0L ? days + " days, " + hours + " hours" : (hours > 0L ? hours + " hours, " + minutes + " minutes" : minutes + " minutes");
    }

    private static final void createWorldOverviewItem$lambda$0(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createBlocksPlacedItem$lambda$1(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createBlocksBrokenItem$lambda$2(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createItemsCraftedItem$lambda$3(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createMobsKilledItem$lambda$4(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createAnimalsKilledItem$lambda$5(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createPlayerKillsItem$lambda$6(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createPlayerDeathsItem$lambda$7(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createTimePlayedItem$lambda$8(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createPersonalStatsItem$lambda$9(InventoryClickEvent it) {
        it.setCancelled(true);
    }

    private static final void createBackItem$lambda$11$lambda$10(WorldStatsGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        new WorldManageGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager, null, null, 48, null).open($player, $world);
    }

    private static final void createBackItem$lambda$11(Player $player, WorldStatsGui this$0, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldStatsGui.createBackItem$lambda$11$lambda$10(this$0, $player, $world, arg_0), null);
    }

    private static final void createRefreshItem$lambda$13$lambda$12(WorldStatsGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        this$0.open($player, $world);
    }

    private static final void createRefreshItem$lambda$13(Player $player, WorldStatsGui this$0, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldStatsGui.createRefreshItem$lambda$13$lambda$12(this$0, $player, $world, arg_0), null);
    }
}

