/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.gui.BackupGui;
import tech.bedson.playerworldmanager.gui.MainMenuGui;
import tech.bedson.playerworldmanager.gui.WorldBorderGui;
import tech.bedson.playerworldmanager.gui.WorldManageGui;
import tech.bedson.playerworldmanager.gui.WorldStatsGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.ChestGuiBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.NoWhenBranchMatchedException;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.BackupManager;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.StatsManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.BackupSchedule;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.TimeLock;
import tech.bedson.playerworldmanager.models.WeatherLock;
import tech.bedson.playerworldmanager.models.WorldBorderSettings;
import tech.bedson.playerworldmanager.models.WorldStatistics;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010,\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ltech/bedson/playerworldmanager/gui/WorldManageGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "statsManager", "Ltech/bedson/playerworldmanager/managers/StatsManager;", "backupManager", "Ltech/bedson/playerworldmanager/managers/BackupManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/managers/StatsManager;Ltech/bedson/playerworldmanager/managers/BackupManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createBackItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "createBackupItem", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "createDeleteItem", "createGameModeItem", "createInvitePlayerItem", "createInvitedPlayersItem", "createKickPlayerItem", "createSetSpawnItem", "createStatsItem", "createTeleportItem", "environment", "Lorg/bukkit/World$Environment;", "createTimeLockItem", "createTransferOwnershipItem", "createWeatherLockItem", "createWorldBorderItem", "formatNumber", "", "number", "", "open", "", "openWithBackupManager", "Companion", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nWorldManageGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldManageGui.kt\ntech/bedson/playerworldmanager/gui/WorldManageGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,647:1\n1549#2:648\n1620#2,3:649\n1855#2,2:652\n*S KotlinDebug\n*F\n+ 1 WorldManageGui.kt\ntech/bedson/playerworldmanager/gui/WorldManageGui\n*L\n166#1:648\n166#1:649,3\n175#1:652,2\n*E\n"})
public final class WorldManageGui {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @Nullable
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @Nullable
    private final StatsManager statsManager;
    @Nullable
    private BackupManager backupManager;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private static final ConcurrentHashMap<UUID, Companion.PendingDelete> pendingDeletes = new ConcurrentHashMap();

    public WorldManageGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @Nullable InviteManager inviteManager, @NotNull DataManager dataManager, @Nullable StatsManager statsManager, @Nullable BackupManager backupManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.statsManager = statsManager;
        this.backupManager = backupManager;
        this.debugLogger = new DebugLogger(this.plugin, "WorldManageGui");
    }

    public /* synthetic */ WorldManageGui(JavaPlugin javaPlugin, WorldManager worldManager, InviteManager inviteManager, DataManager dataManager, StatsManager statsManager, BackupManager backupManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            statsManager = null;
        }
        if ((n & 0x20) != 0) {
            backupManager = null;
        }
        this(javaPlugin, worldManager, inviteManager, dataManager, statsManager, backupManager);
    }

    public final void openWithBackupManager(@NotNull Player player, @NotNull PlayerWorld world, @NotNull BackupManager backupManager) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(backupManager, "backupManager");
        this.backupManager = backupManager;
        this.open(player, world);
    }

    public final void open(@NotNull Player player, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        this.plugin.getLogger().info("[GUI] WorldManageGui: Opening for player " + player.getName() + ", world " + world.getName());
        pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerUuid", world.getOwnerUuid()), TuplesKt.to("timeLock", world.getTimeLock()), TuplesKt.to("weatherLock", world.getWeatherLock()), TuplesKt.to("defaultGameMode", world.getDefaultGameMode()), TuplesKt.to("invitedPlayers", world.getInvitedPlayers().size())};
        this.debugLogger.debugState("WorldManageGui", pairArray);
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(Component.text("Manage: " + world.getName(), (TextColor)NamedTextColor.GOLD))).rows(5)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(gui, "create(...)");
        Gui gui2 = gui;
        this.debugLogger.debug("Setting up Row 1: Teleportation");
        gui2.setItem(0, this.createTeleportItem(player, world, World.Environment.NORMAL));
        gui2.setItem(1, this.createTeleportItem(player, world, World.Environment.NETHER));
        gui2.setItem(2, this.createTeleportItem(player, world, World.Environment.THE_END));
        gui2.setItem(4, this.createInvitedPlayersItem(world));
        this.debugLogger.debug("Setting up Row 2: Settings");
        gui2.setItem(9, this.createTimeLockItem(player, world));
        gui2.setItem(10, this.createWeatherLockItem(player, world));
        gui2.setItem(11, this.createGameModeItem(player, world));
        gui2.setItem(12, this.createSetSpawnItem(player, world));
        gui2.setItem(13, this.createWorldBorderItem(player, world));
        this.debugLogger.debug("Setting up Row 3: Invite/Kick/Stats/Backup");
        gui2.setItem(18, this.createInvitePlayerItem(player, world));
        gui2.setItem(19, this.createKickPlayerItem(player, world));
        gui2.setItem(20, this.createStatsItem(player, world));
        gui2.setItem(21, this.createBackupItem(player, world));
        this.debugLogger.debug("Setting up Row 4: Ownership");
        gui2.setItem(27, this.createTransferOwnershipItem(player, world));
        this.debugLogger.debug("Setting up Row 5: Navigation and deletion");
        gui2.setItem(36, this.createBackItem(player));
        gui2.setItem(44, this.createDeleteItem(player, world));
        this.debugLogger.debug("Filling empty slots with glass panes");
        for (int i = 0; i < 45; ++i) {
            if (gui2.getGuiItem(i) != null) continue;
            gui2.setItem(i, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Opening GUI for player", pairArray2);
        gui2.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    private final GuiItem createTeleportItem(Player player, PlayerWorld world, World.Environment environment) {
        Object object = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("environment", environment)};
        this.debugLogger.debugMethodEntry("createTeleportItem", (Pair<String, ? extends Object>)object);
        object = switch (WhenMappings.$EnumSwitchMapping$0[environment.ordinal()]) {
            case 1 -> TuplesKt.to(Material.COMPASS, "Teleport to Overworld");
            case 2 -> TuplesKt.to(Material.NETHERRACK, "Teleport to Nether");
            case 3 -> TuplesKt.to(Material.END_STONE, "Teleport to End");
            default -> TuplesKt.to(Material.COMPASS, "Teleport");
        };
        Material material = (Material)((Pair)object).component1();
        String name = (String)((Pair)object).component2();
        Pair[] pairArray = new Pair[]{TuplesKt.to("material", material), TuplesKt.to("name", name)};
        this.debugLogger.debug("Creating teleport item", pairArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(name, (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(Component.text("Click to teleport", (TextColor)NamedTextColor.YELLOW)))).asGuiItem(arg_0 -> WorldManageGui.createTeleportItem$lambda$2(this, player, environment, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createTeleportItem", null, 2, null);
        return item2;
    }

    /*
     * WARNING - void declaration
     */
    private final GuiItem createInvitedPlayersItem(PlayerWorld world) {
        void $this$mapTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createInvitedPlayersItem", pairArray);
        int invitedCount = world.getInvitedPlayers().size();
        Pair[] $this$map$iv = (Pair[])CollectionsKt.take((Iterable)world.getInvitedPlayers(), 5);
        boolean $i$f$map = false;
        Pair[] pairArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void uuid;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            if (string == null) {
                string = uuid.toString();
            }
            collection.add(string);
        }
        List invitedNames = (List)destination$iv$iv;
        $this$map$iv = new Pair[]{TuplesKt.to("invitedCount", invitedCount), TuplesKt.to("displayedNames", invitedNames.size())};
        this.debugLogger.debugState("InvitedPlayersItem", $this$map$iv);
        List<TextComponent> $this$createInvitedPlayersItem_u24lambda_u245 = $i$f$map = CollectionsKt.createListBuilder();
        boolean bl = false;
        TextComponent textComponent = Component.text("Invited Players: " + invitedCount, (TextColor)NamedTextColor.GRAY);
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        $this$createInvitedPlayersItem_u24lambda_u245.add(textComponent);
        if (!((Collection)invitedNames).isEmpty()) {
            TextComponent textComponent2 = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent2, "empty(...)");
            $this$createInvitedPlayersItem_u24lambda_u245.add(textComponent2);
            Iterable $this$forEach$iv = invitedNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name = (String)element$iv;
                boolean bl2 = false;
                TextComponent textComponent3 = Component.text("  - " + name, (TextColor)NamedTextColor.GRAY);
                Intrinsics.checkNotNullExpressionValue(textComponent3, "text(...)");
                $this$createInvitedPlayersItem_u24lambda_u245.add(textComponent3);
            }
            if (invitedCount > 5) {
                TextComponent textComponent4 = Component.text("  ...and " + (invitedCount - 5) + " more", (TextColor)NamedTextColor.GRAY);
                Intrinsics.checkNotNullExpressionValue(textComponent4, "text(...)");
                $this$createInvitedPlayersItem_u24lambda_u245.add(textComponent4);
            }
        }
        List<Component> lore = CollectionsKt.build($i$f$map);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.PLAYER_HEAD).name(Component.text("Invited Players", (TextColor)NamedTextColor.AQUA))).lore(lore)).asGuiItem(arg_0 -> WorldManageGui.createInvitedPlayersItem$lambda$6(this, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        this.debugLogger.debugMethodExit("createInvitedPlayersItem", "invitedCount=" + invitedCount);
        return item2;
    }

    private final GuiItem createTimeLockItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createTimeLockItem", pairArray);
        TimeLock currentLock = world.getTimeLock();
        TimeLock nextLock = switch (WhenMappings.$EnumSwitchMapping$1[currentLock.ordinal()]) {
            case 1 -> TimeLock.DAY;
            case 2 -> TimeLock.NIGHT;
            case 3 -> TimeLock.CYCLE;
            default -> throw new NoWhenBranchMatchedException();
        };
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("currentLock", currentLock), TuplesKt.to("nextLock", nextLock)};
        this.debugLogger.debugState("TimeLockItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + currentLock, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to change to " + nextLock, (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.CLOCK).name(Component.text("Time Setting", (TextColor)NamedTextColor.YELLOW))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createTimeLockItem$lambda$8(this, player, currentLock, nextLock, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createTimeLockItem", null, 2, null);
        return item2;
    }

    private final GuiItem createWeatherLockItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createWeatherLockItem", pairArray);
        WeatherLock currentLock = world.getWeatherLock();
        WeatherLock nextLock = switch (WhenMappings.$EnumSwitchMapping$2[currentLock.ordinal()]) {
            case 1 -> WeatherLock.CLEAR;
            case 2 -> WeatherLock.RAIN;
            case 3 -> WeatherLock.CYCLE;
            default -> throw new NoWhenBranchMatchedException();
        };
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("currentLock", currentLock), TuplesKt.to("nextLock", nextLock)};
        this.debugLogger.debugState("WeatherLockItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + currentLock, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to change to " + nextLock, (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.WATER_BUCKET).name(Component.text("Weather Setting", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createWeatherLockItem$lambda$10(this, player, currentLock, nextLock, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createWeatherLockItem", null, 2, null);
        return item2;
    }

    private final GuiItem createGameModeItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createGameModeItem", pairArray);
        GameMode currentMode = world.getDefaultGameMode();
        GameMode nextMode = switch (WhenMappings.$EnumSwitchMapping$3[currentMode.ordinal()]) {
            case 1 -> GameMode.CREATIVE;
            case 2 -> GameMode.ADVENTURE;
            case 3 -> GameMode.SPECTATOR;
            case 4 -> GameMode.SURVIVAL;
            default -> throw new NoWhenBranchMatchedException();
        };
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("currentMode", currentMode), TuplesKt.to("nextMode", nextMode)};
        this.debugLogger.debugState("GameModeItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + currentMode, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to change to " + nextMode, (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.DIAMOND_SWORD).name(Component.text("Default Gamemode", (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createGameModeItem$lambda$11(this, player, currentMode, nextMode, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createGameModeItem", null, 2, null);
        return item2;
    }

    private final GuiItem createSetSpawnItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createSetSpawnItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Sets spawn to your current location", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to set", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.RED_BED).name(Component.text("Set Spawn Point", (TextColor)NamedTextColor.RED))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createSetSpawnItem$lambda$13(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createSetSpawnItem", null, 2, null);
        return item2;
    }

    private final GuiItem createWorldBorderItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createWorldBorderItem", pairArray);
        WorldBorderSettings settings = world.getWorldBorder();
        String sizeDisplay = settings.getSize() >= 5.9999968E7 ? "Unlimited" : String.valueOf((long)settings.getSize());
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current size: " + sizeDisplay + " blocks", (TextColor)NamedTextColor.GRAY), Component.text("Center: " + (long)settings.getCenterX() + ", " + (long)settings.getCenterZ(), (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to open border settings", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.STRUCTURE_VOID).name(Component.text("World Border", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createWorldBorderItem$lambda$15(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createWorldBorderItem", null, 2, null);
        return item2;
    }

    private final GuiItem createInvitePlayerItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createInvitePlayerItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Click to invite a player", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /world invite <player>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.NAME_TAG).name(Component.text("Invite Player", (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createInvitePlayerItem$lambda$16(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createInvitePlayerItem", null, 2, null);
        return item2;
    }

    private final GuiItem createKickPlayerItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createKickPlayerItem", pairArray);
        int invitedCount = world.getInvitedPlayers().size();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("invitedCount", invitedCount)};
        this.debugLogger.debugState("KickPlayerItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Invited players: " + invitedCount, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /world kick <player>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Component.text("Kick Player", (TextColor)NamedTextColor.RED))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createKickPlayerItem$lambda$17(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createKickPlayerItem", null, 2, null);
        return item2;
    }

    private final GuiItem createBackupItem(Player player, PlayerWorld world) {
        BackupSchedule schedule;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createBackupItem", pairArray);
        BackupManager bm = this.backupManager;
        Object object = bm;
        int backupCount = object != null && (object = ((BackupManager)object).getBackupsForWorld(world.getId())) != null ? object.size() : 0;
        BackupManager backupManager = bm;
        int maxBackups = backupManager != null ? backupManager.getMaxBackupsPerWorld() : 5;
        BackupManager backupManager2 = bm;
        BackupSchedule backupSchedule = schedule = backupManager2 != null ? backupManager2.getBackupSchedule(world.getId()) : null;
        String scheduleStatus = (backupSchedule != null ? backupSchedule.getEnabled() : false) ? "Enabled" : "Disabled";
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Manage world backups", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Backups: " + backupCount + " / " + maxBackups, (TextColor)NamedTextColor.GRAY), Component.text("Auto-backup: " + scheduleStatus, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to manage backups", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.ENDER_CHEST).name(Component.text("Backups", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createBackupItem$lambda$19(this, player, world, bm, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createBackupItem", null, 2, null);
        return item2;
    }

    private final GuiItem createStatsItem(Player player, PlayerWorld world) {
        WorldStatistics stats;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createStatsItem", pairArray);
        StatsManager statsManager = this.statsManager;
        WorldStatistics worldStatistics = stats = statsManager != null ? statsManager.getWorldStats(world.getId()) : null;
        long blocksPlaced = worldStatistics != null ? worldStatistics.getBlocksPlaced() : 0L;
        WorldStatistics worldStatistics2 = stats;
        long blocksBroken = worldStatistics2 != null ? worldStatistics2.getBlocksBroken() : 0L;
        WorldStatistics worldStatistics3 = stats;
        long mobsKilled = worldStatistics3 != null ? worldStatistics3.getMobsKilled() : 0L;
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("View statistics for this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Quick Stats:", (TextColor)NamedTextColor.YELLOW), Component.text("  Blocks Placed: " + this.formatNumber(blocksPlaced), (TextColor)NamedTextColor.GRAY), Component.text("  Blocks Broken: " + this.formatNumber(blocksBroken), (TextColor)NamedTextColor.GRAY), Component.text("  Mobs Killed: " + this.formatNumber(mobsKilled), (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to view detailed stats", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.PAPER).name(Component.text("World Statistics", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createStatsItem$lambda$21(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createStatsItem", null, 2, null);
        return item2;
    }

    private final String formatNumber(long number) {
        String string = "%,d";
        Object[] objectArray = new Object[]{number};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private final GuiItem createTransferOwnershipItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createTransferOwnershipItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Transfer this world to another player", (TextColor)NamedTextColor.GRAY), Component.text("They must be invited first", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /world transfer <player>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.GOLD_INGOT).name(Component.text("Transfer Ownership", (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createTransferOwnershipItem$lambda$22(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createTransferOwnershipItem", null, 2, null);
        return item2;
    }

    private final GuiItem createBackItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createBackItem", pairArray);
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Back to Main Menu", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> WorldManageGui.createBackItem$lambda$24(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createBackItem", null, 2, null);
        return item2;
    }

    private final GuiItem createDeleteItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createDeleteItem", pairArray);
        long currentTime = System.currentTimeMillis();
        Companion.PendingDelete pendingDelete = pendingDeletes.get(player.getUniqueId());
        boolean hasPendingDelete = pendingDelete != null && Intrinsics.areEqual(pendingDelete.getWorldId(), world.getId()) && currentTime - pendingDelete.getTimestamp() <= 5000L;
        boolean needsConfirmation = !hasPendingDelete;
        Material material = needsConfirmation ? Material.TNT : Material.BARRIER;
        String name = needsConfirmation ? "Delete World" : "Click again to confirm deletion";
        NamedTextColor color = needsConfirmation ? NamedTextColor.RED : NamedTextColor.DARK_RED;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("needsConfirmation", needsConfirmation), TuplesKt.to("hasPendingDelete", hasPendingDelete), TuplesKt.to("worldName", world.getName()), TuplesKt.to("timeSinceLastClick", pendingDelete != null ? Long.valueOf(currentTime - pendingDelete.getTimestamp()) : "N/A")};
        this.debugLogger.debugState("DeleteItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("This cannot be undone!", (TextColor)NamedTextColor.RED), Component.empty(), needsConfirmation ? Component.text("Click twice to delete", (TextColor)NamedTextColor.YELLOW) : Component.text("Click to DELETE PERMANENTLY", (TextColor)NamedTextColor.RED)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(name, (TextColor)color))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldManageGui.createDeleteItem$lambda$26(needsConfirmation, player, world, currentTime, this, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createDeleteItem", null, 2, null);
        return item2;
    }

    private static final void createTeleportItem$lambda$2$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createTeleportItem$lambda$2$lambda$1(WorldManageGui this$0, Player $player, World.Environment $environment, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($environment, "$environment");
        Intrinsics.checkNotNullParameter($world, "$world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("environment", $environment)};
        this$0.debugLogger.debug("Initiating teleport to dimension", pairArray);
        this$0.worldManager.teleportToDimension($player, $world, $environment).thenAccept(arg_0 -> WorldManageGui.createTeleportItem$lambda$2$lambda$1$lambda$0(new Function1<Boolean, Unit>(this$0, $player, $environment, $world){
            final /* synthetic */ WorldManageGui this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ World.Environment $environment;
            final /* synthetic */ PlayerWorld $world;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$environment = $environment;
                this.$world = $world;
                super(1);
            }

            public final void invoke(Boolean success) {
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    WorldManageGui.access$getPlugin$p(this.this$0).getLogger().info("[GUI] WorldManageGui: Player " + this.$player.getName() + " successfully teleported to " + this.$environment.name() + " in world " + this.$world.getName());
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("environment", this.$environment)};
                    WorldManageGui.access$getDebugLogger$p(this.this$0).debug("Teleport successful", pairArray);
                    this.$player.sendMessage(Component.text("Teleported to ", (TextColor)NamedTextColor.GREEN).append(Component.text(this.$world.getName(), (TextColor)NamedTextColor.GOLD)));
                } else {
                    WorldManageGui.access$getPlugin$p(this.this$0).getLogger().warning("[GUI] WorldManageGui: Player " + this.$player.getName() + " failed to teleport to " + this.$environment.name() + " in world " + this.$world.getName());
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("environment", this.$environment)};
                    WorldManageGui.access$getDebugLogger$p(this.this$0).debug("Teleport failed", pairArray);
                    this.$player.sendMessage((Component)Component.text("Failed to teleport to world", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
    }

    private static final void createTeleportItem$lambda$2(WorldManageGui this$0, Player $player, World.Environment $environment, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($environment, "$environment");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " clicked teleport to " + $environment.name() + " in world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("environment", $environment), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Teleport button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createTeleportItem$lambda$2$lambda$1(this$0, $player, $environment, $world, arg_0), null);
    }

    private static final void createInvitedPlayersItem$lambda$6(WorldManageGui this$0, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Invited Players item clicked (display only)", pairArray);
    }

    private static final void createTimeLockItem$lambda$8$lambda$7(WorldManageGui this$0, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        this$0.worldManager.applyWorldSettings($world);
    }

    private static final void createTimeLockItem$lambda$8(WorldManageGui this$0, Player $player, TimeLock $currentLock, TimeLock $nextLock, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter((Object)$currentLock, "$currentLock");
        Intrinsics.checkNotNullParameter((Object)$nextLock, "$nextLock");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " changing time lock from " + $currentLock + " to " + $nextLock + " in world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentLock", $currentLock), TuplesKt.to("nextLock", $nextLock)};
        this$0.debugLogger.debug("Time lock button clicked", pairArray);
        $world.setTimeLock($nextLock);
        this$0.dataManager.saveWorld($world);
        pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Time lock saved, applying world settings", pairArray);
        Bukkit.getGlobalRegionScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createTimeLockItem$lambda$8$lambda$7(this$0, $world, arg_0));
        $player.sendMessage(Component.text("Time setting changed to ", (TextColor)NamedTextColor.GREEN).append(Component.text($nextLock.toString(), (TextColor)NamedTextColor.GOLD)));
        this$0.open($player, $world);
    }

    private static final void createWeatherLockItem$lambda$10$lambda$9(WorldManageGui this$0, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        this$0.worldManager.applyWorldSettings($world);
    }

    private static final void createWeatherLockItem$lambda$10(WorldManageGui this$0, Player $player, WeatherLock $currentLock, WeatherLock $nextLock, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter((Object)$currentLock, "$currentLock");
        Intrinsics.checkNotNullParameter((Object)$nextLock, "$nextLock");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " changing weather lock from " + $currentLock + " to " + $nextLock + " in world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentLock", $currentLock), TuplesKt.to("nextLock", $nextLock)};
        this$0.debugLogger.debug("Weather lock button clicked", pairArray);
        $world.setWeatherLock($nextLock);
        this$0.dataManager.saveWorld($world);
        pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Weather lock saved, applying world settings", pairArray);
        Bukkit.getGlobalRegionScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createWeatherLockItem$lambda$10$lambda$9(this$0, $world, arg_0));
        $player.sendMessage(Component.text("Weather setting changed to ", (TextColor)NamedTextColor.GREEN).append(Component.text($nextLock.toString(), (TextColor)NamedTextColor.GOLD)));
        this$0.open($player, $world);
    }

    private static final void createGameModeItem$lambda$11(WorldManageGui this$0, Player $player, GameMode $currentMode, GameMode $nextMode, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($currentMode, "$currentMode");
        Intrinsics.checkNotNullParameter($nextMode, "$nextMode");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " changing default gamemode from " + $currentMode + " to " + $nextMode + " in world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentMode", $currentMode), TuplesKt.to("nextMode", $nextMode)};
        this$0.debugLogger.debug("GameMode button clicked", pairArray);
        $world.setDefaultGameMode($nextMode);
        this$0.dataManager.saveWorld($world);
        pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("newGameMode", $nextMode)};
        this$0.debugLogger.debug("GameMode saved", pairArray);
        $player.sendMessage(Component.text("Default gamemode changed to ", (TextColor)NamedTextColor.GREEN).append(Component.text($nextMode.toString(), (TextColor)NamedTextColor.GOLD)));
        this$0.open($player, $world);
    }

    private static final void createSetSpawnItem$lambda$13$lambda$12(Player $player, WorldManageGui this$0, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("x", location2.getBlockX()), TuplesKt.to("y", location2.getBlockY()), TuplesKt.to("z", location2.getBlockZ())};
        this$0.debugLogger.debug("Setting spawn location", pairArray);
        this$0.worldManager.setSpawnLocation($world, location2);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Spawn point set for world " + $world.getName() + " at " + location2.getBlockX() + ", " + location2.getBlockY() + ", " + location2.getBlockZ());
        pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Spawn point set successfully", pairArray);
        $player.sendMessage((Component)Component.text("Spawn point set to your current location", (TextColor)NamedTextColor.GREEN));
    }

    private static final void createSetSpawnItem$lambda$13(WorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " setting spawn point in world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Set Spawn button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createSetSpawnItem$lambda$13$lambda$12($player, this$0, $world, arg_0), null);
    }

    private static final void createWorldBorderItem$lambda$15$lambda$14(WorldManageGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Opening WorldBorderGui", pairArray);
        if (this$0.inviteManager != null) {
            new WorldBorderGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager).open($player, $world);
        } else {
            $player.sendMessage((Component)Component.text("World border settings unavailable.", (TextColor)NamedTextColor.RED));
        }
    }

    private static final void createWorldBorderItem$lambda$15(WorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " opening world border settings for world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("World Border button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createWorldBorderItem$lambda$15$lambda$14(this$0, $player, $world, arg_0), null);
    }

    private static final void createInvitePlayerItem$lambda$16(WorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Invite Player button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/world invite <player>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to invite a player to ", (TextColor)NamedTextColor.YELLOW))).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
    }

    private static final void createKickPlayerItem$lambda$17(WorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Kick Player button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/world kick <player>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to kick a player from ", (TextColor)NamedTextColor.YELLOW))).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
    }

    private static final void createBackupItem$lambda$19$lambda$18(WorldManageGui this$0, BackupManager $bm, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        new BackupGui(this$0.plugin, this$0.worldManager, $bm, this$0.dataManager).open($player, $world);
    }

    private static final void createBackupItem$lambda$19(WorldManageGui this$0, Player $player, PlayerWorld $world, BackupManager $bm, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Backup button clicked", pairArray);
        if ($bm == null) {
            $player.sendMessage((Component)Component.text("Backup system not available", (TextColor)NamedTextColor.RED));
            return;
        }
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createBackupItem$lambda$19$lambda$18(this$0, $bm, $player, $world, arg_0), null);
    }

    private static final void createStatsItem$lambda$21$lambda$20(WorldManageGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        new WorldStatsGui(this$0.plugin, this$0.statsManager, this$0.worldManager, this$0.inviteManager, this$0.dataManager).open($player, $world);
    }

    private static final void createStatsItem$lambda$21(WorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Stats button clicked", pairArray);
        $player.closeInventory();
        if (this$0.statsManager != null && this$0.inviteManager != null) {
            $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createStatsItem$lambda$21$lambda$20(this$0, $player, $world, arg_0), null);
        } else {
            $player.sendMessage((Component)Component.text("Statistics are not available.", (TextColor)NamedTextColor.RED));
        }
    }

    private static final void createTransferOwnershipItem$lambda$22(WorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Transfer Ownership button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/world transfer <player>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to transfer ownership of ", (TextColor)NamedTextColor.YELLOW))).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
    }

    private static final void createBackItem$lambda$24$lambda$23(WorldManageGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening MainMenuGui", pairArray);
        if (this$0.inviteManager != null) {
            new MainMenuGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager, null, null, 48, null).open($player);
        }
    }

    private static final void createBackItem$lambda$24(WorldManageGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " clicked Back to Main Menu");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Back button clicked", pairArray);
        pendingDeletes.remove($player.getUniqueId());
        pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Cleared pending delete confirmation", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldManageGui.createBackItem$lambda$24$lambda$23(this$0, $player, arg_0), null);
    }

    private static final void createDeleteItem$lambda$26$lambda$25(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createDeleteItem$lambda$26(boolean $needsConfirmation, Player $player, PlayerWorld $world, long $currentTime, WorldManageGui this$0, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        event.setCancelled(true);
        if ($needsConfirmation) {
            Pair[] pairArray = (Pair[])pendingDeletes;
            UUID uUID = $player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uUID2 = uUID;
            Companion.PendingDelete pendingDelete = new Companion.PendingDelete($world.getId(), $currentTime);
            pairArray.put(uUID2, pendingDelete);
            this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " clicked delete for world " + $world.getName() + " (first click)");
            pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
            this$0.debugLogger.debug("Delete button clicked (first click)", pairArray);
            $player.sendMessage(Component.text("Click delete again to confirm deletion of ", (TextColor)NamedTextColor.YELLOW).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
            this$0.open($player, $world);
        } else {
            pendingDeletes.remove($player.getUniqueId());
            this$0.plugin.getLogger().info("[GUI] WorldManageGui: Player " + $player.getName() + " confirmed deletion of world " + $world.getName());
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName()), TuplesKt.to("worldId", $world.getId())};
            this$0.debugLogger.debug("Delete button clicked (confirmation)", pairArray);
            $player.closeInventory();
            $player.sendMessage(((TextComponent)Component.text("Deleting world ", (TextColor)NamedTextColor.YELLOW).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("...", (TextColor)NamedTextColor.YELLOW)));
            pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
            this$0.debugLogger.debug("Initiating world deletion", pairArray);
            this$0.worldManager.deleteWorld($world).thenAccept(arg_0 -> WorldManageGui.createDeleteItem$lambda$26$lambda$25(new Function1<Result<? extends Unit>, Unit>(this$0, $world, $player){
                final /* synthetic */ WorldManageGui this$0;
                final /* synthetic */ PlayerWorld $world;
                final /* synthetic */ Player $player;
                {
                    this.this$0 = $receiver;
                    this.$world = $world;
                    this.$player = $player;
                    super(1);
                }

                public final void invoke(Result<? extends Unit> result) {
                    block1: {
                        Throwable throwable;
                        Intrinsics.checkNotNull(result);
                        Object object = result.unbox-impl();
                        WorldManageGui worldManageGui = this.this$0;
                        PlayerWorld playerWorld = this.$world;
                        Player player = this.$player;
                        if (Result.isSuccess-impl(object)) {
                            Unit it = (Unit)object;
                            boolean bl = false;
                            WorldManageGui.access$getPlugin$p(worldManageGui).getLogger().info("[GUI] WorldManageGui: Successfully deleted world " + playerWorld.getName() + " for player " + player.getName());
                            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", playerWorld.getName())};
                            WorldManageGui.access$getDebugLogger$p(worldManageGui).debug("World deletion successful", pairArray);
                            player.getScheduler().run((Plugin)WorldManageGui.access$getPlugin$p(worldManageGui), arg_0 -> createDeleteItem.item.1.1.invoke$lambda$1$lambda$0(player, playerWorld, arg_0), null);
                        }
                        worldManageGui = this.this$0;
                        playerWorld = this.$world;
                        player = this.$player;
                        Throwable throwable2 = Result.exceptionOrNull-impl(object);
                        if (throwable2 == null) break block1;
                        Throwable error = throwable = throwable2;
                        boolean bl = false;
                        WorldManageGui.access$getPlugin$p(worldManageGui).getLogger().warning("[GUI] WorldManageGui: Failed to delete world " + playerWorld.getName() + " for player " + player.getName() + ": " + error.getMessage());
                        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("error", error.getMessage())};
                        WorldManageGui.access$getDebugLogger$p(worldManageGui).debug("World deletion failed", pairArray);
                        player.getScheduler().run((Plugin)WorldManageGui.access$getPlugin$p(worldManageGui), arg_0 -> createDeleteItem.item.1.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                    }
                }

                private static final void invoke$lambda$1$lambda$0(Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    Intrinsics.checkNotNullParameter($world, "$world");
                    $player.sendMessage(Component.text("Successfully deleted world ", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
                }

                private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    Intrinsics.checkNotNullParameter($error, "$error");
                    $player.sendMessage((Component)Component.text("Failed to delete world: " + $error.getMessage(), (TextColor)NamedTextColor.RED));
                }
            }, arg_0));
        }
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(WorldManageGui $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(WorldManageGui $this) {
        return $this.debugLogger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ltech/bedson/playerworldmanager/gui/WorldManageGui$Companion;", "", "()V", "pendingDeletes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ltech/bedson/playerworldmanager/gui/WorldManageGui$Companion$PendingDelete;", "PendingDelete", "PlayerWorldManager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ltech/bedson/playerworldmanager/gui/WorldManageGui$Companion$PendingDelete;", "", "worldId", "Ljava/util/UUID;", "timestamp", "", "(Ljava/util/UUID;J)V", "getTimestamp", "()J", "getWorldId", "()Ljava/util/UUID;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "PlayerWorldManager"})
        public static final class PendingDelete {
            @NotNull
            private final UUID worldId;
            private final long timestamp;

            public PendingDelete(@NotNull UUID worldId, long timestamp) {
                Intrinsics.checkNotNullParameter(worldId, "worldId");
                this.worldId = worldId;
                this.timestamp = timestamp;
            }

            @NotNull
            public final UUID getWorldId() {
                return this.worldId;
            }

            public final long getTimestamp() {
                return this.timestamp;
            }

            @NotNull
            public final UUID component1() {
                return this.worldId;
            }

            public final long component2() {
                return this.timestamp;
            }

            @NotNull
            public final PendingDelete copy(@NotNull UUID worldId, long timestamp) {
                Intrinsics.checkNotNullParameter(worldId, "worldId");
                return new PendingDelete(worldId, timestamp);
            }

            public static /* synthetic */ PendingDelete copy$default(PendingDelete pendingDelete, UUID uUID, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    uUID = pendingDelete.worldId;
                }
                if ((n & 2) != 0) {
                    l = pendingDelete.timestamp;
                }
                return pendingDelete.copy(uUID, l);
            }

            @NotNull
            public String toString() {
                return "PendingDelete(worldId=" + this.worldId + ", timestamp=" + this.timestamp + ")";
            }

            public int hashCode() {
                int result = this.worldId.hashCode();
                result = result * 31 + Long.hashCode(this.timestamp);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PendingDelete)) {
                    return false;
                }
                PendingDelete pendingDelete = (PendingDelete)other;
                if (!Intrinsics.areEqual(this.worldId, pendingDelete.worldId)) {
                    return false;
                }
                return this.timestamp == pendingDelete.timestamp;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[World.Environment.values().length];
            try {
                nArray[World.Environment.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.NETHER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.THE_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TimeLock.values().length];
            try {
                nArray[TimeLock.CYCLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeLock.DAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeLock.NIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WeatherLock.values().length];
            try {
                nArray[WeatherLock.CYCLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeatherLock.CLEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeatherLock.RAIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[GameMode.values().length];
            try {
                nArray[GameMode.SURVIVAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.CREATIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.ADVENTURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.SPECTATOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

