/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.WorldManageGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.ChestGuiBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.ranges.RangesKt;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldBorderSettings;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001cH\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001cH\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010%\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltech/bedson/playerworldmanager/gui/WorldBorderGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "applyWorldBorder", "", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "createBackItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "createCenterHereItem", "createCenterResetItem", "createDamageAmountItem", "createDamageBufferItem", "createInfoItem", "createPresetItem", "size", "", "name", "", "createSizeDecreaseItem", "amount", "createSizeDisplayItem", "createSizeIncreaseItem", "createWarningDistanceItem", "createWarningTimeItem", "open", "PlayerWorldManager"})
public final class WorldBorderGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;

    public WorldBorderGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "WorldBorderGui");
    }

    public final void open(@NotNull Player player, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(Component.text("World Border: " + world.getName(), (TextColor)NamedTextColor.AQUA))).rows(5)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(gui, "create(...)");
        Gui gui2 = gui;
        WorldBorderSettings settings = world.getWorldBorder();
        gui2.setItem(10, this.createSizeDecreaseItem(player, world, 1000.0));
        gui2.setItem(11, this.createSizeDecreaseItem(player, world, 100.0));
        gui2.setItem(12, this.createSizeDecreaseItem(player, world, 10.0));
        gui2.setItem(13, this.createSizeDisplayItem(world));
        gui2.setItem(14, this.createSizeIncreaseItem(player, world, 10.0));
        gui2.setItem(15, this.createSizeIncreaseItem(player, world, 100.0));
        gui2.setItem(16, this.createSizeIncreaseItem(player, world, 1000.0));
        gui2.setItem(19, this.createCenterHereItem(player, world));
        gui2.setItem(20, this.createCenterResetItem(player, world));
        gui2.setItem(22, this.createPresetItem(player, world, 100.0, "Small"));
        gui2.setItem(23, this.createPresetItem(player, world, 500.0, "Medium"));
        gui2.setItem(24, this.createPresetItem(player, world, 2000.0, "Large"));
        gui2.setItem(25, this.createPresetItem(player, world, 5.9999968E7, "Unlimited"));
        gui2.setItem(28, this.createDamageAmountItem(player, world));
        gui2.setItem(29, this.createDamageBufferItem(player, world));
        gui2.setItem(31, this.createWarningDistanceItem(player, world));
        gui2.setItem(32, this.createWarningTimeItem(player, world));
        gui2.setItem(34, this.createInfoItem(world));
        gui2.setItem(36, this.createBackItem(player, world));
        for (int i = 0; i < 45; ++i) {
            if (gui2.getGuiItem(i) != null) continue;
            gui2.setItem(i, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        gui2.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    private final void applyWorldBorder(PlayerWorld world) {
        World world2 = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
        if (world2 == null) {
            return;
        }
        World bukkitWorld = world2;
        WorldBorder worldBorder = bukkitWorld.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder border = worldBorder;
        WorldBorderSettings settings = world.getWorldBorder();
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldBorderGui.applyWorldBorder$lambda$0(border, bukkitWorld, settings, arg_0));
    }

    private final GuiItem createSizeDisplayItem(PlayerWorld world) {
        WorldBorderSettings settings = world.getWorldBorder();
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + (long)settings.getSize() + " blocks", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("This is the diameter of the border", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.STRUCTURE_VOID).name(Component.text("Border Size", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(WorldBorderGui::createSizeDisplayItem$lambda$1);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createSizeIncreaseItem(Player player, PlayerWorld world, double amount) {
        Material material = amount >= 1000.0 ? Material.LIME_STAINED_GLASS_PANE : (amount >= 100.0 ? Material.GREEN_STAINED_GLASS_PANE : Material.GREEN_CONCRETE);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Click to increase border", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.text("by " + (long)amount + " blocks", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text("+" + (long)amount, (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createSizeIncreaseItem$lambda$2(world, amount, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createSizeDecreaseItem(Player player, PlayerWorld world, double amount) {
        Material material = amount >= 1000.0 ? Material.RED_STAINED_GLASS_PANE : (amount >= 100.0 ? Material.ORANGE_STAINED_GLASS_PANE : Material.RED_CONCRETE);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Click to decrease border", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.text("by " + (long)amount + " blocks", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text("-" + (long)amount, (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createSizeDecreaseItem$lambda$3(world, amount, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createCenterHereItem(Player player, PlayerWorld world) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Click to set border center", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.text("to your current position", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.COMPASS).name(Component.text("Center at Your Location", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createCenterHereItem$lambda$4(player, world, this, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createCenterResetItem(Player player, PlayerWorld world) {
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Click to reset border center", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.text("to coordinates 0, 0", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.RECOVERY_COMPASS).name(Component.text("Reset Center to 0, 0", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createCenterResetItem$lambda$5(world, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createPresetItem(Player player, PlayerWorld world, double size, String name) {
        Material material = switch (name) {
            case "Small" -> Material.LEATHER_CHESTPLATE;
            case "Medium" -> Material.IRON_CHESTPLATE;
            case "Large" -> Material.DIAMOND_CHESTPLATE;
            case "Unlimited" -> Material.NETHERITE_CHESTPLATE;
            default -> Material.CHAINMAIL_CHESTPLATE;
        };
        String sizeDisplay = size >= 5.9999968E7 ? "Unlimited" : String.valueOf((long)size);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Size: " + sizeDisplay + " blocks", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Click to apply this preset", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(name + " Preset", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createPresetItem$lambda$6(world, size, this, player, name, sizeDisplay, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createDamageAmountItem(Player player, PlayerWorld world) {
        WorldBorderSettings settings = world.getWorldBorder();
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + settings.getDamageAmount() + " per block", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Left-click: +0.1", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), Component.text("Right-click: -0.1", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false), Component.text("Shift-click: Reset to 0.2", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.IRON_SWORD).name(Component.text("Damage Amount", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createDamageAmountItem$lambda$7(settings, world, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createDamageBufferItem(Player player, PlayerWorld world) {
        WorldBorderSettings settings = world.getWorldBorder();
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + settings.getDamageBuffer() + " blocks", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Distance past border before", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.text("damage starts", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Left-click: +1", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), Component.text("Right-click: -1", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false), Component.text("Shift-click: Reset to 5", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.SHIELD).name(Component.text("Damage Buffer", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createDamageBufferItem$lambda$8(settings, world, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createWarningDistanceItem(Player player, PlayerWorld world) {
        WorldBorderSettings settings = world.getWorldBorder();
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + settings.getWarningDistance() + " blocks", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Distance from border when", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.text("screen turns red", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Left-click: +1", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), Component.text("Right-click: -1", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false), Component.text("Shift-click: Reset to 5", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BELL).name(Component.text("Warning Distance", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createWarningDistanceItem$lambda$9(settings, world, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createWarningTimeItem(Player player, PlayerWorld world) {
        WorldBorderSettings settings = world.getWorldBorder();
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current: " + settings.getWarningTime() + " seconds", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Time before border shrink", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.text("warning appears", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Left-click: +5", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false), Component.text("Right-click: -5", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false), Component.text("Shift-click: Reset to 15", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.CLOCK).name(Component.text("Warning Time", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> WorldBorderGui.createWarningTimeItem$lambda$10(settings, world, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createInfoItem(PlayerWorld world) {
        WorldBorderSettings settings = world.getWorldBorder();
        TextComponent[] textComponentArray = new TextComponent[]{Component.empty(), Component.text("Size: " + (long)settings.getSize() + " blocks", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false), Component.text("Center: " + (long)settings.getCenterX() + ", " + (long)settings.getCenterZ(), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Damage: " + settings.getDamageAmount() + "/block", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false), Component.text("Buffer: " + (long)settings.getDamageBuffer() + " blocks", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false), Component.empty(), Component.text("Warning Distance: " + settings.getWarningDistance() + " blocks", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false), Component.text("Warning Time: " + settings.getWarningTime() + " seconds", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.ITALIC, false)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BOOK).name(Component.text("Current Settings", (TextColor)NamedTextColor.WHITE).decoration(TextDecoration.ITALIC, false))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(WorldBorderGui::createInfoItem$lambda$11);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createBackItem(Player player, PlayerWorld world) {
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Back to World Settings", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false))).asGuiItem(arg_0 -> WorldBorderGui.createBackItem$lambda$13(player, this, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private static final void applyWorldBorder$lambda$0(WorldBorder $border, World $bukkitWorld, WorldBorderSettings $settings, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($border, "$border");
        Intrinsics.checkNotNullParameter($bukkitWorld, "$bukkitWorld");
        Intrinsics.checkNotNullParameter($settings, "$settings");
        $border.setCenter(new Location($bukkitWorld, $settings.getCenterX(), 0.0, $settings.getCenterZ()));
        $border.setSize($settings.getSize());
        $border.setDamageAmount($settings.getDamageAmount());
        $border.setDamageBuffer($settings.getDamageBuffer());
        $border.setWarningDistance($settings.getWarningDistance());
        $border.setWarningTime($settings.getWarningTime());
    }

    private static final void createSizeDisplayItem$lambda$1(InventoryClickEvent event) {
        event.setCancelled(true);
    }

    private static final void createSizeIncreaseItem$lambda$2(PlayerWorld $world, double $amount, WorldBorderGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        double newSize = RangesKt.coerceIn($world.getWorldBorder().getSize() + $amount, 1.0, 5.9999968E7);
        $world.getWorldBorder().setSize(newSize);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(((TextComponent)Component.text("Border size set to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        this$0.open($player, $world);
    }

    private static final void createSizeDecreaseItem$lambda$3(PlayerWorld $world, double $amount, WorldBorderGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        double newSize = RangesKt.coerceIn($world.getWorldBorder().getSize() - $amount, 1.0, 5.9999968E7);
        $world.getWorldBorder().setSize(newSize);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(((TextComponent)Component.text("Border size set to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        this$0.open($player, $world);
    }

    private static final void createCenterHereItem$lambda$4(Player $player, PlayerWorld $world, WorldBorderGui this$0, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        event.setCancelled(true);
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location loc = location;
        $world.getWorldBorder().setCenterX(loc.getX());
        $world.getWorldBorder().setCenterZ(loc.getZ());
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(Component.text("Border center set to ", (TextColor)NamedTextColor.GREEN).append(Component.text(loc.getBlockX() + ", " + loc.getBlockZ(), (TextColor)NamedTextColor.YELLOW)));
        this$0.open($player, $world);
    }

    private static final void createCenterResetItem$lambda$5(PlayerWorld $world, WorldBorderGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        $world.getWorldBorder().setCenterX(0.0);
        $world.getWorldBorder().setCenterZ(0.0);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(Component.text("Border center reset to ", (TextColor)NamedTextColor.GREEN).append(Component.text("0, 0", (TextColor)NamedTextColor.YELLOW)));
        this$0.open($player, $world);
    }

    private static final void createPresetItem$lambda$6(PlayerWorld $world, double $size, WorldBorderGui this$0, Player $player, String $name, String $sizeDisplay, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($name, "$name");
        Intrinsics.checkNotNullParameter($sizeDisplay, "$sizeDisplay");
        event.setCancelled(true);
        $world.getWorldBorder().setSize($size);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(Component.text("Applied " + $name + " preset: ", (TextColor)NamedTextColor.GREEN).append(Component.text($sizeDisplay + " blocks", (TextColor)NamedTextColor.YELLOW)));
        this$0.open($player, $world);
    }

    private static final void createDamageAmountItem$lambda$7(WorldBorderSettings $settings, PlayerWorld $world, WorldBorderGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($settings, "$settings");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        double newValue = event.isShiftClick() ? 0.2 : (event.isLeftClick() ? RangesKt.coerceIn($settings.getDamageAmount() + 0.1, 0.0, 10.0) : (event.isRightClick() ? RangesKt.coerceIn($settings.getDamageAmount() - 0.1, 0.0, 10.0) : $settings.getDamageAmount()));
        $world.getWorldBorder().setDamageAmount(newValue);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        TextComponent textComponent = Component.text("Damage amount set to ", (TextColor)NamedTextColor.GREEN);
        String string = "%.1f";
        Object[] objectArray = new Object[]{newValue};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        $player.sendMessage(((TextComponent)textComponent.append(Component.text(String.valueOf(string2), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" per block", (TextColor)NamedTextColor.GREEN)));
        this$0.open($player, $world);
    }

    private static final void createDamageBufferItem$lambda$8(WorldBorderSettings $settings, PlayerWorld $world, WorldBorderGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($settings, "$settings");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        double newValue = event.isShiftClick() ? 5.0 : (event.isLeftClick() ? RangesKt.coerceIn($settings.getDamageBuffer() + 1.0, 0.0, 100.0) : (event.isRightClick() ? RangesKt.coerceIn($settings.getDamageBuffer() - 1.0, 0.0, 100.0) : $settings.getDamageBuffer()));
        $world.getWorldBorder().setDamageBuffer(newValue);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(((TextComponent)Component.text("Damage buffer set to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)newValue), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        this$0.open($player, $world);
    }

    private static final void createWarningDistanceItem$lambda$9(WorldBorderSettings $settings, PlayerWorld $world, WorldBorderGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($settings, "$settings");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        int newValue = event.isShiftClick() ? 5 : (event.isLeftClick() ? RangesKt.coerceIn($settings.getWarningDistance() + 1, 0, 100) : (event.isRightClick() ? RangesKt.coerceIn($settings.getWarningDistance() - 1, 0, 100) : $settings.getWarningDistance()));
        $world.getWorldBorder().setWarningDistance(newValue);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(((TextComponent)Component.text("Warning distance set to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf(newValue), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        this$0.open($player, $world);
    }

    private static final void createWarningTimeItem$lambda$10(WorldBorderSettings $settings, PlayerWorld $world, WorldBorderGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($settings, "$settings");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        int newValue = event.isShiftClick() ? 15 : (event.isLeftClick() ? RangesKt.coerceIn($settings.getWarningTime() + 5, 0, 300) : (event.isRightClick() ? RangesKt.coerceIn($settings.getWarningTime() - 5, 0, 300) : $settings.getWarningTime()));
        $world.getWorldBorder().setWarningTime(newValue);
        this$0.dataManager.saveWorld($world);
        this$0.applyWorldBorder($world);
        $player.sendMessage(((TextComponent)Component.text("Warning time set to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf(newValue), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" seconds", (TextColor)NamedTextColor.GREEN)));
        this$0.open($player, $world);
    }

    private static final void createInfoItem$lambda$11(InventoryClickEvent event) {
        event.setCancelled(true);
    }

    private static final void createBackItem$lambda$13$lambda$12(WorldBorderGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        new WorldManageGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager, null, null, 48, null).open($player, $world);
    }

    private static final void createBackItem$lambda$13(Player $player, WorldBorderGui this$0, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> WorldBorderGui.createBackItem$lambda$13$lambda$12(this$0, $player, $world, arg_0), null);
    }
}

