/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.gui.InvitedWorldsGui;
import tech.bedson.playerworldmanager.gui.InvitesGui;
import tech.bedson.playerworldmanager.gui.MainMenuGui;
import tech.bedson.playerworldmanager.gui.WorldManageGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.ChestGuiBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.PaginatedBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.BaseGui;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.gui.guis.PaginatedGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.BackupManager;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.StatsManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldInvite;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u001cH\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020&2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ltech/bedson/playerworldmanager/gui/MainMenuGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "statsManager", "Ltech/bedson/playerworldmanager/managers/StatsManager;", "backupManager", "Ltech/bedson/playerworldmanager/managers/BackupManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/managers/StatsManager;Ltech/bedson/playerworldmanager/managers/BackupManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createInvitedWorldsItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "count", "", "createNewWorldItem", "createPaginatedGui", "Ltech/bedson/playerworldmanager/libs/gui/guis/PaginatedGui;", "ownedWorlds", "", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "pendingInviteCount", "invitedWorldsCount", "createPendingInvitesItem", "createReturnToSpawnItem", "createSimpleGui", "Ltech/bedson/playerworldmanager/libs/gui/guis/Gui;", "createWorldItem", "world", "open", "", "setBackupManager", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nMainMenuGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainMenuGui.kt\ntech/bedson/playerworldmanager/gui/MainMenuGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n766#2:356\n857#2,2:357\n1864#2,3:359\n1855#2,2:362\n*S KotlinDebug\n*F\n+ 1 MainMenuGui.kt\ntech/bedson/playerworldmanager/gui/MainMenuGui\n*L\n45#1:356\n45#1:357,2\n91#1:359,3\n138#1:362,2\n*E\n"})
public final class MainMenuGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @Nullable
    private final StatsManager statsManager;
    @Nullable
    private BackupManager backupManager;
    @NotNull
    private final DebugLogger debugLogger;

    public MainMenuGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager, @Nullable StatsManager statsManager, @Nullable BackupManager backupManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.statsManager = statsManager;
        this.backupManager = backupManager;
        this.debugLogger = new DebugLogger(this.plugin, "MainMenuGui");
    }

    public /* synthetic */ MainMenuGui(JavaPlugin javaPlugin, WorldManager worldManager, InviteManager inviteManager, DataManager dataManager, StatsManager statsManager, BackupManager backupManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            statsManager = null;
        }
        if ((n & 0x20) != 0) {
            backupManager = null;
        }
        this(javaPlugin, worldManager, inviteManager, dataManager, statsManager, backupManager);
    }

    public final void setBackupManager(@NotNull BackupManager backupManager) {
        Intrinsics.checkNotNullParameter(backupManager, "backupManager");
        this.backupManager = backupManager;
    }

    /*
     * WARNING - void declaration
     */
    public final void open(@NotNull Player player) {
        BaseGui baseGui;
        Pair[] pairArray;
        void $this$filterTo$iv$iv;
        Pair[] $this$filter$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("open", pairArray2);
        this.plugin.getLogger().info("[GUI] MainMenuGui: Opening for player " + player.getName());
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<PlayerWorld> ownedWorlds = this.dataManager.getWorldsByOwner(uUID);
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        List<WorldInvite> pendingInvites = this.inviteManager.getPendingInvites(uUID2);
        Iterable iterable = this.dataManager.getAllWorlds();
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerWorld it = (PlayerWorld)element$iv$iv;
            boolean bl = false;
            UUID uUID3 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
            if (!this.inviteManager.isInvited(uUID3, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invitedWorlds = (List)destination$iv$iv;
        this.plugin.getLogger().info("[GUI] MainMenuGui: Player " + player.getName() + " has " + ownedWorlds.size() + " owned worlds, " + pendingInvites.size() + " pending invites, " + invitedWorlds.size() + " invited worlds");
        $this$filter$iv = new Pair[]{TuplesKt.to("ownedWorldCount", ownedWorlds.size()), TuplesKt.to("pendingInviteCount", pendingInvites.size()), TuplesKt.to("invitedWorldCount", invitedWorlds.size()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debug("Loaded player data", $this$filter$iv);
        if (ownedWorlds.size() > 18) {
            this.plugin.getLogger().info("[GUI] MainMenuGui: Using paginated GUI for player " + player.getName());
            pairArray = new Pair[]{TuplesKt.to("worldCount", ownedWorlds.size())};
            this.debugLogger.debug("Creating paginated GUI (worlds > 18)", pairArray);
            baseGui = this.createPaginatedGui(player, ownedWorlds, pendingInvites.size(), invitedWorlds.size());
        } else {
            this.plugin.getLogger().info("[GUI] MainMenuGui: Using simple GUI for player " + player.getName());
            pairArray = new Pair[]{TuplesKt.to("worldCount", ownedWorlds.size())};
            this.debugLogger.debug("Creating simple GUI (worlds <= 18)", pairArray);
            baseGui = this.createSimpleGui(player, ownedWorlds, pendingInvites.size(), invitedWorlds.size());
        }
        BaseGui gui = baseGui;
        pairArray = new Pair[]{TuplesKt.to("guiType", gui.getClass().getSimpleName())};
        this.debugLogger.debug("Opening GUI for player", pairArray);
        gui.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Gui createSimpleGui(Player player, List<PlayerWorld> ownedWorlds, int pendingInviteCount, int invitedWorldsCount) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("ownedWorldCount", ownedWorlds.size()), TuplesKt.to("pendingInviteCount", pendingInviteCount), TuplesKt.to("invitedWorldsCount", invitedWorldsCount)};
        this.debugLogger.debugMethodEntry("createSimpleGui", pairArray);
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(Component.text("World Manager", (TextColor)NamedTextColor.GOLD))).rows(3)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(gui, "create(...)");
        Gui gui2 = gui;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", Math.min(ownedWorlds.size(), 18))};
        this.debugLogger.debug("Adding owned worlds to GUI", pairArray2);
        Iterable $this$forEachIndexed$iv = ownedWorlds;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void world;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PlayerWorld playerWorld = (PlayerWorld)item$iv;
            int index = n;
            boolean bl = false;
            if (index >= 18) continue;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("slot", index), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
            this.debugLogger.debug("Adding world item", pairArray3);
            gui2.setItem(index, this.createWorldItem(player, (PlayerWorld)world));
        }
        boolean canCreate = this.worldManager.canCreateWorld(player);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("canCreate", canCreate)};
        this.debugLogger.debug("Checking create world permission", pairArray4);
        if (canCreate) {
            gui2.setItem(20, this.createNewWorldItem(player));
        }
        gui2.setItem(22, this.createInvitedWorldsItem(player, invitedWorldsCount));
        gui2.setItem(24, this.createPendingInvitesItem(player, pendingInviteCount));
        gui2.setItem(13, this.createReturnToSpawnItem(player));
        this.debugLogger.debugMethodExit("createSimpleGui", "gui created with 3 rows");
        return gui2;
    }

    private final PaginatedGui createPaginatedGui(Player player, List<PlayerWorld> ownedWorlds, int pendingInviteCount, int invitedWorldsCount) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("ownedWorldCount", ownedWorlds.size()), TuplesKt.to("pendingInviteCount", pendingInviteCount), TuplesKt.to("invitedWorldsCount", invitedWorldsCount)};
        this.debugLogger.debugMethodEntry("createPaginatedGui", pairArray);
        PaginatedGui paginatedGui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(Component.text("World Manager", (TextColor)NamedTextColor.GOLD))).rows(6)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(paginatedGui, "create(...)");
        PaginatedGui gui = paginatedGui;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", ownedWorlds.size())};
        this.debugLogger.debug("Adding all owned worlds to paginated GUI", pairArray2);
        Iterable $this$forEach$iv = ownedWorlds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
            this.debugLogger.debug("Adding world item to paginated GUI", pairArray3);
            gui.addItem(this.createWorldItem(player, world));
        }
        this.debugLogger.debug("Adding navigation buttons to paginated GUI");
        gui.setItem(6, 3, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Previous Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> MainMenuGui.createPaginatedGui$lambda$3(this, player, gui, arg_0)));
        gui.setItem(6, 7, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Next Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> MainMenuGui.createPaginatedGui$lambda$4(this, player, gui, arg_0)));
        boolean canCreatePaginated = this.worldManager.canCreateWorld(player);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("canCreate", canCreatePaginated)};
        this.debugLogger.debug("Checking create world permission for paginated GUI", pairArray4);
        if (canCreatePaginated) {
            gui.setItem(6, 1, this.createNewWorldItem(player));
        }
        gui.setItem(6, 4, this.createInvitedWorldsItem(player, invitedWorldsCount));
        gui.setItem(6, 6, this.createPendingInvitesItem(player, pendingInviteCount));
        gui.setItem(6, 5, this.createReturnToSpawnItem(player));
        this.debugLogger.debugMethodExit("createPaginatedGui", "gui created with 6 rows");
        return gui;
    }

    private final GuiItem createWorldItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debugMethodEntry("createWorldItem", pairArray);
        World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
        Object object = bukkitWorld;
        int playersOnline = object != null && (object = object.getPlayers()) != null ? object.size() : 0;
        int invitedCount = world.getInvitedPlayers().size();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldType", world.getWorldType()), TuplesKt.to("playersOnline", playersOnline), TuplesKt.to("invitedCount", invitedCount), TuplesKt.to("worldLoaded", bukkitWorld != null)};
        this.debugLogger.debugState("WorldItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("World Type: " + world.getWorldType(), (TextColor)NamedTextColor.GRAY), Component.text("Players Online: " + playersOnline, (TextColor)NamedTextColor.GRAY), Component.text("Invited Players: " + invitedCount, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to manage", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.GRASS_BLOCK).name(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> MainMenuGui.createWorldItem$lambda$6(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        this.debugLogger.debugMethodExit("createWorldItem", "GuiItem for " + world.getName());
        return item2;
    }

    private final GuiItem createNewWorldItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createNewWorldItem", pairArray);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        PlayerData playerData = this.dataManager.loadPlayerData(uUID);
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        int currentCount = this.worldManager.getWorldCount(uUID2);
        PlayerData playerData2 = playerData;
        int limit = playerData2 != null ? playerData2.getWorldLimit() : 3;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("currentCount", currentCount), TuplesKt.to("limit", limit), TuplesKt.to("hasPlayerData", playerData != null)};
        this.debugLogger.debugState("NewWorldItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Worlds: " + currentCount + "/" + limit, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to create", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.EMERALD_BLOCK).name(Component.text("Create New World", (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> MainMenuGui.createNewWorldItem$lambda$7(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createNewWorldItem", null, 2, null);
        return item2;
    }

    private final GuiItem createInvitedWorldsItem(Player player, int count) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("count", count)};
        this.debugLogger.debugMethodEntry("createInvitedWorldsItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("You have access to " + count + " world(s)", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to view", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.ENDER_PEARL).name(Component.text("Invited Worlds", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> MainMenuGui.createInvitedWorldsItem$lambda$9(this, player, count, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createInvitedWorldsItem", null, 2, null);
        return item2;
    }

    private final GuiItem createPendingInvitesItem(Player player, int count) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("count", count)};
        this.debugLogger.debugMethodEntry("createPendingInvitesItem", pairArray);
        Material material = count > 0 ? Material.PAPER : Material.PAPER;
        NamedTextColor color = count > 0 ? NamedTextColor.GREEN : NamedTextColor.GRAY;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", count), TuplesKt.to("hasInvites", count > 0)};
        this.debugLogger.debugState("PendingInvitesItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("You have " + count + " pending invite(s)", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to view", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text("Pending Invites", (TextColor)color))).lore(CollectionsKt.listOf(textComponentArray))).amount(Math.max(1, count))).asGuiItem(arg_0 -> MainMenuGui.createPendingInvitesItem$lambda$11(this, player, count, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createPendingInvitesItem", null, 2, null);
        return item2;
    }

    private final GuiItem createReturnToSpawnItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createReturnToSpawnItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Teleport to the default world spawn", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to teleport", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.COMPASS).name(Component.text("Return to Spawn", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> MainMenuGui.createReturnToSpawnItem$lambda$13(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createReturnToSpawnItem", null, 2, null);
        return item2;
    }

    private static final void createPaginatedGui$lambda$3(MainMenuGui this$0, Player $player, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " navigated to previous page");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentPage", $gui.getCurrentPageNum())};
        this$0.debugLogger.debug("Previous page clicked", pairArray);
        $gui.previous();
    }

    private static final void createPaginatedGui$lambda$4(MainMenuGui this$0, Player $player, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " navigated to next page");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentPage", $gui.getCurrentPageNum())};
        this$0.debugLogger.debug("Next page clicked", pairArray);
        $gui.next();
    }

    private static final void createWorldItem$lambda$6$lambda$5(MainMenuGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Opening WorldManageGui", pairArray);
        new WorldManageGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager, this$0.statsManager, this$0.backupManager).open($player, $world);
    }

    private static final void createWorldItem$lambda$6(MainMenuGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " clicked on world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName()), TuplesKt.to("worldId", $world.getId())};
        this$0.debugLogger.debug("World item clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> MainMenuGui.createWorldItem$lambda$6$lambda$5(this$0, $player, $world, arg_0), null);
    }

    private static final void createNewWorldItem$lambda$7(MainMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " clicked Create New World button");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Create New World button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/world create <name>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to create a world", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createInvitedWorldsItem$lambda$9$lambda$8(MainMenuGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening InvitedWorldsGui", pairArray);
        new InvitedWorldsGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager).open($player);
    }

    private static final void createInvitedWorldsItem$lambda$9(MainMenuGui this$0, Player $player, int $count, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " clicked Invited Worlds button (count: " + $count + ")");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("invitedCount", $count)};
        this$0.debugLogger.debug("Invited Worlds button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> MainMenuGui.createInvitedWorldsItem$lambda$9$lambda$8(this$0, $player, arg_0), null);
    }

    private static final void createPendingInvitesItem$lambda$11$lambda$10(MainMenuGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening InvitesGui", pairArray);
        new InvitesGui(this$0.plugin, this$0.inviteManager).open($player);
    }

    private static final void createPendingInvitesItem$lambda$11(MainMenuGui this$0, Player $player, int $count, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " clicked Pending Invites button (count: " + $count + ")");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("pendingCount", $count)};
        this$0.debugLogger.debug("Pending Invites button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> MainMenuGui.createPendingInvitesItem$lambda$11$lambda$10(this$0, $player, arg_0), null);
    }

    private static final void createReturnToSpawnItem$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createReturnToSpawnItem$lambda$13(MainMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " clicked Return to Spawn button");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentWorld", $player.getWorld().getName())};
        this$0.debugLogger.debug("Return to Spawn button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage((Component)Component.text("Teleporting to spawn...", (TextColor)NamedTextColor.YELLOW));
        pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Initiating teleport to vanilla world", pairArray);
        this$0.worldManager.teleportToVanillaWorld($player).thenAccept(arg_0 -> MainMenuGui.createReturnToSpawnItem$lambda$13$lambda$12(new Function1<Boolean, Unit>($player, this$0){
            final /* synthetic */ Player $player;
            final /* synthetic */ MainMenuGui this$0;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Boolean success) {
                this.$player.getScheduler().run((Plugin)MainMenuGui.access$getPlugin$p(this.this$0), arg_0 -> createReturnToSpawnItem.item.1.1.invoke$lambda$0(success, this.this$0, this.$player, arg_0), null);
            }

            private static final void invoke$lambda$0(Boolean $success, MainMenuGui this$0, Player $player, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($player, "$player");
                Intrinsics.checkNotNull($success);
                if ($success.booleanValue()) {
                    MainMenuGui.access$getPlugin$p(this$0).getLogger().info("[GUI] MainMenuGui: Player " + $player.getName() + " teleported successfully to spawn");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
                    MainMenuGui.access$getDebugLogger$p(this$0).debug("Teleport to spawn successful", pairArray);
                    $player.sendMessage((Component)Component.text("Teleported to spawn", (TextColor)NamedTextColor.GREEN));
                } else {
                    MainMenuGui.access$getPlugin$p(this$0).getLogger().warning("[GUI] MainMenuGui: Failed to teleport " + $player.getName() + " to spawn");
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
                    MainMenuGui.access$getDebugLogger$p(this$0).debug("Teleport to spawn failed", pairArray);
                    $player.sendMessage((Component)Component.text("Failed to teleport to spawn", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(MainMenuGui $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(MainMenuGui $this) {
        return $this.debugLogger;
    }
}

