/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.PaginatedBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.gui.guis.PaginatedGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.models.WorldInvite;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/bedson/playerworldmanager/gui/InvitesGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/InviteManager;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createInviteItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "invite", "Ltech/bedson/playerworldmanager/models/WorldInvite;", "open", "", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nInvitesGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvitesGui.kt\ntech/bedson/playerworldmanager/gui/InvitesGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1855#2,2:192\n*S KotlinDebug\n*F\n+ 1 InvitesGui.kt\ntech/bedson/playerworldmanager/gui/InvitesGui\n*L\n45#1:192,2\n*E\n"})
public final class InvitesGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final SimpleDateFormat dateFormat;

    public InvitesGui(@NotNull JavaPlugin plugin, @NotNull InviteManager inviteManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        this.plugin = plugin;
        this.inviteManager = inviteManager;
        this.debugLogger = new DebugLogger(this.plugin, "InvitesGui");
        this.dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm");
    }

    public final void open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        this.plugin.getLogger().info("[GUI] InvitesGui: Opening for player " + player.getName());
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<WorldInvite> pendingInvites = this.inviteManager.getPendingInvites(uUID);
        this.plugin.getLogger().info("[GUI] InvitesGui: Player " + player.getName() + " has " + pendingInvites.size() + " pending invites");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", pendingInvites.size()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debug("Loaded pending invites", pairArray2);
        PaginatedGui paginatedGui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(Component.text("Pending Invites", (TextColor)NamedTextColor.GOLD))).rows(6)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(paginatedGui, "create(...)");
        PaginatedGui gui = paginatedGui;
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("count", pendingInvites.size())};
        this.debugLogger.debug("Adding pending invites to GUI", pairArray3);
        Iterable $this$forEach$iv = pendingInvites;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorldInvite invite = (WorldInvite)element$iv;
            boolean bl = false;
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("ownerName", invite.getOwnerName())};
            this.debugLogger.debug("Adding invite item", pairArray4);
            gui.addItem(this.createInviteItem(player, invite));
        }
        this.debugLogger.debug("Adding navigation buttons");
        gui.setItem(6, 3, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Previous Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> InvitesGui.open$lambda$1(this, player, gui, arg_0)));
        gui.setItem(6, 7, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Next Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> InvitesGui.open$lambda$2(this, player, gui, arg_0)));
        gui.setItem(6, 5, ((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Component.text("Back to Main Menu", (TextColor)NamedTextColor.RED))).asGuiItem(arg_0 -> InvitesGui.open$lambda$3(this, player, arg_0)));
        if (pendingInvites.isEmpty()) {
            this.debugLogger.debug("No pending invites found, showing empty state");
            gui.setItem(22, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Component.text("No Pending Invites", (TextColor)NamedTextColor.RED))).lore(CollectionsKt.listOf(Component.text("You don't have any pending invites", (TextColor)NamedTextColor.GRAY)))).asGuiItem());
        }
        pairArray3 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Opening GUI for player", pairArray3);
        gui.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    private final GuiItem createInviteItem(Player player, WorldInvite invite) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("ownerName", invite.getOwnerName())};
        this.debugLogger.debugMethodEntry("createInviteItem", pairArray);
        String sentDate = this.dateFormat.format(new Date(invite.getSentAt()));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", invite.getWorldName()), TuplesKt.to("ownerName", invite.getOwnerName()), TuplesKt.to("sentDate", sentDate), TuplesKt.to("worldId", invite.getWorldId())};
        this.debugLogger.debugState("InviteItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("From: " + invite.getOwnerName(), (TextColor)NamedTextColor.GRAY), Component.text("Sent: " + sentDate, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Left Click: ", (TextColor)NamedTextColor.GREEN).append(Component.text("Accept", (TextColor)NamedTextColor.WHITE)), Component.text("Right Click: ", (TextColor)NamedTextColor.RED).append(Component.text("Deny", (TextColor)NamedTextColor.WHITE))};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.PAPER).name(Component.text(invite.getWorldName(), (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> InvitesGui.createInviteItem$lambda$10(this, player, invite, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        this.debugLogger.debugMethodExit("createInviteItem", "item created");
        return item2;
    }

    private static final void open$lambda$1(InvitesGui this$0, Player $player, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] InvitesGui: Player " + $player.getName() + " navigated to previous page");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentPage", $gui.getCurrentPageNum())};
        this$0.debugLogger.debug("Previous page clicked", pairArray);
        $gui.previous();
    }

    private static final void open$lambda$2(InvitesGui this$0, Player $player, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] InvitesGui: Player " + $player.getName() + " navigated to next page");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentPage", $gui.getCurrentPageNum())};
        this$0.debugLogger.debug("Next page clicked", pairArray);
        $gui.next();
    }

    private static final void open$lambda$3(InvitesGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Back button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/world menu", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to return to the main menu", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createInviteItem$lambda$10$lambda$6(InvitesGui this$0, Player $player, WorldInvite $invite, ScheduledTask scheduledTask) {
        block1: {
            Throwable throwable;
            Object result;
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($player, "$player");
            Intrinsics.checkNotNullParameter($invite, "$invite");
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName())};
            this$0.debugLogger.debug("Processing accept invite", pairArray);
            Object object = result = this$0.inviteManager.acceptInvite-gIAlu-s($invite, $player);
            if (Result.isSuccess-impl(object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                this$0.plugin.getLogger().info("[GUI] InvitesGui: Player " + $player.getName() + " successfully accepted invite to world " + $invite.getWorldName());
                Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName())};
                this$0.debugLogger.debug("Accept invite successful", pairArray2);
                $player.sendMessage(Component.text("Accepted invite to ", (TextColor)NamedTextColor.GREEN).append(Component.text($invite.getWorldName(), (TextColor)NamedTextColor.GOLD)));
            }
            Throwable throwable2 = Result.exceptionOrNull-impl(object);
            if (throwable2 == null) break block1;
            Throwable error = throwable = throwable2;
            boolean bl = false;
            this$0.plugin.getLogger().warning("[GUI] InvitesGui: Player " + $player.getName() + " failed to accept invite to world " + $invite.getWorldName() + ": " + error.getMessage());
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName()), TuplesKt.to("error", error.getMessage())};
            this$0.debugLogger.debug("Accept invite failed", pairArray3);
            $player.sendMessage((Component)Component.text("Failed to accept invite: " + error.getMessage(), (TextColor)NamedTextColor.RED));
        }
    }

    private static final void createInviteItem$lambda$10$lambda$9(InvitesGui this$0, Player $player, WorldInvite $invite, ScheduledTask scheduledTask) {
        block1: {
            Throwable throwable;
            Object result;
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($player, "$player");
            Intrinsics.checkNotNullParameter($invite, "$invite");
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName())};
            this$0.debugLogger.debug("Processing deny invite", pairArray);
            Object object = result = this$0.inviteManager.denyInvite-gIAlu-s($invite, $player);
            if (Result.isSuccess-impl(object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                this$0.plugin.getLogger().info("[GUI] InvitesGui: Player " + $player.getName() + " successfully denied invite to world " + $invite.getWorldName());
                Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName())};
                this$0.debugLogger.debug("Deny invite successful", pairArray2);
                $player.sendMessage(Component.text("Declined invite to ", (TextColor)NamedTextColor.YELLOW).append(Component.text($invite.getWorldName(), (TextColor)NamedTextColor.GOLD)));
            }
            Throwable throwable2 = Result.exceptionOrNull-impl(object);
            if (throwable2 == null) break block1;
            Throwable error = throwable = throwable2;
            boolean bl = false;
            this$0.plugin.getLogger().warning("[GUI] InvitesGui: Player " + $player.getName() + " failed to deny invite to world " + $invite.getWorldName() + ": " + error.getMessage());
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName()), TuplesKt.to("error", error.getMessage())};
            this$0.debugLogger.debug("Deny invite failed", pairArray3);
            $player.sendMessage((Component)Component.text("Failed to decline invite: " + error.getMessage(), (TextColor)NamedTextColor.RED));
        }
    }

    private static final void createInviteItem$lambda$10(InvitesGui this$0, Player $player, WorldInvite $invite, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($invite, "$invite");
        event.setCancelled(true);
        switch (WhenMappings.$EnumSwitchMapping$0[event.getClick().ordinal()]) {
            case 1: {
                this$0.plugin.getLogger().info("[GUI] InvitesGui: Player " + $player.getName() + " accepting invite to world " + $invite.getWorldName());
                Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName())};
                this$0.debugLogger.debug("Accept invite clicked", pairArray);
                $player.closeInventory();
                $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> InvitesGui.createInviteItem$lambda$10$lambda$6(this$0, $player, $invite, arg_0), null);
                break;
            }
            case 2: {
                this$0.plugin.getLogger().info("[GUI] InvitesGui: Player " + $player.getName() + " denying invite to world " + $invite.getWorldName());
                Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $invite.getWorldName())};
                this$0.debugLogger.debug("Deny invite clicked", pairArray);
                $player.closeInventory();
                $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> InvitesGui.createInviteItem$lambda$10$lambda$9(this$0, $player, $invite, arg_0), null);
                break;
            }
            default: {
                Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("clickType", event.getClick())};
                this$0.debugLogger.debug("Other click type ignored", pairArray);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickType.values().length];
            try {
                nArray[ClickType.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

