/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.MainMenuGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.PaginatedBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.gui.guis.PaginatedGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltech/bedson/playerworldmanager/gui/InvitedWorldsGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createWorldItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "open", "", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nInvitedWorldsGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvitedWorldsGui.kt\ntech/bedson/playerworldmanager/gui/InvitedWorldsGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n766#2:152\n857#2,2:153\n1855#2,2:155\n*S KotlinDebug\n*F\n+ 1 InvitedWorldsGui.kt\ntech/bedson/playerworldmanager/gui/InvitedWorldsGui\n*L\n33#1:152\n33#1:153,2\n46#1:155,2\n*E\n"})
public final class InvitedWorldsGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;

    public InvitedWorldsGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "InvitedWorldsGui");
    }

    /*
     * WARNING - void declaration
     */
    public final void open(@NotNull Player player) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        this.plugin.getLogger().info("[GUI] InvitedWorldsGui: Opening for player " + player.getName());
        Pair[] $this$filter$iv = (Pair[])this.dataManager.getAllWorlds();
        boolean $i$f$filter22 = false;
        Pair[] pairArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerWorld it = (PlayerWorld)element$iv$iv;
            boolean bl = false;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (!this.inviteManager.isInvited(uUID, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invitedWorlds = (List)destination$iv$iv;
        this.plugin.getLogger().info("[GUI] InvitedWorldsGui: Player " + player.getName() + " has " + invitedWorlds.size() + " invited worlds");
        $this$filter$iv = new Pair[]{TuplesKt.to("count", invitedWorlds.size()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debug("Loaded invited worlds", $this$filter$iv);
        PaginatedGui paginatedGui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(Component.text("Invited Worlds", (TextColor)NamedTextColor.GOLD))).rows(6)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(paginatedGui, "create(...)");
        PaginatedGui gui = paginatedGui;
        Pair[] $i$f$filter22 = new Pair[]{TuplesKt.to("count", invitedWorlds.size())};
        this.debugLogger.debug("Adding invited worlds to GUI", $i$f$filter22);
        Iterable $this$forEach$iv = invitedWorlds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName())};
            this.debugLogger.debug("Adding world item", pairArray3);
            gui.addItem(this.createWorldItem(player, world));
        }
        this.debugLogger.debug("Adding navigation buttons");
        gui.setItem(6, 3, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Previous Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> InvitedWorldsGui.open$lambda$2(this, player, gui, arg_0)));
        gui.setItem(6, 7, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Next Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> InvitedWorldsGui.open$lambda$3(this, player, gui, arg_0)));
        gui.setItem(6, 5, ((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Component.text("Back to Main Menu", (TextColor)NamedTextColor.RED))).asGuiItem(arg_0 -> InvitedWorldsGui.open$lambda$5(this, player, arg_0)));
        if (invitedWorlds.isEmpty()) {
            this.debugLogger.debug("No invited worlds found, showing empty state");
            gui.setItem(22, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Component.text("No Invited Worlds", (TextColor)NamedTextColor.RED))).lore(CollectionsKt.listOf(Component.text("You haven't been invited to any worlds yet", (TextColor)NamedTextColor.GRAY)))).asGuiItem());
        }
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Opening GUI for player", pairArray4);
        gui.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    private final GuiItem createWorldItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createWorldItem", pairArray);
        World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
        Object object = bukkitWorld;
        int playersOnline = object != null && (object = object.getPlayers()) != null ? object.size() : 0;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("worldType", world.getWorldType()), TuplesKt.to("playersOnline", playersOnline), TuplesKt.to("worldLoaded", bukkitWorld != null)};
        this.debugLogger.debugState("WorldItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Owner: " + world.getOwnerName(), (TextColor)NamedTextColor.GRAY), Component.text("World Type: " + world.getWorldType(), (TextColor)NamedTextColor.GRAY), Component.text("Players Online: " + playersOnline, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to visit", (TextColor)NamedTextColor.GREEN)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.GRASS_BLOCK).name(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> InvitedWorldsGui.createWorldItem$lambda$8(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        this.debugLogger.debugMethodExit("createWorldItem", "item created");
        return item2;
    }

    private static final void open$lambda$2(InvitedWorldsGui this$0, Player $player, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] InvitedWorldsGui: Player " + $player.getName() + " navigated to previous page");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentPage", $gui.getCurrentPageNum())};
        this$0.debugLogger.debug("Previous page clicked", pairArray);
        $gui.previous();
    }

    private static final void open$lambda$3(InvitedWorldsGui this$0, Player $player, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] InvitedWorldsGui: Player " + $player.getName() + " navigated to next page");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("currentPage", $gui.getCurrentPageNum())};
        this$0.debugLogger.debug("Next page clicked", pairArray);
        $gui.next();
    }

    private static final void open$lambda$5$lambda$4(InvitedWorldsGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening MainMenuGui", pairArray);
        new MainMenuGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager, null, null, 48, null).open($player);
    }

    private static final void open$lambda$5(InvitedWorldsGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] InvitedWorldsGui: Player " + $player.getName() + " clicked Back to Main Menu");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Back button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> InvitedWorldsGui.open$lambda$5$lambda$4(this$0, $player, arg_0), null);
    }

    private static final void createWorldItem$lambda$8$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createWorldItem$lambda$8$lambda$7(InvitedWorldsGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        this$0.worldManager.teleportToWorld($player, $world).thenAccept(arg_0 -> InvitedWorldsGui.createWorldItem$lambda$8$lambda$7$lambda$6(new Function1<Boolean, Unit>(this$0, $player, $world){
            final /* synthetic */ InvitedWorldsGui this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ PlayerWorld $world;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$world = $world;
                super(1);
            }

            public final void invoke(Boolean success) {
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    InvitedWorldsGui.access$getPlugin$p(this.this$0).getLogger().info("[GUI] InvitedWorldsGui: Player " + this.$player.getName() + " successfully teleported to world " + this.$world.getName());
                    this.$player.sendMessage(Component.text("Teleported to ", (TextColor)NamedTextColor.GREEN).append(Component.text(this.$world.getName(), (TextColor)NamedTextColor.GOLD)));
                } else {
                    InvitedWorldsGui.access$getPlugin$p(this.this$0).getLogger().warning("[GUI] InvitedWorldsGui: Player " + this.$player.getName() + " failed to teleport to world " + this.$world.getName());
                    this.$player.sendMessage((Component)Component.text("Failed to teleport to world", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
    }

    private static final void createWorldItem$lambda$8(InvitedWorldsGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] InvitedWorldsGui: Player " + $player.getName() + " clicked to teleport to world " + $world.getName());
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> InvitedWorldsGui.createWorldItem$lambda$8$lambda$7(this$0, $player, $world, arg_0), null);
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(InvitedWorldsGui $this) {
        return $this.plugin;
    }
}

