/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.PlayerWorldManager;
import tech.bedson.playerworldmanager.gui.BackupGui;
import tech.bedson.playerworldmanager.gui.WorldManageGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.ChestGuiBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.PaginatedBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.gui.guis.PaginatedGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.BackupManager;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.StatsManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.BackupSchedule;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldBackup;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 H\u0002J&\u0010!\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ltech/bedson/playerworldmanager/gui/BackupGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "backupManager", "Ltech/bedson/playerworldmanager/managers/BackupManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/BackupManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createBackItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "createBackupItem", "backup", "Ltech/bedson/playerworldmanager/models/WorldBackup;", "createNewBackupItem", "createNextPageItem", "gui", "Ltech/bedson/playerworldmanager/libs/gui/guis/PaginatedGui;", "createPreviousPageItem", "createScheduleItem", "open", "", "openPaginatedGui", "backups", "", "openSimpleGui", "Companion", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nBackupGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupGui.kt\ntech/bedson/playerworldmanager/gui/BackupGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n1864#2,3:387\n1855#2,2:390\n1855#2,2:392\n*S KotlinDebug\n*F\n+ 1 BackupGui.kt\ntech/bedson/playerworldmanager/gui/BackupGui\n*L\n81#1:387,3\n115#1:390,2\n122#1:392,2\n*E\n"})
public final class BackupGui {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final BackupManager backupManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private static final ConcurrentHashMap<UUID, Companion.PendingRestore> pendingRestores = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, Companion.PendingDelete> pendingDeletes = new ConcurrentHashMap();

    public BackupGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull BackupManager backupManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(backupManager, "backupManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.backupManager = backupManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "BackupGui");
    }

    public final void open(@NotNull Player player, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        List<WorldBackup> backups = this.backupManager.getBackupsForWorld(world.getId());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("count", backups.size())};
        this.debugLogger.debug("Retrieved backups", pairArray2);
        if (backups.size() > 18) {
            this.openPaginatedGui(player, world, backups);
        } else {
            this.openSimpleGui(player, world, backups);
        }
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void openSimpleGui(Player player, PlayerWorld world, List<WorldBackup> backups) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("backupCount", backups.size())};
        this.debugLogger.debug("Opening simple GUI", pairArray);
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(Component.text("Backups: " + world.getName(), (TextColor)NamedTextColor.GOLD))).rows(4)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(gui, "create(...)");
        Gui gui2 = gui;
        gui2.setItem(0, this.createNewBackupItem(player, world));
        gui2.setItem(1, this.createScheduleItem(player, world));
        gui2.setItem(8, this.createBackItem(player, world));
        Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)backups, 18);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void backup;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorldBackup worldBackup = (WorldBackup)item$iv;
            int index = n;
            boolean bl = false;
            gui2.setItem(9 + index, this.createBackupItem(player, world, (WorldBackup)backup));
        }
        for (int i = 0; i < 36; ++i) {
            if (gui2.getGuiItem(i) != null) continue;
            gui2.setItem(i, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        gui2.open((HumanEntity)player);
    }

    private final void openPaginatedGui(Player player, PlayerWorld world, List<WorldBackup> backups) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("backupCount", backups.size())};
        this.debugLogger.debug("Opening paginated GUI", pairArray);
        PaginatedGui paginatedGui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(Component.text("Backups: " + world.getName(), (TextColor)NamedTextColor.GOLD))).rows(5)).pageSize(27).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(paginatedGui, "create(...)");
        PaginatedGui gui = paginatedGui;
        gui.setItem(36, this.createBackItem(player, world));
        gui.setItem(39, this.createPreviousPageItem(gui));
        gui.setItem(40, this.createNewBackupItem(player, world));
        gui.setItem(41, this.createScheduleItem(player, world));
        gui.setItem(42, this.createNextPageItem(gui));
        Integer[] integerArray = new Integer[]{37, 38, 43, 44};
        Iterable $this$forEach$iv = CollectionsKt.listOf(integerArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int slot = ((Number)element$iv).intValue();
            boolean bl = false;
            gui.setItem(slot, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        $this$forEach$iv = backups;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorldBackup backup = (WorldBackup)element$iv;
            boolean bl = false;
            gui.addItem(this.createBackupItem(player, world, backup));
        }
        gui.open((HumanEntity)player);
    }

    private final GuiItem createBackupItem(Player player, PlayerWorld world, WorldBackup backup) {
        List<TextComponent> list;
        Pair[] pairArray = new Pair[]{TuplesKt.to("backupId", backup.getId())};
        this.debugLogger.debug("Creating backup item", pairArray);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String date = dateFormat.format(new Date(backup.getCreatedAt()));
        long currentTime = System.currentTimeMillis();
        Companion.PendingRestore pendingRestore = pendingRestores.get(player.getUniqueId());
        boolean hasPendingRestore = pendingRestore != null && Intrinsics.areEqual(pendingRestore.getBackupId(), backup.getId()) && currentTime - pendingRestore.getTimestamp() <= 5000L;
        Companion.PendingDelete pendingDelete = pendingDeletes.get(player.getUniqueId());
        boolean hasPendingDelete = pendingDelete != null && Intrinsics.areEqual(pendingDelete.getBackupId(), backup.getId()) && currentTime - pendingDelete.getTimestamp() <= 5000L;
        Material material = hasPendingRestore ? Material.LIME_STAINED_GLASS : (hasPendingDelete ? Material.RED_STAINED_GLASS : (backup.isAutomatic() ? Material.CLOCK : Material.CHEST));
        List<TextComponent> $this$createBackupItem_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        TextComponent textComponent = Component.text("Created: " + date, (TextColor)NamedTextColor.GRAY);
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        $this$createBackupItem_u24lambda_u243.add(textComponent);
        TextComponent textComponent2 = Component.text("Size: " + backup.getHumanReadableSize(), (TextColor)NamedTextColor.GRAY);
        Intrinsics.checkNotNullExpressionValue(textComponent2, "text(...)");
        $this$createBackupItem_u24lambda_u243.add(textComponent2);
        if (backup.isAutomatic()) {
            TextComponent textComponent3 = Component.text("Type: Automatic", (TextColor)NamedTextColor.YELLOW);
            Intrinsics.checkNotNullExpressionValue(textComponent3, "text(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent3);
        } else {
            TextComponent textComponent4 = Component.text("Type: Manual", (TextColor)NamedTextColor.GREEN);
            Intrinsics.checkNotNullExpressionValue(textComponent4, "text(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent4);
        }
        if (backup.getDescription() != null) {
            TextComponent textComponent5 = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent5, "empty(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent5);
            TextComponent textComponent6 = Component.text(backup.getDescription(), (TextColor)NamedTextColor.GRAY);
            Intrinsics.checkNotNullExpressionValue(textComponent6, "text(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent6);
        }
        TextComponent textComponent7 = Component.empty();
        Intrinsics.checkNotNullExpressionValue(textComponent7, "empty(...)");
        $this$createBackupItem_u24lambda_u243.add(textComponent7);
        String string = backup.getId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        TextComponent textComponent8 = Component.text("ID: " + StringsKt.take(string, 8), (TextColor)NamedTextColor.DARK_GRAY);
        Intrinsics.checkNotNullExpressionValue(textComponent8, "text(...)");
        $this$createBackupItem_u24lambda_u243.add(textComponent8);
        TextComponent textComponent9 = Component.empty();
        Intrinsics.checkNotNullExpressionValue(textComponent9, "empty(...)");
        $this$createBackupItem_u24lambda_u243.add(textComponent9);
        if (hasPendingRestore) {
            TextComponent textComponent10 = Component.text("Click again to CONFIRM RESTORE", (TextColor)NamedTextColor.GREEN);
            Intrinsics.checkNotNullExpressionValue(textComponent10, "text(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent10);
        } else if (hasPendingDelete) {
            TextComponent textComponent11 = Component.text("Click again to CONFIRM DELETE", (TextColor)NamedTextColor.RED);
            Intrinsics.checkNotNullExpressionValue(textComponent11, "text(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent11);
        } else {
            TextComponent textComponent12 = Component.text("Left-click to restore", (TextColor)NamedTextColor.YELLOW);
            Intrinsics.checkNotNullExpressionValue(textComponent12, "text(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent12);
            TextComponent textComponent13 = Component.text("Right-click to delete", (TextColor)NamedTextColor.RED);
            Intrinsics.checkNotNullExpressionValue(textComponent13, "text(...)");
            $this$createBackupItem_u24lambda_u243.add(textComponent13);
        }
        List<Component> lore = CollectionsKt.build(list);
        String name = hasPendingRestore ? "Confirm Restore?" : (hasPendingDelete ? "Confirm Delete?" : "Backup from " + date);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(name, (TextColor)(hasPendingDelete ? NamedTextColor.RED : NamedTextColor.GOLD)))).lore(lore)).asGuiItem(arg_0 -> BackupGui.createBackupItem$lambda$6(hasPendingRestore, player, this, backup, hasPendingDelete, currentTime, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createNewBackupItem(Player player, PlayerWorld world) {
        int maxBackups = this.backupManager.getMaxBackupsPerWorld();
        int currentBackups = this.backupManager.getBackupsForWorld(world.getId()).size();
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Create a manual backup of this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Current backups: " + currentBackups + " / " + maxBackups, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to create backup", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.EMERALD).name(Component.text("Create New Backup", (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> BackupGui.createNewBackupItem$lambda$8(player, world, this, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createScheduleItem(Player player, PlayerWorld world) {
        List<Component> list;
        BackupSchedule schedule;
        BackupSchedule backupSchedule = schedule = this.backupManager.getBackupSchedule(world.getId());
        boolean isEnabled = backupSchedule != null ? backupSchedule.getEnabled() : false;
        Material material = isEnabled ? Material.LIME_DYE : Material.GRAY_DYE;
        String statusText = isEnabled ? "Enabled" : "Disabled";
        NamedTextColor statusColor = isEnabled ? NamedTextColor.GREEN : NamedTextColor.RED;
        List<Component> $this$createScheduleItem_u24lambda_u249 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Component component = Component.text("Status: ", (TextColor)NamedTextColor.GRAY).append(Component.text(statusText, (TextColor)statusColor));
        Intrinsics.checkNotNullExpressionValue(component, "append(...)");
        $this$createScheduleItem_u24lambda_u249.add(component);
        if (isEnabled && schedule != null) {
            TextComponent textComponent = Component.text("Interval: " + schedule.getIntervalMinutes() + " minutes", (TextColor)NamedTextColor.GRAY);
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
            $this$createScheduleItem_u24lambda_u249.add(textComponent);
            if (schedule.getLastBackupTime() > 0L) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                String lastBackup = dateFormat.format(new Date(schedule.getLastBackupTime()));
                TextComponent textComponent2 = Component.text("Last backup: " + lastBackup, (TextColor)NamedTextColor.GRAY);
                Intrinsics.checkNotNullExpressionValue(textComponent2, "text(...)");
                $this$createScheduleItem_u24lambda_u249.add(textComponent2);
            }
        }
        TextComponent textComponent = Component.empty();
        Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
        $this$createScheduleItem_u24lambda_u249.add(textComponent);
        TextComponent textComponent3 = Component.text("Click to " + (isEnabled ? "disable" : "enable"), (TextColor)NamedTextColor.YELLOW);
        Intrinsics.checkNotNullExpressionValue(textComponent3, "text(...)");
        $this$createScheduleItem_u24lambda_u249.add(textComponent3);
        List<Component> lore = CollectionsKt.build(list);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text("Automatic Backups", (TextColor)NamedTextColor.GOLD))).lore(lore)).asGuiItem(arg_0 -> BackupGui.createScheduleItem$lambda$10(isEnabled, this, world, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createBackItem(Player player, PlayerWorld world) {
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Back to World Settings", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> BackupGui.createBackItem$lambda$12(player, this, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createPreviousPageItem(PaginatedGui gui) {
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.SPECTRAL_ARROW).name(Component.text("Previous Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> BackupGui.createPreviousPageItem$lambda$13(gui, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private final GuiItem createNextPageItem(PaginatedGui gui) {
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.SPECTRAL_ARROW).name(Component.text("Next Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> BackupGui.createNextPageItem$lambda$14(gui, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        return guiItem;
    }

    private static final void createBackupItem$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createBackupItem$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createBackupItem$lambda$6(boolean $hasPendingRestore, Player $player, BackupGui this$0, WorldBackup $backup, boolean $hasPendingDelete, long $currentTime, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($backup, "$backup");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        if ($hasPendingRestore) {
            pendingRestores.remove($player.getUniqueId());
            $player.closeInventory();
            $player.sendMessage((Component)Component.text("Restoring backup...", (TextColor)NamedTextColor.YELLOW));
            this$0.backupManager.restoreBackup($backup).thenAccept(arg_0 -> BackupGui.createBackupItem$lambda$6$lambda$4(new Function1<Result<? extends Unit>, Unit>($player, this$0){
                final /* synthetic */ Player $player;
                final /* synthetic */ BackupGui this$0;
                {
                    this.$player = $player;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Result<? extends Unit> result) {
                    block1: {
                        Throwable throwable;
                        Intrinsics.checkNotNull(result);
                        Object object = result.unbox-impl();
                        Player player = this.$player;
                        BackupGui backupGui = this.this$0;
                        if (Result.isSuccess-impl(object)) {
                            Unit it = (Unit)object;
                            boolean bl = false;
                            player.getScheduler().run((Plugin)BackupGui.access$getPlugin$p(backupGui), arg_0 -> createBackupItem.1.1.invoke$lambda$1$lambda$0(player, arg_0), null);
                        }
                        player = this.$player;
                        backupGui = this.this$0;
                        Throwable throwable2 = Result.exceptionOrNull-impl(object);
                        if (throwable2 == null) break block1;
                        Throwable error = throwable = throwable2;
                        boolean bl = false;
                        player.getScheduler().run((Plugin)BackupGui.access$getPlugin$p(backupGui), arg_0 -> createBackupItem.1.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                    }
                }

                private static final void invoke$lambda$1$lambda$0(Player $player, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    $player.sendMessage((Component)Component.text("World restored successfully!", (TextColor)NamedTextColor.GREEN));
                }

                private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    Intrinsics.checkNotNullParameter($error, "$error");
                    $player.sendMessage((Component)Component.text("Failed to restore: " + $error.getMessage(), (TextColor)NamedTextColor.RED));
                }
            }, arg_0));
        } else if ($hasPendingDelete) {
            pendingDeletes.remove($player.getUniqueId());
            $player.sendMessage((Component)Component.text("Deleting backup...", (TextColor)NamedTextColor.YELLOW));
            this$0.backupManager.deleteBackup($backup).thenAccept(arg_0 -> BackupGui.createBackupItem$lambda$6$lambda$5(new Function1<Result<? extends Unit>, Unit>($player, this$0, $world){
                final /* synthetic */ Player $player;
                final /* synthetic */ BackupGui this$0;
                final /* synthetic */ PlayerWorld $world;
                {
                    this.$player = $player;
                    this.this$0 = $receiver;
                    this.$world = $world;
                    super(1);
                }

                public final void invoke(Result<? extends Unit> result) {
                    block1: {
                        Intrinsics.checkNotNull(result);
                        Object object = result.unbox-impl();
                        Player player = this.$player;
                        BackupGui backupGui = this.this$0;
                        Object object2 = this.$world;
                        if (Result.isSuccess-impl(object)) {
                            Unit it = (Unit)object;
                            boolean bl = false;
                            player.getScheduler().run((Plugin)BackupGui.access$getPlugin$p(backupGui), arg_0 -> createBackupItem.1.2.invoke$lambda$1$lambda$0(player, backupGui, (PlayerWorld)object2, arg_0), null);
                        }
                        player = this.$player;
                        backupGui = this.this$0;
                        Throwable throwable = Result.exceptionOrNull-impl(object);
                        if (throwable == null) break block1;
                        Object error = object2 = throwable;
                        boolean bl = false;
                        player.getScheduler().run((Plugin)BackupGui.access$getPlugin$p(backupGui), arg_0 -> createBackupItem.1.2.invoke$lambda$3$lambda$2(player, (Throwable)error, arg_0), null);
                    }
                }

                private static final void invoke$lambda$1$lambda$0(Player $player, BackupGui this$0, PlayerWorld $world, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    Intrinsics.checkNotNullParameter(this$0, "this$0");
                    Intrinsics.checkNotNullParameter($world, "$world");
                    $player.sendMessage((Component)Component.text("Backup deleted!", (TextColor)NamedTextColor.GREEN));
                    this$0.open($player, $world);
                }

                private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    Intrinsics.checkNotNullParameter($error, "$error");
                    $player.sendMessage((Component)Component.text("Failed to delete: " + $error.getMessage(), (TextColor)NamedTextColor.RED));
                }
            }, arg_0));
        } else if (event.isLeftClick()) {
            Map map = pendingRestores;
            UUID uUID = $player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uUID2 = uUID;
            Companion.PendingRestore pendingRestore = new Companion.PendingRestore($backup.getId(), $currentTime);
            map.put(uUID2, pendingRestore);
            pendingDeletes.remove($player.getUniqueId());
            $player.sendMessage((Component)Component.text("Click again to confirm restore", (TextColor)NamedTextColor.YELLOW));
            this$0.open($player, $world);
        } else if (event.isRightClick()) {
            Map map = pendingDeletes;
            UUID uUID = $player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uUID3 = uUID;
            Companion.PendingDelete pendingDelete = new Companion.PendingDelete($backup.getId(), $currentTime);
            map.put(uUID3, pendingDelete);
            pendingRestores.remove($player.getUniqueId());
            $player.sendMessage((Component)Component.text("Click again to confirm deletion", (TextColor)NamedTextColor.YELLOW));
            this$0.open($player, $world);
        }
    }

    private static final void createNewBackupItem$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createNewBackupItem$lambda$8(Player $player, PlayerWorld $world, BackupGui this$0, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        event.setCancelled(true);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Creating backup for ", (TextColor)NamedTextColor.YELLOW).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("...", (TextColor)NamedTextColor.YELLOW)));
        this$0.backupManager.createBackup($world, null, false).thenAccept(arg_0 -> BackupGui.createNewBackupItem$lambda$8$lambda$7(new Function1<Result<? extends WorldBackup>, Unit>($player, this$0){
            final /* synthetic */ Player $player;
            final /* synthetic */ BackupGui this$0;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Result<? extends WorldBackup> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    Player player = this.$player;
                    BackupGui backupGui = this.this$0;
                    if (Result.isSuccess-impl(object)) {
                        WorldBackup backup = (WorldBackup)object;
                        boolean bl = false;
                        player.getScheduler().run((Plugin)BackupGui.access$getPlugin$p(backupGui), arg_0 -> createNewBackupItem.1.1.invoke$lambda$1$lambda$0(player, backup, arg_0), null);
                    }
                    player = this.$player;
                    backupGui = this.this$0;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    player.getScheduler().run((Plugin)BackupGui.access$getPlugin$p(backupGui), arg_0 -> createNewBackupItem.1.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, WorldBackup $backup, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($player, "$player");
                Intrinsics.checkNotNullParameter($backup, "$backup");
                $player.sendMessage(Component.text("Backup created! ", (TextColor)NamedTextColor.GREEN).append(Component.text("Size: " + $backup.getHumanReadableSize(), (TextColor)NamedTextColor.AQUA)));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($player, "$player");
                Intrinsics.checkNotNullParameter($error, "$error");
                $player.sendMessage((Component)Component.text("Failed to create backup: " + $error.getMessage(), (TextColor)NamedTextColor.RED));
            }
        }, arg_0));
    }

    private static final void createScheduleItem$lambda$10(boolean $isEnabled, BackupGui this$0, PlayerWorld $world, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        if ($isEnabled) {
            this$0.backupManager.disableBackupSchedule($world.getId());
            $player.sendMessage((Component)Component.text("Automatic backups disabled", (TextColor)NamedTextColor.YELLOW));
        } else {
            BackupManager.setBackupSchedule$default(this$0.backupManager, $world.getId(), true, null, 4, null);
            $player.sendMessage((Component)Component.text("Automatic backups enabled", (TextColor)NamedTextColor.GREEN));
        }
        this$0.open($player, $world);
    }

    private static final void createBackItem$lambda$12$lambda$11(BackupGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        PlayerWorldManager pwm;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        JavaPlugin javaPlugin = this$0.plugin;
        PlayerWorldManager playerWorldManager = pwm = javaPlugin instanceof PlayerWorldManager ? (PlayerWorldManager)javaPlugin : null;
        InviteManager inviteManager = playerWorldManager != null ? playerWorldManager.getInviteManager() : null;
        PlayerWorldManager playerWorldManager2 = pwm;
        StatsManager statsManager = playerWorldManager2 != null ? playerWorldManager2.getStatsManager() : null;
        new WorldManageGui(this$0.plugin, this$0.worldManager, inviteManager, this$0.dataManager, statsManager, this$0.backupManager).open($player, $world);
    }

    private static final void createBackItem$lambda$12(Player $player, BackupGui this$0, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        pendingRestores.remove($player.getUniqueId());
        pendingDeletes.remove($player.getUniqueId());
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> BackupGui.createBackItem$lambda$12$lambda$11(this$0, $player, $world, arg_0), null);
    }

    private static final void createPreviousPageItem$lambda$13(PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        $gui.previous();
    }

    private static final void createNextPageItem$lambda$14(PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        $gui.next();
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(BackupGui $this) {
        return $this.plugin;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltech/bedson/playerworldmanager/gui/BackupGui$Companion;", "", "()V", "pendingDeletes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ltech/bedson/playerworldmanager/gui/BackupGui$Companion$PendingDelete;", "pendingRestores", "Ltech/bedson/playerworldmanager/gui/BackupGui$Companion$PendingRestore;", "PendingDelete", "PendingRestore", "PlayerWorldManager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ltech/bedson/playerworldmanager/gui/BackupGui$Companion$PendingDelete;", "", "backupId", "Ljava/util/UUID;", "timestamp", "", "(Ljava/util/UUID;J)V", "getBackupId", "()Ljava/util/UUID;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "PlayerWorldManager"})
        public static final class PendingDelete {
            @NotNull
            private final UUID backupId;
            private final long timestamp;

            public PendingDelete(@NotNull UUID backupId, long timestamp) {
                Intrinsics.checkNotNullParameter(backupId, "backupId");
                this.backupId = backupId;
                this.timestamp = timestamp;
            }

            @NotNull
            public final UUID getBackupId() {
                return this.backupId;
            }

            public final long getTimestamp() {
                return this.timestamp;
            }

            @NotNull
            public final UUID component1() {
                return this.backupId;
            }

            public final long component2() {
                return this.timestamp;
            }

            @NotNull
            public final PendingDelete copy(@NotNull UUID backupId, long timestamp) {
                Intrinsics.checkNotNullParameter(backupId, "backupId");
                return new PendingDelete(backupId, timestamp);
            }

            public static /* synthetic */ PendingDelete copy$default(PendingDelete pendingDelete, UUID uUID, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    uUID = pendingDelete.backupId;
                }
                if ((n & 2) != 0) {
                    l = pendingDelete.timestamp;
                }
                return pendingDelete.copy(uUID, l);
            }

            @NotNull
            public String toString() {
                return "PendingDelete(backupId=" + this.backupId + ", timestamp=" + this.timestamp + ")";
            }

            public int hashCode() {
                int result = this.backupId.hashCode();
                result = result * 31 + Long.hashCode(this.timestamp);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PendingDelete)) {
                    return false;
                }
                PendingDelete pendingDelete = (PendingDelete)other;
                if (!Intrinsics.areEqual(this.backupId, pendingDelete.backupId)) {
                    return false;
                }
                return this.timestamp == pendingDelete.timestamp;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ltech/bedson/playerworldmanager/gui/BackupGui$Companion$PendingRestore;", "", "backupId", "Ljava/util/UUID;", "timestamp", "", "(Ljava/util/UUID;J)V", "getBackupId", "()Ljava/util/UUID;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "PlayerWorldManager"})
        public static final class PendingRestore {
            @NotNull
            private final UUID backupId;
            private final long timestamp;

            public PendingRestore(@NotNull UUID backupId, long timestamp) {
                Intrinsics.checkNotNullParameter(backupId, "backupId");
                this.backupId = backupId;
                this.timestamp = timestamp;
            }

            @NotNull
            public final UUID getBackupId() {
                return this.backupId;
            }

            public final long getTimestamp() {
                return this.timestamp;
            }

            @NotNull
            public final UUID component1() {
                return this.backupId;
            }

            public final long component2() {
                return this.timestamp;
            }

            @NotNull
            public final PendingRestore copy(@NotNull UUID backupId, long timestamp) {
                Intrinsics.checkNotNullParameter(backupId, "backupId");
                return new PendingRestore(backupId, timestamp);
            }

            public static /* synthetic */ PendingRestore copy$default(PendingRestore pendingRestore, UUID uUID, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    uUID = pendingRestore.backupId;
                }
                if ((n & 2) != 0) {
                    l = pendingRestore.timestamp;
                }
                return pendingRestore.copy(uUID, l);
            }

            @NotNull
            public String toString() {
                return "PendingRestore(backupId=" + this.backupId + ", timestamp=" + this.timestamp + ")";
            }

            public int hashCode() {
                int result = this.backupId.hashCode();
                result = result * 31 + Long.hashCode(this.timestamp);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PendingRestore)) {
                    return false;
                }
                PendingRestore pendingRestore = (PendingRestore)other;
                if (!Intrinsics.areEqual(this.backupId, pendingRestore.backupId)) {
                    return false;
                }
                return this.timestamp == pendingRestore.timestamp;
            }
        }
    }
}

