/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.AdminWorldBrowserGui;
import tech.bedson.playerworldmanager.gui.AdminWorldManageGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.ChestGuiBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ltech/bedson/playerworldmanager/gui/AdminWorldManageGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "deleteClickCount", "", "lastDeleteClick", "", "createBackItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "createForceDeleteItem", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "createForceInviteItem", "createForceKickItem", "createForceTransferItem", "createInvitedPlayersInfoItem", "createSetLimitItem", "createTeleportItem", "environment", "Lorg/bukkit/World$Environment;", "createToggleEnableItem", "createWorldInfoItem", "open", "", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nAdminWorldManageGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminWorldManageGui.kt\ntech/bedson/playerworldmanager/gui/AdminWorldManageGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,458:1\n1549#2:459\n1620#2,3:460\n1855#2,2:463\n*S KotlinDebug\n*F\n+ 1 AdminWorldManageGui.kt\ntech/bedson/playerworldmanager/gui/AdminWorldManageGui\n*L\n133#1:459\n133#1:460,3\n142#1:463,2\n*E\n"})
public final class AdminWorldManageGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;
    private int deleteClickCount;
    private long lastDeleteClick;

    public AdminWorldManageGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "AdminWorldManageGui");
    }

    public final void open(@NotNull Player player, @NotNull PlayerWorld world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        this.plugin.getLogger().info("[GUI] AdminWorldManageGui: Opening for admin " + player.getName() + ", world " + world.getName() + " (owner: " + world.getOwnerName() + ")");
        pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerUuid", world.getOwnerUuid()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("isEnabled", world.isEnabled()), TuplesKt.to("invitedPlayers", world.getInvitedPlayers().size())};
        this.debugLogger.debugState("AdminWorldManageGui", pairArray);
        this.deleteClickCount = 0;
        this.debugLogger.debug("Reset delete confirmation counter");
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(Component.text("Admin: " + world.getName(), (TextColor)NamedTextColor.DARK_PURPLE))).rows(5)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(gui, "create(...)");
        Gui gui2 = gui;
        this.debugLogger.debug("Setting up Row 1: Info");
        gui2.setItem(0, this.createWorldInfoItem(world));
        gui2.setItem(1, this.createInvitedPlayersInfoItem(world));
        this.debugLogger.debug("Setting up Row 2: Teleport");
        gui2.setItem(9, this.createTeleportItem(player, world, World.Environment.NORMAL));
        gui2.setItem(10, this.createTeleportItem(player, world, World.Environment.NETHER));
        gui2.setItem(11, this.createTeleportItem(player, world, World.Environment.THE_END));
        this.debugLogger.debug("Setting up Row 3: Management");
        gui2.setItem(18, this.createForceInviteItem(player, world));
        gui2.setItem(19, this.createForceKickItem(player, world));
        gui2.setItem(20, this.createForceTransferItem(player, world));
        this.debugLogger.debug("Setting up Row 4: Status");
        gui2.setItem(27, this.createToggleEnableItem(player, world));
        gui2.setItem(28, this.createSetLimitItem(player, world));
        this.debugLogger.debug("Setting up Row 5: Navigation and deletion");
        gui2.setItem(36, this.createBackItem(player));
        gui2.setItem(40, this.createForceDeleteItem(player, world));
        this.debugLogger.debug("Filling empty slots with glass panes");
        for (int i = 0; i < 45; ++i) {
            if (gui2.getGuiItem(i) != null) continue;
            gui2.setItem(i, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Opening GUI for player", pairArray2);
        gui2.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    private final GuiItem createWorldInfoItem(PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createWorldInfoItem", pairArray);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm");
        String createdDate = dateFormat.format(new Date(world.getCreatedAt()));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("worldType", world.getWorldType()), TuplesKt.to("createdDate", createdDate), TuplesKt.to("isEnabled", world.isEnabled())};
        this.debugLogger.debugState("WorldInfoItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Name: " + world.getName(), (TextColor)NamedTextColor.GRAY), Component.text("Owner: " + world.getOwnerName(), (TextColor)NamedTextColor.GRAY), Component.text("Type: " + world.getWorldType(), (TextColor)NamedTextColor.GRAY), Component.text("Created: " + createdDate, (TextColor)NamedTextColor.GRAY), Component.text("Status: " + (world.isEnabled() ? "Enabled" : "Disabled"), (TextColor)(world.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED))};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.PAPER).name(Component.text("World Information", (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldManageGui.createWorldInfoItem$lambda$0(this, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createWorldInfoItem", null, 2, null);
        return item2;
    }

    /*
     * WARNING - void declaration
     */
    private final GuiItem createInvitedPlayersInfoItem(PlayerWorld world) {
        void $this$mapTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createInvitedPlayersInfoItem", pairArray);
        int invitedCount = world.getInvitedPlayers().size();
        Pair[] $this$map$iv = (Pair[])CollectionsKt.take((Iterable)world.getInvitedPlayers(), 10);
        boolean $i$f$map = false;
        Pair[] pairArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void uuid;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            if (string == null) {
                string = uuid.toString();
            }
            collection.add(string);
        }
        List invitedNames = (List)destination$iv$iv;
        $this$map$iv = new Pair[]{TuplesKt.to("invitedCount", invitedCount), TuplesKt.to("displayedNames", invitedNames.size())};
        this.debugLogger.debugState("InvitedPlayersInfoItem", $this$map$iv);
        List<TextComponent> $this$createInvitedPlayersInfoItem_u24lambda_u243 = $i$f$map = CollectionsKt.createListBuilder();
        boolean bl = false;
        TextComponent textComponent = Component.text("Invited Players: " + invitedCount, (TextColor)NamedTextColor.GRAY);
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        $this$createInvitedPlayersInfoItem_u24lambda_u243.add(textComponent);
        if (!((Collection)invitedNames).isEmpty()) {
            TextComponent textComponent2 = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent2, "empty(...)");
            $this$createInvitedPlayersInfoItem_u24lambda_u243.add(textComponent2);
            Iterable $this$forEach$iv = invitedNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name = (String)element$iv;
                boolean bl2 = false;
                TextComponent textComponent3 = Component.text("  - " + name, (TextColor)NamedTextColor.GRAY);
                Intrinsics.checkNotNullExpressionValue(textComponent3, "text(...)");
                $this$createInvitedPlayersInfoItem_u24lambda_u243.add(textComponent3);
            }
            if (invitedCount > 10) {
                TextComponent textComponent4 = Component.text("  ...and " + (invitedCount - 10) + " more", (TextColor)NamedTextColor.GRAY);
                Intrinsics.checkNotNullExpressionValue(textComponent4, "text(...)");
                $this$createInvitedPlayersInfoItem_u24lambda_u243.add(textComponent4);
            }
        }
        List<Component> lore = CollectionsKt.build($i$f$map);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BOOK).name(Component.text("Invited Players", (TextColor)NamedTextColor.AQUA))).lore(lore)).asGuiItem(arg_0 -> AdminWorldManageGui.createInvitedPlayersInfoItem$lambda$4(this, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        this.debugLogger.debugMethodExit("createInvitedPlayersInfoItem", "invitedCount=" + invitedCount);
        return item2;
    }

    private final GuiItem createTeleportItem(Player player, PlayerWorld world, World.Environment environment) {
        Object object = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("environment", environment)};
        this.debugLogger.debugMethodEntry("createTeleportItem", (Pair<String, ? extends Object>)object);
        object = switch (WhenMappings.$EnumSwitchMapping$0[environment.ordinal()]) {
            case 1 -> TuplesKt.to(Material.COMPASS, "TP to Overworld");
            case 2 -> TuplesKt.to(Material.NETHERRACK, "TP to Nether");
            case 3 -> TuplesKt.to(Material.END_STONE, "TP to End");
            default -> TuplesKt.to(Material.COMPASS, "Teleport");
        };
        Material material = (Material)((Pair)object).component1();
        String name = (String)((Pair)object).component2();
        Pair[] pairArray = new Pair[]{TuplesKt.to("material", material), TuplesKt.to("name", name)};
        this.debugLogger.debug("Creating teleport item", pairArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(name, (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(Component.text("Click to teleport", (TextColor)NamedTextColor.YELLOW)))).asGuiItem(arg_0 -> AdminWorldManageGui.createTeleportItem$lambda$7(this, player, environment, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createTeleportItem", null, 2, null);
        return item2;
    }

    private final GuiItem createForceInviteItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createForceInviteItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Invite a player to this world", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /worldadmin invite <world> <player>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.EMERALD).name(Component.text("Force Invite Player", (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldManageGui.createForceInviteItem$lambda$8(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createForceInviteItem", null, 2, null);
        return item2;
    }

    private final GuiItem createForceKickItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createForceKickItem", pairArray);
        int invitedCount = world.getInvitedPlayers().size();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("invitedCount", invitedCount)};
        this.debugLogger.debugState("ForceKickItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Kick a player from this world", (TextColor)NamedTextColor.GRAY), Component.text("Invited players: " + invitedCount, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /worldadmin kick <world> <player>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Component.text("Force Kick Player", (TextColor)NamedTextColor.RED))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldManageGui.createForceKickItem$lambda$9(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createForceKickItem", null, 2, null);
        return item2;
    }

    private final GuiItem createForceTransferItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("currentOwner", world.getOwnerName())};
        this.debugLogger.debugMethodEntry("createForceTransferItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Transfer this world to another player", (TextColor)NamedTextColor.GRAY), Component.text("Current owner: " + world.getOwnerName(), (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /worldadmin transfer <world> <player>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.GOLD_INGOT).name(Component.text("Force Transfer Ownership", (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldManageGui.createForceTransferItem$lambda$10(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createForceTransferItem", null, 2, null);
        return item2;
    }

    private final GuiItem createToggleEnableItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createToggleEnableItem", pairArray);
        boolean isEnabled = world.isEnabled();
        Material material = isEnabled ? Material.LIME_DYE : Material.GRAY_DYE;
        String name = isEnabled ? "Disable World" : "Enable World";
        NamedTextColor color = isEnabled ? NamedTextColor.RED : NamedTextColor.GREEN;
        String action = isEnabled ? "disable" : "enable";
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("isEnabled", isEnabled), TuplesKt.to("action", action)};
        this.debugLogger.debugState("ToggleEnableItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Current status: " + (isEnabled ? "Enabled" : "Disabled"), (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to " + action, (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(name, (TextColor)color))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldManageGui.createToggleEnableItem$lambda$11(world, this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createToggleEnableItem", null, 2, null);
        return item2;
    }

    private final GuiItem createSetLimitItem(Player player, PlayerWorld world) {
        PlayerData playerData;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName())};
        this.debugLogger.debugMethodEntry("createSetLimitItem", pairArray);
        PlayerData playerData2 = playerData = this.dataManager.loadPlayerData(world.getOwnerUuid());
        int currentLimit = playerData2 != null ? playerData2.getWorldLimit() : 3;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("currentLimit", currentLimit), TuplesKt.to("hasPlayerData", playerData != null)};
        this.debugLogger.debugState("SetLimitItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Owner: " + world.getOwnerName(), (TextColor)NamedTextColor.GRAY), Component.text("Current limit: " + currentLimit, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /worldadmin setlimit <player> <limit>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.PLAYER_HEAD).name(Component.text("Set Player World Limit", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldManageGui.createSetLimitItem$lambda$12(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createSetLimitItem", null, 2, null);
        return item2;
    }

    private final GuiItem createBackItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createBackItem", pairArray);
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Back to Browser", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> AdminWorldManageGui.createBackItem$lambda$14(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createBackItem", null, 2, null);
        return item2;
    }

    private final GuiItem createForceDeleteItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debugMethodEntry("createForceDeleteItem", pairArray);
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastDeleteClick > 5000L) {
            this.deleteClickCount = 0;
            this.debugLogger.debug("Reset delete click counter (timeout)");
        }
        boolean needsConfirmation = this.deleteClickCount == 0;
        Material material = needsConfirmation ? Material.TNT : Material.BARRIER;
        String name = needsConfirmation ? "Force Delete World" : "Click again to confirm deletion";
        NamedTextColor color = needsConfirmation ? NamedTextColor.RED : NamedTextColor.DARK_RED;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("needsConfirmation", needsConfirmation), TuplesKt.to("deleteClickCount", this.deleteClickCount), TuplesKt.to("timeSinceLastClick", currentTime - this.lastDeleteClick)};
        this.debugLogger.debugState("ForceDeleteItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("This cannot be undone!", (TextColor)NamedTextColor.RED), Component.text("Owner will lose the world!", (TextColor)NamedTextColor.RED), Component.empty(), needsConfirmation ? Component.text("Click twice to delete", (TextColor)NamedTextColor.YELLOW) : Component.text("Click to DELETE PERMANENTLY", (TextColor)NamedTextColor.DARK_RED)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(name, (TextColor)color))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldManageGui.createForceDeleteItem$lambda$16(this, currentTime, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createForceDeleteItem", null, 2, null);
        return item2;
    }

    private static final void createWorldInfoItem$lambda$0(AdminWorldManageGui this$0, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("World info item clicked (display only)", pairArray);
    }

    private static final void createInvitedPlayersInfoItem$lambda$4(AdminWorldManageGui this$0, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Invited players info item clicked (display only)", pairArray);
    }

    private static final void createTeleportItem$lambda$7$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createTeleportItem$lambda$7$lambda$6(AdminWorldManageGui this$0, Player $player, World.Environment $environment, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($environment, "$environment");
        Intrinsics.checkNotNullParameter($world, "$world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("environment", $environment)};
        this$0.debugLogger.debug("Initiating teleport to dimension", pairArray);
        this$0.worldManager.teleportToDimension($player, $world, $environment).thenAccept(arg_0 -> AdminWorldManageGui.createTeleportItem$lambda$7$lambda$6$lambda$5(new Function1<Boolean, Unit>(this$0, $player, $environment, $world){
            final /* synthetic */ AdminWorldManageGui this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ World.Environment $environment;
            final /* synthetic */ PlayerWorld $world;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$environment = $environment;
                this.$world = $world;
                super(1);
            }

            public final void invoke(Boolean success) {
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    AdminWorldManageGui.access$getPlugin$p(this.this$0).getLogger().info("[GUI] AdminWorldManageGui: Admin " + this.$player.getName() + " successfully teleported to " + this.$environment.name() + " in world " + this.$world.getName());
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("environment", this.$environment)};
                    AdminWorldManageGui.access$getDebugLogger$p(this.this$0).debug("Teleport successful", pairArray);
                    this.$player.sendMessage(Component.text("Teleported to ", (TextColor)NamedTextColor.GREEN).append(Component.text(this.$world.getName(), (TextColor)NamedTextColor.GOLD)));
                } else {
                    AdminWorldManageGui.access$getPlugin$p(this.this$0).getLogger().warning("[GUI] AdminWorldManageGui: Admin " + this.$player.getName() + " failed to teleport to " + this.$environment.name() + " in world " + this.$world.getName());
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("environment", this.$environment)};
                    AdminWorldManageGui.access$getDebugLogger$p(this.this$0).debug("Teleport failed", pairArray);
                    this.$player.sendMessage((Component)Component.text("Failed to teleport to world", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
    }

    private static final void createTeleportItem$lambda$7(AdminWorldManageGui this$0, Player $player, World.Environment $environment, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($environment, "$environment");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] AdminWorldManageGui: Admin " + $player.getName() + " teleporting to " + $environment.name() + " in world " + $world.getName());
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("environment", $environment), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Teleport button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminWorldManageGui.createTeleportItem$lambda$7$lambda$6(this$0, $player, $environment, $world, arg_0), null);
    }

    private static final void createForceInviteItem$lambda$8(AdminWorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Force Invite button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin invite " + $world.getName() + " <player>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to force invite a player", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createForceKickItem$lambda$9(AdminWorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Force Kick button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin kick " + $world.getName() + " <player>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to force kick a player", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createForceTransferItem$lambda$10(AdminWorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Force Transfer button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin transfer " + $world.getName() + " <player>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to force transfer ownership", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createToggleEnableItem$lambda$11(PlayerWorld $world, AdminWorldManageGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        boolean newStatus = !$world.isEnabled();
        this$0.plugin.getLogger().info("[GUI] AdminWorldManageGui: Admin " + $player.getName() + " toggling world " + $world.getName() + " from " + $world.isEnabled() + " to " + newStatus);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName()), TuplesKt.to("oldStatus", $world.isEnabled()), TuplesKt.to("newStatus", newStatus)};
        this$0.debugLogger.debug("Toggle Enable button clicked", pairArray);
        $world.setEnabled(newStatus);
        this$0.dataManager.saveWorld($world);
        pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("newStatus", newStatus)};
        this$0.debugLogger.debug("World status saved", pairArray);
        $player.sendMessage(((TextComponent)Component.text("World ", (TextColor)NamedTextColor.YELLOW).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" is now " + ($world.isEnabled() ? "enabled" : "disabled"), (TextColor)NamedTextColor.YELLOW)));
        pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Refreshing GUI after toggle", pairArray);
        this$0.open($player, $world);
    }

    private static final void createSetLimitItem$lambda$12(AdminWorldManageGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("ownerName", $world.getOwnerName())};
        this$0.debugLogger.debug("Set Limit button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin setlimit " + $world.getOwnerName() + " <limit>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to set the player's world limit", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createBackItem$lambda$14$lambda$13(AdminWorldManageGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening AdminWorldBrowserGui", pairArray);
        AdminWorldBrowserGui.open$default(new AdminWorldBrowserGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager), $player, false, 2, null);
    }

    private static final void createBackItem$lambda$14(AdminWorldManageGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] AdminWorldManageGui: Admin " + $player.getName() + " clicked Back to Browser");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Back button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminWorldManageGui.createBackItem$lambda$14$lambda$13(this$0, $player, arg_0), null);
    }

    private static final void createForceDeleteItem$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createForceDeleteItem$lambda$16(AdminWorldManageGui this$0, long $currentTime, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        if (this$0.deleteClickCount == 0) {
            this$0.deleteClickCount = 1;
            this$0.lastDeleteClick = $currentTime;
            this$0.plugin.getLogger().info("[GUI] AdminWorldManageGui: Admin " + $player.getName() + " clicked force delete for world " + $world.getName() + " (first click)");
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
            this$0.debugLogger.debug("Force Delete button clicked (first click)", pairArray);
            $player.sendMessage(Component.text("Click delete again to confirm deletion of ", (TextColor)NamedTextColor.YELLOW).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
            this$0.open($player, $world);
        } else {
            this$0.plugin.getLogger().info("[GUI] AdminWorldManageGui: Admin " + $player.getName() + " confirmed force deletion of world " + $world.getName() + " (owner: " + $world.getOwnerName() + ")");
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName()), TuplesKt.to("worldId", $world.getId())};
            this$0.debugLogger.debug("Force Delete button clicked (confirmation)", pairArray);
            $player.closeInventory();
            $player.sendMessage(((TextComponent)Component.text("Force deleting world ", (TextColor)NamedTextColor.YELLOW).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("...", (TextColor)NamedTextColor.YELLOW)));
            pairArray = new Pair[]{TuplesKt.to("worldName", $world.getName()), TuplesKt.to("ownerName", $world.getOwnerName())};
            this$0.debugLogger.debug("Initiating world deletion", pairArray);
            this$0.worldManager.deleteWorld($world).thenAccept(arg_0 -> AdminWorldManageGui.createForceDeleteItem$lambda$16$lambda$15(new Function1<Result<? extends Unit>, Unit>(this$0, $world, $player){
                final /* synthetic */ AdminWorldManageGui this$0;
                final /* synthetic */ PlayerWorld $world;
                final /* synthetic */ Player $player;
                {
                    this.this$0 = $receiver;
                    this.$world = $world;
                    this.$player = $player;
                    super(1);
                }

                public final void invoke(Result<? extends Unit> result) {
                    block1: {
                        Throwable throwable;
                        Intrinsics.checkNotNull(result);
                        Object object = result.unbox-impl();
                        AdminWorldManageGui adminWorldManageGui = this.this$0;
                        PlayerWorld playerWorld = this.$world;
                        Player player = this.$player;
                        if (Result.isSuccess-impl(object)) {
                            Unit it = (Unit)object;
                            boolean bl = false;
                            AdminWorldManageGui.access$getPlugin$p(adminWorldManageGui).getLogger().info("[GUI] AdminWorldManageGui: Successfully force deleted world " + playerWorld.getName() + " for admin " + player.getName());
                            Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", playerWorld.getName())};
                            AdminWorldManageGui.access$getDebugLogger$p(adminWorldManageGui).debug("World deletion successful", pairArray);
                            player.getScheduler().run((Plugin)AdminWorldManageGui.access$getPlugin$p(adminWorldManageGui), arg_0 -> createForceDeleteItem.item.1.1.invoke$lambda$1$lambda$0(player, playerWorld, arg_0), null);
                        }
                        adminWorldManageGui = this.this$0;
                        playerWorld = this.$world;
                        player = this.$player;
                        Throwable throwable2 = Result.exceptionOrNull-impl(object);
                        if (throwable2 == null) break block1;
                        Throwable error = throwable = throwable2;
                        boolean bl = false;
                        AdminWorldManageGui.access$getPlugin$p(adminWorldManageGui).getLogger().warning("[GUI] AdminWorldManageGui: Failed to force delete world " + playerWorld.getName() + " for admin " + player.getName() + ": " + error.getMessage());
                        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("error", error.getMessage())};
                        AdminWorldManageGui.access$getDebugLogger$p(adminWorldManageGui).debug("World deletion failed", pairArray);
                        player.getScheduler().run((Plugin)AdminWorldManageGui.access$getPlugin$p(adminWorldManageGui), arg_0 -> createForceDeleteItem.item.1.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                    }
                }

                private static final void invoke$lambda$1$lambda$0(Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    Intrinsics.checkNotNullParameter($world, "$world");
                    $player.sendMessage(Component.text("Successfully deleted world ", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
                }

                private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter($player, "$player");
                    Intrinsics.checkNotNullParameter($error, "$error");
                    $player.sendMessage((Component)Component.text("Failed to delete world: " + $error.getMessage(), (TextColor)NamedTextColor.RED));
                }
            }, arg_0));
        }
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(AdminWorldManageGui $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(AdminWorldManageGui $this) {
        return $this.debugLogger;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[World.Environment.values().length];
            try {
                nArray[World.Environment.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.NETHER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.THE_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

