/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.AdminMenuGui;
import tech.bedson.playerworldmanager.gui.AdminWorldManageGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.PaginatedBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.gui.guis.PaginatedGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.NoWhenBranchMatchedException;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.comparisons.ComparisonsKt;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntries;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntriesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J$\u0010%\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ltech/bedson/playerworldmanager/gui/AdminWorldBrowserGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "currentFilter", "Ltech/bedson/playerworldmanager/gui/AdminWorldBrowserGui$FilterMode;", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createBackItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "createFilterItem", "createNextPageItem", "gui", "Ltech/bedson/playerworldmanager/libs/gui/guis/PaginatedGui;", "createPageIndicatorItem", "createPreviousPageItem", "createWorldItem", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "open", "", "disabledOnly", "", "openForPlayer", "targetUuid", "Ljava/util/UUID;", "targetName", "", "openWithFilter", "FilterMode", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nAdminWorldBrowserGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminWorldBrowserGui.kt\ntech/bedson/playerworldmanager/gui/AdminWorldBrowserGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n766#2:343\n857#2,2:344\n766#2:346\n857#2,2:347\n1054#2:349\n1855#2,2:350\n*S KotlinDebug\n*F\n+ 1 AdminWorldBrowserGui.kt\ntech/bedson/playerworldmanager/gui/AdminWorldBrowserGui\n*L\n86#1:343\n86#1:344,2\n87#1:346\n87#1:347,2\n91#1:349\n102#1:350,2\n*E\n"})
public final class AdminWorldBrowserGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private FilterMode currentFilter;

    public AdminWorldBrowserGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "AdminWorldBrowserGui");
        this.currentFilter = FilterMode.ALL;
    }

    public final void open(@NotNull Player player, boolean disabledOnly) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("disabledOnly", disabledOnly)};
        this.debugLogger.debugMethodEntry("open", pairArray);
        this.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Opening for admin " + player.getName() + ", disabledOnly=" + disabledOnly);
        if (disabledOnly) {
            this.currentFilter = FilterMode.DISABLED_ONLY;
            this.debugLogger.debug("Filter set to DISABLED_ONLY");
        }
        this.openWithFilter(player, null, null);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    public static /* synthetic */ void open$default(AdminWorldBrowserGui adminWorldBrowserGui, Player player, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        adminWorldBrowserGui.open(player, bl);
    }

    public final void openForPlayer(@NotNull Player player, @NotNull UUID targetUuid, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(targetUuid, "targetUuid");
        Intrinsics.checkNotNullParameter(targetName, "targetName");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("targetUuid", targetUuid), TuplesKt.to("targetName", targetName)};
        this.debugLogger.debugMethodEntry("openForPlayer", pairArray);
        this.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Opening for admin " + player.getName() + ", browsing worlds of player " + targetName);
        this.openWithFilter(player, targetUuid, targetName);
        DebugLogger.debugMethodExit$default(this.debugLogger, "openForPlayer", null, 2, null);
    }

    private final void openWithFilter(Player player, UUID targetUuid, String targetName) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("targetUuid", targetUuid), TuplesKt.to("targetName", targetName)};
        this.debugLogger.debugMethodEntry("openWithFilter", pairArray);
        String string = targetName;
        PaginatedGui paginatedGui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(Component.text((String)(string != null ? string + "'s Worlds" : "Browse Worlds"), (TextColor)NamedTextColor.DARK_PURPLE))).rows(6)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(paginatedGui, "create(...)");
        PaginatedGui gui = paginatedGui;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("targetUuid", targetUuid), TuplesKt.to("filter", this.currentFilter)};
        this.debugLogger.debug("Loading worlds", pairArray2);
        List<PlayerWorld> allWorlds = targetUuid != null ? this.dataManager.getWorldsByOwner(targetUuid) : this.dataManager.getAllWorlds();
        List<PlayerWorld> filteredWorlds = switch (WhenMappings.$EnumSwitchMapping$0[this.currentFilter.ordinal()]) {
            case 1 -> allWorlds;
            case 2 -> {
                PlayerWorld it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = allWorlds;
                boolean $i$f$filter = false;
                Iterable var11_12 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (PlayerWorld)element$iv$iv;
                    boolean $i$a$-filter-AdminWorldBrowserGui$openWithFilter$filteredWorlds$1 = false;
                    if (!it.isEnabled()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List<PlayerWorld>)destination$iv$iv;
            }
            case 3 -> {
                PlayerWorld it;
                Iterable $this$filter$iv = allWorlds;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (PlayerWorld)element$iv$iv;
                    boolean $i$a$-filter-AdminWorldBrowserGui$openWithFilter$filteredWorlds$2 = false;
                    if (!(!it.isEnabled())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Pair[] $this$sortedByDescending$iv = (Pair[])filteredWorlds;
        boolean $i$f$sortedByDescending = false;
        List sortedWorlds = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                PlayerWorld it = (PlayerWorld)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCreatedAt());
                it = (PlayerWorld)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getCreatedAt());
            }
        });
        this.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Displaying " + sortedWorlds.size() + " worlds to admin " + player.getName() + " (filter: " + this.currentFilter + ")");
        $this$sortedByDescending$iv = new Pair[]{TuplesKt.to("totalWorlds", allWorlds.size()), TuplesKt.to("filteredWorlds", filteredWorlds.size()), TuplesKt.to("filter", this.currentFilter)};
        this.debugLogger.debug("Worlds loaded and filtered", $this$sortedByDescending$iv);
        $this$sortedByDescending$iv = new Pair[]{TuplesKt.to("count", sortedWorlds.size())};
        this.debugLogger.debug("Adding world items to GUI", $this$sortedByDescending$iv);
        Iterable $this$forEach$iv = sortedWorlds;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("isEnabled", world.isEnabled())};
            this.debugLogger.debug("Adding world item", pairArray3);
            gui.addItem(this.createWorldItem(player, world));
        }
        this.debugLogger.debug("Adding navigation buttons");
        gui.setItem(6, 1, this.createBackItem(player));
        gui.setItem(6, 4, this.createPreviousPageItem(gui));
        gui.setItem(6, 5, this.createPageIndicatorItem(gui));
        gui.setItem(6, 6, this.createNextPageItem(gui));
        gui.setItem(6, 9, this.createFilterItem(player));
        this.debugLogger.debug("Filling empty slots with glass panes");
        Integer[] $i$f$forEach22 = new Integer[]{0, 2, 3, 7, 8};
        Pair[] pairArray4 = CollectionsKt.listOf($i$f$forEach22).iterator();
        while (pairArray4.hasNext()) {
            int i = ((Number)pairArray4.next()).intValue();
            gui.setItem(6, i + 1, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        pairArray4 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Opening GUI for player", pairArray4);
        gui.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "openWithFilter", null, 2, null);
    }

    private final GuiItem createWorldItem(Player player, PlayerWorld world) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName())};
        this.debugLogger.debugMethodEntry("createWorldItem", pairArray);
        Material material = world.isEnabled() ? Material.GRASS_BLOCK : Material.GRAY_STAINED_GLASS;
        NamedTextColor nameColor = world.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.GRAY;
        String statusText = world.isEnabled() ? "Enabled" : "Disabled";
        NamedTextColor statusColor = world.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED;
        World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
        Object object = bukkitWorld;
        int playersOnline = object != null && (object = object.getPlayers()) != null ? object.size() : 0;
        int invitedCount = world.getInvitedPlayers().size();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy");
        String createdDate = dateFormat.format(new Date(world.getCreatedAt()));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("ownerName", world.getOwnerName()), TuplesKt.to("isEnabled", world.isEnabled()), TuplesKt.to("playersOnline", playersOnline), TuplesKt.to("invitedCount", invitedCount), TuplesKt.to("worldType", world.getWorldType()), TuplesKt.to("worldLoaded", bukkitWorld != null)};
        this.debugLogger.debugState("WorldItem", pairArray2);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Type: " + world.getWorldType(), (TextColor)NamedTextColor.GRAY), Component.text("Status: ", (TextColor)NamedTextColor.GRAY).append(Component.text(statusText, (TextColor)statusColor)), Component.text("Players Online: " + playersOnline, (TextColor)NamedTextColor.GRAY), Component.text("Invited: " + invitedCount + " players", (TextColor)NamedTextColor.GRAY), Component.text("Created: " + createdDate, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Left-click: Teleport", (TextColor)NamedTextColor.YELLOW), Component.text("Right-click: Manage", (TextColor)NamedTextColor.YELLOW), Component.text("Shift-click: Toggle Enable/Disable", (TextColor)NamedTextColor.GOLD)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.text(world.getOwnerName() + "'s " + world.getName(), (TextColor)nameColor))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminWorldBrowserGui.createWorldItem$lambda$8(this, player, world, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        this.debugLogger.debugMethodExit("createWorldItem", "item created");
        return item2;
    }

    private final GuiItem createBackItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createBackItem", pairArray);
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Back to Admin Menu", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> AdminWorldBrowserGui.createBackItem$lambda$10(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createBackItem", null, 2, null);
        return item2;
    }

    private final GuiItem createPreviousPageItem(PaginatedGui gui) {
        this.debugLogger.debugMethodEntry("createPreviousPageItem", new Pair[0]);
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Previous Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> AdminWorldBrowserGui.createPreviousPageItem$lambda$11(this, gui, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createPreviousPageItem", null, 2, null);
        return item2;
    }

    private final GuiItem createPageIndicatorItem(PaginatedGui gui) {
        this.debugLogger.debugMethodEntry("createPageIndicatorItem", new Pair[0]);
        int currentPage = gui.getCurrentPageNum() + 1;
        int totalPages = Math.max(1, gui.getPagesNum());
        Pair[] pairArray = new Pair[]{TuplesKt.to("currentPage", currentPage), TuplesKt.to("totalPages", totalPages)};
        this.debugLogger.debugState("PageIndicator", pairArray);
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.PAPER).name(Component.text("Page " + currentPage + "/" + totalPages, (TextColor)NamedTextColor.GOLD))).asGuiItem(AdminWorldBrowserGui::createPageIndicatorItem$lambda$12);
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createPageIndicatorItem", null, 2, null);
        return item2;
    }

    private final GuiItem createNextPageItem(PaginatedGui gui) {
        this.debugLogger.debugMethodEntry("createNextPageItem", new Pair[0]);
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Component.text("Next Page", (TextColor)NamedTextColor.YELLOW))).asGuiItem(arg_0 -> AdminWorldBrowserGui.createNextPageItem$lambda$13(this, gui, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createNextPageItem", null, 2, null);
        return item2;
    }

    private final GuiItem createFilterItem(Player player) {
        Object object = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createFilterItem", (Pair<String, ? extends Object>)object);
        object = switch (WhenMappings.$EnumSwitchMapping$0[this.currentFilter.ordinal()]) {
            case 1 -> TuplesKt.to("All Worlds", FilterMode.ENABLED_ONLY);
            case 2 -> TuplesKt.to("Enabled Only", FilterMode.DISABLED_ONLY);
            case 3 -> TuplesKt.to("Disabled Only", FilterMode.ALL);
            default -> throw new NoWhenBranchMatchedException();
        };
        String filterName = (String)((Pair)object).component1();
        FilterMode nextFilter = (FilterMode)((Object)((Pair)object).component2());
        String nextFilterName = switch (WhenMappings.$EnumSwitchMapping$0[nextFilter.ordinal()]) {
            case 1 -> "All Worlds";
            case 2 -> "Enabled Only";
            case 3 -> "Disabled Only";
            default -> throw new NoWhenBranchMatchedException();
        };
        Pair[] pairArray = new Pair[]{TuplesKt.to("currentFilter", filterName), TuplesKt.to("nextFilter", nextFilterName)};
        this.debugLogger.debugState("FilterItem", pairArray);
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.HOPPER).name(Component.text("Filter: " + filterName, (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(Component.text("Click to change to: " + nextFilterName, (TextColor)NamedTextColor.YELLOW)))).asGuiItem(arg_0 -> AdminWorldBrowserGui.createFilterItem$lambda$15(this, player, nextFilter, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createFilterItem", null, 2, null);
        return item2;
    }

    private static final void createWorldItem$lambda$8$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createWorldItem$lambda$8$lambda$5(AdminWorldBrowserGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Initiating teleport", pairArray);
        this$0.worldManager.teleportToWorld($player, $world).thenAccept(arg_0 -> AdminWorldBrowserGui.createWorldItem$lambda$8$lambda$5$lambda$4(new Function1<Boolean, Unit>(this$0, $player, $world){
            final /* synthetic */ AdminWorldBrowserGui this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ PlayerWorld $world;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$world = $world;
                super(1);
            }

            public final void invoke(Boolean success) {
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    AdminWorldBrowserGui.access$getPlugin$p(this.this$0).getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + this.$player.getName() + " successfully teleported to world " + this.$world.getName());
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("worldName", this.$world.getName())};
                    AdminWorldBrowserGui.access$getDebugLogger$p(this.this$0).debug("Teleport successful", pairArray);
                    this.$player.sendMessage(Component.text("Teleported to ", (TextColor)NamedTextColor.GREEN).append(Component.text(this.$world.getName(), (TextColor)NamedTextColor.GOLD)));
                } else {
                    AdminWorldBrowserGui.access$getPlugin$p(this.this$0).getLogger().warning("[GUI] AdminWorldBrowserGui: Admin " + this.$player.getName() + " failed to teleport to world " + this.$world.getName());
                    Pair[] pairArray = new Pair[]{TuplesKt.to("player", this.$player.getName()), TuplesKt.to("worldName", this.$world.getName())};
                    AdminWorldBrowserGui.access$getDebugLogger$p(this.this$0).debug("Teleport failed", pairArray);
                    this.$player.sendMessage((Component)Component.text("Failed to teleport to world", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
    }

    private static final void createWorldItem$lambda$8$lambda$6(AdminWorldBrowserGui this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
        this$0.debugLogger.debug("Opening AdminWorldManageGui", pairArray);
        new AdminWorldManageGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager).open($player, $world);
    }

    private static final void createWorldItem$lambda$8$lambda$7(AdminWorldBrowserGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Refreshing GUI after toggle", pairArray);
        this$0.openWithFilter($player, null, null);
    }

    private static final void createWorldItem$lambda$8(AdminWorldBrowserGui this$0, Player $player, PlayerWorld $world, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        event.setCancelled(true);
        switch (WhenMappings.$EnumSwitchMapping$1[event.getClick().ordinal()]) {
            case 1: {
                this$0.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + $player.getName() + " teleporting to world " + $world.getName());
                Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
                this$0.debugLogger.debug("Teleport (LEFT click)", pairArray);
                $player.closeInventory();
                $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminWorldBrowserGui.createWorldItem$lambda$8$lambda$5(this$0, $player, $world, arg_0), null);
                break;
            }
            case 2: {
                this$0.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + $player.getName() + " opening manage GUI for world " + $world.getName());
                Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName())};
                this$0.debugLogger.debug("Manage (RIGHT click)", pairArray);
                $player.closeInventory();
                $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminWorldBrowserGui.createWorldItem$lambda$8$lambda$6(this$0, $player, $world, arg_0), null);
                break;
            }
            case 3: 
            case 4: {
                boolean newStatus = !$world.isEnabled();
                this$0.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + $player.getName() + " toggling world " + $world.getName() + " from " + $world.isEnabled() + " to " + newStatus);
                Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("worldName", $world.getName()), TuplesKt.to("oldStatus", $world.isEnabled()), TuplesKt.to("newStatus", newStatus)};
                this$0.debugLogger.debug("Toggle enable/disable (SHIFT click)", pairArray);
                $world.setEnabled(newStatus);
                this$0.dataManager.saveWorld($world);
                String status = $world.isEnabled() ? "enabled" : "disabled";
                $player.sendMessage(((TextComponent)Component.text("World ", (TextColor)NamedTextColor.YELLOW).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" is now " + status, (TextColor)NamedTextColor.YELLOW)));
                $player.closeInventory();
                $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminWorldBrowserGui.createWorldItem$lambda$8$lambda$7(this$0, $player, arg_0), null);
                break;
            }
            default: {
                Pair[] pairArray = new Pair[]{TuplesKt.to("clickType", event.getClick())};
                this$0.debugLogger.debug("Other click type ignored", pairArray);
            }
        }
    }

    private static final void createBackItem$lambda$10$lambda$9(AdminWorldBrowserGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening AdminMenuGui", pairArray);
        new AdminMenuGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager).open($player);
    }

    private static final void createBackItem$lambda$10(AdminWorldBrowserGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + $player.getName() + " clicked Back to Admin Menu");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Back button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminWorldBrowserGui.createBackItem$lambda$10$lambda$9(this$0, $player, arg_0), null);
    }

    private static final void createPreviousPageItem$lambda$11(AdminWorldBrowserGui this$0, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        Pair[] pairArray = event.getWhoClicked();
        Player clickedPlayer = pairArray instanceof Player ? (Player)pairArray : null;
        Player player = clickedPlayer;
        this$0.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + (player != null ? player.getName() : null) + " navigated to previous page");
        DebugLogger debugLogger = this$0.debugLogger;
        pairArray = new Pair[2];
        Object object = clickedPlayer;
        if (object == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        pairArray[0] = TuplesKt.to("player", object);
        pairArray[1] = TuplesKt.to("currentPage", $gui.getCurrentPageNum());
        debugLogger.debug("Previous page clicked", pairArray);
        $gui.previous();
    }

    private static final void createPageIndicatorItem$lambda$12(InventoryClickEvent event) {
        event.setCancelled(true);
    }

    private static final void createNextPageItem$lambda$13(AdminWorldBrowserGui this$0, PaginatedGui $gui, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($gui, "$gui");
        event.setCancelled(true);
        Pair[] pairArray = event.getWhoClicked();
        Player clickedPlayer = pairArray instanceof Player ? (Player)pairArray : null;
        Player player = clickedPlayer;
        this$0.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + (player != null ? player.getName() : null) + " navigated to next page");
        DebugLogger debugLogger = this$0.debugLogger;
        pairArray = new Pair[2];
        Object object = clickedPlayer;
        if (object == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        pairArray[0] = TuplesKt.to("player", object);
        pairArray[1] = TuplesKt.to("currentPage", $gui.getCurrentPageNum());
        debugLogger.debug("Next page clicked", pairArray);
        $gui.next();
    }

    private static final void createFilterItem$lambda$15$lambda$14(AdminWorldBrowserGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("filter", this$0.currentFilter)};
        this$0.debugLogger.debug("Refreshing GUI with new filter", pairArray);
        this$0.openWithFilter($player, null, null);
    }

    private static final void createFilterItem$lambda$15(AdminWorldBrowserGui this$0, Player $player, FilterMode $nextFilter, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter((Object)$nextFilter, "$nextFilter");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] AdminWorldBrowserGui: Admin " + $player.getName() + " changed filter from " + this$0.currentFilter + " to " + $nextFilter);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("oldFilter", this$0.currentFilter), TuplesKt.to("newFilter", $nextFilter)};
        this$0.debugLogger.debug("Filter button clicked", pairArray);
        this$0.currentFilter = $nextFilter;
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminWorldBrowserGui.createFilterItem$lambda$15$lambda$14(this$0, $player, arg_0), null);
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(AdminWorldBrowserGui $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(AdminWorldBrowserGui $this) {
        return $this.debugLogger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ltech/bedson/playerworldmanager/gui/AdminWorldBrowserGui$FilterMode;", "", "(Ljava/lang/String;I)V", "ALL", "ENABLED_ONLY", "DISABLED_ONLY", "PlayerWorldManager"})
    private static final class FilterMode
    extends Enum<FilterMode> {
        public static final /* enum */ FilterMode ALL = new FilterMode();
        public static final /* enum */ FilterMode ENABLED_ONLY = new FilterMode();
        public static final /* enum */ FilterMode DISABLED_ONLY = new FilterMode();
        private static final /* synthetic */ FilterMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FilterMode[] values() {
            return (FilterMode[])$VALUES.clone();
        }

        public static FilterMode valueOf(String value) {
            return Enum.valueOf(FilterMode.class, value);
        }

        @NotNull
        public static EnumEntries<FilterMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = filterModeArray = new FilterMode[]{FilterMode.ALL, FilterMode.ENABLED_ONLY, FilterMode.DISABLED_ONLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FilterMode.values().length];
            try {
                nArray[FilterMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterMode.ENABLED_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterMode.DISABLED_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ClickType.values().length];
            try {
                nArray[ClickType.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.SHIFT_LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickType.SHIFT_RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

