/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.gui;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.AdminWorldBrowserGui;
import tech.bedson.playerworldmanager.libs.gui.builder.gui.ChestGuiBuilder;
import tech.bedson.playerworldmanager.libs.gui.builder.item.ItemBuilder;
import tech.bedson.playerworldmanager.libs.gui.guis.Gui;
import tech.bedson.playerworldmanager.libs.gui.guis.GuiItem;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltech/bedson/playerworldmanager/gui/AdminMenuGui;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "createBrowseAllWorldsItem", "Ltech/bedson/playerworldmanager/libs/gui/guis/GuiItem;", "player", "Lorg/bukkit/entity/Player;", "createBrowseByPlayerItem", "createCloseItem", "createDisabledWorldsItem", "createPurgeInactiveItem", "createReloadPluginItem", "createSearchWorldItem", "createStatisticsItem", "open", "", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nAdminMenuGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminMenuGui.kt\ntech/bedson/playerworldmanager/gui/AdminMenuGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1774#2,4:312\n1774#2,4:316\n1774#2,4:320\n1477#2:324\n1502#2,3:325\n1505#2,3:335\n372#3,7:328\n1#4:338\n*S KotlinDebug\n*F\n+ 1 AdminMenuGui.kt\ntech/bedson/playerworldmanager/gui/AdminMenuGui\n*L\n214#1:312,4\n93#1:316,4\n94#1:320,4\n97#1:324\n97#1:325,3\n97#1:335,3\n97#1:328,7\n*E\n"})
public final class AdminMenuGui {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;

    public AdminMenuGui(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "AdminMenuGui");
    }

    public final void open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debugMethodEntry("open", pairArray);
        this.plugin.getLogger().info("[GUI] AdminMenuGui: Opening for admin player " + player.getName());
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(Component.text("World Admin Menu", (TextColor)NamedTextColor.DARK_PURPLE))).rows(4)).disableAllInteractions()).create();
        Intrinsics.checkNotNullExpressionValue(gui, "create(...)");
        Gui gui2 = gui;
        this.debugLogger.debug("Setting up Row 1: Overview");
        gui2.setItem(0, this.createStatisticsItem(player));
        gui2.setItem(1, this.createBrowseAllWorldsItem(player));
        gui2.setItem(2, this.createBrowseByPlayerItem(player));
        this.debugLogger.debug("Setting up Row 2: Quick Actions");
        gui2.setItem(9, this.createSearchWorldItem(player));
        gui2.setItem(10, this.createDisabledWorldsItem(player));
        this.debugLogger.debug("Setting up Row 3: Dangerous Actions");
        gui2.setItem(18, this.createPurgeInactiveItem(player));
        gui2.setItem(19, this.createReloadPluginItem(player));
        this.debugLogger.debug("Setting up Row 4: Navigation");
        gui2.setItem(31, this.createCloseItem());
        this.debugLogger.debug("Filling empty slots with glass panes");
        for (int i = 0; i < 36; ++i) {
            if (gui2.getGuiItem(i) != null) continue;
            gui2.setItem(i, ((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.empty())).asGuiItem());
        }
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Opening GUI for player", pairArray2);
        gui2.open((HumanEntity)player);
        DebugLogger.debugMethodExit$default(this.debugLogger, "open", null, 2, null);
    }

    private final GuiItem createStatisticsItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createStatisticsItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Click to view world statistics", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to view", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BOOK).name(Component.text("Server Statistics", (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminMenuGui.createStatisticsItem$lambda$6(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createStatisticsItem", null, 2, null);
        return item2;
    }

    private final GuiItem createBrowseAllWorldsItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createBrowseAllWorldsItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("View and manage all player worlds", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to browse", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.COMPASS).name(Component.text("Browse All Worlds", (TextColor)NamedTextColor.AQUA))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminMenuGui.createBrowseAllWorldsItem$lambda$8(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createBrowseAllWorldsItem", null, 2, null);
        return item2;
    }

    private final GuiItem createBrowseByPlayerItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createBrowseByPlayerItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("View worlds owned by a specific player", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /worldadmin player <name>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.PLAYER_HEAD).name(Component.text("Browse by Player", (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminMenuGui.createBrowseByPlayerItem$lambda$9(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createBrowseByPlayerItem", null, 2, null);
        return item2;
    }

    private final GuiItem createSearchWorldItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createSearchWorldItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Search for a world by name", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /worldadmin search <name>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.EMERALD).name(Component.text("Search World", (TextColor)NamedTextColor.GREEN))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminMenuGui.createSearchWorldItem$lambda$10(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createSearchWorldItem", null, 2, null);
        return item2;
    }

    private final GuiItem createDisabledWorldsItem(Player player) {
        int n;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createDisabledWorldsItem", pairArray);
        Pair[] $this$count$iv = (Pair[])this.dataManager.getAllWorlds();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object t : $this$count$iv) {
                PlayerWorld it = (PlayerWorld)t;
                boolean bl = false;
                if (!(!it.isEnabled()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int disabledCount = n;
        $this$count$iv = new Pair[]{TuplesKt.to("disabledCount", disabledCount)};
        this.debugLogger.debugState("DisabledWorldsItem", $this$count$iv);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("View all disabled worlds", (TextColor)NamedTextColor.GRAY), Component.text("Total disabled: " + disabledCount, (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Click to view", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.REDSTONE).name(Component.text("Disabled Worlds", (TextColor)NamedTextColor.RED))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminMenuGui.createDisabledWorldsItem$lambda$13(this, player, disabledCount, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createDisabledWorldsItem", null, 2, null);
        return item2;
    }

    private final GuiItem createPurgeInactiveItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createPurgeInactiveItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Delete worlds from inactive players", (TextColor)NamedTextColor.GRAY), Component.text("This action cannot be undone!", (TextColor)NamedTextColor.RED), Component.empty(), Component.text("Use /worldadmin purge <days>", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.TNT).name(Component.text("Purge Inactive Worlds", (TextColor)NamedTextColor.DARK_RED))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminMenuGui.createPurgeInactiveItem$lambda$14(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createPurgeInactiveItem", null, 2, null);
        return item2;
    }

    private final GuiItem createReloadPluginItem(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debugMethodEntry("createReloadPluginItem", pairArray);
        TextComponent[] textComponentArray = new TextComponent[]{Component.text("Reload plugin configuration", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text("Use /worldadmin reload", (TextColor)NamedTextColor.YELLOW)};
        GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.COMMAND_BLOCK).name(Component.text("Reload Plugin", (TextColor)NamedTextColor.GOLD))).lore(CollectionsKt.listOf(textComponentArray))).asGuiItem(arg_0 -> AdminMenuGui.createReloadPluginItem$lambda$15(this, player, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createReloadPluginItem", null, 2, null);
        return item2;
    }

    private final GuiItem createCloseItem() {
        this.debugLogger.debugMethodEntry("createCloseItem", new Pair[0]);
        GuiItem guiItem = ((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Component.text("Close", (TextColor)NamedTextColor.RED))).asGuiItem(arg_0 -> AdminMenuGui.createCloseItem$lambda$16(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiItem, "asGuiItem(...)");
        GuiItem item2 = guiItem;
        DebugLogger.debugMethodExit$default(this.debugLogger, "createCloseItem", null, 2, null);
        return item2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void createStatisticsItem$lambda$6$lambda$5(AdminMenuGui this$0, Player $player, ScheduledTask scheduledTask) {
        Map.Entry mostActive;
        Object object;
        Pair[] pairArray;
        int playerCount;
        int disabledCount;
        int enabledCount;
        List<PlayerWorld> allWorlds;
        block19: {
            block18: {
                Iterator iterator2;
                void $this$groupByTo$iv$iv;
                int n;
                Object element$iv2;
                int n2;
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($player, "$player");
                this$0.debugLogger.debug("Loading statistics data");
                allWorlds = this$0.dataManager.getAllWorlds();
                Iterable $this$count$iv = allWorlds;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv2 : $this$count$iv) {
                        PlayerWorld it = (PlayerWorld)element$iv2;
                        boolean bl = false;
                        if (!it.isEnabled() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                enabledCount = n2;
                Iterable $this$count$iv2 = allWorlds;
                boolean $i$f$count2 = false;
                if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv3 : $this$count$iv2) {
                        PlayerWorld it = (PlayerWorld)element$iv3;
                        boolean bl = false;
                        if (!(!it.isEnabled()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                disabledCount = n;
                Iterable $this$groupBy$iv = allWorlds;
                boolean $i$f$groupBy = false;
                element$iv2 = $this$groupBy$iv;
                Object destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    PlayerWorld it = (PlayerWorld)element$iv$iv;
                    boolean bl = false;
                    UUID key$iv$iv = it.getOwnerUuid();
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map ownerCounts = destination$iv$iv;
                playerCount = ownerCounts.size();
                destination$iv$iv = ownerCounts.entrySet();
                pairArray = destination$iv$iv.iterator();
                if (!pairArray.hasNext()) {
                    iterator2 = null;
                } else {
                    Iterator bl = pairArray.next();
                    if (!pairArray.hasNext()) {
                        iterator2 = bl;
                    } else {
                        Map.Entry it22 = (Map.Entry)((Object)bl);
                        boolean bl3 = false;
                        int it22 = ((List)it22.getValue()).size();
                        do {
                            Object t = pairArray.next();
                            Map.Entry it = (Map.Entry)t;
                            $i$a$-maxByOrNull-AdminMenuGui$createStatisticsItem$item$1$1$mostActive$1 = false;
                            int n3 = ((List)it.getValue()).size();
                            if (it22 >= n3) continue;
                            bl = t;
                            it22 = n3;
                        } while (pairArray.hasNext());
                        iterator2 = bl;
                    }
                }
                if ((object = (mostActive = (Map.Entry)((Object)iterator2))) == null) break block18;
                Map.Entry it = object;
                boolean bl = false;
                Object object3 = (PlayerWorld)CollectionsKt.firstOrNull((List)mostActive.getValue());
                if (object3 == null || (object3 = ((PlayerWorld)object3).getOwnerName()) == null) {
                    object3 = "Unknown";
                }
                object = object3;
                if (object3 != null) break block19;
            }
            object = "None";
        }
        Object mostActiveName = object;
        Object object4 = mostActive;
        int mostActiveCount = object4 != null && (object4 = (List)object4.getValue()) != null ? object4.size() : 0;
        pairArray = new Pair[]{TuplesKt.to("totalWorlds", allWorlds.size()), TuplesKt.to("enabledCount", enabledCount), TuplesKt.to("disabledCount", disabledCount), TuplesKt.to("playerCount", playerCount), TuplesKt.to("mostActiveName", mostActiveName), TuplesKt.to("mostActiveCount", mostActiveCount)};
        this$0.debugLogger.debugState("ServerStatistics", pairArray);
        this$0.plugin.getLogger().info("[GUI] AdminMenuGui: Statistics - Total: " + allWorlds.size() + ", Enabled: " + enabledCount + ", Disabled: " + disabledCount + ", Players: " + playerCount);
        $player.sendMessage((Component)Component.text("=== Server World Statistics ===", (TextColor)NamedTextColor.DARK_PURPLE));
        $player.sendMessage((Component)Component.text("Total Worlds: " + allWorlds.size(), (TextColor)NamedTextColor.GRAY));
        $player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Enabled: ", (TextColor)NamedTextColor.GRAY).append(Component.text(enabledCount, (TextColor)NamedTextColor.GREEN))).append(Component.text(" | ", (TextColor)NamedTextColor.GRAY))).append(Component.text("Disabled: ", (TextColor)NamedTextColor.GRAY))).append(Component.text(disabledCount, (TextColor)NamedTextColor.RED)));
        $player.sendMessage((Component)Component.text("Total Players with Worlds: " + playerCount, (TextColor)NamedTextColor.GRAY));
        $player.sendMessage(((TextComponent)Component.text("Most Active: ", (TextColor)NamedTextColor.GRAY).append(Component.text((String)mostActiveName, (TextColor)NamedTextColor.GOLD))).append(Component.text(" (" + mostActiveCount + " worlds)", (TextColor)NamedTextColor.GRAY)));
    }

    private static final void createStatisticsItem$lambda$6(AdminMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] AdminMenuGui: Admin " + $player.getName() + " clicked Server Statistics");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Statistics button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminMenuGui.createStatisticsItem$lambda$6$lambda$5(this$0, $player, arg_0), null);
    }

    private static final void createBrowseAllWorldsItem$lambda$8$lambda$7(AdminMenuGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening AdminWorldBrowserGui", pairArray);
        AdminWorldBrowserGui.open$default(new AdminWorldBrowserGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager), $player, false, 2, null);
    }

    private static final void createBrowseAllWorldsItem$lambda$8(AdminMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] AdminMenuGui: Admin " + $player.getName() + " clicked Browse All Worlds");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Browse All Worlds button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminMenuGui.createBrowseAllWorldsItem$lambda$8$lambda$7(this$0, $player, arg_0), null);
    }

    private static final void createBrowseByPlayerItem$lambda$9(AdminMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Browse by Player button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin player <name>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to browse a player's worlds", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createSearchWorldItem$lambda$10(AdminMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Search World button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin search <name>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to search for a world", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createDisabledWorldsItem$lambda$13$lambda$12(AdminMenuGui this$0, Player $player, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Opening AdminWorldBrowserGui with disabled filter", pairArray);
        new AdminWorldBrowserGui(this$0.plugin, this$0.worldManager, this$0.inviteManager, this$0.dataManager).open($player, true);
    }

    private static final void createDisabledWorldsItem$lambda$13(AdminMenuGui this$0, Player $player, int $disabledCount, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        this$0.plugin.getLogger().info("[GUI] AdminMenuGui: Admin " + $player.getName() + " clicked Disabled Worlds (count: " + $disabledCount + ")");
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName()), TuplesKt.to("disabledCount", $disabledCount)};
        this$0.debugLogger.debug("Disabled Worlds button clicked", pairArray);
        $player.closeInventory();
        $player.getScheduler().run((Plugin)this$0.plugin, arg_0 -> AdminMenuGui.createDisabledWorldsItem$lambda$13$lambda$12(this$0, $player, arg_0), null);
    }

    private static final void createPurgeInactiveItem$lambda$14(AdminMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Purge Inactive Worlds button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin purge <days>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to purge worlds from players inactive for X days", (TextColor)NamedTextColor.YELLOW)));
        $player.sendMessage((Component)Component.text("WARNING: This action cannot be undone!", (TextColor)NamedTextColor.RED));
    }

    private static final void createReloadPluginItem$lambda$15(AdminMenuGui this$0, Player $player, InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        event.setCancelled(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", $player.getName())};
        this$0.debugLogger.debug("Reload Plugin button clicked", pairArray);
        $player.closeInventory();
        $player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/worldadmin reload", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to reload the plugin configuration", (TextColor)NamedTextColor.YELLOW)));
    }

    private static final void createCloseItem$lambda$16(AdminMenuGui this$0, InventoryClickEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            event.setCancelled(true);
            Pair[] pairArray = event.getWhoClicked();
            Player clickedPlayer = pairArray instanceof Player ? (Player)pairArray : null;
            Player player = clickedPlayer;
            this$0.plugin.getLogger().info("[GUI] AdminMenuGui: Admin " + (player != null ? player.getName() : null) + " clicked Close");
            DebugLogger debugLogger = this$0.debugLogger;
            pairArray = new Pair[1];
            Object object = clickedPlayer;
            if (object == null || (object = object.getName()) == null) {
                object = "unknown";
            }
            pairArray[0] = TuplesKt.to("player", object);
            debugLogger.debug("Close button clicked", pairArray);
            Player player2 = clickedPlayer;
            if (player2 == null) break block1;
            player2.closeInventory();
        }
    }
}

