/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.commands.WorldCommands;
import tech.bedson.playerworldmanager.gui.MainMenuGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.BackupManager;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.BackupSchedule;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldBackup;
import tech.bedson.playerworldmanager.models.WorldInvite;
import tech.bedson.playerworldmanager.models.WorldRole;
import tech.bedson.playerworldmanager.models.WorldType;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u001bH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0016\u0010&\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010)\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010*\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010+\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010,\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010-\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010.\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010/\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00100\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00101\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00102\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00103\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00104\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00105\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00106\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00107\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00108\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u00109\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010:\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010;\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010<\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010=\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010>\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010?\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010@\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010A\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010B\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010C\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010D\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010E\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010F\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010G\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010H\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010I\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010J\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010K\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010L\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010M\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010N\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0016\u0010O\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J\u0012\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\u001bH\u0002J\u0012\u0010S\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\u001bH\u0002J\u0012\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020\u001bH\u0002J\u0016\u0010W\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0002J$\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010]\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010^\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010_\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010`\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010a\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010b\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010c\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010d\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010e\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002J$\u0010f\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(2\u0006\u0010[\u001a\u00020\\H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Ltech/bedson/playerworldmanager/commands/WorldCommands;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "backupManager", "Ltech/bedson/playerworldmanager/managers/BackupManager;", "mainMenuGui", "Ltech/bedson/playerworldmanager/gui/MainMenuGui;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/managers/BackupManager;Ltech/bedson/playerworldmanager/gui/MainMenuGui;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "build", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "createBackupForWorld", "", "player", "Lorg/bukkit/entity/Player;", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "description", "", "displayWorldMembers", "", "findBackupByPartialId", "Ltech/bedson/playerworldmanager/models/WorldBackup;", "partialId", "getCurrentOwnedWorld", "getCurrentWorld", "getPlayerWorld", "name", "getWorldWithPermission", "handleAccept", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "handleBackupCreate", "handleBackupCreateWithDescription", "handleBackupCreateWithWorld", "handleBackupDelete", "handleBackupHelp", "handleBackupList", "handleBackupListWorld", "handleBackupRestore", "handleBackupScheduleDisable", "handleBackupScheduleEnable", "handleBackupScheduleEnableWithInterval", "handleBackupScheduleStatus", "handleBrowse", "handleCreate", "handleCreateWithSeed", "handleCreateWithType", "handleDelete", "handleDeny", "handleHelp", "handleInvite", "handleInviteWithWorld", "handleInvites", "handleKick", "handleKickWithWorld", "handleLeave", "handleList", "handleMembers", "handleMembersWithWorld", "handleMenu", "handlePublicRole", "handlePublicRoleWithWorld", "handleRole", "handleRoleWithWorld", "handleSpawn", "handleTeleport", "handleTransfer", "handleVisibility", "handleVisibilityWithWorld", "handleVisit", "parsePublicRole", "Ltech/bedson/playerworldmanager/models/WorldRole;", "role", "parseRole", "parseWorldType", "Ltech/bedson/playerworldmanager/models/WorldType;", "type", "sendPlayerOnlyError", "suggestBackupIds", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "suggestInviteOwners", "suggestInviteWorlds", "suggestOnlinePlayers", "suggestOwnedWorlds", "suggestOwnerWorlds", "suggestPlayersWithWorlds", "suggestPublicRoles", "suggestRoles", "suggestWorldMembers", "suggestWorldTypes", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nWorldCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldCommands.kt\ntech/bedson/playerworldmanager/commands/WorldCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2414:1\n1549#2:2415\n1620#2,3:2416\n1855#2,2:2419\n288#2,2:2421\n288#2,2:2423\n288#2,2:2425\n1549#2:2427\n1620#2,3:2428\n1855#2,2:2431\n1855#2,2:2433\n1855#2,2:2435\n288#2,2:2437\n766#2:2442\n857#2,2:2443\n1855#2,2:2445\n766#2:2447\n857#2,2:2448\n1855#2,2:2450\n1549#2:2452\n1620#2,3:2453\n766#2:2456\n857#2,2:2457\n1855#2,2:2459\n766#2:2461\n857#2,2:2462\n1549#2:2464\n1620#2,3:2465\n766#2:2468\n857#2,2:2469\n1855#2,2:2471\n1549#2:2473\n1620#2,3:2474\n766#2:2477\n857#2,2:2478\n1855#2,2:2480\n1549#2:2482\n1620#2,3:2483\n766#2:2486\n857#2,2:2487\n1855#2,2:2489\n1549#2:2491\n1620#2,3:2492\n766#2:2495\n857#2,2:2496\n1855#2,2:2498\n766#2:2500\n857#2,2:2501\n1549#2:2503\n1620#2,3:2504\n766#2:2507\n857#2,2:2508\n1855#2,2:2510\n1603#2,9:2512\n1855#2:2521\n1856#2:2523\n1612#2:2524\n766#2:2525\n857#2,2:2526\n1855#2,2:2528\n766#2:2530\n857#2,2:2531\n1855#2,2:2533\n766#2:2535\n857#2,2:2536\n1855#2,2:2538\n1549#2:2540\n1620#2,3:2541\n766#2:2544\n857#2,2:2545\n1855#2,2:2547\n288#2,2:2549\n288#2,2:2551\n288#2,2:2553\n215#3:2439\n216#3:2441\n1#4:2440\n1#4:2522\n*S KotlinDebug\n*F\n+ 1 WorldCommands.kt\ntech/bedson/playerworldmanager/commands/WorldCommands\n*L\n528#1:2415\n528#1:2416,3\n530#1:2419,2\n652#1:2421,2\n925#1:2423,2\n987#1:2425,2\n1087#1:2427\n1087#1:2428,3\n1089#1:2431,2\n1440#1:2433,2\n1489#1:2435,2\n1740#1:2437,2\n2076#1:2442\n2076#1:2443,2\n2084#1:2445,2\n2116#1:2447\n2116#1:2448,2\n2117#1:2450,2\n2132#1:2452\n2132#1:2453,3\n2133#1:2456\n2133#1:2457,2\n2134#1:2459,2\n2144#1:2461\n2144#1:2462,2\n2145#1:2464\n2145#1:2465,3\n2146#1:2468\n2146#1:2469,2\n2147#1:2471,2\n2158#1:2473\n2158#1:2474,3\n2159#1:2477\n2159#1:2478,2\n2160#1:2480,2\n2169#1:2482\n2169#1:2483,3\n2170#1:2486\n2170#1:2487,2\n2171#1:2489,2\n2182#1:2491\n2182#1:2492,3\n2184#1:2495\n2184#1:2496,2\n2185#1:2498,2\n2198#1:2500\n2198#1:2501,2\n2199#1:2503\n2199#1:2504,3\n2200#1:2507\n2200#1:2508,2\n2201#1:2510,2\n2216#1:2512,9\n2216#1:2521\n2216#1:2523\n2216#1:2524\n2217#1:2525\n2217#1:2526,2\n2218#1:2528,2\n2229#1:2530\n2229#1:2531,2\n2230#1:2533,2\n2239#1:2535\n2239#1:2536,2\n2240#1:2538,2\n2251#1:2540\n2251#1:2541,3\n2252#1:2544\n2252#1:2545,2\n2253#1:2547,2\n2274#1:2549,2\n2386#1:2551,2\n2394#1:2553,2\n2049#1:2439\n2049#1:2441\n2216#1:2522\n*E\n"})
public final class WorldCommands {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final BackupManager backupManager;
    @NotNull
    private final MainMenuGui mainMenuGui;
    @NotNull
    private final DebugLogger debugLogger;

    public WorldCommands(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager, @NotNull BackupManager backupManager, @NotNull MainMenuGui mainMenuGui) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(backupManager, "backupManager");
        Intrinsics.checkNotNullParameter(mainMenuGui, "mainMenuGui");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.backupManager = backupManager;
        this.mainMenuGui = mainMenuGui;
        this.debugLogger = new DebugLogger(this.plugin, "WorldCommands");
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> build() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"world").then(((LiteralArgumentBuilder)Commands.literal((String)"create").requires(WorldCommands::build$lambda$0)).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.word())).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestWorldTypes).then(Commands.argument((String)"seed", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(this::handleCreateWithSeed))).executes(this::handleCreateWithType))).executes(this::handleCreate)))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleDelete)))).then(Commands.literal((String)"list").executes(this::handleList))).then(Commands.literal((String)"tp").then(Commands.argument((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleTeleport)))).then(Commands.literal((String)"visit").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnerWorlds).executes(this::handleVisit))))).then(Commands.literal((String)"invite").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOnlinePlayers).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleInviteWithWorld))).executes(this::handleInvite)))).then(Commands.literal((String)"kick").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOnlinePlayers).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleKickWithWorld))).executes(this::handleKick)))).then(Commands.literal((String)"accept").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestInviteOwners).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestInviteWorlds).executes(this::handleAccept))))).then(Commands.literal((String)"deny").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestInviteOwners).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestInviteWorlds).executes(this::handleDeny))))).then(Commands.literal((String)"transfer").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOnlinePlayers).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleTransfer))))).then(Commands.literal((String)"invites").executes(this::handleInvites))).then(Commands.literal((String)"leave").executes(this::handleLeave))).then(Commands.literal((String)"spawn").executes(this::handleSpawn))).then(Commands.literal((String)"menu").executes(this::handleMenu))).then(Commands.literal((String)"help").executes(this::handleHelp))).then(Commands.literal((String)"role").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestWorldMembers).then(((RequiredArgumentBuilder)Commands.argument((String)"role", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestRoles).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleRoleWithWorld))).executes(this::handleRole))))).then(((LiteralArgumentBuilder)Commands.literal((String)"visibility").then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleVisibilityWithWorld))).executes(this::handleVisibility))).then(Commands.literal((String)"publicrole").then(((RequiredArgumentBuilder)Commands.argument((String)"role", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPublicRoles).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handlePublicRoleWithWorld))).executes(this::handlePublicRole)))).then(((LiteralArgumentBuilder)Commands.literal((String)"members").then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleMembersWithWorld))).executes(this::handleMembers))).then(Commands.literal((String)"browse").executes(this::handleBrowse))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"backup").requires(WorldCommands::build$lambda$1)).then(((LiteralArgumentBuilder)Commands.literal((String)"create").then(((RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).then(Commands.argument((String)"description", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(this::handleBackupCreateWithDescription))).executes(this::handleBackupCreateWithWorld))).executes(this::handleBackupCreate))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleBackupListWorld))).executes(this::handleBackupList))).then(Commands.literal((String)"restore").then(Commands.argument((String)"backup-id", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestBackupIds).executes(this::handleBackupRestore)))).then(Commands.literal((String)"delete").then(Commands.argument((String)"backup-id", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestBackupIds).executes(this::handleBackupDelete)))).then(Commands.literal((String)"schedule").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).then(((LiteralArgumentBuilder)Commands.literal((String)"enable").then(Commands.argument((String)"interval", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(this::handleBackupScheduleEnableWithInterval))).executes(this::handleBackupScheduleEnable))).then(Commands.literal((String)"disable").executes(this::handleBackupScheduleDisable))).then(Commands.literal((String)"status").executes(this::handleBackupScheduleStatus))))).executes(this::handleBackupHelp))).executes(this::handleMenu)).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final int handleCreate(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleCreate", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleCreate: Executing world create command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleCreate", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String name = StringArgumentType.getString(ctx, (String)"name");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("name", name), TuplesKt.to("type", "NORMAL"), TuplesKt.to("seed", null)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        this.plugin.getLogger().info("[WorldCommands] handleCreate: Player " + player.getName() + " creating world '" + name + "' with type NORMAL");
        player.sendMessage((Component)Component.text("Creating world...", (TextColor)NamedTextColor.YELLOW));
        pairArray3 = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("name", name), TuplesKt.to("type", "NORMAL")};
        this.debugLogger.debug("Calling worldManager.createWorld", pairArray3);
        Intrinsics.checkNotNull(name);
        this.worldManager.createWorld(player, name, WorldType.NORMAL, null).thenAccept(arg_0 -> WorldCommands.handleCreate$lambda$2(new Function1<Result<? extends PlayerWorld>, Unit>(this, player, name){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$name = $name;
                super(1);
            }

            public final void invoke(Result<? extends PlayerWorld> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    WorldCommands worldCommands = this.this$0;
                    Object object2 = this.$player;
                    if (Result.isSuccess-impl(object)) {
                        PlayerWorld world = (PlayerWorld)object;
                        boolean bl = false;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
                        WorldCommands.access$getDebugLogger$p(worldCommands).debug("World creation succeeded", pairArray);
                        WorldCommands.access$getPlugin$p(worldCommands).getLogger().info("[WorldCommands] handleCreate: World '" + world.getName() + "' created successfully for " + object2.getName());
                        object2.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleCreate.1.invoke$lambda$1$lambda$0((Player)object2, world, arg_0), null);
                    }
                    worldCommands = this.this$0;
                    object2 = this.$name;
                    Player player = this.$player;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to("error", error.getMessage())};
                    WorldCommands.access$getDebugLogger$p(worldCommands).debug("World creation failed", pairArray);
                    WorldCommands.access$getPlugin$p(worldCommands).getLogger().warning("[WorldCommands] handleCreate: Failed to create world '" + (String)object2 + "' for " + player.getName() + ": " + error.getMessage());
                    player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleCreate.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($world, "$world");
                $player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("World '", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("' created! Use ", (TextColor)NamedTextColor.GREEN))).append(Component.text("/world tp " + $world.getName(), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" to visit it.", (TextColor)NamedTextColor.GREEN)));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($error, "$error");
                TextComponent textComponent = Component.text("Failed to create world: ", (TextColor)NamedTextColor.RED);
                String string = $error.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                $player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleCreate", 1);
        return 1;
    }

    private final int handleCreateWithType(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleCreateWithType", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleCreateWithType: Executing world create command with type");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleCreateWithType", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String name = StringArgumentType.getString(ctx, (String)"name");
        String typeString = StringArgumentType.getString(ctx, (String)"type");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("name", name), TuplesKt.to("typeString", typeString)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        this.plugin.getLogger().info("[WorldCommands] handleCreateWithType: Player " + player.getName() + " creating world '" + name + "' with type '" + typeString + "'");
        Intrinsics.checkNotNull(typeString);
        WorldType worldType = this.parseWorldType(typeString);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("typeString", typeString), TuplesKt.to("worldType", worldType)};
        this.debugLogger.debug("Parsed world type", pairArray4);
        if (worldType == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleCreateWithType: Invalid world type '" + typeString + "' provided by " + player.getName());
            player.sendMessage(Component.text("Invalid world type. Valid types: ", (TextColor)NamedTextColor.RED).append(Component.text("normal, flat, amplified, large_biomes, void", (TextColor)NamedTextColor.GOLD)));
            this.debugLogger.debugMethodExit("handleCreateWithType", "invalid world type");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleCreateWithType: Starting async world creation for " + player.getName());
        player.sendMessage((Component)Component.text("Creating world...", (TextColor)NamedTextColor.YELLOW));
        pairArray4 = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("name", name), TuplesKt.to("type", worldType)};
        this.debugLogger.debug("Calling worldManager.createWorld", pairArray4);
        Intrinsics.checkNotNull(name);
        this.worldManager.createWorld(player, name, worldType, null).thenAccept(arg_0 -> WorldCommands.handleCreateWithType$lambda$3(new Function1<Result<? extends PlayerWorld>, Unit>(this, player, name){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$name = $name;
                super(1);
            }

            public final void invoke(Result<? extends PlayerWorld> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    WorldCommands worldCommands = this.this$0;
                    Object object2 = this.$player;
                    if (Result.isSuccess-impl(object)) {
                        PlayerWorld world = (PlayerWorld)object;
                        boolean bl = false;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
                        WorldCommands.access$getDebugLogger$p(worldCommands).debug("World creation succeeded", pairArray);
                        WorldCommands.access$getPlugin$p(worldCommands).getLogger().info("[WorldCommands] handleCreateWithType: World '" + world.getName() + "' created successfully for " + object2.getName());
                        object2.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleCreateWithType.1.invoke$lambda$1$lambda$0((Player)object2, world, arg_0), null);
                    }
                    worldCommands = this.this$0;
                    object2 = this.$name;
                    Player player = this.$player;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to("error", error.getMessage())};
                    WorldCommands.access$getDebugLogger$p(worldCommands).debug("World creation failed", pairArray);
                    WorldCommands.access$getPlugin$p(worldCommands).getLogger().warning("[WorldCommands] handleCreateWithType: Failed to create world '" + (String)object2 + "' for " + player.getName() + ": " + error.getMessage());
                    player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleCreateWithType.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($world, "$world");
                $player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("World '", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("' created! Use ", (TextColor)NamedTextColor.GREEN))).append(Component.text("/world tp " + $world.getName(), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" to visit it.", (TextColor)NamedTextColor.GREEN)));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($error, "$error");
                TextComponent textComponent = Component.text("Failed to create world: ", (TextColor)NamedTextColor.RED);
                String string = $error.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                $player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleCreateWithType", 1);
        return 1;
    }

    private final int handleCreateWithSeed(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleCreateWithSeed", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleCreateWithSeed: Executing world create command with seed");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleCreateWithSeed", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String name = StringArgumentType.getString(ctx, (String)"name");
        String typeString = StringArgumentType.getString(ctx, (String)"type");
        String seedString = StringArgumentType.getString(ctx, (String)"seed");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("name", name), TuplesKt.to("typeString", typeString), TuplesKt.to("seedString", seedString)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        this.plugin.getLogger().info("[WorldCommands] handleCreateWithSeed: Player " + player.getName() + " creating world '" + name + "' with type '" + typeString + "' and seed '" + seedString + "'");
        Intrinsics.checkNotNull(typeString);
        WorldType worldType = this.parseWorldType(typeString);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("typeString", typeString), TuplesKt.to("worldType", worldType)};
        this.debugLogger.debug("Parsed world type", pairArray4);
        if (worldType == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleCreateWithSeed: Invalid world type '" + typeString + "' provided by " + player.getName());
            player.sendMessage(Component.text("Invalid world type. Valid types: ", (TextColor)NamedTextColor.RED).append(Component.text("normal, flat, amplified, large_biomes, void", (TextColor)NamedTextColor.GOLD)));
            this.debugLogger.debugMethodExit("handleCreateWithSeed", "invalid world type");
            return 1;
        }
        Intrinsics.checkNotNull(seedString);
        Long seed = StringsKt.toLongOrNull(seedString);
        Pair[] pairArray5 = new Pair[]{TuplesKt.to("seedString", seedString), TuplesKt.to("seed", seed)};
        this.debugLogger.debug("Parsed seed", pairArray5);
        if (seed == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleCreateWithSeed: Invalid seed '" + seedString + "' provided by " + player.getName());
            player.sendMessage((Component)Component.text("Invalid seed. Must be a number", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleCreateWithSeed", "invalid seed");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleCreateWithSeed: Starting async world creation for " + player.getName() + " with seed " + seed);
        player.sendMessage((Component)Component.text("Creating world...", (TextColor)NamedTextColor.YELLOW));
        pairArray5 = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("name", name), TuplesKt.to("type", worldType), TuplesKt.to("seed", seed)};
        this.debugLogger.debug("Calling worldManager.createWorld", pairArray5);
        Intrinsics.checkNotNull(name);
        this.worldManager.createWorld(player, name, worldType, seed).thenAccept(arg_0 -> WorldCommands.handleCreateWithSeed$lambda$4(new Function1<Result<? extends PlayerWorld>, Unit>(this, seed, player, name){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ Long $seed;
            final /* synthetic */ Player $player;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$seed = $seed;
                this.$player = $player;
                this.$name = $name;
                super(1);
            }

            public final void invoke(Result<? extends PlayerWorld> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    WorldCommands worldCommands = this.this$0;
                    Object object2 = this.$seed;
                    Player player = this.$player;
                    if (Result.isSuccess-impl(object)) {
                        PlayerWorld world = (PlayerWorld)object;
                        boolean bl = false;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("seed", object2)};
                        WorldCommands.access$getDebugLogger$p(worldCommands).debug("World creation succeeded", pairArray);
                        WorldCommands.access$getPlugin$p(worldCommands).getLogger().info("[WorldCommands] handleCreateWithSeed: World '" + world.getName() + "' created successfully for " + player.getName());
                        player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleCreateWithSeed.1.invoke$lambda$1$lambda$0(player, world, arg_0), null);
                    }
                    worldCommands = this.this$0;
                    object2 = this.$name;
                    player = this.$player;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to("error", error.getMessage())};
                    WorldCommands.access$getDebugLogger$p(worldCommands).debug("World creation failed", pairArray);
                    WorldCommands.access$getPlugin$p(worldCommands).getLogger().warning("[WorldCommands] handleCreateWithSeed: Failed to create world '" + (String)object2 + "' for " + player.getName() + ": " + error.getMessage());
                    player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleCreateWithSeed.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($world, "$world");
                $player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("World '", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("' created! Use ", (TextColor)NamedTextColor.GREEN))).append(Component.text("/world tp " + $world.getName(), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" to visit it.", (TextColor)NamedTextColor.GREEN)));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($error, "$error");
                TextComponent textComponent = Component.text("Failed to create world: ", (TextColor)NamedTextColor.RED);
                String string = $error.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                $player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleCreateWithSeed", 1);
        return 1;
    }

    private final int handleDelete(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleDelete", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleDelete: Executing world delete command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleDelete", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String name = StringArgumentType.getString(ctx, (String)"name");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("name", name)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        this.plugin.getLogger().info("[WorldCommands] handleDelete: Player " + player.getName() + " attempting to delete world '" + name + "'");
        Intrinsics.checkNotNull(name);
        PlayerWorld world = this.getPlayerWorld(player, name);
        Pair[] pairArray4 = new Pair[3];
        pairArray4[0] = TuplesKt.to("worldName", name);
        pairArray4[1] = TuplesKt.to("found", world != null);
        PlayerWorld playerWorld = world;
        pairArray4[2] = TuplesKt.to("worldId", playerWorld != null ? playerWorld.getId() : null);
        this.debugLogger.debug("World lookup result", pairArray4);
        if (world == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleDelete: Player " + player.getName() + " does not own world '" + name + "'");
            this.debugLogger.debugMethodExit("handleDelete", "world not found");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleDelete: Starting async world deletion for " + player.getName());
        player.sendMessage((Component)Component.text("Deleting world...", (TextColor)NamedTextColor.YELLOW));
        pairArray4 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debug("Calling worldManager.deleteWorld", pairArray4);
        this.worldManager.deleteWorld(world).thenAccept(arg_0 -> WorldCommands.handleDelete$lambda$5(new Function1<Result<? extends Unit>, Unit>(this, name, player){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Player $player;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$player = $player;
                super(1);
            }

            public final void invoke(Result<? extends Unit> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    WorldCommands worldCommands = this.this$0;
                    String string = this.$name;
                    Player player = this.$player;
                    if (Result.isSuccess-impl(object)) {
                        Unit it = (Unit)object;
                        boolean bl = false;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", string)};
                        WorldCommands.access$getDebugLogger$p(worldCommands).debug("World deletion succeeded", pairArray);
                        WorldCommands.access$getPlugin$p(worldCommands).getLogger().info("[WorldCommands] handleDelete: World '" + string + "' deleted successfully for " + player.getName());
                        player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleDelete.1.invoke$lambda$1$lambda$0(player, string, arg_0), null);
                    }
                    worldCommands = this.this$0;
                    string = this.$name;
                    player = this.$player;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", string), TuplesKt.to("error", error.getMessage())};
                    WorldCommands.access$getDebugLogger$p(worldCommands).debug("World deletion failed", pairArray);
                    WorldCommands.access$getPlugin$p(worldCommands).getLogger().warning("[WorldCommands] handleDelete: Failed to delete world '" + string + "' for " + player.getName() + ": " + error.getMessage());
                    player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleDelete.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, String $name, ScheduledTask scheduledTask) {
                $player.sendMessage(((TextComponent)Component.text("World '", (TextColor)NamedTextColor.GREEN).append(Component.text($name, (TextColor)NamedTextColor.GOLD))).append(Component.text("' deleted successfully!", (TextColor)NamedTextColor.GREEN)));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($error, "$error");
                TextComponent textComponent = Component.text("Failed to delete world: ", (TextColor)NamedTextColor.RED);
                String string = $error.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                $player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleDelete", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int handleList(CommandContext<CommandSourceStack> ctx) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleList", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleList: Executing world list command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleList", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        this.plugin.getLogger().info("[WorldCommands] handleList: Player " + player.getName() + " listing their worlds");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<PlayerWorld> worlds = this.dataManager.getWorldsByOwner(uUID);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldCount", worlds.size())};
        this.debugLogger.debug("Retrieved worlds", pairArray3);
        if (worlds.isEmpty()) {
            this.plugin.getLogger().info("[WorldCommands] handleList: Player " + player.getName() + " has no worlds");
            player.sendMessage((Component)Component.text("You don't own any worlds", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handleList", "no worlds");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleList: Player " + player.getName() + " has " + worlds.size() + " world(s)");
        pairArray3 = new Pair[1];
        Iterable iterable = worlds;
        String string = "worldNames";
        int n = 0;
        Pair[] pairArray4 = pairArray3;
        String string2 = "Displaying worlds";
        DebugLogger debugLogger = this.debugLogger;
        boolean $i$f$map = false;
        void var7_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        pairArray4[n] = TuplesKt.to(string, collection);
        debugLogger.debug(string2, pairArray3);
        player.sendMessage((Component)Component.text("Your worlds:", (TextColor)NamedTextColor.GREEN));
        Iterable $this$forEach$iv = worlds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            TextComponent textComponent = (TextComponent)((TextComponent)Component.text("  - ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" (", (TextColor)NamedTextColor.GRAY));
            String string3 = world.getWorldType().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            player.sendMessage(((TextComponent)textComponent.append(Component.text(string3, (TextColor)NamedTextColor.YELLOW))).append(Component.text(")", (TextColor)NamedTextColor.GRAY)));
        }
        this.plugin.getLogger().info("[WorldCommands] handleList: Command completed successfully for " + player.getName());
        this.debugLogger.debugMethodExit("handleList", 1);
        return 1;
    }

    private final int handleTeleport(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleTeleport", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleTeleport: Executing world teleport command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleTeleport", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String name = StringArgumentType.getString(ctx, (String)"name");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("name", name)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        this.plugin.getLogger().info("[WorldCommands] handleTeleport: Player " + player.getName() + " attempting to teleport to world '" + name + "'");
        boolean isDefaultWorld = StringsKt.equals(name, "default", true);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("name", name), TuplesKt.to("isDefault", isDefaultWorld)};
        this.debugLogger.debug("Default world check", pairArray4);
        if (isDefaultWorld) {
            this.plugin.getLogger().info("[WorldCommands] handleTeleport: Player " + player.getName() + " teleporting to default (vanilla) world");
            player.sendMessage((Component)Component.text("Teleporting to spawn...", (TextColor)NamedTextColor.YELLOW));
            pairArray4 = new Pair[]{TuplesKt.to("player", player.getName())};
            this.debugLogger.debug("Calling worldManager.teleportToVanillaWorld", pairArray4);
            this.worldManager.teleportToVanillaWorld(player).thenAccept(arg_0 -> WorldCommands.handleTeleport$lambda$8(new Function1<Boolean, Unit>(this, player){
                final /* synthetic */ WorldCommands this$0;
                final /* synthetic */ Player $player;
                {
                    this.this$0 = $receiver;
                    this.$player = $player;
                    super(1);
                }

                public final void invoke(Boolean success) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to("success", success)};
                    WorldCommands.access$getDebugLogger$p(this.this$0).debug("Vanilla world teleport result", pairArray);
                    this.$player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(this.this$0), arg_0 -> handleTeleport.1.invoke$lambda$0(success, this.this$0, this.$player, arg_0), null);
                }

                private static final void invoke$lambda$0(Boolean $success, WorldCommands this$0, Player $player, ScheduledTask scheduledTask) {
                    Intrinsics.checkNotNullParameter(this$0, "this$0");
                    Intrinsics.checkNotNull($success);
                    if ($success.booleanValue()) {
                        WorldCommands.access$getPlugin$p(this$0).getLogger().info("[WorldCommands] handleTeleport: Player " + $player.getName() + " teleported successfully to default world");
                        $player.sendMessage((Component)Component.text("Teleported to spawn", (TextColor)NamedTextColor.GREEN));
                    } else {
                        WorldCommands.access$getPlugin$p(this$0).getLogger().warning("[WorldCommands] handleTeleport: Failed to teleport " + $player.getName() + " to default world");
                        $player.sendMessage((Component)Component.text("Failed to teleport to spawn", (TextColor)NamedTextColor.RED));
                    }
                }
            }, arg_0));
            this.debugLogger.debugMethodExit("handleTeleport", "default world teleport initiated");
            return 1;
        }
        Intrinsics.checkNotNull(name);
        PlayerWorld world = this.getPlayerWorld(player, name);
        Pair[] pairArray5 = new Pair[3];
        pairArray5[0] = TuplesKt.to("worldName", name);
        pairArray5[1] = TuplesKt.to("found", world != null);
        PlayerWorld playerWorld = world;
        pairArray5[2] = TuplesKt.to("worldId", playerWorld != null ? playerWorld.getId() : null);
        this.debugLogger.debug("World lookup result", pairArray5);
        if (world == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleTeleport: Player " + player.getName() + " does not own world '" + name + "'");
            this.debugLogger.debugMethodExit("handleTeleport", "world not found");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleTeleport: Starting async teleport for " + player.getName() + " to world '" + name + "'");
        player.sendMessage((Component)Component.text("Teleporting...", (TextColor)NamedTextColor.YELLOW));
        pairArray5 = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debug("Calling worldManager.teleportToWorld", pairArray5);
        this.worldManager.teleportToWorld(player, world).thenAccept(arg_0 -> WorldCommands.handleTeleport$lambda$9(new Function1<Boolean, Unit>(this, world, player, name){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ PlayerWorld $world;
            final /* synthetic */ Player $player;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$world = $world;
                this.$player = $player;
                this.$name = $name;
                super(1);
            }

            public final void invoke(Boolean success) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("success", success), TuplesKt.to("worldName", this.$world.getName())};
                WorldCommands.access$getDebugLogger$p(this.this$0).debug("Plugin world teleport result", pairArray);
                this.$player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(this.this$0), arg_0 -> handleTeleport.2.invoke$lambda$0(success, this.this$0, this.$player, this.$name, this.$world, arg_0), null);
            }

            private static final void invoke$lambda$0(Boolean $success, WorldCommands this$0, Player $player, String $name, PlayerWorld $world, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNull($success);
                if ($success.booleanValue()) {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().info("[WorldCommands] handleTeleport: Player " + $player.getName() + " teleported successfully to '" + $name + "'");
                    $player.sendMessage(Component.text("Teleported to ", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
                } else {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().warning("[WorldCommands] handleTeleport: Failed to teleport " + $player.getName() + " to '" + $name + "'");
                    $player.sendMessage((Component)Component.text("Failed to teleport to world", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleTeleport", 1);
        return 1;
    }

    private final int handleVisit(CommandContext<CommandSourceStack> ctx) {
        Object v3;
        Pair[] $this$firstOrNull$iv;
        OfflinePlayer owner;
        String worldName;
        String ownerName;
        Player player;
        block5: {
            Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
            this.debugLogger.debugMethodEntry("handleVisit", pairArray);
            this.plugin.getLogger().info("[WorldCommands] handleVisit: Executing world visit command");
            Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
            player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
            pairArray2 = new Pair[2];
            pairArray2[0] = TuplesKt.to("isPlayer", player != null);
            Player player2 = player;
            pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
            this.debugLogger.debug("Player check", pairArray2);
            if (player == null) {
                this.debugLogger.debugMethodExit("handleVisit", "player-only error");
                return this.sendPlayerOnlyError(ctx);
            }
            ownerName = StringArgumentType.getString(ctx, (String)"owner");
            worldName = StringArgumentType.getString(ctx, (String)"name");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("worldName", worldName)};
            this.debugLogger.debug("Parsed arguments", pairArray3);
            this.plugin.getLogger().info("[WorldCommands] handleVisit: Player " + player.getName() + " attempting to visit world '" + worldName + "' owned by '" + ownerName + "'");
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)ownerName);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            owner = offlinePlayer;
            boolean ownerExists = owner.hasPlayedBefore() || owner.isOnline();
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("exists", ownerExists)};
            this.debugLogger.debug("Owner lookup", pairArray4);
            if (!ownerExists) {
                this.plugin.getLogger().warning("[WorldCommands] handleVisit: Owner '" + ownerName + "' not found");
                player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(ownerName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
                this.debugLogger.debugMethodExit("handleVisit", "owner not found");
                return 1;
            }
            UUID uUID = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                PlayerWorld it = (PlayerWorld)t;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), worldName, true)) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        PlayerWorld world = v3;
        $this$firstOrNull$iv = new Pair[]{TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("worldName", worldName), TuplesKt.to("found", world != null)};
        this.debugLogger.debug("World lookup", $this$firstOrNull$iv);
        if (world == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleVisit: World '" + worldName + "' not found for owner '" + ownerName + "'");
            player.sendMessage(((TextComponent)Component.text(ownerName + " doesn't own a world named '", (TextColor)NamedTextColor.RED).append(Component.text(worldName, (TextColor)NamedTextColor.GOLD))).append(Component.text("'", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleVisit", "world not found");
            return 1;
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        boolean hasAccess = this.inviteManager.hasAccess(uUID, world);
        Pair[] pairArray = new Pair[]{TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("hasAccess", hasAccess)};
        this.debugLogger.debug("Access check", pairArray);
        if (!hasAccess) {
            this.plugin.getLogger().warning("[WorldCommands] handleVisit: Player " + player.getName() + " does not have access to world '" + worldName + "'");
            player.sendMessage((Component)Component.text("You don't have access to this world", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleVisit", "no access");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleVisit: Starting async teleport for " + player.getName() + " to '" + worldName + "'");
        player.sendMessage((Component)Component.text("Teleporting...", (TextColor)NamedTextColor.YELLOW));
        pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debug("Calling worldManager.teleportToWorld", pairArray);
        this.worldManager.teleportToWorld(player, world).thenAccept(arg_0 -> WorldCommands.handleVisit$lambda$11(new Function1<Boolean, Unit>(this, world, player, worldName){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ PlayerWorld $world;
            final /* synthetic */ Player $player;
            final /* synthetic */ String $worldName;
            {
                this.this$0 = $receiver;
                this.$world = $world;
                this.$player = $player;
                this.$worldName = $worldName;
                super(1);
            }

            public final void invoke(Boolean success) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("success", success), TuplesKt.to("worldName", this.$world.getName())};
                WorldCommands.access$getDebugLogger$p(this.this$0).debug("Visit teleport result", pairArray);
                this.$player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(this.this$0), arg_0 -> handleVisit.1.invoke$lambda$0(success, this.this$0, this.$player, this.$worldName, this.$world, arg_0), null);
            }

            private static final void invoke$lambda$0(Boolean $success, WorldCommands this$0, Player $player, String $worldName, PlayerWorld $world, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNull($success);
                if ($success.booleanValue()) {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().info("[WorldCommands] handleVisit: Player " + $player.getName() + " teleported successfully to '" + $worldName + "'");
                    $player.sendMessage(Component.text("Teleported to ", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
                } else {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().warning("[WorldCommands] handleVisit: Failed to teleport " + $player.getName() + " to '" + $worldName + "'");
                    $player.sendMessage((Component)Component.text("Failed to teleport to world", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleVisit", 1);
        return 1;
    }

    private final int handleInvite(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleInvite", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleInvite: Executing world invite command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleInvite", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("targetName", targetName)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        this.plugin.getLogger().info("[WorldCommands] handleInvite: Player " + player.getName() + " attempting to invite '" + targetName + "'");
        Player target = Bukkit.getPlayer((String)targetName);
        Pair[] pairArray4 = new Pair[3];
        pairArray4[0] = TuplesKt.to("targetName", targetName);
        pairArray4[1] = TuplesKt.to("isOnline", target != null);
        Player player3 = target;
        pairArray4[2] = TuplesKt.to("targetUuid", player3 != null ? player3.getUniqueId() : null);
        this.debugLogger.debug("Target player lookup", pairArray4);
        if (target == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleInvite: Target player '" + targetName + "' is not online");
            player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' is not online", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleInvite", "target not online");
            return 1;
        }
        PlayerWorld world = this.getCurrentWorld(player);
        Object object = new Pair[3];
        object[0] = TuplesKt.to("playerWorld", player.getWorld().getName());
        PlayerWorld playerWorld = world;
        object[1] = TuplesKt.to("ownedWorld", playerWorld != null ? playerWorld.getName() : null);
        PlayerWorld playerWorld2 = world;
        object[2] = TuplesKt.to("worldId", playerWorld2 != null ? playerWorld2.getId() : null);
        this.debugLogger.debug("Current world check", (Pair<String, ? extends Object>)object);
        if (world == null) {
            this.plugin.getLogger().warning("[WorldCommands] handleInvite: Player " + player.getName() + " not in their own world");
            player.sendMessage((Component)Component.text("You must specify a world name or be in one of your worlds", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleInvite", "not in own world");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleInvite: Sending invite for world '" + world.getName() + "' to " + target.getName());
        object = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("targetName", target.getName())};
        this.debugLogger.debug("Calling inviteManager.sendInvite", (Pair<String, ? extends Object>)object);
        object = InviteManager.sendInvite-BWLJW6A$default(this.inviteManager, world, player, target, null, 8, null);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            Pair[] pairArray5 = new Pair[]{TuplesKt.to("error", error.getMessage())};
            this.debugLogger.debug("Invite failed", pairArray5);
            this.plugin.getLogger().warning("[WorldCommands] handleInvite: Failed to send invite: " + error.getMessage());
            TextComponent textComponent = Component.text("Failed to send invite: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.plugin.getLogger().info("[WorldCommands] handleInvite: Command completed for " + player.getName());
        this.debugLogger.debugMethodExit("handleInvite", 1);
        return 1;
    }

    private final int handleInviteWithWorld(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleInviteWithWorld", pairArray);
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleInviteWithWorld", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        Player target = Bukkit.getPlayer((String)targetName);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("isOnline", target != null)};
        this.debugLogger.debug("Target player lookup", pairArray4);
        if (target == null) {
            player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' is not online", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleInviteWithWorld", "target not online");
            return 1;
        }
        Intrinsics.checkNotNull(worldName);
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        Object object = new Pair[3];
        object[0] = TuplesKt.to("worldName", worldName);
        object[1] = TuplesKt.to("found", world != null);
        PlayerWorld playerWorld = world;
        object[2] = TuplesKt.to("worldId", playerWorld != null ? playerWorld.getId() : null);
        this.debugLogger.debug("World lookup", (Pair<String, ? extends Object>)object);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleInviteWithWorld", "world not found");
            return 1;
        }
        object = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("targetName", target.getName())};
        this.debugLogger.debug("Calling inviteManager.sendInvite", (Pair<String, ? extends Object>)object);
        object = InviteManager.sendInvite-BWLJW6A$default(this.inviteManager, world, player, target, null, 8, null);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            Pair[] pairArray5 = new Pair[]{TuplesKt.to("error", error.getMessage())};
            this.debugLogger.debug("Invite failed", pairArray5);
            TextComponent textComponent = Component.text("Failed to send invite: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleInviteWithWorld", 1);
        return 1;
    }

    private final int handleKick(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleKick", pairArray);
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleKick", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("targetName", targetName)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer target = offlinePlayer;
        boolean targetExists = target.hasPlayedBefore() || target.isOnline();
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("targetUuid", target.getUniqueId()), TuplesKt.to("exists", targetExists)};
        this.debugLogger.debug("Target player lookup", pairArray4);
        if (!targetExists) {
            player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleKick", "target not found");
            return 1;
        }
        PlayerWorld world = this.getCurrentWorld(player);
        Object object = new Pair[3];
        object[0] = TuplesKt.to("playerWorld", player.getWorld().getName());
        PlayerWorld playerWorld = world;
        object[1] = TuplesKt.to("ownedWorld", playerWorld != null ? playerWorld.getName() : null);
        PlayerWorld playerWorld2 = world;
        object[2] = TuplesKt.to("worldId", playerWorld2 != null ? playerWorld2.getId() : null);
        this.debugLogger.debug("Current world check", (Pair<String, ? extends Object>)object);
        if (world == null) {
            player.sendMessage((Component)Component.text("You must specify a world name or be in one of your worlds", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleKick", "not in own world");
            return 1;
        }
        object = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("targetUuid", target.getUniqueId())};
        this.debugLogger.debug("Calling inviteManager.kickPlayer", (Pair<String, ? extends Object>)object);
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        object = this.inviteManager.kickPlayer-0E7RQCE(world, player, uUID);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            Pair[] pairArray5 = new Pair[]{TuplesKt.to("error", error.getMessage())};
            this.debugLogger.debug("Kick failed", pairArray5);
            TextComponent textComponent = Component.text("Failed to kick player: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleKick", 1);
        return 1;
    }

    private final int handleKickWithWorld(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleKickWithWorld", pairArray);
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleKickWithWorld", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer target = offlinePlayer;
        boolean targetExists = target.hasPlayedBefore() || target.isOnline();
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("targetUuid", target.getUniqueId()), TuplesKt.to("exists", targetExists)};
        this.debugLogger.debug("Target player lookup", pairArray4);
        if (!targetExists) {
            player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleKickWithWorld", "target not found");
            return 1;
        }
        Intrinsics.checkNotNull(worldName);
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        Object object = new Pair[3];
        object[0] = TuplesKt.to("worldName", worldName);
        object[1] = TuplesKt.to("found", world != null);
        PlayerWorld playerWorld = world;
        object[2] = TuplesKt.to("worldId", playerWorld != null ? playerWorld.getId() : null);
        this.debugLogger.debug("World lookup", (Pair<String, ? extends Object>)object);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleKickWithWorld", "world not found");
            return 1;
        }
        object = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("targetUuid", target.getUniqueId())};
        this.debugLogger.debug("Calling inviteManager.kickPlayer", (Pair<String, ? extends Object>)object);
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        object = this.inviteManager.kickPlayer-0E7RQCE(world, player, uUID);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            Pair[] pairArray5 = new Pair[]{TuplesKt.to("error", error.getMessage())};
            this.debugLogger.debug("Kick failed", pairArray5);
            TextComponent textComponent = Component.text("Failed to kick player: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleKickWithWorld", 1);
        return 1;
    }

    private final int handleAccept(CommandContext<CommandSourceStack> ctx) {
        Object v3;
        Object object;
        Pair[] $this$firstOrNull$iv;
        OfflinePlayer owner;
        String worldName;
        String ownerName;
        Player player;
        block7: {
            Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
            this.debugLogger.debugMethodEntry("handleAccept", pairArray);
            Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
            player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
            pairArray2 = new Pair[2];
            pairArray2[0] = TuplesKt.to("isPlayer", player != null);
            Player player2 = player;
            pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
            this.debugLogger.debug("Player check", pairArray2);
            if (player == null) {
                this.debugLogger.debugMethodExit("handleAccept", "player-only error");
                return this.sendPlayerOnlyError(ctx);
            }
            ownerName = StringArgumentType.getString(ctx, (String)"owner");
            worldName = StringArgumentType.getString(ctx, (String)"world");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("worldName", worldName)};
            this.debugLogger.debug("Parsed arguments", pairArray3);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)ownerName);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            owner = offlinePlayer;
            boolean ownerExists = owner.hasPlayedBefore() || owner.isOnline();
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("exists", ownerExists)};
            this.debugLogger.debug("Owner lookup", pairArray4);
            if (!ownerExists) {
                player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(ownerName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
                this.debugLogger.debugMethodExit("handleAccept", "owner not found");
                return 1;
            }
            UUID uUID = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), worldName, true)) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        PlayerWorld world = v3;
        $this$firstOrNull$iv = new Pair[]{TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("worldName", worldName), TuplesKt.to("found", world != null)};
        this.debugLogger.debug("World lookup", $this$firstOrNull$iv);
        if (world == null) {
            player.sendMessage(((TextComponent)Component.text(ownerName + " doesn't own a world named '", (TextColor)NamedTextColor.RED).append(Component.text(worldName, (TextColor)NamedTextColor.GOLD))).append(Component.text("'", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleAccept", "world not found");
            return 1;
        }
        UUID uUID = world.getId();
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        WorldInvite invite = this.dataManager.getInvite(uUID, uUID2);
        Object object2 = new Pair[]{TuplesKt.to("worldId", world.getId()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("found", invite != null)};
        this.debugLogger.debug("Invite lookup", (Pair<String, ? extends Object>)object2);
        if (invite == null) {
            player.sendMessage((Component)Component.text("You don't have a pending invite to this world", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleAccept", "no invite");
            return 1;
        }
        object2 = new Pair[]{TuplesKt.to("worldId", invite.getWorldId()), TuplesKt.to("inviteeUuid", invite.getInviteeUuid())};
        this.debugLogger.debug("Calling inviteManager.acceptInvite", (Pair<String, ? extends Object>)object2);
        object2 = this.inviteManager.acceptInvite-gIAlu-s(invite, player);
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Object error = object = throwable;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("error", ((Throwable)error).getMessage())};
            this.debugLogger.debug("Accept invite failed", pairArray);
            TextComponent textComponent = Component.text("Failed to accept invite: ", (TextColor)NamedTextColor.RED);
            String string = ((Throwable)error).getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleAccept", 1);
        return 1;
    }

    private final int handleDeny(CommandContext<CommandSourceStack> ctx) {
        Object v3;
        Object object;
        Pair[] $this$firstOrNull$iv;
        OfflinePlayer owner;
        String worldName;
        String ownerName;
        Player player;
        block7: {
            Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
            this.debugLogger.debugMethodEntry("handleDeny", pairArray);
            Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
            player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
            pairArray2 = new Pair[2];
            pairArray2[0] = TuplesKt.to("isPlayer", player != null);
            Player player2 = player;
            pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
            this.debugLogger.debug("Player check", pairArray2);
            if (player == null) {
                this.debugLogger.debugMethodExit("handleDeny", "player-only error");
                return this.sendPlayerOnlyError(ctx);
            }
            ownerName = StringArgumentType.getString(ctx, (String)"owner");
            worldName = StringArgumentType.getString(ctx, (String)"world");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("worldName", worldName)};
            this.debugLogger.debug("Parsed arguments", pairArray3);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)ownerName);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            owner = offlinePlayer;
            boolean ownerExists = owner.hasPlayedBefore() || owner.isOnline();
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("exists", ownerExists)};
            this.debugLogger.debug("Owner lookup", pairArray4);
            if (!ownerExists) {
                player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(ownerName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
                this.debugLogger.debugMethodExit("handleDeny", "owner not found");
                return 1;
            }
            UUID uUID = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), worldName, true)) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        PlayerWorld world = v3;
        $this$firstOrNull$iv = new Pair[]{TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("worldName", worldName), TuplesKt.to("found", world != null)};
        this.debugLogger.debug("World lookup", $this$firstOrNull$iv);
        if (world == null) {
            player.sendMessage(((TextComponent)Component.text(ownerName + " doesn't own a world named '", (TextColor)NamedTextColor.RED).append(Component.text(worldName, (TextColor)NamedTextColor.GOLD))).append(Component.text("'", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleDeny", "world not found");
            return 1;
        }
        UUID uUID = world.getId();
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        WorldInvite invite = this.dataManager.getInvite(uUID, uUID2);
        Object object2 = new Pair[]{TuplesKt.to("worldId", world.getId()), TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("found", invite != null)};
        this.debugLogger.debug("Invite lookup", (Pair<String, ? extends Object>)object2);
        if (invite == null) {
            player.sendMessage((Component)Component.text("You don't have a pending invite to this world", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleDeny", "no invite");
            return 1;
        }
        object2 = new Pair[]{TuplesKt.to("worldId", invite.getWorldId()), TuplesKt.to("inviteeUuid", invite.getInviteeUuid())};
        this.debugLogger.debug("Calling inviteManager.denyInvite", (Pair<String, ? extends Object>)object2);
        object2 = this.inviteManager.denyInvite-gIAlu-s(invite, player);
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Object error = object = throwable;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("error", ((Throwable)error).getMessage())};
            this.debugLogger.debug("Deny invite failed", pairArray);
            TextComponent textComponent = Component.text("Failed to deny invite: ", (TextColor)NamedTextColor.RED);
            String string = ((Throwable)error).getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleDeny", 1);
        return 1;
    }

    private final int handleTransfer(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleTransfer", pairArray);
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleTransfer", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debug("Parsed arguments", pairArray3);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer target = offlinePlayer;
        boolean targetExists = target.hasPlayedBefore() || target.isOnline();
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("targetUuid", target.getUniqueId()), TuplesKt.to("exists", targetExists)};
        this.debugLogger.debug("Target lookup", pairArray4);
        if (!targetExists) {
            player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleTransfer", "target not found");
            return 1;
        }
        Intrinsics.checkNotNull(worldName);
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        Object object = new Pair[3];
        object[0] = TuplesKt.to("worldName", worldName);
        object[1] = TuplesKt.to("found", world != null);
        PlayerWorld playerWorld = world;
        object[2] = TuplesKt.to("worldId", playerWorld != null ? playerWorld.getId() : null);
        this.debugLogger.debug("World lookup", (Pair<String, ? extends Object>)object);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleTransfer", "world not found");
            return 1;
        }
        object = new Pair[]{TuplesKt.to("worldId", world.getId()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("newOwnerUuid", target.getUniqueId())};
        this.debugLogger.debug("Calling inviteManager.transferOwnership", (Pair<String, ? extends Object>)object);
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        object = this.inviteManager.transferOwnership-0E7RQCE(world, player, uUID);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            Pair[] pairArray5 = new Pair[]{TuplesKt.to("error", error.getMessage())};
            this.debugLogger.debug("Transfer failed", pairArray5);
            TextComponent textComponent = Component.text("Failed to transfer ownership: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleTransfer", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int handleInvites(CommandContext<CommandSourceStack> ctx) {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleInvites", pairArray);
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleInvites", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<WorldInvite> invites = this.inviteManager.getPendingInvites(uUID);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("inviteCount", invites.size())};
        this.debugLogger.debug("Retrieved pending invites", pairArray3);
        if (invites.isEmpty()) {
            player.sendMessage((Component)Component.text("You have no pending invites", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handleInvites", "no invites");
            return 1;
        }
        pairArray3 = new Pair[1];
        Iterable iterable = invites;
        String string = "inviteDetails";
        int n = 0;
        Pair[] pairArray4 = pairArray3;
        String string2 = "Displaying invites";
        DebugLogger debugLogger = this.debugLogger;
        boolean $i$f$map = false;
        void var7_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WorldInvite worldInvite = (WorldInvite)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CallSite)((Object)(it.getOwnerName() + "/" + it.getWorldName())));
        }
        collection = (List)destination$iv$iv;
        pairArray4[n] = TuplesKt.to(string, collection);
        debugLogger.debug(string2, pairArray3);
        player.sendMessage((Component)Component.text("Pending invites:", (TextColor)NamedTextColor.GREEN));
        Iterable $this$forEach$iv = invites;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorldInvite invite = (WorldInvite)element$iv;
            boolean bl = false;
            player.sendMessage(((TextComponent)((TextComponent)Component.text("  - ", (TextColor)NamedTextColor.GRAY).append(Component.text(invite.getWorldName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" from ", (TextColor)NamedTextColor.GRAY))).append(Component.text(invite.getOwnerName(), (TextColor)NamedTextColor.GOLD)));
            player.sendMessage(Component.text("    Use ", (TextColor)NamedTextColor.GRAY).append(Component.text("/world accept " + invite.getOwnerName() + " " + invite.getWorldName(), (TextColor)NamedTextColor.YELLOW)));
        }
        this.debugLogger.debugMethodExit("handleInvites", 1);
        return 1;
    }

    private final int handleLeave(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleLeave", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleLeave: Executing world leave command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleLeave", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        this.plugin.getLogger().info("[WorldCommands] handleLeave: Player " + player.getName() + " attempting to leave current world");
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World currentWorld = world;
        boolean isPluginWorld = this.worldManager.isPluginWorld(currentWorld);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", currentWorld.getName()), TuplesKt.to("isPluginWorld", isPluginWorld)};
        this.debugLogger.debug("Current world check", pairArray3);
        if (!isPluginWorld) {
            this.plugin.getLogger().info("[WorldCommands] handleLeave: Player " + player.getName() + " is already in a vanilla world");
            player.sendMessage((Component)Component.text("You are already in a vanilla world", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handleLeave", "already in vanilla world");
            return 1;
        }
        this.plugin.getLogger().info("[WorldCommands] handleLeave: Teleporting " + player.getName() + " to vanilla world");
        player.sendMessage((Component)Component.text("Returning to vanilla world...", (TextColor)NamedTextColor.YELLOW));
        pairArray3 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Calling worldManager.teleportToVanillaWorld", pairArray3);
        this.worldManager.teleportToVanillaWorld(player).thenAccept(arg_0 -> WorldCommands.handleLeave$lambda$23(new Function1<Boolean, Unit>(this, player){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ Player $player;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                super(1);
            }

            public final void invoke(Boolean success) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("success", success)};
                WorldCommands.access$getDebugLogger$p(this.this$0).debug("Teleport to vanilla world result", pairArray);
                this.$player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(this.this$0), arg_0 -> handleLeave.1.invoke$lambda$0(success, this.this$0, this.$player, arg_0), null);
            }

            private static final void invoke$lambda$0(Boolean $success, WorldCommands this$0, Player $player, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNull($success);
                if ($success.booleanValue()) {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().info("[WorldCommands] handleLeave: Player " + $player.getName() + " successfully left plugin world");
                    $player.sendMessage((Component)Component.text("Returned to vanilla world", (TextColor)NamedTextColor.GREEN));
                } else {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().warning("[WorldCommands] handleLeave: Failed to teleport " + $player.getName() + " to vanilla world");
                    $player.sendMessage((Component)Component.text("Failed to return to vanilla world", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleLeave", 1);
        return 1;
    }

    private final int handleSpawn(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleSpawn", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleSpawn: Executing world spawn command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleSpawn", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        this.plugin.getLogger().info("[WorldCommands] handleSpawn: Player " + player.getName() + " attempting to teleport to default world spawn");
        pairArray2 = new Pair[]{TuplesKt.to("world", player.getWorld().getName()), TuplesKt.to("location", player.getLocation().toString())};
        this.debugLogger.debug("Current location", pairArray2);
        player.sendMessage((Component)Component.text("Teleporting to spawn...", (TextColor)NamedTextColor.YELLOW));
        pairArray2 = new Pair[]{TuplesKt.to("player", player.getName())};
        this.debugLogger.debug("Calling worldManager.teleportToVanillaWorld", pairArray2);
        this.worldManager.teleportToVanillaWorld(player).thenAccept(arg_0 -> WorldCommands.handleSpawn$lambda$24(new Function1<Boolean, Unit>(this, player){
            final /* synthetic */ WorldCommands this$0;
            final /* synthetic */ Player $player;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                super(1);
            }

            public final void invoke(Boolean success) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("success", success)};
                WorldCommands.access$getDebugLogger$p(this.this$0).debug("Spawn teleport result", pairArray);
                this.$player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(this.this$0), arg_0 -> handleSpawn.1.invoke$lambda$0(success, this.this$0, this.$player, arg_0), null);
            }

            private static final void invoke$lambda$0(Boolean $success, WorldCommands this$0, Player $player, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNull($success);
                if ($success.booleanValue()) {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().info("[WorldCommands] handleSpawn: Player " + $player.getName() + " teleported successfully to spawn");
                    $player.sendMessage((Component)Component.text("Teleported to spawn", (TextColor)NamedTextColor.GREEN));
                } else {
                    WorldCommands.access$getPlugin$p(this$0).getLogger().warning("[WorldCommands] handleSpawn: Failed to teleport " + $player.getName() + " to spawn");
                    $player.sendMessage((Component)Component.text("Failed to teleport to spawn", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleSpawn", 1);
        return 1;
    }

    private final int handleMenu(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleMenu", pairArray);
        this.plugin.getLogger().info("[WorldCommands] handleMenu: Executing world menu command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.debugLogger.debugMethodExit("handleMenu", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        this.plugin.getLogger().info("[WorldCommands] handleMenu: Opening main menu GUI for " + player.getName());
        pairArray2 = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("playerUuid", player.getUniqueId())};
        this.debugLogger.debug("Opening main menu GUI", pairArray2);
        this.mainMenuGui.open(player);
        this.plugin.getLogger().info("[WorldCommands] handleMenu: Command completed for " + player.getName());
        this.debugLogger.debugMethodExit("handleMenu", 1);
        return 1;
    }

    private final int handleHelp(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleHelp", pairArray);
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("senderName", sender.getName())};
        this.debugLogger.debug("Displaying help", pairArray2);
        sender.sendMessage((Component)Component.text("World Management Commands", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text("/world create <name> [type] [seed]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Create a world", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world delete <name>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Delete your world", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world list", (TextColor)NamedTextColor.GRAY).append(Component.text(" - List your worlds", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world tp <name>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Teleport to your world", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world visit <owner> <name>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Visit a world", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world invite <player> [world]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Invite a player", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world kick <player> [world]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Kick a player", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world accept <owner> <world>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Accept an invite", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world deny <owner> <world>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Deny an invite", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world transfer <player> <world>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Transfer ownership", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world invites", (TextColor)NamedTextColor.GRAY).append(Component.text(" - List pending invites", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world leave", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Return to vanilla world", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world spawn", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Return to default spawn", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world menu", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Open the GUI menu", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world role <player> <role> [world]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Set player role", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world visibility [world]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Toggle public/private", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world publicrole <role> [world]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Set public join role", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world members [world]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - View world members", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world browse", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Browse public worlds", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world backup", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Manage world backups", (TextColor)NamedTextColor.YELLOW)));
        this.debugLogger.debugMethodExit("handleHelp", 1);
        return 1;
    }

    private final int handleBackupHelp(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupHelp", pairArray);
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        sender.sendMessage((Component)Component.text("Backup Commands", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text("/world backup create [world] [description]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Create a backup", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world backup list [world]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - List your backups", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world backup restore <id>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Restore from backup", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world backup delete <id>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Delete a backup", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world backup schedule <world> enable [interval]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Enable auto-backup", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world backup schedule <world> disable", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Disable auto-backup", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/world backup schedule <world> status", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Check backup schedule", (TextColor)NamedTextColor.YELLOW)));
        this.debugLogger.debugMethodExit("handleBackupHelp", 1);
        return 1;
    }

    private final int handleBackupCreate(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupCreate", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        PlayerWorld world = this.getCurrentOwnedWorld(player);
        if (world == null) {
            player.sendMessage((Component)Component.text("You must be in one of your worlds or specify a world name", (TextColor)NamedTextColor.RED));
            return 1;
        }
        return this.createBackupForWorld(player, world, null);
    }

    private final int handleBackupCreateWithWorld(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupCreateWithWorld", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld playerWorld = this.getPlayerWorld(player, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        return this.createBackupForWorld(player, world, null);
    }

    private final int handleBackupCreateWithDescription(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupCreateWithDescription", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        String description = StringArgumentType.getString(ctx, (String)"description");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld playerWorld = this.getPlayerWorld(player, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        return this.createBackupForWorld(player, world, description);
    }

    private final int createBackupForWorld(Player player, PlayerWorld world, String description) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("world", world.getName()), TuplesKt.to("description", description)};
        this.debugLogger.debug("Creating backup", pairArray);
        player.sendMessage(((TextComponent)Component.text("Creating backup for ", (TextColor)NamedTextColor.YELLOW).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("...", (TextColor)NamedTextColor.YELLOW)));
        this.backupManager.createBackup(world, description, false).thenAccept(arg_0 -> WorldCommands.createBackupForWorld$lambda$25(new Function1<Result<? extends WorldBackup>, Unit>(player, this){
            final /* synthetic */ Player $player;
            final /* synthetic */ WorldCommands this$0;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Result<? extends WorldBackup> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    Player player = this.$player;
                    WorldCommands worldCommands = this.this$0;
                    if (Result.isSuccess-impl(object)) {
                        WorldBackup backup = (WorldBackup)object;
                        boolean bl = false;
                        player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> createBackupForWorld.1.invoke$lambda$1$lambda$0(player, backup, arg_0), null);
                    }
                    player = this.$player;
                    worldCommands = this.this$0;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> createBackupForWorld.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, WorldBackup $backup, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($player, "$player");
                Intrinsics.checkNotNullParameter($backup, "$backup");
                TextComponent textComponent = (TextComponent)Component.text("Backup created successfully! ", (TextColor)NamedTextColor.GREEN).append(Component.text("ID: ", (TextColor)NamedTextColor.GRAY));
                String string = $backup.getId().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                $player.sendMessage(((TextComponent)((TextComponent)textComponent.append(Component.text(StringsKt.take(string, 8), (TextColor)NamedTextColor.GOLD))).append(Component.text(" Size: ", (TextColor)NamedTextColor.GRAY))).append(Component.text($backup.getHumanReadableSize(), (TextColor)NamedTextColor.AQUA)));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($player, "$player");
                Intrinsics.checkNotNullParameter($error, "$error");
                TextComponent textComponent = Component.text("Failed to create backup: ", (TextColor)NamedTextColor.RED);
                String string = $error.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                $player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
            }
        }, arg_0));
        return 1;
    }

    private final int handleBackupList(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupList", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<WorldBackup> backups = this.backupManager.getBackupsForPlayer(uUID);
        if (backups.isEmpty()) {
            player.sendMessage((Component)Component.text("You don't have any backups", (TextColor)NamedTextColor.YELLOW));
            return 1;
        }
        player.sendMessage((Component)Component.text("Your backups:", (TextColor)NamedTextColor.GREEN));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Iterable $this$forEach$iv = backups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorldBackup backup = (WorldBackup)element$iv;
            boolean bl = false;
            String date = dateFormat.format(new Date(backup.getCreatedAt()));
            String autoLabel = backup.isAutomatic() ? " [Auto]" : "";
            TextComponent textComponent = Component.text("  ", (TextColor)NamedTextColor.GRAY);
            String string = backup.getId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)textComponent.append(Component.text(StringsKt.take(string, 8), (TextColor)NamedTextColor.GOLD))).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text(backup.getWorldName(), (TextColor)NamedTextColor.AQUA))).append(Component.text(" (" + date + ")", (TextColor)NamedTextColor.GRAY))).append(Component.text(autoLabel, (TextColor)NamedTextColor.YELLOW))).append(Component.text(" [" + backup.getHumanReadableSize() + "]", (TextColor)NamedTextColor.DARK_GRAY)));
            if (backup.getDescription() == null) continue;
            player.sendMessage(Component.text("    ", (TextColor)NamedTextColor.GRAY).append(Component.text(backup.getDescription(), (TextColor)NamedTextColor.GRAY)));
        }
        return 1;
    }

    private final int handleBackupListWorld(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupListWorld", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld playerWorld = this.getPlayerWorld(player, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        List<WorldBackup> backups = this.backupManager.getBackupsForWorld(world.getId());
        if (backups.isEmpty()) {
            player.sendMessage(Component.text("No backups found for ", (TextColor)NamedTextColor.YELLOW).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
            return 1;
        }
        player.sendMessage(((TextComponent)Component.text("Backups for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(":", (TextColor)NamedTextColor.GREEN)));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Iterable $this$forEach$iv = backups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorldBackup backup = (WorldBackup)element$iv;
            boolean bl = false;
            String date = dateFormat.format(new Date(backup.getCreatedAt()));
            String autoLabel = backup.isAutomatic() ? " [Auto]" : "";
            TextComponent textComponent = Component.text("  ", (TextColor)NamedTextColor.GRAY);
            String string = backup.getId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)textComponent.append(Component.text(StringsKt.take(string, 8), (TextColor)NamedTextColor.GOLD))).append(Component.text(" - " + date, (TextColor)NamedTextColor.GRAY))).append(Component.text(autoLabel, (TextColor)NamedTextColor.YELLOW))).append(Component.text(" [" + backup.getHumanReadableSize() + "]", (TextColor)NamedTextColor.DARK_GRAY)));
            if (backup.getDescription() == null) continue;
            player.sendMessage(Component.text("    ", (TextColor)NamedTextColor.GRAY).append(Component.text(backup.getDescription(), (TextColor)NamedTextColor.GRAY)));
        }
        return 1;
    }

    private final int handleBackupRestore(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupRestore", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String backupIdStr = StringArgumentType.getString(ctx, (String)"backup-id");
        Intrinsics.checkNotNull(backupIdStr);
        WorldBackup backup = this.findBackupByPartialId(player, backupIdStr);
        if (backup == null) {
            player.sendMessage(Component.text("Backup not found: ", (TextColor)NamedTextColor.RED).append(Component.text(backupIdStr, (TextColor)NamedTextColor.GOLD)));
            return 1;
        }
        if (!Intrinsics.areEqual(backup.getOwnerUuid(), player.getUniqueId()) && !player.hasPermission("playerworldmanager.admin")) {
            player.sendMessage((Component)Component.text("You don't own this backup", (TextColor)NamedTextColor.RED));
            return 1;
        }
        player.sendMessage(((TextComponent)Component.text("Restoring world ", (TextColor)NamedTextColor.YELLOW).append(Component.text(backup.getWorldName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" from backup...", (TextColor)NamedTextColor.YELLOW)));
        this.backupManager.restoreBackup(backup).thenAccept(arg_0 -> WorldCommands.handleBackupRestore$lambda$28(new Function1<Result<? extends Unit>, Unit>(player, this){
            final /* synthetic */ Player $player;
            final /* synthetic */ WorldCommands this$0;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Result<? extends Unit> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    Player player = this.$player;
                    WorldCommands worldCommands = this.this$0;
                    if (Result.isSuccess-impl(object)) {
                        Unit it = (Unit)object;
                        boolean bl = false;
                        player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleBackupRestore.1.invoke$lambda$1$lambda$0(player, arg_0), null);
                    }
                    player = this.$player;
                    worldCommands = this.this$0;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleBackupRestore.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, ScheduledTask scheduledTask) {
                $player.sendMessage(Component.text("World restored successfully! ", (TextColor)NamedTextColor.GREEN).append(Component.text("Note: You may need to re-enter the world to see changes.", (TextColor)NamedTextColor.GRAY)));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($error, "$error");
                TextComponent textComponent = Component.text("Failed to restore backup: ", (TextColor)NamedTextColor.RED);
                String string = $error.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                $player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
            }
        }, arg_0));
        return 1;
    }

    private final int handleBackupDelete(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupDelete", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String backupIdStr = StringArgumentType.getString(ctx, (String)"backup-id");
        Intrinsics.checkNotNull(backupIdStr);
        WorldBackup backup = this.findBackupByPartialId(player, backupIdStr);
        if (backup == null) {
            player.sendMessage(Component.text("Backup not found: ", (TextColor)NamedTextColor.RED).append(Component.text(backupIdStr, (TextColor)NamedTextColor.GOLD)));
            return 1;
        }
        if (!Intrinsics.areEqual(backup.getOwnerUuid(), player.getUniqueId()) && !player.hasPermission("playerworldmanager.admin")) {
            player.sendMessage((Component)Component.text("You don't own this backup", (TextColor)NamedTextColor.RED));
            return 1;
        }
        player.sendMessage((Component)Component.text("Deleting backup...", (TextColor)NamedTextColor.YELLOW));
        this.backupManager.deleteBackup(backup).thenAccept(arg_0 -> WorldCommands.handleBackupDelete$lambda$29(new Function1<Result<? extends Unit>, Unit>(player, this){
            final /* synthetic */ Player $player;
            final /* synthetic */ WorldCommands this$0;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Result<? extends Unit> result) {
                block1: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    Player player = this.$player;
                    WorldCommands worldCommands = this.this$0;
                    if (Result.isSuccess-impl(object)) {
                        Unit it = (Unit)object;
                        boolean bl = false;
                        player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleBackupDelete.1.invoke$lambda$1$lambda$0(player, arg_0), null);
                    }
                    player = this.$player;
                    worldCommands = this.this$0;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block1;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    player.getScheduler().run((Plugin)WorldCommands.access$getPlugin$p(worldCommands), arg_0 -> handleBackupDelete.1.invoke$lambda$3$lambda$2(player, error, arg_0), null);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Player $player, ScheduledTask scheduledTask) {
                $player.sendMessage((Component)Component.text("Backup deleted successfully!", (TextColor)NamedTextColor.GREEN));
            }

            private static final void invoke$lambda$3$lambda$2(Player $player, Throwable $error, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter($error, "$error");
                TextComponent textComponent = Component.text("Failed to delete backup: ", (TextColor)NamedTextColor.RED);
                String string = $error.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                $player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
            }
        }, arg_0));
        return 1;
    }

    private final int handleBackupScheduleEnable(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupScheduleEnable", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld playerWorld = this.getPlayerWorld(player, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        BackupSchedule schedule = BackupManager.setBackupSchedule$default(this.backupManager, world.getId(), true, null, 4, null);
        player.sendMessage(((TextComponent)Component.text("Automatic backups enabled for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" (every " + schedule.getIntervalMinutes() + " minutes)", (TextColor)NamedTextColor.GRAY)));
        return 1;
    }

    private final int handleBackupScheduleEnableWithInterval(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupScheduleEnableWithInterval", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        String intervalStr = StringArgumentType.getString(ctx, (String)"interval");
        Intrinsics.checkNotNull(intervalStr);
        Integer interval = StringsKt.toIntOrNull(intervalStr);
        if (interval == null || interval < 1) {
            player.sendMessage((Component)Component.text("Invalid interval. Must be a positive number of minutes.", (TextColor)NamedTextColor.RED));
            return 1;
        }
        Intrinsics.checkNotNull(worldName);
        PlayerWorld playerWorld = this.getPlayerWorld(player, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        BackupSchedule schedule = this.backupManager.setBackupSchedule(world.getId(), true, interval);
        player.sendMessage(((TextComponent)Component.text("Automatic backups enabled for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" (every " + schedule.getIntervalMinutes() + " minutes)", (TextColor)NamedTextColor.GRAY)));
        return 1;
    }

    private final int handleBackupScheduleDisable(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupScheduleDisable", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld playerWorld = this.getPlayerWorld(player, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        this.backupManager.disableBackupSchedule(world.getId());
        player.sendMessage(Component.text("Automatic backups disabled for ", (TextColor)NamedTextColor.YELLOW).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
        return 1;
    }

    private final int handleBackupScheduleStatus(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBackupScheduleStatus", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld playerWorld = this.getPlayerWorld(player, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        BackupSchedule schedule = this.backupManager.getBackupSchedule(world.getId());
        if (schedule == null || !schedule.getEnabled()) {
            player.sendMessage(((TextComponent)((TextComponent)Component.text("Automatic backups are ", (TextColor)NamedTextColor.GRAY).append(Component.text("disabled", (TextColor)NamedTextColor.RED))).append(Component.text(" for ", (TextColor)NamedTextColor.GRAY))).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD)));
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String lastBackup = schedule.getLastBackupTime() > 0L ? dateFormat.format(new Date(schedule.getLastBackupTime())) : "Never";
            player.sendMessage(((TextComponent)Component.text("Backup schedule for ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(":", (TextColor)NamedTextColor.GRAY)));
            player.sendMessage(Component.text("  Status: ", (TextColor)NamedTextColor.GRAY).append(Component.text("Enabled", (TextColor)NamedTextColor.GREEN)));
            player.sendMessage(Component.text("  Interval: ", (TextColor)NamedTextColor.GRAY).append(Component.text(schedule.getIntervalMinutes() + " minutes", (TextColor)NamedTextColor.AQUA)));
            player.sendMessage(Component.text("  Last backup: ", (TextColor)NamedTextColor.GRAY).append(Component.text(lastBackup, (TextColor)NamedTextColor.AQUA)));
        }
        return 1;
    }

    private final WorldBackup findBackupByPartialId(Player player, String partialId) {
        Object v2;
        block4: {
            try {
                UUID uuid = UUID.fromString(partialId);
                Intrinsics.checkNotNull(uuid);
                WorldBackup backup = this.backupManager.getBackup(uuid);
                if (backup != null && (Intrinsics.areEqual(backup.getOwnerUuid(), player.getUniqueId()) || player.hasPermission("playerworldmanager.admin"))) {
                    return backup;
                }
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            List<WorldBackup> playerBackups = this.backupManager.getBackupsForPlayer(uUID);
            Iterable $this$firstOrNull$iv = playerBackups;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WorldBackup it = (WorldBackup)element$iv;
                boolean bl = false;
                String string = it.getId().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                if (!StringsKt.startsWith(string, partialId, true)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    private final int handleRole(CommandContext<CommandSourceStack> ctx) {
        boolean targetExists;
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleRole", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handleRole", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        String roleString = StringArgumentType.getString(ctx, (String)"role");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("roleString", roleString)};
        this.debugLogger.debug("Parsed arguments", pairArray2);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer target = offlinePlayer;
        boolean bl = targetExists = target.hasPlayedBefore() || target.isOnline();
        if (!targetExists) {
            player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Intrinsics.checkNotNull(roleString);
        WorldRole role = this.parseRole(roleString);
        if (role == null) {
            player.sendMessage(Component.text("Invalid role. Valid roles: ", (TextColor)NamedTextColor.RED).append(Component.text("manager, member, visitor", (TextColor)NamedTextColor.GOLD)));
            return 1;
        }
        PlayerWorld world = this.getCurrentOwnedWorld(player);
        if (world == null) {
            player.sendMessage((Component)Component.text("You must specify a world name or be in one of your owned worlds", (TextColor)NamedTextColor.RED));
            return 1;
        }
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Object object = this.inviteManager.setPlayerRole-BWLJW6A(world, player, uUID, role);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl2 = false;
            TextComponent textComponent = Component.text("Failed to set role: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleRole", 1);
        return 1;
    }

    private final int handleRoleWithWorld(CommandContext<CommandSourceStack> ctx) {
        boolean targetExists;
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleRoleWithWorld", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handleRoleWithWorld", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        String roleString = StringArgumentType.getString(ctx, (String)"role");
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("targetName", targetName), TuplesKt.to("roleString", roleString), TuplesKt.to("worldName", worldName)};
        this.debugLogger.debug("Parsed arguments", pairArray2);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer target = offlinePlayer;
        boolean bl = targetExists = target.hasPlayedBefore() || target.isOnline();
        if (!targetExists) {
            player.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(targetName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Intrinsics.checkNotNull(roleString);
        WorldRole role = this.parseRole(roleString);
        if (role == null) {
            player.sendMessage(Component.text("Invalid role. Valid roles: ", (TextColor)NamedTextColor.RED).append(Component.text("manager, member, visitor", (TextColor)NamedTextColor.GOLD)));
            return 1;
        }
        Intrinsics.checkNotNull(worldName);
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        if (world == null) {
            return 1;
        }
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Object object = this.inviteManager.setPlayerRole-BWLJW6A(world, player, uUID, role);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl2 = false;
            TextComponent textComponent = Component.text("Failed to set role: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleRoleWithWorld", 1);
        return 1;
    }

    private final int handleVisibility(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleVisibility", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handleVisibility", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        PlayerWorld world = this.getCurrentOwnedWorld(player);
        if (world == null) {
            player.sendMessage((Component)Component.text("You must specify a world name or be in one of your owned worlds", (TextColor)NamedTextColor.RED));
            return 1;
        }
        Object object = this.inviteManager.toggleWorldVisibility-gIAlu-s(world, player);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            TextComponent textComponent = Component.text("Failed to toggle visibility: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleVisibility", 1);
        return 1;
    }

    private final int handleVisibilityWithWorld(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleVisibilityWithWorld", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handleVisibilityWithWorld", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        if (world == null) {
            return 1;
        }
        Object object = this.inviteManager.toggleWorldVisibility-gIAlu-s(world, player);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            TextComponent textComponent = Component.text("Failed to toggle visibility: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleVisibilityWithWorld", 1);
        return 1;
    }

    private final int handlePublicRole(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handlePublicRole", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handlePublicRole", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String roleString = StringArgumentType.getString(ctx, (String)"role");
        Intrinsics.checkNotNull(roleString);
        WorldRole role = this.parsePublicRole(roleString);
        if (role == null) {
            player.sendMessage(Component.text("Invalid role. Valid public roles: ", (TextColor)NamedTextColor.RED).append(Component.text("member, visitor", (TextColor)NamedTextColor.GOLD)));
            return 1;
        }
        PlayerWorld world = this.getCurrentOwnedWorld(player);
        if (world == null) {
            player.sendMessage((Component)Component.text("You must specify a world name or be in one of your owned worlds", (TextColor)NamedTextColor.RED));
            return 1;
        }
        Object object = this.inviteManager.setPublicJoinRole-0E7RQCE(world, player, role);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            TextComponent textComponent = Component.text("Failed to set public role: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handlePublicRole", 1);
        return 1;
    }

    private final int handlePublicRoleWithWorld(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handlePublicRoleWithWorld", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handlePublicRoleWithWorld", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String roleString = StringArgumentType.getString(ctx, (String)"role");
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(roleString);
        WorldRole role = this.parsePublicRole(roleString);
        if (role == null) {
            player.sendMessage(Component.text("Invalid role. Valid public roles: ", (TextColor)NamedTextColor.RED).append(Component.text("member, visitor", (TextColor)NamedTextColor.GOLD)));
            return 1;
        }
        Intrinsics.checkNotNull(worldName);
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        if (world == null) {
            return 1;
        }
        Object object = this.inviteManager.setPublicJoinRole-0E7RQCE(world, player, role);
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            TextComponent textComponent = Component.text("Failed to set public role: ", (TextColor)NamedTextColor.RED);
            String string = error.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            player.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handlePublicRoleWithWorld", 1);
        return 1;
    }

    private final int handleMembers(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleMembers", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handleMembers", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        PlayerWorld world = this.getCurrentOwnedWorld(player);
        if (world == null) {
            player.sendMessage((Component)Component.text("You must specify a world name or be in one of your owned worlds", (TextColor)NamedTextColor.RED));
            return 1;
        }
        this.displayWorldMembers(player, world);
        this.debugLogger.debugMethodExit("handleMembers", 1);
        return 1;
    }

    private final int handleMembersWithWorld(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleMembersWithWorld", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handleMembersWithWorld", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        Intrinsics.checkNotNull(worldName);
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        if (world == null) {
            return 1;
        }
        this.displayWorldMembers(player, world);
        this.debugLogger.debugMethodExit("handleMembersWithWorld", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final void displayWorldMembers(Player player, PlayerWorld world) {
        Object object;
        String visibilityText;
        player.sendMessage(((TextComponent)Component.text("Members of ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(":", (TextColor)NamedTextColor.GREEN)));
        String string = visibilityText = world.isPublic() ? "Public" : "Private";
        if (world.isPublic()) {
            String string2 = world.getPublicJoinRole().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            object = " (joins as " + string2 + ")";
        } else {
            object = "";
        }
        String publicRoleText = object;
        player.sendMessage(Component.text("  Visibility: ", (TextColor)NamedTextColor.GRAY).append(Component.text(visibilityText + publicRoleText, (TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(((TextComponent)((TextComponent)Component.text("  ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getOwnerName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text("Owner", (TextColor)NamedTextColor.RED)));
        if (world.getPlayerRoles().isEmpty()) {
            player.sendMessage((Component)Component.text("  No other members", (TextColor)NamedTextColor.GRAY));
        } else {
            Map<UUID, WorldRole> $this$forEach$iv = world.getPlayerRoles();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<UUID, WorldRole>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                String string3;
                String string4;
                Map.Entry<UUID, WorldRole> element$iv;
                Map.Entry<UUID, WorldRole> entry = element$iv = iterator2.next();
                boolean bl = false;
                UUID uuid = entry.getKey();
                WorldRole role = entry.getValue();
                String string5 = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                if (string5 == null) {
                    string5 = uuid.toString();
                }
                String string6 = string5;
                Intrinsics.checkNotNull(string6);
                String playerName = string6;
                NamedTextColor roleColor = switch (WhenMappings.$EnumSwitchMapping$0[role.ordinal()]) {
                    case 1 -> NamedTextColor.GOLD;
                    case 2 -> NamedTextColor.GREEN;
                    case 3 -> NamedTextColor.AQUA;
                    default -> NamedTextColor.GRAY;
                };
                Player player2 = player;
                TextComponent textComponent = (TextComponent)((TextComponent)Component.text("  ", (TextColor)NamedTextColor.GRAY).append(Component.text(playerName, (TextColor)NamedTextColor.WHITE))).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY));
                Intrinsics.checkNotNullExpressionValue(role.name().toLowerCase(Locale.ROOT), "toLowerCase(...)");
                if (((CharSequence)string4).length() > 0) {
                    String string7;
                    void it;
                    char c = string4.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    TextComponent textComponent2 = textComponent;
                    Player player3 = player2;
                    boolean bl2 = false;
                    String string8 = String.valueOf((char)it);
                    Intrinsics.checkNotNull(string8, "null cannot be cast to non-null type java.lang.String");
                    Intrinsics.checkNotNullExpressionValue(string8.toUpperCase(Locale.ROOT), "toUpperCase(...)");
                    player2 = player3;
                    textComponent = textComponent2;
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)string7);
                    String string9 = string4;
                    int n = 1;
                    String string10 = string9.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string10, "substring(...)");
                    string3 = stringBuilder2.append(string10).toString();
                } else {
                    string3 = string4;
                }
                player2.sendMessage(textComponent.append(Component.text(string3, (TextColor)roleColor)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int handleBrowse(CommandContext<CommandSourceStack> ctx) {
        void $this$filterTo$iv$iv;
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleBrowse", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            this.debugLogger.debugMethodExit("handleBrowse", "player-only error");
            return this.sendPlayerOnlyError(ctx);
        }
        Iterable $this$filter$iv = this.dataManager.getAllWorlds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerWorld it = (PlayerWorld)element$iv$iv;
            boolean bl = false;
            if (!(it.isPublic() && it.isEnabled())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List publicWorlds = (List)destination$iv$iv;
        if (publicWorlds.isEmpty()) {
            player.sendMessage((Component)Component.text("No public worlds available", (TextColor)NamedTextColor.YELLOW));
            return 1;
        }
        player.sendMessage((Component)Component.text("Public Worlds:", (TextColor)NamedTextColor.GREEN));
        Iterable $this$forEach$iv = publicWorlds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            String joinRoleText = switch (WhenMappings.$EnumSwitchMapping$0[world.getPublicJoinRole().ordinal()]) {
                case 2 -> "can play";
                case 3 -> "spectator only";
                default -> "";
            };
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("  - ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" by ", (TextColor)NamedTextColor.GRAY))).append(Component.text(world.getOwnerName(), (TextColor)NamedTextColor.WHITE))).append(Component.text(" (" + joinRoleText + ")", (TextColor)NamedTextColor.DARK_GRAY)));
            player.sendMessage(Component.text("    ", (TextColor)NamedTextColor.GRAY).append(Component.text("/world visit " + world.getOwnerName() + " " + world.getName(), (TextColor)NamedTextColor.YELLOW)));
        }
        this.debugLogger.debugMethodExit("handleBrowse", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestWorldTypes(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"normal", "flat", "amplified", "large_biomes", "void"};
        Iterable $this$filter$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.suggest(it);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestOwnedWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (sender instanceof Player) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (StringsKt.startsWith$default("default", string, false, 2, null)) {
                builder.suggest("default");
            }
            UUID uUID = ((Player)sender).getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((PlayerWorld)((Object)it)).getName());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String string2 = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                String string3 = builder.getRemainingLowerCase();
                Intrinsics.checkNotNullExpressionValue(string3, "getRemainingLowerCase(...)");
                if (!StringsKt.startsWith$default(string2, string3, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                builder.suggest(it2);
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final CompletableFuture<Suggestions> suggestPlayersWithWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Player)element$iv$iv;
            boolean bl = false;
            UUID uUID = it.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            boolean bl2 = !((Collection)this.dataManager.getWorldsByOwner(uUID)).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Player)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            String string = ((String)it).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String string2 = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            builder.suggest(it2);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestOwnerWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String ownerName = StringArgumentType.getString(ctx, (String)"owner");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)ownerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer owner = offlinePlayer;
        UUID uUID = owner.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((PlayerWorld)((Object)it)).getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String string2 = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            builder.suggest(it2);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestOnlinePlayers(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Player player = (Player)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String string2 = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            builder.suggest(it2);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestInviteOwners(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (sender instanceof Player) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            UUID uUID = ((Player)sender).getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.inviteManager.getPendingInvites(uUID);
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                WorldInvite worldInvite = (WorldInvite)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((WorldInvite)((Object)it)).getOwnerName());
            }
            $this$map$iv = CollectionsKt.distinct((List)destination$iv$iv);
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String string2 = builder.getRemainingLowerCase();
                Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
                if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                builder.suggest(it2);
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestInviteWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (sender instanceof Player) {
            void $this$forEach$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String ownerName = StringArgumentType.getString(ctx, (String)"owner");
            UUID uUID = ((Player)sender).getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.inviteManager.getPendingInvites(uUID);
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (WorldInvite)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.equals(((WorldInvite)it).getOwnerName(), ownerName, true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (WorldInvite)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((WorldInvite)it).getWorldName());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String string = ((String)it).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String string2 = builder.getRemainingLowerCase();
                Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
                if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                builder.suggest(it2);
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestWorldMembers(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        PlayerWorld currentWorld;
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (sender instanceof Player && (currentWorld = this.getCurrentOwnedWorld((Player)sender)) != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Iterable iterable = currentWorld.getPlayerRoles().keySet();
            boolean $i$f$mapNotNull = false;
            Iterator iterator2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl2 = false;
                if (Bukkit.getOfflinePlayer((UUID)it).getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String string2 = builder.getRemainingLowerCase();
                Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
                if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                builder.suggest(it);
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestRoles(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"manager", "member", "visitor"};
        Iterable $this$filter$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.suggest(it);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestPublicRoles(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"member", "visitor"};
        Iterable $this$filter$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.suggest(it);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestBackupIds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (sender instanceof Player) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            UUID uUID = ((Player)sender).getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.backupManager.getBackupsForPlayer(uUID);
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                WorldBackup worldBackup = (WorldBackup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = ((WorldBackup)((Object)it)).getId().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                collection.add(StringsKt.take(string, 8));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String string2 = builder.getRemainingLowerCase();
                Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
                if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                builder.suggest(it2);
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final int sendPlayerOnlyError(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("senderType", ((CommandSourceStack)ctx.getSource()).getSender().getClass().getSimpleName())};
        this.debugLogger.debug("sendPlayerOnlyError called", pairArray);
        this.plugin.getLogger().warning("[WorldCommands] Non-player attempted to execute player-only command");
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final PlayerWorld getPlayerWorld(Player player, String name) {
        Object v1;
        Pair[] pairArray;
        block2: {
            void $this$firstOrNull$iv;
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("name", name)};
            this.debugLogger.debugMethodEntry("getPlayerWorld", pairArray2);
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            pairArray = (Pair[])this.dataManager.getWorldsByOwner(uUID);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), name, true)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        PlayerWorld world = v1;
        pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to("name", name);
        pairArray[1] = TuplesKt.to("found", world != null);
        PlayerWorld playerWorld = world;
        pairArray[2] = TuplesKt.to("worldId", playerWorld != null ? playerWorld.getId() : null);
        this.debugLogger.debug("World lookup result", pairArray);
        if (world == null) {
            player.sendMessage(((TextComponent)Component.text("You don't own a world named '", (TextColor)NamedTextColor.RED).append(Component.text(name, (TextColor)NamedTextColor.GOLD))).append(Component.text("'", (TextColor)NamedTextColor.RED)));
        }
        PlayerWorld playerWorld2 = world;
        this.debugLogger.debugMethodExit("getPlayerWorld", playerWorld2 != null ? playerWorld2.getName() : null);
        return world;
    }

    private final PlayerWorld getCurrentWorld(Player player) {
        WorldRole playerRole;
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("bukkitWorld", player.getWorld().getName())};
        this.debugLogger.debugMethodEntry("getCurrentWorld", pairArray);
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        PlayerWorld currentWorld = this.worldManager.getPlayerWorldFromBukkitWorld(world);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("bukkitWorld", player.getWorld().getName()), TuplesKt.to("found", currentWorld != null)};
        this.debugLogger.debug("Player world lookup", pairArray2);
        if (currentWorld == null) {
            this.debugLogger.debugMethodExit("getCurrentWorld", null);
            return null;
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        WorldRole worldRole = playerRole = currentWorld.getPlayerRole(uUID);
        boolean canManage = worldRole != null ? worldRole.canInvite() : false;
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldOwner", currentWorld.getOwnerUuid()), TuplesKt.to("player", player.getUniqueId()), TuplesKt.to("role", playerRole), TuplesKt.to("canManage", canManage)};
        this.debugLogger.debug("Permission check", pairArray3);
        if (!canManage) {
            this.debugLogger.debugMethodExit("getCurrentWorld", "no permission");
            return null;
        }
        this.debugLogger.debugMethodExit("getCurrentWorld", currentWorld.getName());
        return currentWorld;
    }

    private final WorldType parseWorldType(String type2) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("type", type2)};
        this.debugLogger.debugMethodEntry("parseWorldType", pairArray);
        String string = type2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        WorldType result = switch (string) {
            case "normal" -> WorldType.NORMAL;
            case "flat" -> WorldType.FLAT;
            case "amplified" -> WorldType.AMPLIFIED;
            case "large_biomes" -> WorldType.LARGE_BIOMES;
            case "void" -> WorldType.VOID;
            default -> null;
        };
        this.debugLogger.debugMethodExit("parseWorldType", (Object)result);
        return result;
    }

    private final WorldRole parseRole(String role) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("role", role)};
        this.debugLogger.debugMethodEntry("parseRole", pairArray);
        String string = role.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        WorldRole result = switch (string) {
            case "manager" -> WorldRole.MANAGER;
            case "member" -> WorldRole.MEMBER;
            case "visitor" -> WorldRole.VISITOR;
            default -> null;
        };
        this.debugLogger.debugMethodExit("parseRole", (Object)result);
        return result;
    }

    private final WorldRole parsePublicRole(String role) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("role", role)};
        this.debugLogger.debugMethodEntry("parsePublicRole", pairArray);
        String string = role.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String string2 = string;
        WorldRole result = Intrinsics.areEqual(string2, "member") ? WorldRole.MEMBER : (Intrinsics.areEqual(string2, "visitor") ? WorldRole.VISITOR : null);
        this.debugLogger.debugMethodExit("parsePublicRole", (Object)result);
        return result;
    }

    private final PlayerWorld getCurrentOwnedWorld(Player player) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", player.getName()), TuplesKt.to("bukkitWorld", player.getWorld().getName())};
        this.debugLogger.debugMethodEntry("getCurrentOwnedWorld", pairArray);
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        PlayerWorld currentWorld = this.worldManager.getPlayerWorldFromBukkitWorld(world);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("bukkitWorld", player.getWorld().getName()), TuplesKt.to("found", currentWorld != null)};
        this.debugLogger.debug("Player world lookup", pairArray2);
        if (currentWorld == null) {
            this.debugLogger.debugMethodExit("getCurrentOwnedWorld", null);
            return null;
        }
        boolean isOwner = Intrinsics.areEqual(currentWorld.getOwnerUuid(), player.getUniqueId());
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldOwner", currentWorld.getOwnerUuid()), TuplesKt.to("player", player.getUniqueId()), TuplesKt.to("isOwner", isOwner)};
        this.debugLogger.debug("Ownership check", pairArray3);
        if (!isOwner) {
            this.debugLogger.debugMethodExit("getCurrentOwnedWorld", "not owner");
            return null;
        }
        this.debugLogger.debugMethodExit("getCurrentOwnedWorld", currentWorld.getName());
        return currentWorld;
    }

    /*
     * Unable to fully structure code
     */
    private final PlayerWorld getWorldWithPermission(Player player, String name) {
        block7: {
            block6: {
                var3_3 = new Pair[]{TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("name", name)};
                this.debugLogger.debugMethodEntry("getWorldWithPermission", var3_3);
                v0 = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(v0, "getUniqueId(...)");
                var4_4 = this.dataManager.getWorldsByOwner(v0);
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (PlayerWorld)element$iv;
                    $i$a$-firstOrNull-WorldCommands$getWorldWithPermission$ownedWorld$1 = false;
                    if (!StringsKt.equals(it.getName(), name, true)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            ownedWorld = v1;
            if (ownedWorld != null) {
                this.debugLogger.debugMethodExit("getWorldWithPermission", "owned: " + ownedWorld.getName());
                return ownedWorld;
            }
            allWorlds = this.dataManager.getAllWorlds();
            $this$firstOrNull$iv = allWorlds;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                world = (PlayerWorld)element$iv;
                $i$a$-firstOrNull-WorldCommands$getWorldWithPermission$managedWorld$1 = false;
                if (!StringsKt.equals(world.getName(), name, true)) ** GOTO lbl-1000
                v2 = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(v2, "getUniqueId(...)");
                v3 = world.getPlayerRole(v2);
                v4 = v3 != null ? v3.canInvite() : false;
                if (v4) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5) continue;
                v6 = element$iv;
                break block7;
            }
            v6 = null;
        }
        managedWorld = v6;
        if (managedWorld != null) {
            this.debugLogger.debugMethodExit("getWorldWithPermission", "managed: " + managedWorld.getName());
            return managedWorld;
        }
        player.sendMessage(((TextComponent)Component.text("You don't have permission for world '", (TextColor)NamedTextColor.RED).append(Component.text(name, (TextColor)NamedTextColor.GOLD))).append(Component.text("'", (TextColor)NamedTextColor.RED)));
        this.debugLogger.debugMethodExit("getWorldWithPermission", null);
        return null;
    }

    private static final boolean build$lambda$0(CommandSourceStack it) {
        return it.getSender().hasPermission("playerworldmanager.create");
    }

    private static final boolean build$lambda$1(CommandSourceStack it) {
        return it.getSender().hasPermission("playerworldmanager.backup");
    }

    private static final void handleCreate$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleCreateWithType$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleCreateWithSeed$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleDelete$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleTeleport$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleTeleport$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleVisit$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleLeave$lambda$23(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleSpawn$lambda$24(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createBackupForWorld$lambda$25(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleBackupRestore$lambda$28(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleBackupDelete$lambda$29(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(WorldCommands $this) {
        return $this.debugLogger;
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(WorldCommands $this) {
        return $this.plugin;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorldRole.values().length];
            try {
                nArray[WorldRole.MANAGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldRole.MEMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorldRole.VISITOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

